/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs.patch;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.dialogs.patch.ErrorMessages;
import org.eclipse.ui.dialogs.patch.IIssueMessage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class ProjectLocationSelectionDialog
extends SelectionStatusDialog
implements IIssueMessage {
    public Text projectNameField;
    private IProject project;
    private ProjectContentsLocationArea locationArea;
    private static String PROJECT_NAME_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_nameLabel;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean firstLocationCheck;
    public ErrorMessages errorMessages = new ErrorMessages(this);
    private int NAMEERRORMSG;
    private int PATHERRORMSG;

    public ProjectLocationSelectionDialog(Shell shell, IProject iProject) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.setStatusLineAboveButtons(true);
        this.project = iProject;
    }

    private String checkValidName() {
        String string = this.projectNameField.getText();
        IWorkspace iWorkspace = this.getProject().getWorkspace();
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (!iStatus.isOK()) {
            return iStatus.getMessage();
        }
        IProject iProject = iWorkspace.getRoot().getProject(string);
        if (iProject.exists()) {
            return NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_alreadyExists, (Object)string);
        }
        if (this.isProjectInWorkspacePath(this.projectNameField.getText())) {
            return NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_alreadyExists, (Object)string);
        }
        return null;
    }

    private boolean isProjectInWorkspacePath(String string) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IPath iPath = iWorkspace.getRoot().getLocation();
        IPath iPath2 = iPath.append(string);
        return iPath2.toFile().exists();
    }

    protected void computeResult() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.projectNameField.getText());
        arrayList.add(this.locationArea.getProjectLocation());
        this.setResult(arrayList);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.project_location_selection_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.NAMEERRORMSG = this.errorMessages.addMsgIndex();
        this.createProjectNameGroup(composite2);
        this.PATHERRORMSG = this.errorMessages.addMsgIndex();
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), composite2);
        this.locationArea.updateProjectName(this.projectNameField.getText());
        return composite2;
    }

    private void createNameListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationSelectionDialog.this.setLocationForSelection();
                ProjectLocationSelectionDialog.this.errorMessages.issueMessage(ProjectLocationSelectionDialog.this.NAMEERRORMSG, ProjectLocationSelectionDialog.this.checkValidName());
            }
        };
        this.projectNameField.addListener(24, listener);
    }

    private void createProjectNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(PROJECT_NAME_LABEL);
        this.projectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        this.projectNameField.setText(this.getCopyNameFor(this.getProject().getName()));
        this.projectNameField.selectAll();
        this.createNameListener();
        ProjectLocationSelectionDialog.applyDialogFont((Control)composite2);
    }

    private String getCopyNameFor(String string) {
        IWorkspace iWorkspace = this.getProject().getWorkspace();
        if (!iWorkspace.getRoot().getProject(string).exists()) {
            return string;
        }
        int n = 1;
        while (true) {
            String string2 = n > 1 ? NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_copyNameTwoArgs, (Object)new Integer(n), (Object)string) : NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_copyNameOneArg, (Object)string);
            if (!iWorkspace.getRoot().getProject(string2).exists() && !this.isProjectInWorkspacePath(string2)) {
                return string2;
            }
            ++n;
        }
    }

    private IProject getProject() {
        return this.project;
    }

    private void setLocationForSelection() {
        this.locationArea.updateProjectName(this.projectNameField.getText());
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String string) {
                ProjectLocationSelectionDialog.this.errorMessages.issueMessage(ProjectLocationSelectionDialog.this.PATHERRORMSG, string);
            }

            public void reportError(String string, boolean bl) {
                ProjectLocationSelectionDialog.this.errorMessages.issueMessage(ProjectLocationSelectionDialog.this.PATHERRORMSG, string);
            }
        };
    }

    @Override
    public void issueMessage(String string) {
        int n = 0;
        boolean bl = true;
        if (string.length() != 0) {
            n = 4;
            bl = false;
        }
        try {
            this.updateStatus((IStatus)new Status(n, "org.eclipse.ui.ide", n, string, null));
            this.getOkButton().setEnabled(bl);
        }
        catch (Exception exception) {}
    }
}

