/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.OS2200UIStartup;
import com.unisys.tde.ui.UiPlugin;
import com.unisys.tde.ui.actions.OpenFileAction;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.tde.ui.wizards.UpdateOS2200ProjectPage;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class UpdateOS2200ProjectContents
extends Wizard
implements INewWizard {
    private UpdateOS2200ProjectPage fMainPage;
    IStructuredSelection selection;
    IProject project = null;
    IProjectNature nature = null;
    Properties properties = null;
    ArrayList esolist = null;
    boolean finishOk = false;
    boolean fileOk = false;
    String cifsHost;
    String workfile;
    String shr;
    private String eltName = null;

    public UpdateOS2200ProjectContents() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        block10: {
            Object object = iStructuredSelection.getFirstElement();
            if (object == null) {
                return;
            }
            this.project = object instanceof IProject ? (IProject)object : ((IResource)object).getProject();
            if (this.project == null || !this.project.isOpen()) {
                return;
            }
            try {
                String string;
                File file;
                String string2;
                Object object2;
                this.properties = OS2200ProjectUpdate.getProperties((IProject)this.project);
                this.nature = this.project.getNature("com.unisys.tde.core.OS2200");
                if (this.nature == null) {
                    this.project = null;
                    break block10;
                }
                this.selection = iStructuredSelection;
                long l = OS2200ProjectUpdate.connectOS2200((IProject)this.project, (boolean)true);
                if (l != 0L) {
                    object2 = new HashMap<String, Integer>();
                    ((HashMap)object2).put("severity", new Integer(2));
                    string2 = OS2200FileInterface.getConnectErrorMsg((long)l, (IProject)this.project);
                    MarkerUtilities.setMessage((Map)object2, (String)string2);
                    OS2200CorePlugin.logger.info((Object)string2);
                    try {
                        MarkerUtilities.createMarker((IResource)this.project, (Map)object2, (String)"org.eclipse.core.resources.problemmarker");
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.warn((Object)"Exception from createMarker", (Throwable)exception);
                    }
                    this.finishOk = false;
                } else {
                    this.finishOk = true;
                }
                object2 = this.properties.getProperty("hostID");
                this.cifsHost = LoginAccount.getLoginAccount((String)object2).getHostAccount().getCifsHostId();
                this.workfile = this.properties.getProperty("workFile");
                this.shr = OS2200ProjectUpdate.getShareName((IProject)this.project);
                string2 = OS2200ProjectUpdate.getShareState((IProject)this.project);
                if (string2.equals((Object)OS2200ProjectUpdate.Share.nShare)) {
                    this.workfile = this.shr;
                }
                this.fileOk = (file = new File(string = OS2200FileInterface.getCIFSDir((Properties)this.properties))).exists();
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.warn((Object)exception);
            }
        }
    }

    public boolean canFinish() {
        boolean bl = super.canFinish();
        return bl && this.finishOk && this.fileOk && this.project != null && this.fMainPage.canFinish();
    }

    public void addPages() {
        Object object;
        if (this.project == null || !this.project.isOpen()) {
            return;
        }
        URL uRL = UiPlugin.getDefault().getBundle().getEntry("/");
        try {
            object = new URL(uRL, "icons/banners/newpprj_wiz.gif");
            this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)object));
        }
        catch (Exception exception) {}
        super.addPages();
        super.setWindowTitle(Messages.getString((String)"UpdateOS2200ProjectContents.0"));
        this.fMainPage = new UpdateOS2200ProjectPage("NewProjectCreationWizard");
        this.fMainPage.setTitle(Messages.getString((String)"UpdateOS2200ProjectContents.1"));
        if (this.fileOk) {
            this.fMainPage.setDescription(Messages.getString((String)"UpdateOS2200ProjectContents.4"));
        } else if (this.workfile != null && this.cifsHost != null) {
            this.fMainPage.setDescription(Messages.getString((String)"NewOS2200ProjectPageOne.10", (String)this.workfile, (String)this.cifsHost));
        } else {
            object = this.properties.getProperty("hostID");
            this.fMainPage.setDescription(Messages.getString((String)"Connection.1", (String)object));
        }
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        IResource iResource;
        IResource[] iResourceArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            IResource[] iResourceArray2 = iResourceArray = this.project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                iResource = iResourceArray2[n2];
                if (iResource instanceof IFile) {
                    arrayList.add(iResource.toString());
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.warn((Object)"Exception from perform finish", (Throwable)coreException);
        }
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask(Messages.getString((String)"UpdateOS2200ProjectContents.0"), 1);
                    OS2200ProjectUpdate.setLinks((IProject)UpdateOS2200ProjectContents.this.project, (ArrayList)UpdateOS2200ProjectContents.this.fMainPage.getESOList(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    try {
                        UpdateOS2200ProjectContents.this.project.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {}
        OS2200ProjectUpdate.displayLinkNotes();
        try {
            iResource = this.project.members();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            IResource iResource2 = iResource;
            int n = ((IResource)iResource2).length;
            int n3 = 0;
            while (n3 < n) {
                IResource iResource3 = iResource2[n3];
                if (iResource3 instanceof IFile) {
                    arrayList2.add(iResource3.toString());
                }
                ++n3;
            }
            if (arrayList2 != null) {
                arrayList2.removeAll(arrayList);
                if (arrayList2.size() == 1 && !((Object)arrayList2).toString().toLowerCase().endsWith(".project") && !((Object)arrayList2).toString().toLowerCase().endsWith(".settings")) {
                    this.eltName = ((Object)arrayList2).toString().substring(((Object)arrayList2).toString().lastIndexOf("/"), ((Object)arrayList2).toString().length() - 1);
                    BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                                IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
                                IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[0].getPages();
                                OpenFileAction openFileAction = new OpenFileAction(iWorkbenchPageArray[0]);
                                IFile iFile = UpdateOS2200ProjectContents.this.project.getFile(UpdateOS2200ProjectContents.this.eltName);
                                if (TDECoreUtilities.isIFileADirectory((IFile)iFile)) {
                                    return;
                                }
                                openFileAction.initiateOpenElement(iFile);
                            }
                            catch (Exception exception) {
                                OS2200CorePlugin.logger.warn((Object)("Exception from perform finish: " + exception.getMessage()), (Throwable)exception);
                            }
                        }
                    });
                } else {
                    Thread thread = new Thread(Messages.getString((String)"UpdateOS2200ProjectContents_0"), (IResource[])iResource){
                        private final /* synthetic */ IResource[] val$rss;
                        {
                            this.val$rss = iResourceArray;
                            super(string);
                        }

                        @Override
                        public void run() {
                            if (!OS2200ArchitectureUtils.startDownlodingElements(this.val$rss)) {
                                OS2200UIStartup.downloadUnInitializedFile();
                            }
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
            }
            Thread thread = new Thread(Messages.getString((String)"UpdateOS2200ProjectContents_1"), (IResource[])iResource){
                private final /* synthetic */ IResource[] val$rss;
                {
                    this.val$rss = iResourceArray;
                    super(string);
                }

                @Override
                public void run() {
                    try {
                        final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
                        IResource[] iResourceArray = this.val$rss;
                        int n = this.val$rss.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource iResource = iResourceArray[n2];
                            if (iResource instanceof IFile && !iResource.toString().toLowerCase().endsWith(".project") && !iResource.toString().toLowerCase().endsWith(".settings")) {
                                final IFile iFile = (IFile)iResource;
                                if (TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
                                    iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                } else {
                                    IProject iProject = iFile.getProject();
                                    long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)true);
                                    if (l == 0L) {
                                        iProject.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "True");
                                        if (!TDECoreUtilities.isPhysicallyInSync((IFile)iFile)) {
                                            iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                                        } else {
                                            iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                        }
                                    } else {
                                        iProject.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "False");
                                        if (!TDECoreUtilities.getInstance().isFileModified(iFile)) {
                                            iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                                        } else {
                                            iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                        }
                                    }
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        oS2200View.getViewer().refresh((Object)iFile, true);
                                    }
                                });
                            }
                            ++n2;
                        }
                        oS2200View.getViewer().refresh();
                    }
                    catch (Exception exception) {}
                }
            };
            thread.setPriority(1);
            thread.start();
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.warn((Object)"Exception from perform finish", (Throwable)coreException);
        }
        return true;
    }

    public String getHostName() {
        return this.properties.getProperty("hostID");
    }

    public String getWorkFile() {
        return this.properties.getProperty("workFile");
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isFinishOk() {
        return this.finishOk;
    }
}

