/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import com.unisys.tde.ui.wizards.NewOS2200FileWizard;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class RenameOS2200FileWizard
extends NewOS2200FileWizard {
    IStructuredSelection selection;
    ElementSelectionObject originalEso;

    @Override
    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.selection = iStructuredSelection;
    }

    @Override
    public void addPages() {
        super.addPages();
        super.setWindowTitle(Messages.getString((String)"RenameOS2200FileWizard.0"));
        this.page.setTitle(Messages.getString((String)"RenameOS2200FileWizard.1"));
        this.page.setDescription(Messages.getString((String)"RenameOS2200FileWizard.2"));
        IResource iResource = (IResource)this.selection.getFirstElement();
        IPath iPath = iResource.getLocation();
        String string = iPath.lastSegment().replace(".", "/");
        this.page.setrenameElt(iResource);
        this.page.setEltName(string);
        this.page.setSubType(iResource.getFileExtension());
        this.page.setcharConversion(OS2200ProjectUpdate.getCharConversion((IFile)((IFile)iResource)));
        this.page.setOperationType("Rename-Type-modification");
    }

    @Override
    void doFinish(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        ElementSelectionObject elementSelectionObject = new ElementSelectionObject(string, string2, this.subType, string, this.charConvType);
        ArrayList<ElementSelectionObject> arrayList = new ArrayList<ElementSelectionObject>();
        arrayList.add(elementSelectionObject);
        final IResource iResource = (IResource)this.selection.getFirstElement();
        iProgressMonitor.beginTask("Creating %1 %2 ", 2);
        IPath iPath = this.project.getFullPath().append(string2);
        long l = OS2200FileInterface.renameOS2200Elt((Properties)this.properties, (String)iResource.getLocation().lastSegment().toUpperCase(), (String)string, (IResource)iResource);
        if (l == 0L) {
            iResource.delete(1, (IProgressMonitor)new NullProgressMonitor());
            OS2200ProjectUpdate.addLinks((IProject)this.project, arrayList, (IProgressMonitor)iProgressMonitor);
            this.newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
            if (this.newResource != null && this.newResource instanceof IFile) {
                final IFile iFile = (IFile)this.newResource;
                File file = new File(iFile.getRawLocation().toOSString());
                if (TDECoreUtilities.isPhysicallyInSync((File)file)) {
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                } else {
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OS2200ArchitectureUtils.getViewObject().getViewer().refresh((Object)iFile, true);
                    }
                });
            }
        } else {
            Display display = Display.getDefault();
            final long l2 = l;
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (l2 == -1005L) {
                        MessageDialog.openError((Shell)RenameOS2200FileWizard.this.getShell(), (String)Messages.getString((String)"RenameOS2200FileWizard.3"), (String)Messages.getString((String)"RenameOS2200FileWizard.4"));
                    } else if (l2 == -1006L) {
                        MessageDialog.openInformation((Shell)RenameOS2200FileWizard.this.getShell(), (String)Messages.getString((String)"RenameOS2200FileWizard.5"), (String)Messages.getString((String)"NewOS2200FileWizard.8"));
                    } else if (l2 == -2L) {
                        try {
                            final IFile iFile = (IFile)iResource;
                            iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    OS2200ArchitectureUtils.getViewObject().getViewer().refresh((Object)iFile, true);
                                }
                            });
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.warn((Object)coreException.getMessage(), (Throwable)coreException);
                        }
                        MessageDialog.openError((Shell)RenameOS2200FileWizard.this.getShell(), (String)Messages.getString((String)"RenameOS2200FileWizard.8"), (String)Messages.getString((String)"RenameOS2200FileWizard.9"));
                    } else {
                        MessageDialog.openError((Shell)RenameOS2200FileWizard.this.getShell(), (String)Messages.getString((String)"RenameOS2200FileWizard.6"), (String)Messages.getString((String)"RenameOS2200FileWizard.7", (String)OS2200FileInterface.getConnectErrorMsg((long)l2, (IProject)RenameOS2200FileWizard.this.project)));
                    }
                }
            });
        }
        iProgressMonitor.worked(1);
    }
}

