/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.wizards.ImportUtilities;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class OS2200ProjectsImportWizardPage
extends WizardPage
implements IOverwriteQuery {
    public static final String METADATA_FOLDER = ".metadata";
    private ILeveledImportStructureProvider structureProvider;
    private boolean proceed = true;
    private String errorMessage = null;
    private String conName = null;
    private static final String STORE_COPY_PROJECT_ID = "WizardProjectsImportPage.STORE_COPY_PROJECT_ID";
    private static final String STORE_ARCHIVE_SELECTED = "WizardProjectsImportPage.STORE_ARCHIVE_SELECTED";
    private Text directoryPathField;
    private CheckboxTreeViewer projectsList;
    private Button copyCheckbox;
    private boolean copyFiles = false;
    private boolean lastCopyFiles = false;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button browseDirectoriesButton;
    private IProject[] wsProjects;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String initialPath;
    private String lastPath;
    private long lastModified;
    private WorkingSetGroup workingSetGroup;
    private IStructuredSelection currentSelection;
    List createdProjects;

    public OS2200ProjectsImportWizardPage() {
        this("wizardExternalProjectsPage", null, null);
    }

    public OS2200ProjectsImportWizardPage(String string) {
        this(string, null, null);
    }

    public OS2200ProjectsImportWizardPage(String string, String string2, IStructuredSelection iStructuredSelection) {
        super(string);
        this.initialPath = string2;
        this.currentSelection = iStructuredSelection;
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(composite2);
        this.createProjectsList(composite2);
        this.createOptionsArea(composite2);
        this.createWorkingSetGroup(composite2);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite2);
    }

    private void createWorkingSetGroup(Composite composite) {
        String[] stringArray = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup(composite, this.currentSelection, stringArray);
    }

    private void createOptionsArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(768));
        this.copyCheckbox = new Button(composite2, 32);
        this.copyCheckbox.setText("DataTransferMessages.WizardProjectsImportPage_CopyProjectsIntoWorkspace");
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.setSelection(true);
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200ProjectsImportWizardPage.this.copyFiles = OS2200ProjectsImportWizardPage.this.copyCheckbox.getSelection();
            }
        });
        IDialogSettings iDialogSettings = this.getDialogSettings();
        try {
            if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                this.copyCheckbox.setSelection(true);
                this.copyCheckbox.notifyListeners(13, new Event());
                if (iDialogSettings != null) {
                    iDialogSettings.put(STORE_COPY_PROJECT_ID, this.copyFiles);
                }
                this.copyCheckbox.setEnabled(false);
                this.copyCheckbox.setVisible(false);
                Label label = new Label(composite, 0);
                label.setText(Messages.getString((String)"OS2200ProjectsImportWizardPage_1"));
            } else if (iDialogSettings != null) {
                iDialogSettings.put(STORE_COPY_PROJECT_ID, false);
            }
        }
        catch (Exception exception) {}
    }

    private void createProjectsList(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(composite2, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object object) {
                return null;
            }

            public Object[] getElements(Object object) {
                return OS2200ProjectsImportWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object object) {
                return false;
            }

            public Object getParent(Object object) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ProjectRecord projectRecord = (ProjectRecord)checkStateChangedEvent.getElement();
                if (projectRecord.hasConflicts) {
                    OS2200ProjectsImportWizardPage.this.projectsList.setChecked((Object)projectRecord, false);
                }
                OS2200ProjectsImportWizardPage.this.setPageComplete(OS2200ProjectsImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(composite2);
    }

    private void createSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(2));
        Button button = new Button(composite2, 8);
        button.setText(DataTransferMessages.DataTransfer_selectAll);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = 0;
                while (n < OS2200ProjectsImportWizardPage.this.selectedProjects.length) {
                    if (((OS2200ProjectsImportWizardPage)OS2200ProjectsImportWizardPage.this).selectedProjects[n].hasConflicts) {
                        OS2200ProjectsImportWizardPage.this.projectsList.setChecked((Object)OS2200ProjectsImportWizardPage.this.selectedProjects[n], false);
                    } else {
                        OS2200ProjectsImportWizardPage.this.projectsList.setChecked((Object)OS2200ProjectsImportWizardPage.this.selectedProjects[n], true);
                    }
                    ++n;
                }
                OS2200ProjectsImportWizardPage.this.setPageComplete(OS2200ProjectsImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite2, 8);
        button2.setText(DataTransferMessages.DataTransfer_deselectAll);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200ProjectsImportWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                OS2200ProjectsImportWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)button2);
        this.setButtonLayoutData(button2);
        Button button3 = new Button(composite2, 8);
        button3.setText(DataTransferMessages.DataTransfer_refresh);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (OS2200ProjectsImportWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    OS2200ProjectsImportWizardPage.this.updateProjectsList(OS2200ProjectsImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)button3);
        this.setButtonLayoutData(button3);
    }

    private void createProjectsRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(composite2, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)gridData);
        this.browseDirectoriesButton = new Button(composite2, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200ProjectsImportWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    OS2200ProjectsImportWizardPage.this.updateProjectsList(OS2200ProjectsImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                OS2200ProjectsImportWizardPage.this.updateProjectsList(OS2200ProjectsImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200ProjectsImportWizardPage.this.directoryRadioSelected();
            }
        });
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
            try {
                if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                    this.copyCheckbox.setEnabled(false);
                } else {
                    this.copyCheckbox.setEnabled(true);
                }
            }
            catch (Exception exception) {}
            this.copyCheckbox.setSelection(this.copyFiles);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
    }

    public void updateProjectsList(final String string) {
        if (string == null || string.length() == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = string;
            return;
        }
        final File file = new File(string);
        long l = file.lastModified();
        if (string.equals(this.lastPath) && this.lastModified == l && this.lastCopyFiles == this.copyFiles) {
            return;
        }
        this.lastPath = string;
        this.lastModified = l;
        this.lastCopyFiles = this.copyFiles;
        final boolean bl = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    OS2200ProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList arrayList = new ArrayList();
                    iProgressMonitor.worked(10);
                    if (!bl && ArchiveFileManipulations.isTarFile((String)string)) {
                        TarFile tarFile = OS2200ProjectsImportWizardPage.this.getSpecifiedTarSourceFile(string);
                        if (tarFile == null) {
                            return;
                        }
                        OS2200ProjectsImportWizardPage.this.structureProvider = (ILeveledImportStructureProvider)new TarLeveledStructureProvider(tarFile);
                        Object object = OS2200ProjectsImportWizardPage.this.structureProvider.getRoot();
                        if (!OS2200ProjectsImportWizardPage.this.collectProjectFilesFromProvider(arrayList, object, 0, iProgressMonitor)) {
                            return;
                        }
                        Iterator iterator = arrayList.iterator();
                        OS2200ProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[arrayList.size()];
                        int n = 0;
                        iProgressMonitor.worked(50);
                        iProgressMonitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (iterator.hasNext()) {
                            ((OS2200ProjectsImportWizardPage)OS2200ProjectsImportWizardPage.this).selectedProjects[n++] = (ProjectRecord)iterator.next();
                        }
                    } else if (!bl && ArchiveFileManipulations.isZipFile((String)string)) {
                        ZipFile zipFile = OS2200ProjectsImportWizardPage.this.getSpecifiedZipSourceFile(string);
                        if (zipFile == null) {
                            return;
                        }
                        OS2200ProjectsImportWizardPage.this.structureProvider = (ILeveledImportStructureProvider)new ZipLeveledStructureProvider(zipFile);
                        Object object = OS2200ProjectsImportWizardPage.this.structureProvider.getRoot();
                        if (!OS2200ProjectsImportWizardPage.this.collectProjectFilesFromProvider(arrayList, object, 0, iProgressMonitor)) {
                            return;
                        }
                        Iterator iterator = arrayList.iterator();
                        OS2200ProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[arrayList.size()];
                        int n = 0;
                        iProgressMonitor.worked(50);
                        iProgressMonitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (iterator.hasNext()) {
                            ((OS2200ProjectsImportWizardPage)OS2200ProjectsImportWizardPage.this).selectedProjects[n++] = (ProjectRecord)iterator.next();
                        }
                    } else if (bl && file.isDirectory()) {
                        if (!OS2200ProjectsImportWizardPage.this.collectProjectFilesFromDirectory(arrayList, file, null, iProgressMonitor)) {
                            return;
                        }
                        Iterator iterator = arrayList.iterator();
                        OS2200ProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[arrayList.size()];
                        int n = 0;
                        iProgressMonitor.worked(50);
                        iProgressMonitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (iterator.hasNext()) {
                            File file2 = (File)iterator.next();
                            ((OS2200ProjectsImportWizardPage)OS2200ProjectsImportWizardPage.this).selectedProjects[n] = new ProjectRecord(file2);
                            ++n;
                        }
                        if (ImportUtilities.getInstance().rejectedProjects.size() > 0) {
                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    int n = 0;
                                    while (n < ImportUtilities.getInstance().rejectedProjects.size()) {
                                        stringBuffer.append(ImportUtilities.getInstance().rejectedProjects.get(n));
                                        stringBuffer.append("\n");
                                        ++n;
                                    }
                                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OS2200ProjectsImportWizardPage_2"), (String)(String.valueOf(stringBuffer.toString()) + Messages.getString((String)"OS2200ProjectsImportWizardPage_3")));
                                }
                            });
                        }
                    } else {
                        iProgressMonitor.worked(60);
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            IDEWorkbenchPlugin.log((String)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        ProjectRecord[] projectRecordArray = this.getProjectRecords();
        boolean bl2 = false;
        int n = 0;
        while (n < projectRecordArray.length) {
            if (projectRecordArray[n].hasConflicts) {
                bl2 = true;
                this.projectsList.setGrayed((Object)projectRecordArray[n], true);
            } else {
                this.projectsList.setChecked((Object)projectRecordArray[n], true);
            }
            ++n;
        }
        if (bl2) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(string);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new TarFile(string);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        return null;
    }

    protected void displayErrorDialog(String string) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)string, (int)0x10000000);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    private boolean collectProjectFilesFromDirectory(Collection collection, File file, Set hashSet, IProgressMonitor iProgressMonitor) {
        Object object;
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        iProgressMonitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)file.getPath()));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return false;
        }
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            try {
                hashSet.add(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)iOException.getLocalizedMessage(), (Throwable)iOException));
            }
        }
        int n = 0;
        while (n < fileArray.length) {
            object = fileArray[n];
            if (((File)object).isFile() && ((File)object).getName().equals(".project")) {
                collection.add(object);
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < fileArray.length) {
            block12: {
                if (fileArray[n].isDirectory() && !fileArray[n].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            object = fileArray[n].getCanonicalPath();
                            if (hashSet.add(object)) break block11;
                            break block12;
                        }
                        catch (IOException iOException) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)iOException.getLocalizedMessage(), (Throwable)iOException));
                        }
                    }
                    this.collectProjectFilesFromDirectory(collection, fileArray[n], hashSet, iProgressMonitor);
                }
            }
            ++n;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection collection, Object object, int n, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        iProgressMonitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(object)));
        ArrayList arrayList = this.structureProvider.getChildren(object);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
        }
        for (Object e : arrayList) {
            String string;
            if (this.structureProvider.isFolder(e)) {
                this.collectProjectFilesFromProvider(collection, e, n + 1, iProgressMonitor);
            }
            if (!(string = this.structureProvider.getLabel(e)).equals(".project")) continue;
            collection.add(new ProjectRecord(e, object, n));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        directoryDialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String string = this.directoryPathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedDirectory;
        }
        if (string.length() == 0) {
            directoryDialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string);
            if (((File)object).exists()) {
                directoryDialog.setFilterPath(new Path(string).toOSString());
            }
        }
        object = directoryDialog.open();
        if (object != null) {
            previouslyBrowsedDirectory = object;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList((String)object);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] objectArray = this.projectsList.getCheckedElements();
        this.createdProjects = new ArrayList();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iProgressMonitor.beginTask("", objectArray.length);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int n = 0;
                    while (n < objectArray.length) {
                        OS2200ProjectsImportWizardPage.this.createExistingProject((ProjectRecord)objectArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        ++n;
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Object object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, string, throwable);
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)object);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
        this.addToWorkingSets();
        return true;
    }

    private void addToWorkingSets() {
        IWorkingSet[] iWorkingSetArray = this.workingSetGroup.getSelectedWorkingSets();
        if (iWorkingSetArray == null || iWorkingSetArray.length == 0) {
            return;
        }
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        for (IProject iProject : this.createdProjects) {
            iWorkingSetManager.addToWorkingSets((IAdaptable)iProject, iWorkingSetArray);
        }
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
    }

    private boolean createExistingProject(ProjectRecord projectRecord, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        Object object;
        Object object2;
        Object object3;
        IProject iProject;
        long l;
        block35: {
            Object object4;
            try {
                if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                    this.copyFiles = true;
                }
            }
            catch (Exception exception) {}
            l = -1L;
            String string = projectRecord.getProjectName();
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iProject = iWorkspace.getRoot().getProject(string);
            if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                object3 = null;
                try {
                    object3 = OS2200ProjectUpdate.getProperties((IProject)iProject);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    return false;
                }
                this.conName = ((Properties)object3).getProperty("hostID");
                if (this.conName.trim().length() == 0) {
                    object2 = projectRecord.projectSystemFile.getAbsolutePath();
                    object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(File.separator));
                    object = String.valueOf(object2) + File.separator + ".settings" + File.separator + "org.eclipse.core.resources.prefs";
                    OS2200CorePlugin.logger.info((Object)("Reading the meta-data from  " + (String)object));
                    object4 = new Properties();
                    try {
                        ((Properties)object4).load(new FileInputStream(new File((String)object)));
                        this.conName = ((Properties)object4).getProperty("hostID/<project>");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        OS2200CorePlugin.logger.error((Object)fileNotFoundException.getLocalizedMessage(), (Throwable)fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                }
                if (this.conName != null && this.conName.trim().length() > 0) {
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(iProject.getName()) + " is created with connection name : " + this.conName));
                    object2 = LoginAccount.getLoginAccount((String)this.conName);
                    if (object2 == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)OS2200ProjectsImportWizardPage.this.getShell(), (String)Messages.getString((String)"ImportProject.1"), (String)Messages.getString((String)"ImportProject.2", (String)iProject.getName(), (String)OS2200ProjectsImportWizardPage.this.conName));
                                OS2200ProjectsImportWizardPage.this.errorMessage = Messages.getString((String)"ImportProject.2", (String)iProject.getName(), (String)OS2200ProjectsImportWizardPage.this.conName);
                                OS2200ProjectsImportWizardPage.this.setErrorMessage(OS2200ProjectsImportWizardPage.this.errorMessage);
                                OS2200CorePlugin.logger.info((Object)OS2200ProjectsImportWizardPage.this.errorMessage);
                                OS2200ProjectsImportWizardPage.this.proceed = false;
                            }
                        });
                    } else {
                        this.proceed = true;
                    }
                } else {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            OS2200ProjectsImportWizardPage.this.errorMessage = Messages.getString((String)"ImportProject.3", (String)iProject.getName());
                            MessageDialog.openInformation((Shell)OS2200ProjectsImportWizardPage.this.getShell(), (String)Messages.getString((String)"ImportProject.1"), (String)OS2200ProjectsImportWizardPage.this.errorMessage);
                            OS2200ProjectsImportWizardPage.this.setErrorMessage(OS2200ProjectsImportWizardPage.this.errorMessage);
                            OS2200CorePlugin.logger.info((Object)OS2200ProjectsImportWizardPage.this.errorMessage);
                            OS2200ProjectsImportWizardPage.this.proceed = false;
                        }
                    });
                }
                if (!this.proceed) {
                    OS2200CorePlugin.logger.info((Object)" import project failed.");
                    throw new InterruptedException(this.errorMessage);
                }
            }
            this.createdProjects.add(iProject);
            if (projectRecord.description == null) {
                projectRecord.description = iWorkspace.newProjectDescription(string);
                object3 = new Path(projectRecord.projectSystemFile.getAbsolutePath());
                if (Platform.getLocation().isPrefixOf((IPath)object3)) {
                    projectRecord.description.setLocation(null);
                } else {
                    projectRecord.description.setLocation((IPath)object3);
                }
            } else {
                projectRecord.description.setName(string);
            }
            if (projectRecord.projectArchiveFile != null) {
                object3 = this.structureProvider.getChildren(projectRecord.parent);
                this.structureProvider.setStrip(projectRecord.level);
                object2 = new ImportOperation(iProject.getFullPath(), this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, (List)object3);
                object2.setContext(this.getShell());
                object2.run(iProgressMonitor);
                return true;
            }
            object3 = null;
            if (this.copyFiles && (object2 = projectRecord.description.getLocationURI()) != null) {
                object = ResourcesPlugin.getWorkspace().validateProjectLocationURI(iProject, (URI)object2);
                if (!object.isOK()) {
                    throw new InvocationTargetException(new CoreException(object));
                }
                object3 = new File((URI)object2);
                object4 = iWorkspace.newProjectDescription(string);
                object4.setBuildSpec(projectRecord.description.getBuildSpec());
                object4.setComment(projectRecord.description.getComment());
                object4.setDynamicReferences(projectRecord.description.getDynamicReferences());
                object4.setNatureIds(projectRecord.description.getNatureIds());
                object4.setReferencedProjects(projectRecord.description.getReferencedProjects());
                projectRecord.description = object4;
            }
            try {
                try {
                    iProgressMonitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                    iProject.create(projectRecord.description, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 30));
                    iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 70));
                    try {
                        if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                            iProject.setSessionProperty(new QualifiedName("com.unisys.tde.core", "IMPORT"), (Object)iProject.getName());
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                    iProgressMonitor.done();
                    break block35;
                }
            }
            catch (Throwable throwable) {
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
        }
        if (this.copyFiles && object3 != null) {
            object2 = FileSystemStructureProvider.INSTANCE.getChildren(object3);
            object = new ImportOperation(iProject.getFullPath(), object3, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, (List)object2);
            object.setContext(this.getShell());
            object.setOverwriteResources(true);
            object.setCreateContainerStructure(false);
            object.run(iProgressMonitor);
        }
        try {
            if (l != 0L) {
                iProject.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "False");
            } else {
                iProject.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "True");
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        return true;
    }

    public String queryOverwrite(String string) {
        Path path = new Path(string);
        String string2 = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)string) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] stringArray = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                messageDialog.open();
            }
        });
        return messageDialog.getReturnCode() < 0 ? "CANCEL" : stringArray[messageDialog.getReturnCode()];
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        int n = 0;
        while (n < this.selectedProjects.length) {
            if (this.isProjectInWorkspacePath(this.selectedProjects[n].getProjectName()) && this.copyFiles || this.isProjectInWorkspace(this.selectedProjects[n].getProjectName())) {
                this.selectedProjects[n].hasConflicts = true;
            }
            if (this.selectedProjects[n].getProjectName() != null && !arrayList.contains(this.selectedProjects[n].getProjectName())) {
                arrayList.add(this.selectedProjects[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ProjectRecord[arrayList.size()]);
    }

    private boolean isProjectInWorkspacePath(String string) {
        if (string != null) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IPath iPath = iWorkspace.getRoot().getLocation();
            IPath iPath2 = iPath.append(string);
            return iPath2.toFile().exists();
        }
        return false;
    }

    private boolean isProjectInWorkspace(String string) {
        if (string == null) {
            return false;
        }
        IProject[] iProjectArray = this.getProjectsInWorkspace();
        int n = 0;
        while (n < iProjectArray.length) {
            if (string.equals(iProjectArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.copyFiles = iDialogSettings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
            this.lastCopyFiles = this.copyFiles;
        }
        if (this.initialPath == null && iDialogSettings != null) {
            boolean bl = iDialogSettings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!bl);
            if (!bl) {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null) {
            boolean bl = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(bl);
            if (bl) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(this.initialPath.length());
                this.directoryRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
        }
    }

    public Button getCopyCheckbox() {
        return this.copyCheckbox;
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object object) {
            return ((ProjectRecord)object).getProjectLabel();
        }

        public Color getBackground(Object object) {
            return null;
        }

        public Color getForeground(Object object) {
            ProjectRecord projectRecord = (ProjectRecord)object;
            if (projectRecord.hasConflicts) {
                return OS2200ProjectsImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        boolean hasConflicts;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object object, Object object2, int n) {
            this.projectArchiveFile = object;
            this.parent = object2;
            this.level = n;
            this.setProjectName();
        }

        private void setProjectName() {
            block17: {
                try {
                    InputStream inputStream;
                    if (this.projectArchiveFile != null) {
                        inputStream = OS2200ProjectsImportWizardPage.this.structureProvider.getContents(this.projectArchiveFile);
                        if (inputStream == null) {
                            Path path;
                            if (this.projectArchiveFile instanceof ZipEntry) {
                                path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                                this.projectName = path.segment(path.segmentCount() - 2);
                            } else if (this.projectArchiveFile instanceof TarEntry) {
                                path = new Path(((TarEntry)this.projectArchiveFile).getName());
                                this.projectName = path.segment(path.segmentCount() - 2);
                            }
                        } else {
                            this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(inputStream);
                            inputStream.close();
                            this.projectName = this.description.getName();
                        }
                    }
                    if (this.projectName != null) break block17;
                    inputStream = new Path(this.projectSystemFile.getPath());
                    try {
                        if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                            OS2200CorePlugin.logger.debug((Object)"");
                            try {
                                inputStream = ImportUtilities.getInstance().createImportRepository((IPath)inputStream);
                                OS2200CorePlugin.logger.debug((Object)" create Import Repository successful.");
                            }
                            catch (Exception exception) {
                                OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                                final String string = exception.getMessage();
                                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (OS2200ProjectsImportWizardPage.super.getShell() != null) {
                                            MessageDialog.openError((Shell)OS2200ProjectsImportWizardPage.this.getShell(), (String)Messages.getString((String)"OS2200ProjectsImportWizardPage_0"), (String)string);
                                            OS2200ProjectsImportWizardPage.this.setErrorMessage(string);
                                        }
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    if (inputStream != null) {
                        if (this.isDefaultLocation((IPath)inputStream)) {
                            this.projectName = inputStream.segment(inputStream.segmentCount() - 2);
                            this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                        } else {
                            this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)inputStream);
                            this.projectName = this.description.getName();
                        }
                    }
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
        }

        private boolean isDefaultLocation(IPath iPath) {
            if (iPath.segmentCount() < 2) {
                return false;
            }
            return iPath.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String string = this.projectSystemFile == null ? OS2200ProjectsImportWizardPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)string);
        }

        public boolean hasConflicts() {
            return this.hasConflicts;
        }
    }
}

