/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.tde.ui.wizards.ImportUtilities;
import com.unisys.tde.ui.wizards.OS2200ProjectsImportWizardPage;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class OS2200ProjectImportWizard
extends Wizard
implements IImportWizard {
    private static final String EXTERNAL_PROJECT_SECTION = "ExternalProjectImportWizard";
    private OS2200ProjectsImportWizardPage mainPage;
    private IStructuredSelection currentSelection = null;
    private String initialPath = null;

    public OS2200ProjectImportWizard() {
        this(null);
    }

    public OS2200ProjectImportWizard(String string) {
        this.initialPath = string;
        this.setNeedsProgressMonitor(true);
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(EXTERNAL_PROJECT_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(EXTERNAL_PROJECT_SECTION);
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new OS2200ProjectsImportWizardPage("wizardExternalProjectsPage", this.initialPath, this.currentSelection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(DataTransferMessages.DataTransfer_importTitle);
        this.setDefaultPageImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/importproj_wiz.png"));
        this.currentSelection = iStructuredSelection;
    }

    public boolean performCancel() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.mainPage.performCancel();
        try {
            if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                ImportUtilities.getInstance().cleanFolder();
                OS2200CorePlugin.logger.debug((Object)" folder deleted ");
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return true;
    }

    public boolean performFinish() {
        OS2200CorePlugin.logger.debug((Object)"");
        boolean bl = this.mainPage.createProjects();
        try {
            if (PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getPerspective().getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                Object[] objectArray = this.mainPage.getProjectsList().getCheckedElements();
                IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                int n = 0;
                while (n < objectArray.length) {
                    String string = ((OS2200ProjectsImportWizardPage.ProjectRecord)objectArray[n]).getProjectName();
                    IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                    final IProject iProject = iWorkspace.getRoot().getProject(string);
                    this.setEltIcon(iProject);
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (iProject.exists()) {
                                    long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)true);
                                    if (l == 0L) {
                                        OS2200CorePlugin.logger.info((Object)("Started downloading elements for project, " + iProject.getName()));
                                        OS2200ArchitectureUtils.startDownlodingElements(iProject.members());
                                        OS2200CorePlugin.logger.info((Object)(" Download successfull for project, " + iProject.getName()));
                                    } else {
                                        OS2200CorePlugin.logger.info((Object)("Unable to download the elements for the project, " + iProject.getName()));
                                    }
                                    final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
                                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            oS2200View.getViewer().refresh();
                                        }
                                    });
                                }
                            }
                            catch (CoreException coreException) {
                                OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                            }
                        }
                    });
                    thread.setName(iProject.getName());
                    thread.start();
                    OS2200CorePlugin.logger.info((Object)("Imported project " + iProject.getName() + " successfully."));
                    Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                    String string2 = properties.getProperty("hostID");
                    if (string2 != null && string2.trim().length() > 0) {
                        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string2);
                        HostAccount hostAccount = loginAccount.getHostAccount();
                        if (loginAccount != null) {
                            iPreferenceStore.setValue(iProject.getName(), String.valueOf(hostAccount.getCifsHostId()) + "#" + hostAccount.getCifsUserId() + "#" + hostAccount.getConnectionName());
                            ((IPersistentPreferenceStore)iPreferenceStore).save();
                        }
                    }
                    ++n;
                }
                ImportUtilities.getInstance().cleanFolder();
                OS2200CorePlugin.logger.debug((Object)" folder deleted ");
            }
            OS2200CorePlugin.logger.info((Object)"All the import activities complete.");
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return bl;
    }

    private void setEltIcon(final IProject iProject) {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            Thread thread = new Thread(Messages.getString((String)"OS2200ProjectImportWizard_0")){

                @Override
                public void run() {
                    try {
                        if (iProject.exists()) {
                            IResource[] iResourceArray;
                            final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
                            IResource[] iResourceArray2 = iResourceArray = iProject.members();
                            int n = iResourceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource iResource = iResourceArray2[n2];
                                if (iResource instanceof IFile && !iResource.toString().toLowerCase().endsWith(".project") && !iResource.toString().toLowerCase().endsWith(".settings")) {
                                    final IFile iFile = (IFile)iResource;
                                    TDECoreUtilities.getInstance().monitor(iFile.getRawLocation().toOSString());
                                    iFile.getRawLocation().toFile().setLastModified(0L);
                                    iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            oS2200View.getViewer().refresh((Object)iFile, true);
                                        }
                                    });
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

