/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.views;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.views.OS2200WorkFile;
import com.unisys.tde.ui.views.Pseudo2200Proj;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class OS2200ViewContentProvider
implements ITreeContentProvider {
    private static OS2200ViewContentProvider fStructuresViewContentProvider = null;

    public static OS2200ViewContentProvider getStructuresViewContentProvider() {
        if (fStructuresViewContentProvider == null) {
            fStructuresViewContentProvider = new OS2200ViewContentProvider();
        }
        return fStructuresViewContentProvider;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(OS2200CorePlugin.getWorkspace().getRoot());
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = new Object[]{};
        try {
            if (object instanceof IProject) {
                IProject iProject = (IProject)object;
                if (iProject.isOpen() && iProject.getNature("com.unisys.tde.core.OS2200") != null) {
                    Pseudo2200Proj pseudo2200Proj = Pseudo2200Proj.getPseudo2200Proj(iProject);
                    if (pseudo2200Proj != null) {
                        objectArray = pseudo2200Proj.members();
                    }
                } else {
                    objectArray = iProject.members();
                }
            } else if (object instanceof OS2200WorkFile) {
                OS2200WorkFile oS2200WorkFile = (OS2200WorkFile)object;
                objectArray = oS2200WorkFile.members();
            } else if (object instanceof IFolder) {
                IFolder iFolder = (IFolder)object;
                objectArray = iFolder.members();
            } else if (!(object instanceof IFile)) {
                if (object instanceof IWorkspaceRoot) {
                    IWorkspaceRoot iWorkspaceRoot = (IWorkspaceRoot)object;
                    objectArray = iWorkspaceRoot.members();
                } else {
                    OS2200CorePlugin.logger.debug((Object)"getChildren: Unknown resource type ");
                }
            }
        }
        catch (Exception exception) {}
        return this.simpleFilter(objectArray);
    }

    private Object[] simpleFilter(Object[] objectArray) {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof Pseudo2200Proj) {
                    arrayList.add(objectArray[n]);
                } else if (objectArray[n] instanceof OS2200WorkFile) {
                    arrayList.add(objectArray[n]);
                } else {
                    IResource iResource = (IResource)objectArray[n];
                    if (iResource.getName().equals("." + iResource.getFileExtension())) {
                        if (iResource instanceof IProject) {
                            arrayList.add(objectArray[n]);
                        }
                    } else {
                        arrayList.add(objectArray[n]);
                    }
                }
                ++n;
            }
            return arrayList.toArray();
        }
        catch (Exception exception) {
            return objectArray;
        }
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object getParent(Object object) {
        Object object2 = null;
        try {
            if (object instanceof IProject) {
                IProject iProject = (IProject)object;
                object2 = iProject.getParent();
            } else if (object instanceof IFolder) {
                IFolder iFolder = (IFolder)object;
                object2 = iFolder.getParent();
            } else if (object instanceof IFile) {
                IProject iProject;
                IFile iFile = (IFile)object;
                object2 = iFile.getParent();
                if (object2 instanceof IProject && (iProject = (IProject)object2).getNature("com.unisys.tde.core.OS2200") != null) {
                    object2 = Pseudo2200Proj.getIFileparent(iFile, iProject);
                }
            } else if (!(object instanceof IWorkspaceRoot)) {
                OS2200CorePlugin.logger.debug((Object)"getParent: Unknown resource type ");
            }
        }
        catch (Exception exception) {}
        return object2;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
    }
}

