/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.views;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.console.ConsoleResourceBundleMessages;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class LogView
extends ViewPart {
    private TextViewer viewer;
    private Document document = new Document();
    protected Map fGlobalActions = new HashMap();
    protected ArrayList fSelectionActions = new ArrayList();
    private IViewSite viewSite;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            LogView.this.updateSelectionDependentActions();
        }
    };
    private ITextListener textListener = new ITextListener(){

        public void textChanged(TextEvent textEvent) {
            IUpdate iUpdate = (IUpdate)LogView.this.fGlobalActions.get(ActionFactory.FIND.getId());
            if (iUpdate != null) {
                iUpdate.update();
            }
        }
    };

    public void createPartControl(Composite composite) {
        OS2200CorePlugin.logger.debug((Object)"Inside createPartControl Method");
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = iWorkspaceRoot.getLocation().append((IPath)new Path(Messages.getString((String)"MailLogInfoHandler.logfile.sourcepath")));
        this.viewer = new TextViewer(composite, 768);
        GridData gridData = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setEditable(false);
        this.viewer.setDocument((IDocument)this.document);
        try {
            this.setDocumentData(iPath);
            IFindReplaceTargetExtension cfr_ignored_0 = (IFindReplaceTargetExtension)this.viewer.getFindReplaceTarget();
            this.createActions();
            this.viewer.addSelectionChangedListener(this.selectionChangedListener);
            this.viewer.addTextListener(this.textListener);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)("Error while setting the data to the document:" + coreException.getMessage()));
            coreException.printStackTrace();
        }
    }

    private void setDocumentData(IPath iPath) throws CoreException {
        OS2200CorePlugin.logger.debug((Object)"Inside set document data Method");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(iPath.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            OS2200CorePlugin.logger.error((Object)("Error while creating the input Stream:" + fileNotFoundException.getMessage()));
            fileNotFoundException.printStackTrace();
        }
        this.document.set(LogView.convertStreamToString(fileInputStream));
    }

    public static String convertStreamToString(InputStream inputStream) {
        StringBuilder stringBuilder;
        block12: {
            OS2200CorePlugin.logger.debug((Object)"Inside convert stream to string Method");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringBuilder = new StringBuilder();
            String string = null;
            try {
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(String.valueOf(string) + "\n");
                    }
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)("Error while reading the file:" + iOException.getMessage()));
                    iOException.printStackTrace();
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        OS2200CorePlugin.logger.error((Object)("Error while closing the file:" + iOException2.getMessage()));
                        iOException2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)("Error while closing the file:" + iOException.getMessage()));
                    iOException.printStackTrace();
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)("Error while closing the file:" + iOException.getMessage()));
                iOException.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    public void setFocus() {
        OS2200CorePlugin.logger.debug((Object)"Inside setfocus method");
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void createActions() {
        IActionBars iActionBars = this.viewSite.getActionBars();
        ResourceBundle resourceBundle = ConsoleResourceBundleMessages.getBundle();
        FindReplaceAction findReplaceAction = new FindReplaceAction(resourceBundle, "find_replace_action_", (IWorkbenchPart)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)findReplaceAction, IConsoleHelpContextIds.CONSOLE_FIND_REPLACE_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.FIND.getId(), (IAction)findReplaceAction);
        iActionBars.updateActionBars();
    }

    protected void setGlobalAction(IActionBars iActionBars, String string, IAction iAction) {
        this.fGlobalActions.put(string, iAction);
        iActionBars.setGlobalActionHandler(string, iAction);
    }

    public Object getAdapter(Class clazz) {
        if (IFindReplaceTarget.class.equals((Object)clazz)) {
            return this.viewer.getFindReplaceTarget();
        }
        if (Widget.class.equals((Object)clazz)) {
            return this.viewer.getTextWidget();
        }
        return null;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.viewSite = iViewSite;
    }
}

