/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.views;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.telnet.lib.hostaccount.HostAccount;

public class HostManagerViewModel {
    private HostAccount hostAccount;
    private boolean isConnected;

    public HostManagerViewModel(HostAccount hostAccount) {
        this.hostAccount = hostAccount;
    }

    public String getHostName() {
        return this.hostAccount.getHostId();
    }

    public String getConnectionStatus() {
        boolean bl = OS2200FileInterface.isCifsConnected((HostAccount)this.hostAccount);
        if (bl) {
            return Messages.getString((String)"HManager.1");
        }
        return Messages.getString((String)"HManager.2");
    }

    public long doConnect() {
        long l = OS2200FileInterface.connectCifs((HostAccount)this.hostAccount, (String)"os2200", (boolean)true);
        return l;
    }

    public long doDisconnect() {
        return OS2200FileInterface.disconnectCifs((HostAccount)this.hostAccount, (String)"os2200");
    }

    public String getUserID() {
        return this.hostAccount.getUserId();
    }

    public HostAccount getHostAccount() {
        return this.hostAccount;
    }

    public void setHostAccount(HostAccount hostAccount) {
        this.hostAccount = hostAccount;
    }

    public String getOS() {
        if (this.hostAccount.getOS2200()) {
            return "OS 2200";
        }
        return "Unix";
    }

    public String getConnName() {
        return this.hostAccount.getConnectionName();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }
}

