/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.views;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.listeners.RegisterEvent;
import com.unisys.tde.ui.serviceprovider.ConnectionStatusUtility;
import com.unisys.tde.ui.views.HostManagerViewModel;
import com.unisys.tde.ui.views.TableSorter;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HostManagerView
extends ViewPart {
    private TableViewer tableViewer;
    private Set<HostManagerViewModel> hostSet = null;
    private Table table = null;
    private final int[] BOUNDS = new int[]{208, 208, 208, 208, 208};
    private final int[] STYLE = new int[]{0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
    String[] ordername = new String[]{"ord1", "ord2", "ord3", "ord4", "ord5"};
    private final String[] PROPS = new String[]{Messages.getString((String)"HManagerToolBar.1"), Messages.getString((String)"HManagerToolBar.2"), Messages.getString((String)"HManagerToolBar.3"), Messages.getString((String)"HManagerToolBar.4"), Messages.getString((String)"HManagerToolBar.5")};
    private TableSorter tableSorter = null;

    public void createPartControl(Composite composite) {
        int n;
        Object object;
        OS2200CorePlugin.logger.debug((Object)"");
        composite.setLayout((Layout)new FillLayout());
        this.hostSet = new HashSet<HostManagerViewModel>();
        this.fillList();
        this.tableViewer = new TableViewer(composite, 101124);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        int n2 = 0;
        while (n2 < this.PROPS.length) {
            final int n3 = n2;
            object = new TableColumn(this.table, this.STYLE[n2]);
            object.setWidth(this.BOUNDS[n2]);
            object.setText(this.PROPS[n2]);
            object.setMoveable(true);
            object.addSelectionListener((SelectionListener)new SelectionAdapter((TableColumn)object){
                private final /* synthetic */ TableColumn val$tableColumn;
                {
                    this.val$tableColumn = tableColumn;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    HostManagerView.this.sortColumn(n3, this.val$tableColumn);
                }
            });
            ++n2;
        }
        this.tableViewer.setInput(this.hostSet);
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        object = new HMVTableListener();
        this.tableViewer.getTable().addSelectionListener((SelectionListener)object);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, Messages.getString((String)"HELP_CONTEXT_HOST_ACCT_PREF"));
        this.resetStatus();
        this.tableSorter = new TableSorter();
        this.tableViewer.setSorter((ViewerSorter)this.tableSorter);
        this.tableViewer.setColumnProperties(this.PROPS);
        new RegisterEvent();
        int[] nArray = new int[5];
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        int n4 = 0;
        if (iPreferenceStore != null) {
            n = 0;
            while (n < 5) {
                nArray[n] = iPreferenceStore.getInt(this.ordername[n]);
                n4 += nArray[n];
                ++n;
            }
        }
        if (n4 != 10) {
            n = 0;
            while (n < 5) {
                nArray[n] = n;
                ++n;
            }
        }
        this.tableViewer.getTable().setColumnOrder(nArray);
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                HostManagerView.this.setWindowSettings();
            }
        });
    }

    public void fillList() {
        HostAccount[] hostAccountArray = HostAccount.getHostAccounts();
        this.hostSet.clear();
        HostManagerViewModel hostManagerViewModel = null;
        int n = 0;
        while (n < hostAccountArray.length) {
            hostManagerViewModel = new HostManagerViewModel(hostAccountArray[n]);
            hostManagerViewModel.setConnected(OS2200FileInterface.isCifsConnected((HostAccount)hostAccountArray[n]));
            this.hostSet.add(hostManagerViewModel);
            ++n;
        }
    }

    public void updateHMVSet(HostAccount hostAccount) {
        OS2200CorePlugin.logger.debug((Object)"");
        if (this.hostSet != null) {
            HostManagerViewModel hostManagerViewModel = new HostManagerViewModel(hostAccount);
            hostManagerViewModel.setConnected(OS2200FileInterface.isCifsConnected((HostAccount)hostAccount));
            this.hostSet.add(hostManagerViewModel);
        }
    }

    public void updateHostManagerView() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.tableViewer.setInput(this.hostSet);
        this.resetStatus();
        this.tableViewer.refresh();
    }

    public void updateHostManagerView(HashSet<HostManagerViewModel> hashSet) {
        OS2200CorePlugin.logger.debug((Object)"");
        this.tableViewer.setInput(hashSet);
        this.tableViewer.refresh();
    }

    public void updateHstMgrView(HostAccount hostAccount, boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"");
        HostManagerViewModel hostManagerViewModel2 = null;
        for (HostManagerViewModel hostManagerViewModel2 : this.hostSet) {
            if (!hostManagerViewModel2.getHostAccount().getConnectionName().equalsIgnoreCase(hostAccount.getConnectionName())) continue;
            hostManagerViewModel2.setHostAccount(hostAccount);
            hostManagerViewModel2.setConnected(bl);
        }
        this.tableViewer.setInput(this.hostSet);
        this.resetStatus();
        this.tableViewer.refresh(this.hostSet);
    }

    public void deleteFromHostManagerView(String string) {
        OS2200CorePlugin.logger.debug((Object)"");
        boolean bl = false;
        HostManagerViewModel hostManagerViewModel = null;
        for (HostManagerViewModel hostManagerViewModel2 : this.hostSet) {
            if (!hostManagerViewModel2.getHostAccount().getConnectionName().equalsIgnoreCase(string)) continue;
            hostManagerViewModel = hostManagerViewModel2;
            bl = true;
            break;
        }
        if (bl) {
            HostManagerViewModel hostManagerViewModel2;
            hostManagerViewModel2 = hostManagerViewModel.getHostAccount();
            this.hostSet.remove(hostManagerViewModel);
            if (HostAccount._hostaccounts.contains(hostManagerViewModel2)) {
                HostAccount.Remove((HostAccount)hostManagerViewModel2);
            }
            HostAccount.Save();
            if (LoginAccount._loginaccounts.contains(hostManagerViewModel2)) {
                LoginAccount.Remove((String)hostManagerViewModel2.getConnectionName());
            }
            LoginAccount.Save();
            this.resetStatus();
        }
        this.tableViewer.setInput(this.hostSet);
        this.tableViewer.refresh();
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void saveBeforeOperation(String string) {
        OS2200CorePlugin.logger.debug((Object)"");
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = null;
        IWorkbenchPage iWorkbenchPage = null;
        if (iWorkbench != null) {
            iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        }
        if (iWorkbenchWindow != null) {
            iWorkbenchPage = iWorkbenchWindow.getActivePage();
        }
        if (iWorkbenchPage != null && iWorkbenchPage.getEditorReferences() != null) {
            ArrayList<IEditorReference[]> arrayList = new ArrayList<IEditorReference[]>();
            ArrayList<IEditorPart> arrayList2 = new ArrayList<IEditorPart>();
            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            try {
                IEditorReference[] iEditorReferenceArray2;
                IEditorReference[] iEditorReferenceArray3 = iEditorReferenceArray;
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    iEditorReferenceArray2 = iEditorReferenceArray3[n2];
                    if (iEditorReferenceArray2.getEditorInput() instanceof FileEditorInput) {
                        IFile iFile = ((FileEditorInput)iEditorReferenceArray2.getEditorInput()).getFile();
                        List list = OS2200ProjectUpdate.getProjListOfHost((String)string);
                        String string2 = iFile.getProject().getName();
                        if (list != null && list.size() != 0) {
                            for (String string3 : list) {
                                if (!string2.equalsIgnoreCase(string3)) continue;
                                if (iEditorReferenceArray2.isDirty()) {
                                    arrayList2.add(iEditorReferenceArray2.getEditor(false));
                                }
                                arrayList.add(iEditorReferenceArray2);
                            }
                        }
                    }
                    ++n2;
                }
                if (arrayList2.size() > 0) {
                    int n3 = 0;
                    while (n3 < arrayList2.size()) {
                        iWorkbenchPage.saveEditor((IEditorPart)arrayList2.get(n3), true);
                        ++n3;
                    }
                }
                if (arrayList.size() > 0) {
                    iEditorReferenceArray2 = new IEditorReference[arrayList.size()];
                    n2 = 0;
                    while (n2 < iEditorReferenceArray2.length) {
                        iEditorReferenceArray2[n2] = (IEditorReference)arrayList.get(n2);
                        ++n2;
                    }
                    iWorkbenchPage.closeEditors(iEditorReferenceArray2, false);
                }
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void resetStatus() {
        this.tableViewer.getTable().select(this.getOrientation());
    }

    public void createWaitingCursor() {
        this.tableViewer.getTable().getShell().setCursor(this.table.getDisplay().getSystemCursor(1));
    }

    public void disposeWaitingCursor() {
        this.tableViewer.getTable().getShell().setCursor(null);
    }

    private void sortColumn(int n, TableColumn tableColumn) {
        this.tableSorter.setColumn(n);
        int n2 = this.tableViewer.getTable().getSortDirection();
        n2 = n2 == 128 ? 1024 : 128;
        this.tableViewer.getTable().setSortDirection(n2);
        this.tableViewer.getTable().setSortColumn(tableColumn);
        this.tableViewer.refresh();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void setWindowSettings() {
        int[] nArray = this.tableViewer.getTable().getColumnOrder();
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        try {
            if (iPreferenceStore != null) {
                int n = 0;
                while (n < nArray.length) {
                    iPreferenceStore.putValue(this.ordername[n], String.valueOf(nArray[n]));
                    ++n;
                }
                ((IPersistentPreferenceStore)iPreferenceStore).save();
            }
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)iOException);
        }
    }

    private class HMVTableListener
    implements SelectionListener {
        private HostManagerViewModel hmvm = null;

        private HMVTableListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"");
            try {
                if (selectionEvent.item != null) {
                    Object object = ((TableItem)selectionEvent.item).getData();
                    if (object instanceof HostManagerViewModel) {
                        this.hmvm = (HostManagerViewModel)object;
                    }
                    ConnectionStatusUtility.changeStatus(HostManagerView.this, this.hmvm);
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    private class SimpleLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image connected = AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString((String)"HManager.0"), (String)Messages.getString((String)"HManagericon.1")).createImage();
        private Image disconnected = AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString((String)"HManager.0"), (String)Messages.getString((String)"HManagericon.2")).createImage();

        SimpleLabelProvider() {
        }

        public void dispose() {
            this.connected.dispose();
            this.connected = null;
            this.disconnected.dispose();
            this.disconnected = null;
            super.dispose();
        }

        public Image getColumnImage(Object object, int n) {
            HostManagerViewModel hostManagerViewModel = (HostManagerViewModel)object;
            HostAccount hostAccount = hostManagerViewModel.getHostAccount();
            switch (n) {
                case 0: {
                    if (OS2200FileInterface.isCifsConnected((HostAccount)hostAccount) && hostManagerViewModel.isConnected()) {
                        return this.connected;
                    }
                    return this.disconnected;
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            HostManagerViewModel hostManagerViewModel = (HostManagerViewModel)object;
            HostAccount hostAccount = hostManagerViewModel.getHostAccount();
            switch (n) {
                case 0: {
                    return hostAccount.getCifsHostId();
                }
                case 1: {
                    String string = OS2200FileInterface.isCifsConnected((HostAccount)hostAccount) && hostManagerViewModel.isConnected() ? "Connected" : "Disconnected";
                    return string;
                }
                case 2: {
                    return hostAccount.getCifsUserId();
                }
                case 3: {
                    return hostManagerViewModel.getOS();
                }
                case 4: {
                    return hostAccount.getConnectionName();
                }
            }
            return null;
        }
    }
}

