/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.views;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.ui.actions.OpenFileAction;
import com.unisys.tde.ui.handler.COBOLErrorsObject;
import com.unisys.tde.ui.utils.ActiveEditorFilePath;
import com.unisys.tde.ui.utils.COBOLRulesEngine;
import com.unisys.tde.ui.utils.OpenElement;
import com.unisys.tde.ui.views.MyLabelProvider;
import com.unisys.tde.ui.views.MyTreeContentProvider;
import com.unisys.tde.ui.views.Node;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.preferences.ConfigureCOBOLRulesConstants;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class COBOLErrorsView
extends ViewPart {
    private Tree tree = null;
    private Vector<Node> nodes = new Vector();
    private COBOLEditor editor = null;
    private StyledText styledTextObject = null;
    public static TreeViewer treeViewer = null;
    private COBOLRulesEngine ruleEngine = null;

    public void createPartControl(Composite composite) {
        this.tree = new Tree(composite, 2048);
        treeViewer = new TreeViewer(this.tree);
        treeViewer.setContentProvider((IContentProvider)new MyTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.cleanview();
        this.loadTree();
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
                if (iStructuredSelection.isEmpty()) {
                    return;
                }
                try {
                    IWorkbench iWorkbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    Widget widget = selectionEvent.item;
                    if (widget instanceof TreeItem) {
                        TreeItem treeItem = (TreeItem)widget;
                        String string = treeItem.getText();
                        if (!string.contains("::")) {
                            return;
                        }
                        String[] stringArray = string.split("::");
                        int n = Integer.parseInt(stringArray[0].trim());
                        COBOLErrorsObject cOBOLErrorsObject = COBOLErrorsView.this.ruleEngine.getCOBOLErrorsObject();
                        if (cOBOLErrorsObject == null) {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"COBOLErrorsView.fileMissing"), (String)Messages.getString((String)"COBOLErrorsView.fileDeleted"));
                            return;
                        }
                        if (!OpenElement.isElementOpen(cOBOLErrorsObject.getEdiPart(), iWorkbenchPage).booleanValue()) {
                            if ((cOBOLErrorsObject = COBOLErrorsView.this.openElement(cOBOLErrorsObject, iWorkbenchPage)) == null) {
                                return;
                            }
                            COBOLErrorsView.this.editor = (COBOLEditor)cOBOLErrorsObject.getEdiPart();
                        }
                        IDocument iDocument = COBOLErrorsView.this.editor.getDocumentProvider().getDocument((Object)COBOLErrorsView.this.ruleEngine.getCOBOLErrorsObject().getEdiPart().getEditorInput());
                        int n2 = iDocument.getLineOffset(n - 1);
                        COBOLErrorsView.this.styledTextObject = COBOLErrorsView.this.editor.getCurrentSourceViewer().getTextWidget();
                        COBOLErrorsView.this.editor.selectAndReveal(n2, COBOLErrorsView.this.styledTextObject.getLine(n - 1).length());
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"Title.error"), (String)Messages.getString((String)"COBOLErrorsView.errorinDisplay"));
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.tree.setSize(300, 200);
    }

    public void loadTree() {
        String string = ActiveEditorFilePath.getActiveEditorFilePath();
        if (string != null) {
            Node node = new Node(string, null);
            this.nodes.add(node);
            this.buildTree(node);
            treeViewer.setInput(this.nodes);
            TreeItem[] treeItemArray = this.tree.getItems();
            if (treeItemArray[0].getItems().length == 0) {
                this.nodes.add(new Node(Messages.getString((String)"COBOLErrorsHandler.noErrorsChecked"), null));
                treeViewer.setInput(this.nodes);
                treeViewer.refresh();
            }
        }
    }

    private void buildTree(Node node) {
        try {
            this.ruleEngine = new COBOLRulesEngine();
            this.ruleEngine.beginRulesEngine();
            this.editor = (COBOLEditor)this.ruleEngine.getCOBOLErrorsObject().getEdiPart();
            String string = "";
            int n = 0;
            IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
            this.styledTextObject = this.editor.getCurrentSourceViewer().getTextWidget();
            Set<Map.Entry<Integer, List<Integer>>> set = this.ruleEngine.getErrorData().entrySet();
            for (Map.Entry<Integer, List<Integer>> entry : set) {
                Node node2 = null;
                String string2 = iPreferenceStore.getString(ConfigureCOBOLRulesConstants.RULES[entry.getKey()]);
                if (string2.isEmpty()) {
                    string2 = (String)ConfigureCOBOLRulesConstants.DEFAULTRULEMAP.get(ConfigureCOBOLRulesConstants.RULES[entry.getKey()]);
                }
                node2 = new Node(String.valueOf(ConfigureCOBOLRulesConstants.RULES[entry.getKey()]) + " : Priority - " + string2, node);
                List<Integer> list = entry.getValue();
                int n2 = 0;
                while (n2 < list.size()) {
                    string = this.styledTextObject.getLine(list.get(n2).intValue());
                    n = list.get(n2) + 1;
                    new Node(String.valueOf(n) + "::" + string, node2);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void setFocus() {
    }

    protected COBOLErrorsObject openElement(COBOLErrorsObject cOBOLErrorsObject, IWorkbenchPage iWorkbenchPage) {
        if (cOBOLErrorsObject.getEditorType().equals((Object)OpenEditorTypes.LinkedToProject)) {
            IFile iFile = cOBOLErrorsObject.getIfile();
            if (iFile == null && cOBOLErrorsObject.getEdiInput() instanceof FileEditorInput) {
                iFile = ((FileEditorInput)cOBOLErrorsObject.getEdiInput()).getFile();
            }
            if ((iFile = this.syncIFileWithProject(iFile)) == null || !iFile.getLocation().toFile().exists()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"COBOLErrorsView.fileMissing"), (String)Messages.getString((String)"COBOLErrorsView.fileDeleted", (String)cOBOLErrorsObject.getIfile().toString()));
                OS2200CorePlugin.logger.warn((Object)"file is null or does not exist");
                return null;
            }
            OpenFileAction openFileAction = new OpenFileAction(iWorkbenchPage);
            boolean bl = openFileAction.initiateOpenElement(iFile);
            if (bl) {
                IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
                if (iEditorPart == null) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"COBOLErrorsView.fileMissing"), (String)Messages.getString((String)"COBOLErrorsView.fileDeleted", (String)cOBOLErrorsObject.getIfile().toString()));
                    OS2200CorePlugin.logger.warn((Object)"editorPart is null");
                    return null;
                }
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                cOBOLErrorsObject = new COBOLErrorsObject(iEditorPart, iEditorInput, iFile, OpenEditorTypes.LinkedToProject);
            }
            return cOBOLErrorsObject;
        }
        if (cOBOLErrorsObject.getEditorType().equals((Object)OpenEditorTypes.LinkedToOFCS)) {
            IEditorPart iEditorPart = null;
            File file = cOBOLErrorsObject.getFile();
            if (!file.exists()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"COBOLErrorsView.fileMissing"), (String)Messages.getString((String)"COBOLErrorsView.fileDeleted", (String)cOBOLErrorsObject.getFile().getName()));
                OS2200CorePlugin.logger.warn((Object)"file does not exist");
                return null;
            }
            iEditorPart = cOBOLErrorsObject.getOS2200fileEdInput().getEditorid() != null ? OS2200FileInterface.openFileInEditor((File)file, (OS2200FileEditorInput)cOBOLErrorsObject.getOS2200fileEdInput()) : OS2200FileInterface.OpenAction((File)file, (OS2200FileEditorInput)cOBOLErrorsObject.getOS2200fileEdInput());
            if (iEditorPart == null) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"Title.information"), (String)Messages.getString((String)"COBOLErrorsView.unableToOpen", (String)cOBOLErrorsObject.getFile().getName()));
                OS2200CorePlugin.logger.warn((Object)"editor part is null");
            } else {
                cOBOLErrorsObject = new COBOLErrorsObject(iEditorPart, cOBOLErrorsObject.getOS2200fileEdInput(), file, OpenEditorTypes.LinkedToOFCS);
            }
            return cOBOLErrorsObject;
        }
        if (cOBOLErrorsObject.getEditorType().equals((Object)OpenEditorTypes.LocalFile)) {
            File file = cOBOLErrorsObject.getFile();
            if (!file.exists()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"COBOLErrorsView.fileMissing"), (String)Messages.getString((String)"COBOLErrorsView.fileDeleted", (String)cOBOLErrorsObject.getFile().getName()));
                OS2200CorePlugin.logger.warn((Object)"file does not exist");
                return null;
            }
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(file.toURI());
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
            }
            catch (PartInitException partInitException) {
                OS2200CorePlugin.logger.error((Object)partInitException.getMessage(), (Throwable)partInitException);
                return null;
            }
            cOBOLErrorsObject = new COBOLErrorsObject(iWorkbenchPage.getActiveEditor(), cOBOLErrorsObject.getEdiInput(), file, OpenEditorTypes.LocalFile);
            return cOBOLErrorsObject;
        }
        return null;
    }

    private IFile syncIFileWithProject(IFile iFile) {
        block11: {
            if (iFile.getProject().findMember(iFile.getProjectRelativePath()) != null) {
                return iFile;
            }
            try {
                try {
                    IResource[] iResourceArray = null;
                    if (iFile.getProject() instanceof IProject) {
                        iResourceArray = iFile.getProject().members();
                    }
                    if (iResourceArray == null || iResourceArray.length <= 0) break block11;
                    int n = 0;
                    while (n < iResourceArray.length) {
                        if (iResourceArray[n] instanceof IFile) {
                            if (iResourceArray[n].toString().contains(".") && iResourceArray[n].toString().replace(" ", "").substring(0, iResourceArray[n].toString().indexOf(".")).equals(iFile.toString())) {
                                iFile = (IFile)iResourceArray[n];
                                break;
                            }
                            if (iFile.toString().contains(".") && iFile.toString().replace(" ", "").substring(0, iFile.toString().indexOf(".")).equals(iResourceArray[n].toString())) {
                                iFile = (IFile)iResourceArray[n];
                                break;
                            }
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
                }
            }
            catch (Throwable throwable) {}
        }
        if (iFile.isAccessible()) {
            return iFile;
        }
        return null;
    }

    public void cleanview() {
        this.nodes.clear();
        treeViewer.refresh();
    }

    public void dispose() {
        this.ruleEngine.dispose();
    }

    public static enum OpenEditorTypes {
        LinkedToProject,
        LinkedToOFCS,
        LocalFile,
        None;

    }
}

