/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.utils;

import com.unisys.os2200.editor.editors.UDTEditor;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class RetrieveSelectionForFieldSize {
    private final String LEVEL_NUMS = "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,66,77,88";
    private final String LF = "\n";
    private final String EMPTY_STR = "";
    private final String SINGLE_SPACE = " ";
    private final String EIGHTY_SPACES = "                                                                                ";
    private final String CHARS_FOR_COMMENT = "*D-/";
    private final String PERIOD = ".";
    private final String TAB_CHAR = "\t";
    private final String FOUR_SPACES = "    ";
    private final String USAGE = " USAGE";
    private final String DISPLAY = " DISPLAY";
    private final String DISP = " DISP";
    private final String SPL_LEVELS = "77";
    private final int MAX_SCAN = 5;
    private IEditorPart edtPart = null;
    private IDocument document = null;
    private String[] wholeLines = null;
    public static String lineDelimiter = null;
    private String firstSelLine = "";
    private String lastSelLine = "";
    private String strTemp = "";
    private String level = "";
    public String stat = "";
    private int varLevel = 0;
    private int count = 0;
    private int startLine = -1;
    private int endLine = -1;
    private int docLength = 0;
    private boolean isMoreExpected = false;

    public String getSelection() {
        String string;
        long l;
        block18: {
            l = System.currentTimeMillis();
            this.initialize();
            lineDelimiter = null;
            string = null;
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null) {
                this.edtPart = iWorkbenchPage.getActiveEditor();
                if (this.edtPart != null) {
                    block17: {
                        ITextSelection iTextSelection;
                        block20: {
                            block21: {
                                block19: {
                                    try {
                                        if (!(this.edtPart instanceof ITextEditor)) break block17;
                                        ISelectionProvider iSelectionProvider = ((ITextEditor)this.edtPart).getSelectionProvider();
                                        ISelection iSelection = iSelectionProvider.getSelection();
                                        if (!(iSelection instanceof ITextSelection)) break block18;
                                        iTextSelection = (ITextSelection)iSelection;
                                        if (!(this.edtPart instanceof COBOLEditor)) break block19;
                                        COBOLEditor cOBOLEditor = (COBOLEditor)this.edtPart;
                                        if (cOBOLEditor != null) {
                                            this.document = cOBOLEditor.getDocumentProvider().getDocument((Object)this.edtPart.getEditorInput());
                                            break block20;
                                        }
                                        this.logError("FieldSizeInput.9", "FieldSizeInput.1");
                                        return null;
                                    }
                                    catch (Exception exception) {
                                        this.logError("FieldSizeInput.9", exception.getMessage());
                                        return null;
                                    }
                                }
                                if (!(this.edtPart instanceof UDTEditor)) break block21;
                                UDTEditor uDTEditor = (UDTEditor)this.edtPart;
                                if (uDTEditor != null) {
                                    this.document = uDTEditor.getDocumentProvider().getDocument((Object)this.edtPart.getEditorInput());
                                    break block20;
                                }
                                this.logError("FieldSizeInput.9", "FieldSizeInput.1");
                                return null;
                            }
                            this.logError("FieldSizeInput.7", "FieldSizeInput.8");
                            return null;
                        }
                        this.startLine = iTextSelection.getStartLine();
                        this.endLine = iTextSelection.getEndLine();
                        if (this.document != null) {
                            lineDelimiter = this.document.getLineDelimiter(this.startLine);
                            if (lineDelimiter != null) {
                                this.wholeLines = this.document.get().split(lineDelimiter);
                            } else {
                                OS2200CorePlugin.logger.debug((Object)"Line-delimiter retrieved as NULL. New-Line character would be considered for line-delimiter.");
                                this.wholeLines = this.document.get().split("\n");
                            }
                        } else {
                            this.logError("FieldSizeInput.9", "FieldSizeInput.2");
                            return null;
                        }
                        string = this.markSelection(this.startLine, this.endLine);
                        if (string != null && string.trim().length() > 0) {
                            string = this.getCompleteSelection();
                            break block18;
                        }
                        this.logError("FieldSizeInput.9", "FieldSizeInput.3");
                        return null;
                    }
                    this.stat = Messages.getString((String)"FieldSizeInput.7");
                    OS2200CorePlugin.logger.debug((Object)this.stat);
                    return null;
                }
            }
        }
        if (string == null || string.trim().length() <= 0) {
            this.logError("FieldSizeInput.9", "FieldSizeInput.3");
            return null;
        }
        string = this.formatString(string);
        long l2 = System.currentTimeMillis();
        OS2200CorePlugin.logger.info((Object)("Total time taken for selection: " + Long.toString((l2 - l) / 1000L)));
        return string;
    }

    private void logError(String string, String string2) {
        this.stat = Messages.getString((String)string);
        if (string2.length() > 0) {
            this.stat = string2.startsWith("FieldSizeInput.") ? String.valueOf(this.stat) + Messages.getString((String)"FieldSizeInput.14") + Messages.getString((String)string2) : String.valueOf(this.stat) + Messages.getString((String)"FieldSizeInput.14") + string2;
        }
        if (this.stat.length() > 0) {
            if (this.stat.contains("\n")) {
                OS2200CorePlugin.logger.debug((Object)this.stat.substring(0, this.stat.indexOf("\n")));
            } else {
                OS2200CorePlugin.logger.debug((Object)this.stat);
            }
        }
    }

    private String getCompleteSelection() {
        String string = "";
        this.docLength = this.wholeLines.length;
        if (this.docLength <= 0) {
            this.logError("FieldSizeInput.9", "FieldSizeInput.11");
            return null;
        }
        if (this.startLine >= this.docLength) {
            OS2200CorePlugin.logger.debug((Object)("startLine (" + Integer.toString(this.startLine) + ") is greater than the length of wholeLines (" + Integer.toString(this.docLength) + "). startLine would be considered as 0."));
            this.startLine = 0;
        }
        if (this.endLine >= this.docLength || this.endLine < this.startLine) {
            OS2200CorePlugin.logger.debug((Object)("endLine (" + Integer.toString(this.endLine) + ") is greater than the length of wholeLines (" + Integer.toString(this.docLength) + "). endLine would be considered as (length of wholeLines - 1)."));
            this.endLine = this.docLength - 1;
        }
        int n = this.startLine;
        int n2 = this.endLine;
        this.firstSelLine = this.formatString(this.wholeLines[this.startLine]);
        this.firstSelLine = (String.valueOf(this.firstSelLine) + "                                                                                ").substring(6, 72);
        this.lastSelLine = this.formatString(this.wholeLines[this.endLine]);
        this.lastSelLine = (String.valueOf(this.lastSelLine) + "                                                                                ").substring(6, 72);
        if (!this.isCommented(this.firstSelLine)) {
            this.firstSelLine = this.firstSelLine.substring(1).trim();
            if (!this.hasLevel(this.firstSelLine)) {
                this.startLine = this.getLevelFromPrevLines(this.startLine);
            }
        }
        this.initialize();
        if (!this.isCommented(this.lastSelLine)) {
            this.lastSelLine = this.lastSelLine.substring(1).trim();
            if (!this.hasLevel(this.lastSelLine)) {
                this.endLine = this.getLevelFromPrevLines(this.endLine);
                if (this.endLine < 0) {
                    this.endLine = n2;
                }
            }
            this.lastSelLine = (String.valueOf(this.formatString(this.wholeLines[this.endLine])) + "                                                                                ").substring(6, 72);
        }
        if (!this.isCommented(this.lastSelLine)) {
            this.lastSelLine = this.lastSelLine.substring(1).trim();
            if (this.hasLevel(this.lastSelLine)) {
                try {
                    this.strTemp = "";
                    this.varLevel = Integer.parseInt(this.lastSelLine.substring(0, this.lastSelLine.indexOf(" ")).trim());
                    if (!this.lastSelLine.contains(" USAGE")) {
                        this.processLastSelLine();
                    } else {
                        this.strTemp = this.lastSelLine.substring(this.lastSelLine.indexOf(" USAGE") + " USAGE".length());
                        if (this.strTemp.contains(" DISPLAY") || this.strTemp.contains(" DISP")) {
                            this.processLastSelLine();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.logError("FieldSizeInput.9", numberFormatException.getMessage());
                }
                catch (Exception exception) {
                    this.logError("FieldSizeInput.9", exception.getMessage());
                }
            }
        }
        if (this.startLine > -1 && this.endLine > -1 && this.endLine < this.wholeLines.length && this.startLine <= this.endLine) {
            return this.markSelection(this.startLine, this.endLine);
        }
        OS2200CorePlugin.logger.info((Object)("Original startLine and endLine values: " + Integer.toString(n) + " " + Integer.toString(n2)));
        string = "startLine and endLine have incorrect values: " + Integer.toString(this.startLine) + " " + Integer.toString(this.endLine);
        this.logError("FieldSizeInput.9", string);
        return null;
    }

    private void processLastSelLine() {
        this.getCompleteVarDefinition();
        this.initialize();
        this.processGroupLevel();
    }

    private String formatString(String string) {
        if (string != null && string.length() > 0) {
            string = string.replace("\t", "    ");
        }
        return string;
    }

    private void getCompleteVarDefinition() {
        if (!this.hasPeriod(this.lastSelLine)) {
            int n = this.endLine + 1;
            while (n < this.docLength) {
                this.lastSelLine = (String.valueOf(this.formatString(this.wholeLines[n])) + "                                                                                ").substring(6, 72);
                if (!this.isCommented(this.lastSelLine)) {
                    this.lastSelLine = this.lastSelLine.substring(1).trim();
                    if (this.hasLevel(this.lastSelLine)) {
                        this.endLine = n - 1;
                        break;
                    }
                    if (this.hasPeriod(this.lastSelLine)) {
                        this.endLine = n;
                        break;
                    }
                }
                ++n;
            }
        }
    }

    private int getLevelFromPrevLines(int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = (String.valueOf(this.formatString(this.wholeLines[n2])) + "                                                                                ").substring(6, 72);
            if (!this.isCommented(string)) {
                if (this.hasLevel(string = string.substring(1).trim())) {
                    if (this.hasPeriod(string)) break;
                    n = n2;
                    break;
                }
                if (this.hasPeriod(string)) break;
                ++this.count;
                if (this.count > 5) break;
            }
            --n2;
        }
        this.count = 0;
        return n;
    }

    private void processGroupLevel() {
        int n = this.endLine + 1;
        while (n < this.docLength) {
            this.lastSelLine = (String.valueOf(this.formatString(this.wholeLines[n])) + "                                                                                ").substring(6, 72);
            if (this.lastSelLine.trim().length() > 0 && !this.isCommented(this.lastSelLine)) {
                this.lastSelLine = this.lastSelLine.substring(1).trim();
                if (this.hasLevel(this.lastSelLine)) {
                    if (this.isMoreExpected) {
                        this.isMoreExpected = false;
                    }
                    if (this.level.trim().length() <= 0 || !NumberUtils.isNumber((String)this.level) || Integer.parseInt(this.level) <= this.varLevel || "77".equals(this.level)) break;
                    this.endLine = n;
                    if (!this.hasPeriod(this.lastSelLine)) {
                        this.isMoreExpected = true;
                    }
                } else {
                    if (!this.isMoreExpected) break;
                    if (this.hasPeriod(this.lastSelLine)) {
                        this.endLine = n;
                        this.isMoreExpected = false;
                    }
                }
            }
            ++n;
        }
    }

    private boolean isCommented(String string) {
        return "*D-/".indexOf(string.substring(0, 1)) >= 0;
    }

    private boolean hasLevel(String string) {
        String string2;
        this.level = "";
        if (string.contains(" ") && "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,66,77,88".indexOf(string2 = string.substring(0, string.indexOf(" ")).trim()) >= 0) {
            this.level = string2;
            return true;
        }
        return false;
    }

    private boolean hasPeriod(String string) {
        return string.endsWith(".");
    }

    private void initialize() {
        this.count = 0;
        this.isMoreExpected = false;
        this.stat = "";
    }

    private String markSelection(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        try {
            n3 = this.document.getLineOffset(n);
            n4 = this.document.getLineOffset(n2) + this.document.getLineLength(n2);
            n5 = n4 - n3;
            return this.document.get(n3, n5);
        }
        catch (BadLocationException badLocationException) {
            this.logError("FieldSizeInput.9", badLocationException.getMessage());
            return null;
        }
    }
}

