/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.utils;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.utils.CacheElementLister;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectCacheClearUtils {
    private final String DOT_PROJECT = ".project";
    private final String DATA_CACHE = "Data-Cache";
    private final String DOT_SETTINGS = ".settings";

    public ProjectCacheClearUtils() {
        OS2200CorePlugin.logger.debug((Object)"");
    }

    private IProject[] getProjectsInWorkspace() {
        OS2200CorePlugin.logger.debug((Object)"");
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return iProjectArray;
    }

    private LinkedList<String> fetchElementListFromProject(IProject iProject) {
        LinkedList<String> linkedList;
        block5: {
            OS2200CorePlugin.logger.debug((Object)"");
            linkedList = new LinkedList<String>();
            try {
                if (!iProject.hasNature("com.unisys.tde.core.OS2200")) break block5;
                if (iProject.isOpen()) {
                    IResource[] iResourceArray = iProject.members();
                    OS2200CorePlugin.logger.info((Object)("Fetching " + iResourceArray.length + " elements info for project, " + iProject.getName()));
                    String string = null;
                    int n = 0;
                    while (n < iResourceArray.length) {
                        string = iResourceArray[n].getName();
                        if (!string.equalsIgnoreCase(".settings") && !string.equalsIgnoreCase(".project")) {
                            linkedList.add(iResourceArray[n].getRawLocation().toOSString());
                        }
                        ++n;
                    }
                    string = null;
                    iResourceArray = null;
                    OS2200CorePlugin.logger.info((Object)"*** Fetch complete *** ");
                    break block5;
                }
                OS2200CorePlugin.logger.info((Object)("Project, " + iProject.getName() + " is not open."));
                List<String> list = this.getElementsforClosedProject(iProject);
                linkedList.addAll(list);
                list = null;
                return linkedList;
            }
            catch (CoreException coreException) {
                OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
            }
        }
        return linkedList;
    }

    private LinkedList<String> accumulateFinalElementList(IProject[] iProjectArray) {
        OS2200CorePlugin.logger.debug((Object)"");
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        while (n < iProjectArray.length) {
            linkedList.addAll(this.fetchElementListFromProject(iProjectArray[n]));
            ++n;
        }
        return linkedList;
    }

    private void performDeleteOperation(LinkedList<String> linkedList) {
        OS2200CorePlugin.logger.debug((Object)"");
        File file = null;
        Iterator iterator = linkedList.iterator();
        OS2200CorePlugin.logger.info((Object)("Starting delete operation for " + linkedList.size() + " elements."));
        while (iterator.hasNext()) {
            file = new File((String)iterator.next());
            if (!file.exists()) continue;
            try {
                if (file.delete()) {
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(file.getAbsolutePath()) + ", deleted successfully."));
                    continue;
                }
                OS2200CorePlugin.logger.info((Object)(String.valueOf(file.getAbsolutePath()) + ", could not be deleted."));
            }
            catch (SecurityException securityException) {
                OS2200CorePlugin.logger.info((Object)securityException.getMessage(), (Throwable)securityException);
            }
        }
        file = null;
        OS2200CorePlugin.logger.info((Object)"delete operation complete.");
    }

    private LinkedList<String> getElementsInCache() {
        OS2200CorePlugin.logger.debug((Object)"");
        LinkedList<String> linkedList = null;
        CacheElementLister cacheElementLister = new CacheElementLister();
        String string = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toOSString();
        String string2 = String.valueOf(string) + File.separator + "Data-Cache";
        try {
            File file = new File(string2);
            if (file.exists()) {
                cacheElementLister.fetchElementList(string2, false);
                linkedList = cacheElementLister.getElementList();
                if (linkedList != null) {
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(linkedList.size()) + " elements in the cache"));
                }
            } else {
                OS2200CorePlugin.logger.debug((Object)(String.valueOf(file.getAbsolutePath()) + ", does not exist in the path, "));
            }
            file = null;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        cacheElementLister = null;
        return linkedList;
    }

    public void startClearOperation() {
        block8: {
            OS2200CorePlugin.logger.debug((Object)"");
            IProject[] iProjectArray = null;
            LinkedList<String> linkedList = null;
            LinkedList<String> linkedList2 = null;
            try {
                try {
                    iProjectArray = this.getProjectsInWorkspace();
                    linkedList = this.accumulateFinalElementList(iProjectArray);
                    linkedList2 = this.getElementsInCache();
                    if (linkedList2 != null) {
                        linkedList2.removeAll(linkedList);
                        if (linkedList2.size() > 0) {
                            this.performDeleteOperation(linkedList2);
                        } else {
                            OS2200CorePlugin.logger.info((Object)"No elements to delete.");
                        }
                        break block8;
                    }
                    OS2200CorePlugin.logger.info((Object)"No elements to delete.");
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    iProjectArray = null;
                    linkedList = null;
                    linkedList2 = null;
                }
            }
            finally {
                iProjectArray = null;
                linkedList = null;
                linkedList2 = null;
            }
        }
    }

    private List<String> getElementsforClosedProject(IProject iProject) {
        OS2200CorePlugin.logger.debug((Object)("Fetching element path for the project, " + iProject.getName()));
        String string = null;
        String string2 = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        File file = null;
        Document document = null;
        NodeList nodeList = null;
        Node node = null;
        NodeList nodeList2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            try {
                string = iProject.getLocation().toOSString();
                string2 = String.valueOf(string) + File.separator + ".project";
                file = new File(string2);
                if (file.exists()) {
                    documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    document = documentBuilder.parse(file);
                    document.getDocumentElement().normalize();
                    nodeList = document.getElementsByTagName("linkedResources");
                    node = nodeList.item(0);
                    nodeList2 = node.getChildNodes();
                    int n = 0;
                    while (n < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n);
                        if (node2.getNodeType() == 1) {
                            NodeList nodeList3 = node2.getChildNodes();
                            int n2 = 0;
                            while (n2 < nodeList3.getLength()) {
                                Node node3 = nodeList3.item(n2);
                                if (node3.getNodeType() == 1 && node3.getNodeName().equalsIgnoreCase("location")) {
                                    Element element = (Element)node3;
                                    linkedList.add(element.getTextContent().replace("/", "\\"));
                                    element = null;
                                }
                                node3 = null;
                                ++n2;
                            }
                            nodeList3 = null;
                        }
                        node2 = null;
                        ++n;
                    }
                } else {
                    OS2200CorePlugin.logger.debug((Object)(String.valueOf(file.getAbsolutePath()) + " does not exist. File might have been corrupt/deleted."));
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                nodeList2 = null;
                node = null;
                nodeList = null;
                document = null;
                documentBuilder = null;
                documentBuilderFactory = null;
                file = null;
                string2 = null;
                string = null;
            }
        }
        finally {
            nodeList2 = null;
            node = null;
            nodeList = null;
            document = null;
            documentBuilder = null;
            documentBuilderFactory = null;
            file = null;
            string2 = null;
            string = null;
        }
        return linkedList;
    }
}

