/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.utils;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.utils.RetrieveSelectionForFieldSize;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.lang.math.NumberUtils;

public class ProcessSelectionForFieldSize {
    private final int BITS = 0;
    private final int BYTES = 1;
    private final int WORDS = 2;
    private final String LF = "\n";
    private final String EMPTY_STR = "";
    private final String SINGLE_SPACE = " ";
    private final String TWO_SPACES = "  ";
    private final String NEW_LINE = "\n";
    private final String TO_STR = "TO ";
    private final String SIX_SPACES = "      ";
    private final String EIGHTY_SPACES = "                                                                                ";
    private final String CHARS_FOR_COMMENT = "*D-/";
    private final String PERIOD = ".";
    private final String LEVEL_NUMS = "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,66,77,88";
    private final String PICTURE = " PICTURE ";
    private final String PIC = " PIC ";
    private final String OCCURS = " OCCURS ";
    private final String BINARY = " BINARY";
    private final String COMPUTATIONAL = " COMP";
    private final String REDEFINES = " REDEFINES ";
    private final String OPEN_BRACKET = "(";
    private final String CLOSED_BRACKET = ")";
    private final String COLON = ":";
    private final String COMMA = ",";
    private final String UNDERSCORE = "_";
    private final String HYPHEN = "-";
    private final String BIN = "1";
    private final String CHAR = "X";
    private final String NUM = "9";
    private final String BIT = "b";
    private final String BYTE = "B";
    private final String OCC = "O";
    private final String COMP = "C";
    private final String IMPLIED_DEC = "V9";
    private final String ACTUAL_DEC = ".9";
    private final String LOOKUP_STARTER = "- Starts ";
    private final String ASSUMED_OCCURS = "1";
    private final String ZERO_STR = "0";
    private final String BIT_FORMATTER = "#.##";
    private final String BIT_APPENDER = "bits";
    private final String BYTE_APPENDER = "bytes";
    private final String WORD_APPENDER = "words";
    private final String USAGE = " USAGE ";
    private final String COMPUTATIONAL_STR = "COMPUTATIONAL";
    private final String COMP_STR = "COMP";
    private final String DISPLAY_STR = "DISPLAY";
    private final String DISP_STR = "DISP";
    private final String SPL_LEVELS = "88";
    private final int BYTE_TO_BIT_FACTOR = 9;
    private final int WORD_TO_BIT_FACTOR = 36;
    private final int ARRAY_GROWTH = 50;
    private String level = "";
    private String gLevel = "";
    private String gLine = "";
    private String gOccurs = "";
    private String calcVal = "";
    private String startsVal = "";
    private String unitAppender = "";
    public String stat = "";
    private int count = 0;
    private boolean hasLevel = false;
    private boolean hasPeriod = false;
    private boolean hasStructure = false;
    private DecimalFormat formatter = new DecimalFormat("#.##");
    private Stack stack = new Stack();
    private HashMap<String, Integer> varMap = new HashMap();

    public String[][] processSelection(String string, int n) {
        if (string == null || string.trim().length() <= 0) {
            OS2200CorePlugin.logger.error((Object)"Selection received as NULL.");
            return null;
        }
        if (n != 0 && n != 1 && n != 2) {
            OS2200CorePlugin.logger.debug((Object)("Incorrect unit received: " + Integer.toString(n) + ". BYTES would be considered."));
            n = 1;
        }
        switch (n) {
            case 0: {
                this.unitAppender = "bits";
                break;
            }
            case 1: {
                this.unitAppender = "bytes";
                break;
            }
            case 2: {
                this.unitAppender = "words";
            }
        }
        this.initialize();
        return this.processInput(string, n);
    }

    private void initialize() {
        this.stat = "";
        this.count = 0;
        this.startsVal = "";
        this.calcVal = "";
        this.gLine = "";
        this.gOccurs = "";
        this.gLevel = "";
        this.level = "";
        this.hasStructure = false;
        this.hasPeriod = false;
        this.hasLevel = false;
    }

    private String[][] processInput(String string, int n) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        string = this.formatString(string);
        String[] stringArray = string.split("\n");
        string = "";
        String[][] stringArray2 = new String[stringArray.length][2];
        stringArray2 = this.createLookups(stringArray);
        stringArray2 = this.convertLookup(stringArray2, n);
        if (this.hasStructure) {
            int n2 = stringArray.length + this.count;
            int n3 = 0;
            String[][] stringArray3 = new String[n2][2];
            String[] stringArray4 = null;
            int n4 = 0;
            while (n4 < stringArray2.length) {
                if (stringArray2[n4][0] != null && stringArray2[n4][1] != null) {
                    stringArray3[n3][0] = stringArray2[n4][0];
                    if (stringArray2[n4][1].contains("\n")) {
                        stringArray4 = stringArray2[n4][1].split("\n");
                        int n5 = 0;
                        while (n5 < stringArray4.length) {
                            if (n3 >= n2) {
                                stringArray3 = (String[][])Arrays.copyOf(stringArray3, stringArray3.length + 50);
                                n2 += 50;
                            }
                            stringArray3[n3][1] = stringArray4[n5];
                            ++n3;
                            ++n5;
                        }
                    } else {
                        if (n3 >= n2) {
                            stringArray3 = (String[][])Arrays.copyOf(stringArray3, stringArray3.length + 50);
                            n2 += 50;
                        }
                        stringArray3[n3][1] = stringArray2[n4][1];
                        ++n3;
                    }
                }
                ++n4;
            }
            l2 = System.currentTimeMillis();
            OS2200CorePlugin.logger.info((Object)("Total time taken for processing the selection in seconds: " + Long.toString((l2 - l) / 1000L)));
            return stringArray3;
        }
        l2 = System.currentTimeMillis();
        OS2200CorePlugin.logger.info((Object)("Total time taken for processing the selection in seconds: " + Long.toString((l2 - l) / 1000L)));
        return stringArray2;
    }

    private String formatString(String string) {
        if (string.trim().length() <= 0) {
            return string;
        }
        int n = 0;
        boolean bl = false;
        String[] stringArray = null;
        if (RetrieveSelectionForFieldSize.lineDelimiter != null) {
            stringArray = string.split(RetrieveSelectionForFieldSize.lineDelimiter);
        } else {
            OS2200CorePlugin.logger.debug((Object)"Line-delimiter received as NULL. New-Line character would be considered for line-delimiter.");
            stringArray = string.split("\n");
        }
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String.valueOf(stringArray[n2]) + "                                                                                ").substring(6, 72);
            if (stringArray[n2].trim().length() > 0 && "*D-/".indexOf(stringArray[n2].substring(0, 1)) < 0) {
                string2 = stringArray[n2].trim();
                this.hasLevel = this.startsWithLevel(string2);
                this.checkForPeriod(string2);
                stringArray[n2] = this.hasLevel ? "      " + stringArray[n2].replaceAll("\\s+$", "") : stringArray[n2].trim();
                if (this.hasPeriod) {
                    n = 0;
                    if (this.hasLevel) {
                        if (stringBuilder.length() > 0) {
                            if (stringBuilder.toString().endsWith("\n")) {
                                stringBuilder.append(String.valueOf(stringArray[n2]) + "\n");
                            } else {
                                stringBuilder.append("\n" + stringArray[n2] + "\n");
                            }
                        } else {
                            stringBuilder.append(String.valueOf(stringArray[n2]) + "\n");
                        }
                        bl = true;
                    } else if (!bl && stringBuilder.length() > 0) {
                        stringBuilder.append(" " + stringArray[n2] + "\n");
                    }
                } else if (this.hasLevel) {
                    n = 0;
                    if (stringBuilder.length() > 0) {
                        if (stringBuilder.toString().endsWith("\n")) {
                            stringBuilder.append(stringArray[n2]);
                        } else {
                            stringBuilder.append("\n" + stringArray[n2]);
                        }
                    } else {
                        stringBuilder.append(stringArray[n2]);
                    }
                    bl = false;
                } else if (stringBuilder.length() > 0 && !bl) {
                    if (++n <= 2) {
                        stringBuilder.append(" " + stringArray[n2]);
                    } else {
                        bl = true;
                    }
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String[][] createLookups(String[] var1_1) {
        var2_2 = "";
        var3_3 = new String[var1_1.length][2];
        var4_4 = "";
        var5_5 = "";
        var6_6 = "";
        var7_7 = -1;
        var8_8 = -1;
        var9_9 = 0;
        while (var9_9 < var1_1.length) {
            block11: {
                block12: {
                    block14: {
                        block13: {
                            var6_6 = String.valueOf(var1_1[var9_9].toUpperCase()) + " ";
                            var2_2 = "";
                            if (var6_6.contains(" USAGE ")) {
                                var6_6 = this.handleUsageClause(var6_6);
                            }
                            if (!this.startsWithLevel(var6_6.trim())) break block12;
                            if (!"88".equals(this.level)) break block13;
                            var3_3[var9_9][0] = var1_1[var9_9];
                            break block11;
                        }
                        if (!this.hasPicture(var6_6)) ** GOTO lbl26
                        var2_2 = this.extractPicValue(var6_6);
                        break block14;
                        while (this.parseToInt((var5_5 = (String)this.stack.peek()).substring(0, var5_5.indexOf(":")), var1_1[var9_9]) >= this.parseToInt(this.level, var1_1[var9_9])) {
                            var4_4 = (String)this.stack.pop();
                            var7_7 = this.parseToInt(var4_4.substring(var4_4.indexOf(":") + 1), var1_1[var9_9]);
                            var3_3[var7_7][1] = String.valueOf(var7_7) + "," + (var9_9 - 1);
lbl26:
                            // 2 sources

                            if (this.stack.size() > 0) continue;
                        }
                        this.stack.push(String.valueOf(this.level) + ":" + var9_9);
                        var8_8 = var9_9;
                    }
                    if (this.hasOccursClause(var6_6)) {
                        var2_2 = String.valueOf(var2_2) + "O" + this.extractOccursValue(var6_6) + ".";
                    }
                    if (this.hasBinary(var6_6)) {
                        var2_2 = String.valueOf(var2_2) + "C" + ".";
                    }
                    if (var8_8 == var9_9) {
                        var3_3[var9_9][0] = var1_1[var9_9];
                    } else {
                        var3_3[var9_9][0] = var1_1[var9_9];
                        var3_3[var9_9][1] = var2_2;
                    }
                    if (var8_8 < var9_9) {
                        while (this.stack.size() > 0) {
                            var5_5 = (String)this.stack.peek();
                            if (this.parseToInt(var5_5.substring(0, var5_5.indexOf(":")), var1_1[var9_9]) >= this.parseToInt(this.level, var1_1[var9_9])) {
                                var4_4 = (String)this.stack.pop();
                                var7_7 = this.parseToInt(var4_4.substring(var4_4.indexOf(":") + 1), var1_1[var9_9]);
                                var3_3[var7_7][1] = String.valueOf(var7_7) + "," + (var9_9 - 1);
                                continue;
                            }
                            break block11;
                        }
                    }
                    break block11;
                }
                OS2200CorePlugin.logger.debug((Object)("The line that does not contain Level: " + var6_6));
            }
            ++var9_9;
        }
        while (this.stack.size() > 0) {
            var4_4 = (String)this.stack.pop();
            var7_7 = this.parseToInt(var4_4.substring(var4_4.indexOf(":") + 1), Integer.toString(var1_1.length - 1));
            var3_3[var7_7][1] = String.valueOf(var7_7) + "," + (var1_1.length - 1);
        }
        return var3_3;
    }

    private String handleUsageClause(String string) {
        int n = string.indexOf(" USAGE ");
        String string2 = string.substring(n + " USAGE ".length()).trim();
        if (string2.startsWith("IS ")) {
            string2 = string2.substring("IS ".length()).trim();
        }
        if (string2.contains(" ")) {
            string2 = string2.substring(0, string2.indexOf(" "));
        } else if (string2.contains(".")) {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        if (string2.contains("-")) {
            string2 = string2.replace("-", "_");
        }
        if (string2.contains("COMPUTATIONAL")) {
            string2 = string2.replace("COMPUTATIONAL", "COMP");
        }
        if (string2.contains("DISPLAY")) {
            string2 = string2.replace("DISPLAY", "DISP");
        }
        if (string2.length() > 0) {
            usageState usageState2 = usageState.valueOf(string2);
            switch (usageState2) {
                case COMP: 
                case COMP_1: 
                case COMP_2: 
                case COMP_4: 
                case DISP: 
                case DISP_1: 
                case DISP_2: 
                case BINARY: 
                case BINARY_1: {
                    break;
                }
                case DATABASE_KEY: {
                    string = String.valueOf(string.substring(0, n)) + " PIC 9(10) BINARY.";
                    break;
                }
                case AREA_NAME: 
                case ACCESS_KEY: {
                    string = String.valueOf(string.substring(0, n)) + " PIC X(12).";
                    break;
                }
                case AREA_KEY: {
                    string = String.valueOf(string.substring(0, n)) + " PIC 1(36) BINARY-1.";
                    break;
                }
                case RECORD_NAME: 
                case SET_NAME: {
                    string = String.valueOf(string.substring(0, n)) + " PIC X(30).";
                    break;
                }
                default: {
                    OS2200CorePlugin.logger.debug((Object)("Unidentified USAGE clause: " + string2));
                }
            }
        }
        return string;
    }

    private String extractOccursValue(String string) {
        String string2 = "";
        String string3 = "";
        if (string.contains(" OCCURS ")) {
            if ((string = string.substring(string.indexOf(" OCCURS ") + " OCCURS ".length()).trim()).contains(" ")) {
                string2 = string.substring(0, string.indexOf(" ")).trim();
                string3 = string.substring(string.indexOf(" ")).trim().toUpperCase();
                if (string3.length() > 0 && string3.startsWith("TO ") && (string3 = string3.substring("TO ".length()).trim()).contains(" ")) {
                    string2 = string3.substring(0, string3.indexOf(" "));
                }
            } else if (string.endsWith(".")) {
                string2 = string.substring(0, string.length() - 1);
            } else if (string.trim().length() > 0 && NumberUtils.isNumber((String)string)) {
                string2 = string;
            } else {
                OS2200CorePlugin.logger.debug((Object)("Invalid Occurs clause received: " + string2));
                string2 = "";
            }
        }
        return string2.trim();
    }

    private String extractPicValue(String string) {
        String string2 = "";
        if (string.contains(" PIC ")) {
            string2 = string.substring(string.indexOf(" PIC ") + " PIC ".length()).trim();
        } else if (string.contains(" PICTURE ")) {
            string2 = string.substring(string.indexOf(" PICTURE ") + " PICTURE ".length()).trim();
        }
        if (string2.contains(" ")) {
            string2 = string2.substring(0, string2.indexOf(" "));
        }
        if ((string2 = this.processPic(string2.toUpperCase())).length() <= 0) {
            this.stat = Messages.getString((String)"FieldSizeOutput.16", (String)string);
            if (this.stat.length() > 0) {
                if (this.stat.contains("\n")) {
                    OS2200CorePlugin.logger.error((Object)this.stat.substring(0, this.stat.indexOf("\n")));
                } else {
                    OS2200CorePlugin.logger.error((Object)this.stat);
                }
            }
            return "B1.";
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processPic(String string) {
        String string2 = "";
        int n = 0;
        boolean bl = false;
        if (string.contains("V9")) {
            string = string.replace("V9", ".9");
            bl = true;
        }
        if (string.indexOf("(") >= 1) {
            string = string.substring(string.indexOf("(") - 1);
            String string3 = string.substring(0, string.indexOf("("));
            if (string.indexOf(")") > 0 && string.indexOf(")") > string.indexOf("(")) {
                try {
                    n = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
                }
                catch (NumberFormatException numberFormatException) {
                    OS2200CorePlugin.logger.error((Object)(String.valueOf(numberFormatException.getMessage()) + " Size: " + n));
                    return "";
                }
                if (string.contains(".") && string.indexOf(".") + 1 < string.length()) {
                    string2 = string.substring(string.indexOf(".") + 1);
                    if (string2.contains(".")) {
                        string2 = string2.substring(0, string2.indexOf("."));
                    }
                    if (string2.contains("(")) {
                        if (string2.contains(")") && string2.indexOf("(") < string2.indexOf(")")) {
                            try {
                                n += Integer.parseInt(string2.substring(string2.indexOf("(") + 1, string2.indexOf(")")));
                            }
                            catch (NumberFormatException numberFormatException) {
                                OS2200CorePlugin.logger.error((Object)(String.valueOf(numberFormatException.getMessage()) + " Size: " + n));
                                return "";
                            }
                        } else {
                            OS2200CorePlugin.logger.error((Object)("Invalid PIC clause: " + string));
                            return "";
                        }
                    }
                    n += string2.length();
                    if (!bl) {
                        ++n;
                    }
                }
                if (string3.equals("1")) {
                    return "b" + n + ".";
                }
                if (string3.equals("X")) return "B" + n + ".";
                if (string3.equals("9")) {
                    return "B" + n + ".";
                }
                OS2200CorePlugin.logger.debug((Object)("Incorrect Type received: " + string3));
                return "";
            }
            OS2200CorePlugin.logger.error((Object)("Invalid PIC clause: " + string));
            return "";
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        while (string.length() > 0) {
            if (string.startsWith("1") || string.startsWith("X") || string.startsWith("9")) {
                n = string.length();
                if (bl) {
                    --n;
                }
                if (!string.startsWith("1")) return "B" + n + ".";
                return "b" + n + ".";
            }
            string = string.substring(1);
        }
        return "";
    }

    private String[][] convertLookup(String[][] stringArray, int n) {
        String string = "";
        String[] stringArray2 = null;
        double d = -1.0;
        double d2 = 0.0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "0";
        String string9 = "";
        String string10 = "";
        double d3 = -1.0;
        double d4 = -1.0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0] != null && stringArray[n2][1] != null) {
                string4 = stringArray[n2][0].trim();
                string = stringArray[n2][1];
                if (this.startsWithLevel(string4) && this.level.length() > 0 && NumberUtils.isNumber((String)this.level)) {
                    string3 = this.level;
                    if (string4.contains(" REDEFINES ") && !string.contains(",")) {
                        d2 = this.handleRedefine(string4, n2, stringArray);
                    }
                    d = -1.0;
                    string6 = "";
                    string7 = "";
                    if (string.trim().length() > 0 && !string.contains(",")) {
                        stringArray2 = string.split("\\.");
                        d = this.processLookup(stringArray2, n);
                        string8 = "0";
                        while (this.stack.size() > 0) {
                            this.initializeGroupVars();
                            string9 = (String)this.stack.peek();
                            this.breakStackEntry(string9);
                            if (string6.contains(" REDEFINES ")) {
                                string8 = "0";
                            } else {
                                this.adjustCalcVal(string8);
                            }
                            string10 = "";
                            if (this.parseToInt(string3, string4) > this.parseToInt(this.gLevel, string4)) {
                                if (!string4.contains(" REDEFINES ")) {
                                    if (d3 >= 0.0 && d4 > 0.0) {
                                        string10 = (String)this.stack.pop();
                                        d4 = this.parseToDouble(this.calcVal, string4) + d;
                                        string10 = String.valueOf(string10.substring(0, string10.lastIndexOf(":") + 1)) + d4;
                                        this.stack.push(string10);
                                        break;
                                    }
                                    d3 = d2;
                                    d4 = d;
                                    string10 = String.valueOf((String)this.stack.pop()) + ":" + d3 + ":" + d4;
                                    this.stack.push(string10);
                                    break;
                                }
                                string10 = (String)this.stack.pop();
                                string10 = String.valueOf(this.gLevel) + ":" + this.gOccurs + ":" + this.gLine + ":" + this.startsVal + ":" + this.calcVal;
                                this.stack.push(string10);
                                break;
                            }
                            this.stack.pop();
                            if (this.calcVal.length() > 0 && NumberUtils.isNumber((String)this.calcVal)) {
                                string8 = Double.toString(this.parseToDouble(this.calcVal, string4) * (double)this.parseToInt(this.gOccurs, string4));
                            }
                            if (this.startsVal.length() <= 0) {
                                if (this.parseToInt(this.gLine, string4) < stringArray.length - 1) {
                                    this.evaluateStartsVal(stringArray[this.parseToInt(this.gLine, string4) + 1][1], string4);
                                } else {
                                    this.startsVal = "0";
                                }
                            }
                            stringArray[this.parseToInt((String)this.gLine, (String)string4)][1] = String.valueOf(Messages.getString((String)"FieldSizeOutput.1", (String)this.formatToDouble(this.startsVal, string4), (String)this.unitAppender)) + " " + Messages.getString((String)"FieldSizeOutput.2", (String)this.formatToDouble(this.calcVal, string4), (String)this.unitAppender);
                            if (this.parseToInt(this.gOccurs, string4) > this.parseToInt("1", string4)) {
                                String[] stringArray3 = stringArray[this.parseToInt(this.gLine, string4)];
                                stringArray3[1] = String.valueOf(stringArray3[1]) + " " + Messages.getString((String)"FieldSizeOutput.8", (String)this.gOccurs) + " " + Messages.getString((String)"FieldSizeOutput.9", (String)this.formatToDouble(string8, string4), (String)this.unitAppender);
                            }
                            string6 = stringArray[this.parseToInt(this.gLine, string4)][0].trim();
                            this.hasLevel = this.startsWithLevel(string6);
                            if (this.hasLevel) {
                                string7 = string6.substring(string6.indexOf(this.level) + this.level.length()).trim();
                                if (string7.contains(" ")) {
                                    string7 = string7.substring(0, string7.indexOf(" "));
                                } else if (string7.contains(".")) {
                                    string7 = string7.substring(0, string7.indexOf("."));
                                }
                            }
                            String[] stringArray4 = stringArray[n2 - 1];
                            stringArray4[1] = String.valueOf(stringArray4[1]) + "\n  " + Messages.getString((String)"FieldSizeOutput.10", (String)this.gLevel, (String)string7) + " " + stringArray[this.parseToInt(this.gLine, string4)][1];
                            this.hasStructure = true;
                            ++this.count;
                            if (stringArray[n2][0].contains(" REDEFINES ")) continue;
                            d2 = this.parseToDouble(this.startsVal, string4) + this.parseToDouble(string8, string4);
                        }
                        stringArray[n2][1] = String.valueOf(Messages.getString((String)"FieldSizeOutput.1", (String)this.formatter.format(d2), (String)this.unitAppender)) + " " + Messages.getString((String)"FieldSizeOutput.2", (String)this.formatter.format(d), (String)this.unitAppender);
                        d2 += d;
                    } else {
                        string5 = string4.substring(string4.indexOf(string3) + string3.length()).trim();
                        if (string5.contains(" ")) {
                            string5 = string5.substring(0, string5.indexOf(" "));
                        } else if (string5.contains(".")) {
                            string5 = string5.substring(0, string5.indexOf("."));
                        }
                        this.varMap.put(string5, n2);
                        if (string4.contains(" REDEFINES ")) {
                            d2 = this.handleRedefine(string4, n2, stringArray);
                        }
                        if ((string2 = this.extractOccursValue(string4)).length() <= 0) {
                            string2 = "1";
                        }
                        if (string2.length() > 0 && string3.length() > 0 && NumberUtils.isNumber((String)string2) && NumberUtils.isNumber((String)string3)) {
                            string8 = "0";
                            while (this.stack.size() > 0) {
                                this.initializeGroupVars();
                                string9 = (String)this.stack.peek();
                                this.breakStackEntry(string9);
                                if (string6.contains(" REDEFINES ")) {
                                    string8 = "0";
                                } else {
                                    this.adjustCalcVal(string8);
                                }
                                if (this.parseToInt(this.gLevel, string4) >= this.parseToInt(string3, string4)) {
                                    this.stack.pop();
                                    if (this.calcVal.length() > 0 && NumberUtils.isNumber((String)this.calcVal)) {
                                        string8 = Double.toString(this.parseToDouble(this.calcVal, string4) * (double)this.parseToInt(this.gOccurs, string4));
                                    }
                                    if (this.startsVal.length() <= 0) {
                                        if (this.parseToInt(this.gLine, string4) < stringArray.length - 1) {
                                            this.evaluateStartsVal(stringArray[this.parseToInt(this.gLine, string4) + 1][1], string4);
                                        } else {
                                            this.startsVal = "0";
                                        }
                                    }
                                    stringArray[this.parseToInt((String)this.gLine, (String)string4)][1] = String.valueOf(Messages.getString((String)"FieldSizeOutput.1", (String)this.formatToDouble(this.startsVal, string4), (String)this.unitAppender)) + " " + Messages.getString((String)"FieldSizeOutput.2", (String)this.formatToDouble(this.calcVal, string4), (String)this.unitAppender);
                                    if (this.parseToInt(this.gOccurs, string4) > this.parseToInt("1", string4)) {
                                        String[] stringArray5 = stringArray[this.parseToInt(this.gLine, string4)];
                                        stringArray5[1] = String.valueOf(stringArray5[1]) + " " + Messages.getString((String)"FieldSizeOutput.8", (String)this.gOccurs) + " " + Messages.getString((String)"FieldSizeOutput.9", (String)this.formatToDouble(string8, string4), (String)this.unitAppender);
                                    }
                                    if (!string4.contains(" REDEFINES ")) {
                                        d2 = this.parseToDouble(this.startsVal, string4) + this.parseToDouble(string8, string4);
                                    }
                                    if (n2 <= 0) continue;
                                    string6 = stringArray[this.parseToInt(this.gLine, string4)][0].trim();
                                    this.hasLevel = this.startsWithLevel(string6);
                                    if (this.hasLevel) {
                                        string7 = string6.substring(string6.indexOf(this.level) + this.level.length()).trim();
                                        if (string7.contains(" ")) {
                                            string7 = string7.substring(0, string7.indexOf(" "));
                                        } else if (string7.contains(".")) {
                                            string7 = string7.substring(0, string7.indexOf("."));
                                        }
                                    }
                                    String[] stringArray6 = stringArray[n2 - 1];
                                    stringArray6[1] = String.valueOf(stringArray6[1]) + "\n  " + Messages.getString((String)"FieldSizeOutput.10", (String)this.gLevel, (String)string7) + " " + stringArray[this.parseToInt(this.gLine, string4)][1];
                                    this.hasStructure = true;
                                    ++this.count;
                                    continue;
                                }
                                string10 = (String)this.stack.pop();
                                string10 = String.valueOf(this.gLevel) + ":" + this.gOccurs + ":" + this.gLine + ":" + this.startsVal + ":" + this.calcVal;
                                this.stack.push(string10);
                                break;
                            }
                            this.stack.push(String.valueOf(string3) + ":" + string2 + ":" + n2);
                            d3 = -1.0;
                            d4 = -1.0;
                        }
                    }
                }
            }
            ++n2;
        }
        string8 = "0";
        while (this.stack.size() > 0) {
            this.initializeGroupVars();
            string9 = (String)this.stack.pop();
            this.breakStackEntry(string9);
            if (string4.contains(" REDEFINES ")) {
                string8 = "0";
            } else {
                this.adjustCalcVal(string8);
            }
            if (this.calcVal.length() > 0 && NumberUtils.isNumber((String)this.calcVal)) {
                string8 = Double.toString(this.parseToDouble(this.calcVal, string4) * (double)this.parseToInt(this.gOccurs, string4));
            }
            if (this.startsVal.length() <= 0) {
                if (this.parseToInt(this.gLine, string4) < stringArray.length - 1) {
                    this.evaluateStartsVal(stringArray[this.parseToInt(this.gLine, string4) + 1][1], string4);
                } else {
                    this.startsVal = "0";
                }
            }
            stringArray[this.parseToInt((String)this.gLine, (String)string4)][1] = String.valueOf(Messages.getString((String)"FieldSizeOutput.1", (String)this.formatToDouble(this.startsVal, string4), (String)this.unitAppender)) + " " + Messages.getString((String)"FieldSizeOutput.2", (String)this.formatToDouble(this.calcVal, string4), (String)this.unitAppender);
            if (this.parseToInt(this.gOccurs, string4) > this.parseToInt("1", string4)) {
                String[] stringArray7 = stringArray[this.parseToInt(this.gLine, string4)];
                stringArray7[1] = String.valueOf(stringArray7[1]) + " " + Messages.getString((String)"FieldSizeOutput.8", (String)this.gOccurs) + " " + Messages.getString((String)"FieldSizeOutput.9", (String)this.formatToDouble(string8, string4), (String)this.unitAppender);
            }
            string4 = stringArray[this.parseToInt(this.gLine, string4)][0].trim();
            this.hasLevel = this.startsWithLevel(string4);
            if (this.hasLevel) {
                string5 = string4.substring(string4.indexOf(this.level) + this.level.length()).trim();
                if (string5.contains(" ")) {
                    string5 = string5.substring(0, string5.indexOf(" "));
                } else if (string5.contains(".")) {
                    string5 = string5.substring(0, string5.indexOf("."));
                }
            }
            String[] stringArray8 = stringArray[stringArray.length - 1];
            stringArray8[1] = String.valueOf(stringArray8[1]) + "\n  " + Messages.getString((String)"FieldSizeOutput.10", (String)this.gLevel, (String)string5) + " " + stringArray[this.parseToInt(this.gLine, string4)][1];
            this.hasStructure = true;
            ++this.count;
        }
        return stringArray;
    }

    private int parseToInt(String string, String string2) {
        if (string.length() > 0 && NumberUtils.isNumber((String)string)) {
            return Integer.parseInt(string);
        }
        OS2200CorePlugin.logger.debug((Object)Messages.getString((String)"FieldSizeOutput.15", (String)string, (String)string2));
        this.stat = Messages.getString((String)"FieldSizeOutput.16", (String)string2);
        if (this.stat.length() > 0) {
            if (this.stat.contains("\n")) {
                OS2200CorePlugin.logger.error((Object)this.stat.substring(0, this.stat.indexOf("\n")));
            } else {
                OS2200CorePlugin.logger.error((Object)this.stat);
            }
        }
        return 0;
    }

    private double parseToDouble(String string, String string2) {
        if (string.length() > 0 && NumberUtils.isNumber((String)string)) {
            return Double.parseDouble(string);
        }
        OS2200CorePlugin.logger.debug((Object)Messages.getString((String)"FieldSizeOutput.14", (String)string, (String)string2));
        this.stat = Messages.getString((String)"FieldSizeOutput.16", (String)string2);
        if (this.stat.length() > 0) {
            if (this.stat.contains("\n")) {
                OS2200CorePlugin.logger.error((Object)this.stat.substring(0, this.stat.indexOf("\n")));
            } else {
                OS2200CorePlugin.logger.error((Object)this.stat);
            }
        }
        return 0.0;
    }

    private String formatToDouble(String string, String string2) {
        return this.formatter.format(this.parseToDouble(string, string2));
    }

    private double handleRedefine(String string, int n, String[][] stringArray) {
        int n2 = 0;
        double d = 0.0;
        String string2 = "";
        String string3 = string.substring(string.indexOf(" REDEFINES ") + " REDEFINES ".length()).trim();
        if (string3.contains(" ")) {
            string3 = string3.substring(0, string3.indexOf(" "));
        } else if (string3.contains(".")) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (this.varMap.containsKey(string3)) {
            n2 = this.varMap.get(string3);
            while (n2 < n) {
                if (!(string2 = stringArray[++n2][1]).startsWith("- Starts ")) continue;
                string2 = string2.substring("- Starts ".length()).trim();
                d = this.parseToDouble(string2.substring(0, string2.indexOf(" ")), string);
                break;
            }
        } else {
            n2 = n;
            while (n2 > 0) {
                if (!stringArray[--n2][0].contains(" " + string3 + " ") || !(string2 = stringArray[n2][1]).startsWith("- Starts ")) continue;
                string2 = string2.substring("- Starts ".length()).trim();
                d = this.parseToDouble(string2.substring(0, string2.indexOf(" ")), string);
                break;
            }
        }
        return d;
    }

    private double processLookup(String[] stringArray, int n) {
        double d = -1.0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].startsWith("b")) {
                d = this.parseToInt(stringArray[n3].substring("b".length()), stringArray[n3]);
                bl = true;
            } else if (stringArray[n3].startsWith("B")) {
                d = this.parseToInt(stringArray[n3].substring("B".length()), stringArray[n3]) * 9;
                bl = false;
            }
            if (bl) {
                if (stringArray[n3].startsWith("O")) {
                    d *= (double)this.parseToInt(stringArray[n3].substring("O".length()), stringArray[n3]);
                }
            } else if (stringArray[n3].startsWith("O")) {
                bl2 = true;
                n2 = this.parseToInt(stringArray[n3].substring("O".length()), stringArray[n3]);
            } else if (stringArray[n3].equals("C")) {
                d = this.computeBinary(d / 9.0) * 9.0;
            }
            ++n3;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                d /= 9.0;
                break;
            }
            case 2: {
                d /= 36.0;
            }
        }
        if (bl2) {
            bl2 = false;
            d *= (double)n2;
        }
        return d;
    }

    private void evaluateStartsVal(String string, String string2) {
        if (string != null && string.startsWith("- Starts ")) {
            string = string.substring("- Starts ".length()).trim();
            this.startsVal = string.substring(0, string.indexOf(" "));
        } else {
            OS2200CorePlugin.logger.debug((Object)("Incorrect lookup encountered: " + string + " for " + string2));
        }
    }

    private void adjustCalcVal(String string) {
        if (string.length() > 0 && NumberUtils.isNumber((String)string)) {
            this.calcVal = this.calcVal.length() > 0 && NumberUtils.isNumber((String)this.calcVal) ? Double.toString(Double.parseDouble(this.calcVal) + Double.parseDouble(string)) : string;
        }
    }

    private void breakStackEntry(String string) {
        this.gLevel = string.substring(0, string.indexOf(":"));
        string = string.substring(string.indexOf(":") + ":".length());
        this.gOccurs = string.substring(0, string.indexOf(":"));
        if ((string = string.substring(string.indexOf(":") + ":".length())).contains(":")) {
            this.gLine = string.substring(0, string.indexOf(":"));
            this.calcVal = string.substring(string.lastIndexOf(":") + ":".length());
            this.startsVal = string.substring(string.indexOf(":") + ":".length(), string.lastIndexOf(":"));
        } else {
            this.gLine = string;
        }
    }

    private void initializeGroupVars() {
        this.startsVal = "";
        this.calcVal = "";
        this.gLine = "";
        this.gOccurs = "";
        this.gLevel = "";
    }

    private double computeBinary(double d) {
        double d2 = 0.0;
        double d3 = d % 5.0;
        d2 = d <= 0.0 ? 1.0 : (d3 == 0.0 ? d * 2.0 / 5.0 : (d + (5.0 - d3)) * 2.0 / 5.0 - 1.0);
        return d2;
    }

    private void checkForPeriod(String string) {
        this.hasPeriod = false;
        if (string.endsWith(".")) {
            this.hasPeriod = true;
        }
    }

    private boolean startsWithLevel(String string) {
        String string2;
        this.level = "";
        if (string.contains(" ") && "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,66,77,88".indexOf(string2 = string.substring(0, string.indexOf(" ")).trim()) >= 0) {
            this.level = string2;
            return true;
        }
        return false;
    }

    private boolean hasPicture(String string) {
        return (string = " " + string).contains(" PIC ") || string.contains(" PICTURE ");
    }

    private boolean hasOccursClause(String string) {
        return string.contains(" OCCURS ");
    }

    private boolean hasBinary(String string) {
        if (string.contains(" PIC ")) {
            string = string.substring(string.indexOf(" PIC "));
        } else if (string.contains(" PICTURE ")) {
            string = string.substring(string.indexOf(" PICTURE "));
        }
        return string.contains(" BINARY") || string.contains(" COMP");
    }

    private static enum usageState {
        COMP,
        COMP_1,
        COMP_2,
        COMP_4,
        DISP,
        DISP_1,
        DISP_2,
        DATABASE_KEY,
        AREA_NAME,
        AREA_KEY,
        RECORD_NAME,
        SET_NAME,
        ACCESS_KEY,
        ALIAS,
        DISP_I18N,
        BYTE_I18N,
        BINARY,
        BINARY_1;

    }
}

