/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.utils;

import com.unisys.os2200.editor.editors.UDTEditor;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.utils.ConstructFileNameUtil;
import com.unisys.tde.ui.views.OFCSView;
import java.util.Properties;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenEltFromRunstreamUtil {
    private IEditorPart edtPart = null;
    private IDocument document = null;
    private String selectedString;
    private String wholeContent;
    int offset = 0;

    public void openElementFromRunStream(final boolean bl) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    OpenEltFromRunstreamUtil.this.edtPart = iWorkbenchPage.getActiveEditor();
                    if (OpenEltFromRunstreamUtil.this.edtPart != null) {
                        try {
                            Object object;
                            OpenEltFromRunstreamUtil.this.selectedString = OpenEltFromRunstreamUtil.this.getCursorString();
                            if (OpenEltFromRunstreamUtil.this.selectedString.trim().length() <= 0) {
                                return;
                            }
                            OpenEltFromRunstreamUtil.this.wholeContent = OpenEltFromRunstreamUtil.this.document.get(0, OpenEltFromRunstreamUtil.this.offset);
                            ConstructFileNameUtil constructFileNameUtil = new ConstructFileNameUtil();
                            OpenEltFromRunstreamUtil.this.selectedString = constructFileNameUtil.getFileName(OpenEltFromRunstreamUtil.this.wholeContent, OpenEltFromRunstreamUtil.this.selectedString);
                            IEditorInput iEditorInput = OpenEltFromRunstreamUtil.this.edtPart.getEditorInput();
                            String string = null;
                            if (iEditorInput instanceof FileEditorInput) {
                                try {
                                    object = OS2200ProjectUpdate.getProperties((IProject)((FileEditorInput)iEditorInput).getFile().getProject());
                                    string = ((Properties)object).getProperty("hostID");
                                }
                                catch (CoreException coreException) {
                                    OS2200CorePlugin.logger.info((Object)coreException.getMessage(), (Throwable)coreException);
                                }
                            } else if (iEditorInput instanceof OS2200FileEditorInput) {
                                string = ((OS2200FileEditorInput)iEditorInput).getHostAcc().getName();
                            }
                            if ((object = OpenEltFromRunstreamUtil.this.getOFEViewObject()) != null) {
                                ((OFCSView)((Object)object)).setPathForOpenRunstream(string, OpenEltFromRunstreamUtil.this.selectedString, bl);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            OS2200CorePlugin.logger.info((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                        }
                    }
                }
            }
        });
    }

    private OFCSView getOFEViewObject() {
        IViewReference iViewReference;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null && (iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OFCSView")) != null) {
            OFCSView oFCSView = null;
            oFCSView = (OFCSView)iViewReference.getView(true);
            return oFCSView;
        }
        return null;
    }

    private String getCursorString() {
        String string = "";
        try {
            if (this.edtPart instanceof ITextEditor) {
                COBOLEditor cOBOLEditor;
                if (this.edtPart instanceof COBOLEditor) {
                    cOBOLEditor = (COBOLEditor)this.edtPart;
                    this.document = cOBOLEditor.getDocumentProvider().getDocument((Object)this.edtPart.getEditorInput());
                } else if (this.edtPart instanceof CEditor) {
                    cOBOLEditor = (CEditor)this.edtPart;
                    this.document = cOBOLEditor.getDocumentProvider().getDocument((Object)this.edtPart.getEditorInput());
                } else if (this.edtPart instanceof UDTEditor) {
                    cOBOLEditor = (UDTEditor)this.edtPart;
                    this.document = cOBOLEditor.getDocumentProvider().getDocument((Object)this.edtPart.getEditorInput());
                } else if (this.edtPart instanceof TextEditor) {
                    cOBOLEditor = (TextEditor)this.edtPart;
                    this.document = cOBOLEditor.getDocumentProvider().getDocument((Object)this.edtPart.getEditorInput());
                }
                if (this.document != null) {
                    cOBOLEditor = (ITextSelection)this.edtPart.getSite().getSelectionProvider().getSelection();
                    this.offset = cOBOLEditor.getOffset();
                    IRegion iRegion = this.findWord(this.document, this.offset);
                    string = this.document.get(iRegion.getOffset(), iRegion.getLength());
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
            string = "";
        }
        return string;
    }

    private IRegion findWord(IDocument iDocument, int n) {
        int n2 = -1;
        int n3 = -1;
        try {
            char c;
            int n4 = n;
            while (n4 >= 0) {
                c = iDocument.getChar(n4);
                if (!this.isAValidOS2200FileNameCharacter(c)) break;
                --n4;
            }
            n2 = n4;
            n4 = n;
            int n5 = iDocument.getLength();
            while (n4 < n5) {
                c = iDocument.getChar(n4);
                if (!this.isAValidOS2200FileNameCharacter(c)) break;
                ++n4;
            }
            n3 = n4;
        }
        catch (BadLocationException badLocationException) {
            OS2200CorePlugin.logger.info((Object)badLocationException.getMessage());
        }
        if (n2 >= -1 && n3 > -1) {
            if (n2 == n && n3 == n) {
                return new Region(n, 0);
            }
            if (n2 == n) {
                return new Region(n2, n3 - n2);
            }
            return new Region(n2 + 1, n3 - n2 - 1);
        }
        return null;
    }

    private boolean isAValidOS2200FileNameCharacter(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '*' || c == '.' || c == '/' || c == '$' || c == '#' || c == '(' || c == '+' || c == ')';
    }
}

