/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.utils;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.FileInfo;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.dialogs.SaveConflictDialog;
import com.unisys.tde.ui.dialogs.SyncInfoObject;
import com.unisys.tde.ui.utils.OS2200CompareUtils;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.tde.ui.views.OS2200WorkFile;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OS2200ArchitectureUtils {
    private static IPreferenceStore ips = PlatformUI.getPreferenceStore();
    private static final String OS2200ViewId = "com.unisys.tde.ui.views.OS2200View";
    private HashSet<SyncInfoObject> listOfOutOffSync;
    private HashSet<SyncInfoObject> listOfDirtyIFile;
    private HashSet<IFile> listOfunInitalizedFiles;
    private static TDECoreUtilities synchronizer;
    private HashSet<Object> listOfOffLineSelection;
    private SyncInfoObject SyncInfoobj = null;
    private static boolean isListOfSelectionCancled;
    private static boolean isZeroKBElement;

    static {
        isListOfSelectionCancled = false;
        isZeroKBElement = true;
        synchronizer = TDECoreUtilities.getInstance();
    }

    public HashSet<SyncInfoObject> getListOfOutOffSync() {
        return this.listOfOutOffSync;
    }

    public HashSet<SyncInfoObject> getListOfDirtyIFile() {
        return this.listOfDirtyIFile;
    }

    public static boolean isZeroKBElement() {
        return isZeroKBElement;
    }

    public static void setZeroKBElement(boolean bl) {
        isZeroKBElement = bl;
    }

    public static boolean isListOfSelectionCancled() {
        return isListOfSelectionCancled;
    }

    public HashSet<Object> getListOfOffLineSelection() {
        return this.listOfOffLineSelection;
    }

    public HashSet<IFile> getListOfunInitalizedFiles() {
        return this.listOfunInitalizedFiles;
    }

    public static boolean startDownlodingElements(IResource[] iResourceArray) {
        final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
        boolean bl = true;
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (iResource instanceof IFile && !iResource.toString().toLowerCase().endsWith(".project") && !iResource.toString().toLowerCase().endsWith(".settings")) {
                try {
                    IPath iPath = iResource.getRawLocation();
                    if (iPath == null) {
                        OS2200CorePlugin.logger.warn((Object)("'" + iResource.getName() + "' does not exist and it will removed from the project list."));
                        iResource.delete(true, null);
                    } else {
                        final IFile iFile = (IFile)iResource;
                        if (TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
                            IProject iProject = iFile.getProject();
                            if (!iProject.isOpen()) {
                                OS2200CorePlugin.logger.info((Object)(String.valueOf(iProject.getName()) + "is closed."));
                                break;
                            }
                            if (TDECoreUtilities.getInstance().downloadingUnInitializedElement(iFile, false).length() != 0) {
                                bl = false;
                            } else {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            if (oS2200View != null) {
                                                oS2200View.getViewer().refresh((Object)iFile, true);
                                            }
                                        }
                                        catch (Exception exception) {
                                            OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
                                        }
                                    }
                                });
                            }
                            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.warn((Object)coreException.getMessage(), (Throwable)coreException);
                }
            }
            ++n2;
        }
        return bl;
    }

    public static void startDownlodingElements(final HashSet<IFile> hashSet) {
        final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    for (IFile iFile : hashSet) {
                        try {
                            iProgressMonitor.beginTask(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_0")) + iFile.getFullPath() + "'", hashSet.size());
                            String string = iFile.getRawLocation().toOSString();
                            String string2 = TDECoreUtilities.getCIFSPathFromFilePath((String)string);
                            if (string2 != null) {
                                File file = new File(string2);
                                File file2 = new File(string);
                                if (file.exists() && file2.exists() && file2.lastModified() == 0L) {
                                    IFile iFile2;
                                    if (TDECoreUtilities.getInstance().copyToLocal(file, file2).length() == 0) {
                                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                        iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                                        iFile2 = iFile;
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                oS2200View.getViewer().refresh((Object)iFile2, true);
                                            }
                                        });
                                    } else {
                                        iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                        file2.setLastModified(0L);
                                        iFile2 = iFile;
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                oS2200View.getViewer().refresh((Object)iFile2, true);
                                            }
                                        });
                                    }
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.warn((Object)coreException.getMessage(), (Throwable)coreException);
                        }
                        if (iProgressMonitor.isCanceled()) {
                            return;
                        }
                        try {
                            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.warn((Object)coreException.getMessage(), (Throwable)coreException);
                        }
                        iProgressMonitor.worked(1);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            OS2200CorePlugin.logger.warn((Object)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            OS2200CorePlugin.logger.warn((Object)interruptedException.getMessage(), (Throwable)interruptedException);
        }
    }

    private boolean isEditordirty(IFile iFile) {
        AbstractTextEditor abstractTextEditor;
        WorkbenchPage workbenchPage = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = workbenchPage.findEditor((IEditorInput)new FileEditorInput(iFile));
        return iEditorPart instanceof AbstractTextEditor && (abstractTextEditor = (AbstractTextEditor)iEditorPart).isDirty();
    }

    public static boolean saveDirtyEditor(IFile iFile) {
        AbstractTextEditor abstractTextEditor;
        IEditorPart iEditorPart;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.findEditor((IEditorInput)new FileEditorInput(iFile))) instanceof AbstractTextEditor && (abstractTextEditor = (AbstractTextEditor)iEditorPart).isDirty()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    abstractTextEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            });
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initiateUplodingElement(final IFile iFile) {
        try {
            final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
            File file = new File(iFile.getRawLocation().toOSString());
            String string = TDECoreUtilities.getCIFSPathFromFilePath((String)file.toString());
            if (string == null) {
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                iFile.refreshLocal(2, null);
                return false;
            }
            File file2 = new File(string);
            String string2 = TDECoreUtilities.getInstance().copyToHost(file, file2);
            if (string2.length() == 0) {
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        oS2200View.getViewer().refresh((Object)iFile, true);
                    }
                });
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                iFile.refreshLocal(2, null);
                return true;
            }
            iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
            iFile.refreshLocal(2, null);
            String string3 = TDECoreUtilities.getCIFSPathFromFilePath((String)iFile.getRawLocation().toOSString());
            String string4 = OS2200CompareUtils.get2200FormatFromPath(iFile.getRawLocation().toOSString());
            string2 = string2.replace(string3, string4);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_1")) + iFile.getName()), (String)(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_2")) + "\n" + string2));
            return false;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initiateDownlodingElement(final IFile iFile) {
        try {
            final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
            File file = new File(iFile.getRawLocation().toOSString());
            FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(file.toString());
            IProject iProject = iFile.getProject();
            long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
            if (fileInfo != null && l == 0L) {
                if (!new File(fileInfo.getRemoteFile()).exists()) {
                    iFile.delete(true, null);
                    return true;
                }
                String string = fileInfo.getRemoteFile();
                File file2 = new File(string);
                if (TDECoreUtilities.getInstance().copyToLocal(file2, file).length() == 0) {
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            oS2200View.getViewer().refresh((Object)iFile, true);
                        }
                    });
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                    iFile.refreshLocal(2, null);
                    return true;
                }
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                iFile.refreshLocal(2, null);
                return false;
            }
            iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
            iFile.refreshLocal(2, null);
            return false;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    public void updatestatus() {
        final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
        Job job = new Job(Messages.getString((String)"OS2200ArchitectureUtils_3")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (oS2200View != null) {
                    IStructuredSelection iStructuredSelection = oS2200View.getCurrentSel();
                    if (iStructuredSelection instanceof TreeSelection) {
                        List list = ((TreeSelection)iStructuredSelection).toList();
                        OS2200ArchitectureUtils.this.listOfOffLineSelection = new HashSet();
                        if (list != null && list.size() > 0) {
                            int n = list.size();
                            iProgressMonitor.beginTask(Messages.getString((String)"OS2200ArchitectureUtils_4"), n);
                            int n2 = 0;
                            while (n2 < list.size()) {
                                try {
                                    int n3 = n2 + 1;
                                    String string = String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_5")) + n3 + "/" + list.size() + ") '";
                                    if (list.get(n2) instanceof IFile) {
                                        iProgressMonitor.setTaskName(String.valueOf(string) + list.get(n2) + "'...");
                                        final IFile iFile = (IFile)list.get(n2);
                                        iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_6")) + iFile.getFullPath());
                                        IProject iProject = iFile.getProject();
                                        long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
                                        if (l == 0L) {
                                            iProject.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "True");
                                            Display.getDefault().syncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    try {
                                                        if (TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
                                                            iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                                        } else if (!TDECoreUtilities.isPhysicallyInSync((IFile)iFile)) {
                                                            iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                                                            iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                                                        } else {
                                                            iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                                                            iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                                        }
                                                        Display.getDefault().syncExec(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                oS2200View.getViewer().refresh((Object)iFile, true);
                                                            }
                                                        });
                                                    }
                                                    catch (Exception exception) {}
                                                }
                                            });
                                        } else {
                                            OS2200ArchitectureUtils.this.listOfOffLineSelection.add(iFile);
                                            iProject.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "False");
                                        }
                                    } else {
                                        OS2200ArchitectureUtils.this.updatestatusForSelection(list.get(n2), string, oS2200View, iProgressMonitor);
                                    }
                                }
                                catch (CoreException coreException) {
                                    OS2200CorePlugin.logger.warn((Object)coreException.getMessage(), (Throwable)coreException);
                                }
                                if (iProgressMonitor.isCanceled()) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            oS2200View.getViewer().refresh();
                                        }
                                    });
                                    return Status.CANCEL_STATUS;
                                }
                                iProgressMonitor.worked(1);
                                ++n2;
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    oS2200View.getViewer().refresh();
                                }
                            });
                        }
                    } else {
                        OS2200CorePlugin.logger.debug((Object)"Could not able to get the list from project selection");
                    }
                }
                OS2200CorePlugin.logger.debug((Object)"Could not able to get the OS2200 project view");
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (OS2200ArchitectureUtils.this.listOfOffLineSelection != null && OS2200ArchitectureUtils.this.listOfOffLineSelection.size() > 0) {
                            StringBuffer stringBuffer = new StringBuffer();
                            int n = 1;
                            stringBuffer.append(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_7")) + OS2200ArchitectureUtils.this.listOfOffLineSelection.size() + "\n\n");
                            for (Object e : OS2200ArchitectureUtils.this.listOfOffLineSelection) {
                                stringBuffer.append("\t" + e.toString() + "\n");
                                if (n >= 5) {
                                    stringBuffer.append("\t" + (OS2200ArchitectureUtils.this.listOfOffLineSelection.size() - 5) + Messages.getString((String)"OS2200ArchitectureUtils_8") + "\n");
                                    break;
                                }
                                ++n;
                            }
                            MessageDialog.openInformation((Shell)new Shell(), (String)Messages.getString((String)"OS2200ArchitectureUtils_9"), (String)stringBuffer.toString());
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }

    /*
     * Unable to fully structure code
     */
    private void updatestatusForSelection(Object var1_1, String var2_2, final OS2200View var3_3, IProgressMonitor var4_4) {
        block10: {
            try {
                var5_5 = null;
                var6_7 = -1L;
                if (var1_1 instanceof IProject) {
                    var6_7 = OS2200ProjectUpdate.connectOS2200((IProject)((IProject)var1_1), (boolean)false);
                    var5_5 = ((IProject)var1_1).members();
                    var2_2 = String.valueOf(var2_2) + ((IProject)var1_1).getName() + "'...";
                } else if (var1_1 instanceof OS2200WorkFile) {
                    var6_7 = OS2200ProjectUpdate.connectOS2200((IProject)((OS2200WorkFile)var1_1).getProject(), (boolean)false);
                    var5_5 = ((OS2200WorkFile)var1_1).members();
                    var2_2 = String.valueOf(var2_2) + ((OS2200WorkFile)var1_1).getName() + "'...";
                }
                if (var5_5 == null || var5_5.length <= 0) break block10;
                var4_4.beginTask(var2_2, var5_5.length);
                var8_8 = 0;
                while (var8_8 < var5_5.length) {
                    if (!(var5_5[var8_8] instanceof IFile) || var5_5[var8_8].toString().toLowerCase().endsWith(".project") || var5_5[var8_8].toString().toLowerCase().endsWith(".settings")) ** GOTO lbl31
                    var9_9 = (IFile)var5_5[var8_8];
                    var4_4.subTask(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_10")) + var9_9.getFullPath());
                    var10_10 = var9_9.getProject();
                    if (var5_5[var8_8].getRawLocation() == null) {
                        var5_5[var8_8].delete(true, null);
                    } else {
                        if (var6_7 != 0L) {
                            this.listOfOffLineSelection.add(var9_9);
                            var10_10.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "False");
                            break;
                        }
                        var10_10.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "True");
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (TDECoreUtilities.isUnInitializedFile((IFile)var9_9)) {
                                        var9_9.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                    } else if (!TDECoreUtilities.isPhysicallyInSync((IFile)var9_9)) {
                                        var9_9.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                                        var9_9.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                                    } else {
                                        var9_9.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                                        var9_9.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                    }
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            var3_3.getViewer().refresh((Object)var9_9, true);
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    OS2200CorePlugin.logger.debug((Object)exception.getMessage(), (Throwable)exception);
                                }
                            }
                        });
lbl31:
                        // 2 sources

                        if (var4_4.isCanceled()) {
                            return;
                        }
                        var4_4.worked(1);
                    }
                    ++var8_8;
                }
            }
            catch (CoreException var5_6) {
                OS2200CorePlugin.logger.debug((Object)var5_6.getMessage(), (Throwable)var5_6);
            }
        }
    }

    public void getListOfSelection(final String string) {
        isListOfSelectionCancled = false;
        final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    if (oS2200View != null) {
                        IStructuredSelection iStructuredSelection = oS2200View.getCurrentSel();
                        if (iStructuredSelection instanceof TreeSelection) {
                            List list = ((TreeSelection)iStructuredSelection).toList();
                            if (list != null && list.size() > 0) {
                                OS2200ArchitectureUtils.this.listOfOutOffSync = new HashSet();
                                OS2200ArchitectureUtils.this.listOfDirtyIFile = new HashSet();
                                OS2200ArchitectureUtils.this.listOfOffLineSelection = new HashSet();
                                OS2200ArchitectureUtils.this.listOfunInitalizedFiles = new HashSet();
                                int n = 0;
                                while (n < list.size()) {
                                    try {
                                        int n2 = n + 1;
                                        String string2 = String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_11")) + n2 + "/" + list.size() + ") '";
                                        if (list.get(n) instanceof IFile) {
                                            iProgressMonitor.beginTask(String.valueOf(string2) + list.get(n) + "'...", list.size());
                                            final IFile iFile = (IFile)list.get(n);
                                            iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_12")) + iFile.getFullPath());
                                            IProject iProject = iFile.getProject();
                                            long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
                                            if (l == 0L) {
                                                Display.getDefault().syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        OS2200ArchitectureUtils.this.checkSyncStatus(iFile, string);
                                                    }
                                                });
                                            } else {
                                                OS2200ArchitectureUtils.this.listOfOffLineSelection.add(iFile);
                                            }
                                        } else {
                                            OS2200ArchitectureUtils.this.getListOfIFile(list.get(n), string2, string, iProgressMonitor);
                                        }
                                    }
                                    catch (CoreException coreException) {
                                        OS2200CorePlugin.logger.warn((Object)coreException.getMessage(), (Throwable)coreException);
                                    }
                                    if (iProgressMonitor.isCanceled()) {
                                        OS2200ArchitectureUtils.this.listOfDirtyIFile.clear();
                                        OS2200ArchitectureUtils.this.listOfOutOffSync.clear();
                                        OS2200ArchitectureUtils.this.listOfunInitalizedFiles.clear();
                                        OS2200ArchitectureUtils.this.listOfOffLineSelection.clear();
                                        isListOfSelectionCancled = true;
                                        return;
                                    }
                                    iProgressMonitor.worked(1);
                                    ++n;
                                }
                            }
                        } else {
                            OS2200CorePlugin.logger.debug((Object)"Could not able to get the list from project selection");
                        }
                    } else {
                        OS2200CorePlugin.logger.info((Object)"Could not able to get the OS2200 project view");
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            OS2200CorePlugin.logger.warn((Object)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            OS2200CorePlugin.logger.warn((Object)interruptedException.getMessage(), (Throwable)interruptedException);
        }
    }

    private void getListOfIFile(Object object, String string, final String string2, IProgressMonitor iProgressMonitor) {
        try {
            final OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
            IResource[] iResourceArray = null;
            long l = -1L;
            String string3 = "";
            if (object instanceof IProject) {
                l = OS2200ProjectUpdate.connectOS2200((IProject)((IProject)object), (boolean)false);
                iResourceArray = ((IProject)object).members();
                string3 = ((IProject)object).getName();
                string = String.valueOf(string) + string3 + "'...";
            } else if (object instanceof OS2200WorkFile) {
                l = OS2200ProjectUpdate.connectOS2200((IProject)((OS2200WorkFile)object).getProject(), (boolean)false);
                iResourceArray = ((OS2200WorkFile)object).members();
                string3 = ((OS2200WorkFile)object).getName();
                string = String.valueOf(string) + string3 + "'...";
            }
            if (iResourceArray != null && iResourceArray.length > 0) {
                iProgressMonitor.beginTask(string, iResourceArray.length);
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n] instanceof IFile && !iResourceArray[n].toString().toLowerCase().endsWith(".project") && !iResourceArray[n].toString().toLowerCase().endsWith(".settings")) {
                        final IFile iFile = (IFile)iResourceArray[n];
                        iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200ArchitectureUtils_13")) + iFile.getFullPath());
                        if (l == 0L) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    OS2200ArchitectureUtils.this.checkSyncStatus(iFile, string2);
                                }
                            });
                        } else {
                            if (string3.trim().length() > 0) {
                                this.listOfOffLineSelection.add(string3);
                                break;
                            }
                            this.listOfOffLineSelection.add(object);
                            break;
                        }
                    }
                    if (iProgressMonitor.isCanceled()) {
                        this.listOfDirtyIFile.clear();
                        this.listOfOutOffSync.clear();
                        this.listOfunInitalizedFiles.clear();
                        this.listOfOffLineSelection.clear();
                        isListOfSelectionCancled = true;
                        return;
                    }
                    iProgressMonitor.worked(1);
                    ++n;
                }
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    oS2200View.getViewer().refresh();
                }
            });
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.debug((Object)coreException.getMessage(), (Throwable)coreException);
        }
    }

    private void checkSyncStatus(final IFile iFile, String string) {
        try {
            IPath iPath = iFile.getRawLocation();
            if (iPath == null) {
                iFile.delete(true, null);
                return;
            }
            FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(iPath.toOSString());
            if (fileInfo == null) {
                return;
            }
            if ("Sync with Local".equals(string)) {
                if (this.isEditordirty(iFile)) {
                    if (!new File(fileInfo.getRemoteFile()).exists()) {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "UnInitialized");
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                    } else if (fileInfo.remoteFileModified()) {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "conflict");
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                    } else {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "harmonious");
                    }
                    this.listOfDirtyIFile.add(this.SyncInfoobj);
                } else if (!new File(fileInfo.getLocalFile()).exists() || TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
                    this.listOfunInitalizedFiles.add(iFile);
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                } else if (fileInfo.localFileModified()) {
                    this.SyncInfoobj = !new File(fileInfo.getRemoteFile()).exists() ? new SyncInfoObject(iFile, "UnInitialized") : (fileInfo.remoteFileModified() ? new SyncInfoObject(iFile, "conflict") : new SyncInfoObject(iFile, "harmonious"));
                    this.listOfOutOffSync.add(this.SyncInfoobj);
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                }
            } else if ("Sync with Host".equals(string)) {
                if (!new File(fileInfo.getRemoteFile()).exists()) {
                    if (this.isEditordirty(iFile)) {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "element_deleted");
                        this.listOfDirtyIFile.add(this.SyncInfoobj);
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                    } else {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "element_deleted");
                        this.listOfOutOffSync.add(this.SyncInfoobj);
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                    }
                } else if (fileInfo.remoteFileModified()) {
                    if (this.isEditordirty(iFile)) {
                        this.SyncInfoobj = fileInfo.localFileModified() ? new SyncInfoObject(iFile, "conflict") : new SyncInfoObject(iFile, "harmonious");
                        this.listOfDirtyIFile.add(this.SyncInfoobj);
                    } else {
                        this.SyncInfoobj = TDECoreUtilities.isUnInitializedFile((IFile)iFile) ? new SyncInfoObject(iFile, "UnInitialized") : (fileInfo.localFileModified() ? new SyncInfoObject(iFile, "conflict") : new SyncInfoObject(iFile, "harmonious"));
                        this.listOfOutOffSync.add(this.SyncInfoobj);
                    }
                } else if (TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
                    this.SyncInfoobj = new SyncInfoObject(iFile, "UnInitialized");
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                    this.listOfOutOffSync.add(this.SyncInfoobj);
                }
            } else if ("Fetch Latest".equals(string)) {
                if (!new File(fileInfo.getRemoteFile()).exists()) {
                    if (this.isEditordirty(iFile)) {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "element_deleted");
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                        this.listOfDirtyIFile.add(this.SyncInfoobj);
                    } else {
                        this.SyncInfoobj = new SyncInfoObject(iFile, "element_deleted");
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                        this.listOfOutOffSync.add(this.SyncInfoobj);
                    }
                } else if (TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
                    this.SyncInfoobj = new SyncInfoObject(iFile, "UnInitialized");
                    this.listOfOutOffSync.add(this.SyncInfoobj);
                } else if (fileInfo.remoteFileModified()) {
                    this.SyncInfoobj = fileInfo.localFileModified() ? new SyncInfoObject(iFile, "conflict") : new SyncInfoObject(iFile, "harmonious");
                    this.listOfOutOffSync.add(this.SyncInfoobj);
                } else if (fileInfo.localFileModified()) {
                    this.SyncInfoobj = new SyncInfoObject(iFile, "harmonious");
                    this.listOfOutOffSync.add(this.SyncInfoobj);
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OS2200ArchitectureUtils.getViewObject().getViewer().refresh((Object)iFile, true);
                }
            });
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public static boolean syncElement(IFile iFile) {
        long l;
        File file = null;
        file = new File(iFile.getRawLocation().toOSString());
        FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(iFile.getRawLocation().toOSString());
        long l2 = fileInfo.getOrigRemoteFileLastModTimestamp();
        File file2 = new File(fileInfo.getRemoteFile());
        long l3 = file2.lastModified();
        if (l3 == (l = file.lastModified())) {
            return true;
        }
        if (l2 != l3) {
            SaveConflictDialog saveConflictDialog = new SaveConflictDialog(Display.getDefault().getActiveShell(), iFile, "Sync with Local");
            if (saveConflictDialog.open() == 0) {
                String string = TDECoreUtilities.getInstance().copyToHost(file, file2);
                return string.length() == 0;
            }
            return false;
        }
        if (l2 != l) {
            String string = TDECoreUtilities.getInstance().initiateCopying(file2, file, 1);
            return string.length() == 0;
        }
        return false;
    }

    public static void getProjectRefresh() {
        OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
        if (oS2200View != null) {
            oS2200View.getViewer().refresh();
        }
    }

    public static OS2200View getViewObject() {
        OS2200View oS2200View = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null) {
            IViewReference iViewReference = iWorkbenchPage.findViewReference(OS2200ViewId);
            if (iViewReference != null) {
                oS2200View = (OS2200View)iViewReference.getView(true);
            }
            if (oS2200View == null) {
                try {
                    oS2200View = (OS2200View)iWorkbenchPage.showView(OS2200ViewId);
                }
                catch (PartInitException partInitException) {
                    OS2200CorePlugin.logger.debug((Object)partInitException.getMessage(), (Throwable)partInitException);
                }
            }
        }
        return oS2200View;
    }

    public static String getOS2200PathFromIFile(IFile iFile) {
        String string = null;
        try {
            IProject iProject = iFile.getProject();
            Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
            String string2 = properties.getProperty("workFile");
            String string3 = iFile.getRawLocation().lastSegment();
            if (string3.contains(".") && iProject.getNature("com.unisys.tde.core.OS2200") != null) {
                string3 = string3.replace(".", "/");
            }
            string = String.valueOf(string2) + string3;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
        return string;
    }
}

