/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.utils;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.ui.handler.COBOLErrorsObject;
import com.unisys.tde.ui.utils.COBOLStatements;
import com.unisys.tde.ui.views.COBOLErrorsView;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class COBOLRulesEngine {
    private static final String SENTENCE_TERMINATING_CHARACTER = ".\n";
    private static final char COMMENT_CHAR = '*';
    private static final String SPACES = "\\s+";
    private static final String NEWLINE = "\\n";
    private static final String LINE_TERMINATING_CHARACTER = "\n";
    private String sentence = "";
    private COBOLEditor editor = null;
    private StyledText styText = null;
    private int beginLine = 0;
    private int procedureLineNumber = 0;
    private Element procedureElement = null;
    private Collection<Element> values = null;
    private COBOLParser cobolParser = null;
    private HashMap<Integer, Element> sourceMetaData = null;
    private static final String[] DATABASE_KEYWORDS = new String[]{" DEPART ", " IMPART ", " ACQUIRE ", " STORE ", " FETCH ", " FIND ", " GET ", " DELETE ", " INSERT ", " FIND ", " MODIFY ", " REMOVE ", " FREE ", " KEEP ", " LOG ", " OPEN ", " CLOSE "};
    private Map<Integer, List<Integer>> errorData = new HashMap<Integer, List<Integer>>();
    private static final String IF = "IF ";
    private static final String ELSE = "ELSE";
    private static final String ENDIF = "END-IF";
    private int indentSpaces = 1;
    private COBOLErrorsObject errorsObject = null;
    private static final int DUPLICATES_RULE = 0;
    private static final int DISCOURAGED_GOTO_RULE = 1;
    private static final int NULLPERFORM_RULE = 2;
    private static final int INDENTATION_RULE = 3;
    private static final int NOERRORCHECK_RULE = 4;
    private static final int UNREFERENCEDSECTION_RULE = 5;
    private Map<String, Integer> unreferencedSectionNames = new HashMap<String, Integer>();
    private static final String COBOL_SINGLEQUOTES_STRING_CHARACTER = "'";
    private static final String COBOL_DOUBLEQUOTES_STRING_CHARACTER = "\"";
    private boolean applyNullPerform = false;
    private boolean applyUnreferencedSection = false;
    private boolean applyGOTO = false;
    private boolean applyNoErrorCheck = false;
    private boolean applyIndentation = false;
    private static final int COMMENT_COLUMN = 7;
    private static final int AREA_B_COLUMN = 10;

    public Map<Integer, List<Integer>> getErrorData() {
        return this.errorData;
    }

    public COBOLEditor getEditor() {
        return this.editor;
    }

    public void beginRulesEngine() {
        IDocument iDocument;
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        if (iPreferenceStore.getString("Null Perform").isEmpty() || !iPreferenceStore.getString("Null Perform").equals("0")) {
            this.applyNullPerform = true;
        }
        if (iPreferenceStore.getString("Unreferenced Section").isEmpty() || !iPreferenceStore.getString("Unreferenced Section").equals("0")) {
            this.applyUnreferencedSection = true;
        }
        if (iPreferenceStore.getString("Discouraged GO TOs").isEmpty() || !iPreferenceStore.getString("Discouraged GO TOs").equals("0")) {
            this.applyGOTO = true;
        }
        if (iPreferenceStore.getString("No Error Check").isEmpty() || !iPreferenceStore.getString("No Error Check").equals("0")) {
            this.applyNoErrorCheck = true;
        }
        if (iPreferenceStore.getString("Indentation Issues").isEmpty() || !iPreferenceStore.getString("Indentation Issues").equals("0")) {
            this.indentSpaces = iPreferenceStore.getString("Indent Spaces").isEmpty() ? Integer.parseInt("1") : Integer.parseInt(iPreferenceStore.getString("Indent Spaces"));
            this.applyIndentation = true;
        }
        if ((iDocument = this.getDocument()) == null) {
            OS2200CorePlugin.logger.error((Object)"Document is null");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"Title.error"), (String)Messages.getString((String)"COBOLErrorsView.errorinDisplay"));
            return;
        }
        this.processDocument(iDocument);
        if (iPreferenceStore.getString("Duplicate Paragraph and Section Names").isEmpty() || !iPreferenceStore.getString("Duplicate Paragraph and Section Names").equals("0")) {
            this.applyDuplicateNamesRule();
        }
        if (iPreferenceStore.getString("Unreferenced Section").isEmpty() || !iPreferenceStore.getString("Unreferenced Section").equals("0")) {
            this.applyUnreferencedSectionRule();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IDocument getDocument() {
        IDocument iDocument = null;
        IEditorPart iEditorPart = null;
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) return iDocument;
        iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart != null) {
            try {
                if (iEditorPart instanceof COBOLEditor) {
                    this.editor = (COBOLEditor)iEditorPart;
                    this.styText = this.editor.getCurrentSourceViewer().getTextWidget();
                    iDocument = this.editor.getDocumentProvider().getDocument((Object)iEditorPart.getEditorInput());
                }
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                IFile iFile = null;
                if (iEditorInput instanceof FileEditorInput) {
                    IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                    iFile = iFileEditorInput.getFile();
                    this.errorsObject = new COBOLErrorsObject(iEditorPart, iEditorInput, iFile, COBOLErrorsView.OpenEditorTypes.LinkedToProject);
                    return iDocument;
                }
                if (iEditorInput instanceof OS2200FileEditorInput) {
                    OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
                    this.errorsObject = new COBOLErrorsObject(iEditorPart, oS2200FileEditorInput, oS2200FileEditorInput.getFile(), COBOLErrorsView.OpenEditorTypes.LinkedToOFCS);
                    return iDocument;
                }
                if (!(iEditorInput instanceof FileStoreEditorInput)) return iDocument;
                URI uRI = ((FileStoreEditorInput)iEditorInput).getURI();
                File file = new File(uRI.getPath());
                this.errorsObject = new COBOLErrorsObject(iEditorPart, iEditorInput, file, COBOLErrorsView.OpenEditorTypes.LocalFile);
                return iDocument;
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                return iDocument;
            }
        } else {
            OS2200CorePlugin.logger.error((Object)"Editorpart is null");
            return null;
        }
    }

    private void processDocument(IDocument iDocument) {
        if (this.editor != null) {
            this.cobolParser = new COBOLParser();
            this.cobolParser.initialize();
            this.cobolParser.parseDocument(iDocument);
            this.sourceMetaData = new HashMap();
            this.sourceMetaData = this.cobolParser.getElementLineMap();
            this.values = this.sourceMetaData.values();
            for (Element object2 : this.values) {
                if (object2.getBlockType() == 2) {
                    this.procedureLineNumber = object2.getLineNumber();
                    this.procedureElement = object2;
                }
                if (object2.getBlockType() != 4 || object2.getParent().getBlockType() != 2 || !this.isValidLine(this.styText.getLine(object2.getLineNumber()))) continue;
                this.unreferencedSectionNames.put(object2.getData(), object2.getLineNumber());
            }
        } else {
            OS2200CorePlugin.logger.error((Object)"Editor is null");
            return;
        }
        int n = iDocument.getNumberOfLines();
        Object var3_5 = null;
        int n2 = this.procedureLineNumber + 1;
        while (n2 < n) {
            try {
                String string3 = this.styText.getLine(n2).toUpperCase();
                string3 = this.editor.trimSpacesAtEnd(string3);
                string3 = String.valueOf(string3) + LINE_TERMINATING_CHARACTER;
                if (!this.sentence.isEmpty() || this.isValidLine(string3)) {
                    if (this.sentence.isEmpty()) {
                        this.beginLine = n2;
                        this.sentence = string3;
                    } else {
                        this.sentence = String.valueOf(this.sentence) + string3;
                    }
                    if (string3.endsWith(SENTENCE_TERMINATING_CHARACTER)) {
                        this.processSentence(iDocument);
                        this.sentence = "";
                    }
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            ++n2;
        }
    }

    private void processSentence(IDocument iDocument) {
        boolean bl = false;
        if (this.sentence.contains("PERFORM ")) {
            if (this.applyNullPerform) {
                this.applyNullPerformRule(iDocument);
            }
            if (this.applyUnreferencedSection && !this.isKeyWordWithinString("PERFORM ")) {
                this.prepareForUnreferencedSectionRule();
            }
        }
        if (this.applyGOTO && this.sentence.contains("GO ") && this.sentence.contains(" TO")) {
            this.applyDiscouragedGoToRule();
        }
        if (this.applyNoErrorCheck) {
            String string = null;
            String[] stringArray = DATABASE_KEYWORDS;
            int n = DATABASE_KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (this.sentence.contains(string2)) {
                    bl = true;
                    string = string2;
                    break;
                }
                ++n2;
            }
            if (bl) {
                this.applyNoErrorCheckRule(string);
            }
        }
        if (this.applyIndentation && this.sentence.contains(IF)) {
            this.applyIndentationRule();
        }
    }

    private void applyNullPerformRule(IDocument iDocument) {
        String[] stringArray = this.sentence.split(NEWLINE);
        int n = 0;
        while (n < stringArray.length) {
            if (this.isValidLine(stringArray[n])) {
                String[] stringArray2 = stringArray[n].split(SPACES);
                String string = null;
                if (stringArray2.length >= 2) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (stringArray2[n2].equals("PERFORM") && !stringArray2[n2 + 1].equals("VARYING")) {
                            string = stringArray2[n2 + 1];
                            if (string.endsWith(".")) {
                                string = string.replace(".", "");
                            }
                            Iterator<Element> iterator = this.values.iterator();
                            boolean bl = false;
                            while (iterator.hasNext()) {
                                Element element = iterator.next();
                                if (element.getData().equalsIgnoreCase(string)) {
                                    int n3 = element.getLineNumber();
                                    int n4 = iDocument.getNumberOfLines();
                                    String string2 = null;
                                    int n5 = n3 + 1;
                                    while (n5 < n4) {
                                        string2 = this.styText.getLine(n5).toUpperCase();
                                        string2 = this.editor.trimSpacesAtEnd(string2);
                                        if (this.isValidLine(string2 = String.valueOf(string2) + LINE_TERMINATING_CHARACTER) || n5 + 1 == n4) {
                                            int n6 = 7;
                                            while (n6 < string2.length()) {
                                                if (Character.isJavaIdentifierPart(string2.charAt(n6))) break;
                                                ++n6;
                                            }
                                            if (n6 > 10) {
                                                bl = true;
                                                break;
                                            }
                                            if (element.getBlockType() == 5 || string2.contains("SECTION") || n5 + 1 == n4) {
                                                this.addToMap(2, this.beginLine + n);
                                                bl = true;
                                                break;
                                            }
                                        }
                                        ++n5;
                                    }
                                }
                                if (bl) break;
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void applyDiscouragedGoToRule() {
        String[] stringArray = this.sentence.split(NEWLINE);
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n].split(SPACES);
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray2.length >= 2) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2].equalsIgnoreCase("GO") && stringArray2[n2 + 1].equalsIgnoreCase("TO")) {
                        bl2 = true;
                        if (n2 - 2 < 0) break;
                        if (stringArray2[n2 - 2].equalsIgnoreCase("ON") && stringArray2[n2 - 1].equalsIgnoreCase("ERROR") || stringArray2[n2 - 2].equalsIgnoreCase("AT") && stringArray2[n2 - 1].equalsIgnoreCase("END")) {
                            bl = true;
                        }
                    }
                    ++n2;
                }
                if (bl2 && !bl) {
                    this.addToMap(1, this.beginLine + n);
                }
            }
            ++n;
        }
    }

    private void prepareForUnreferencedSectionRule() {
        String[] stringArray = this.sentence.split(NEWLINE);
        int n = 0;
        while (n < stringArray.length) {
            if (this.isValidLine(stringArray[n])) {
                String[] stringArray2 = stringArray[n].split(SPACES);
                String string = null;
                if (stringArray2.length >= 2) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (stringArray2[n2].equals("PERFORM") && !stringArray2[n2 + 1].equals("VARYING")) {
                            string = stringArray2[n2 + 1];
                            if (string.endsWith(".")) {
                                string = string.replace(".", "");
                            }
                            for (Element element : this.values) {
                                if (!element.getData().equalsIgnoreCase(string) || element.getBlockType() != 4) continue;
                                this.unreferencedSectionNames.remove(element.getData());
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void applyUnreferencedSectionRule() {
        for (Map.Entry<String, Integer> entry : this.unreferencedSectionNames.entrySet()) {
            this.addToMap(5, entry.getValue());
        }
    }

    private void applyNoErrorCheckRule(String string) {
        if (this.isKeyWordWithinString(string)) {
            return;
        }
        String[] stringArray = this.sentence.split(NEWLINE);
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        block0: while (n2 < stringArray.length) {
            if (stringArray[n2].contains(string) && this.isValidLine(stringArray[n2])) {
                bl2 = true;
                n = n2;
                int n3 = n2;
                while (n3 < stringArray.length) {
                    if (this.isValidLine(stringArray[n3])) {
                        String[] stringArray2 = stringArray[n3].split(SPACES);
                        int n4 = 0;
                        while (n4 < stringArray2.length) {
                            if (stringArray2[n4].equalsIgnoreCase("ON") && stringArray2[n4 + 1].equalsIgnoreCase("ERROR")) {
                                bl = true;
                                break block0;
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                break;
            }
            ++n2;
        }
        if (!bl && bl2) {
            this.addToMap(4, this.beginLine + n);
        }
    }

    private boolean isKeyWordWithinString(String string) {
        String string2 = null;
        if (this.sentence.contains(COBOL_DOUBLEQUOTES_STRING_CHARACTER)) {
            string2 = COBOL_DOUBLEQUOTES_STRING_CHARACTER;
        } else if (this.sentence.contains(COBOL_SINGLEQUOTES_STRING_CHARACTER)) {
            string2 = COBOL_SINGLEQUOTES_STRING_CHARACTER;
        }
        return string2 != null && this.sentence.indexOf(string2) < this.sentence.indexOf(string) && this.sentence.indexOf(string) < this.sentence.lastIndexOf(string2);
    }

    private void applyIndentationRule() {
        Object object;
        Object object2;
        String[] stringArray = this.sentence.split(NEWLINE);
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].contains(IF) && this.isValidLine(stringArray[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = null;
        int n3 = n;
        while (n3 < stringArray.length) {
            object2 = new COBOLStatements();
            ((COBOLStatements)object2).setLineNumber(this.beginLine + n3);
            ((COBOLStatements)object2).setData(stringArray[n3]);
            if (stringArray[n3].contains(IF)) {
                ((COBOLStatements)object2).setStatementType(1);
                if (object3 == null) {
                    object3 = object2;
                    arrayList.add(object2);
                } else {
                    ((COBOLStatements)object2).setParent((COBOLStatements)object3);
                    ((COBOLStatements)object3).addChildElement((COBOLStatements)object2);
                    object3 = object2;
                }
            } else if (stringArray[n3].contains(ELSE)) {
                ((COBOLStatements)object2).setStatementType(2);
                if (((COBOLStatements)object3).getStatementType() == 2) {
                    try {
                        object3 = ((COBOLStatements)object3).getParent().getParent();
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.debug((Object)exception.getMessage(), (Throwable)exception);
                        break;
                    }
                    ((COBOLStatements)object2).setParent((COBOLStatements)object3);
                    ((COBOLStatements)object3).addChildElement((COBOLStatements)object2);
                    object3 = object2;
                } else {
                    ((COBOLStatements)object3).addChildElement((COBOLStatements)object2);
                    ((COBOLStatements)object2).setParent((COBOLStatements)object3);
                    object3 = object2;
                }
            } else if (stringArray[n3].contains(ENDIF)) {
                ((COBOLStatements)object2).setStatementType(3);
                object = object3;
                if (((COBOLStatements)object3).getStatementType() == 2) {
                    object = ((COBOLStatements)object3).getParent();
                }
                ((COBOLStatements)object2).setParent((COBOLStatements)object);
                ((COBOLStatements)object).addChildElement((COBOLStatements)object2);
                object3 = ((COBOLStatements)object).getParent();
                if (object3 == null) {
                    break;
                }
            } else {
                if (object3 == null) break;
                ((COBOLStatements)object2).setStatementType(5);
                object = object3;
                if (((COBOLStatements)object3).getStatementType() == 2) {
                    object = ((COBOLStatements)object3).getParent();
                }
                ((COBOLStatements)object2).setParent((COBOLStatements)object);
                ((COBOLStatements)object).addChildElement((COBOLStatements)object2);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < arrayList.size()) {
            object2 = ((COBOLStatements)arrayList.get(n3)).getData();
            if (((String)object2).contains(IF)) {
                object = ((String)object2).split(SPACES);
                int n4 = 0;
                while (n4 < ((String[])object).length) {
                    int n5;
                    if (object[n4].equalsIgnoreCase("IF") && (n5 = ((String)object2).indexOf(object[n4 + 1]) - ((String)object2).indexOf(IF)) - 2 != this.indentSpaces) {
                        this.addToMap(3, n + this.beginLine);
                        break;
                    }
                    ++n4;
                }
            }
            this.findIndentationIssues((COBOLStatements)arrayList.get(n3));
            ++n3;
        }
    }

    private void findIndentationIssues(COBOLStatements cOBOLStatements) {
        ArrayList<COBOLStatements> arrayList = cOBOLStatements.getChildElements();
        int n = 0;
        if (arrayList.size() != 0) {
            if (cOBOLStatements.getData().contains(IF)) {
                n = cOBOLStatements.getData().indexOf(IF);
            } else if (cOBOLStatements.getParent().getData().contains(IF)) {
                n = cOBOLStatements.getParent().getData().indexOf(IF);
            } else {
                return;
            }
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (arrayList.get(n2).getData().contains(ELSE)) {
                if (n != arrayList.get(n2).getData().indexOf(ELSE)) {
                    this.addToMap(3, arrayList.get(n2).getLineNumber());
                } else if (arrayList.get(n2).getData().contains(IF)) {
                    this.checkIndentSpacesforIF(arrayList.get(n2));
                }
            } else if (arrayList.get(n2).getData().contains(ENDIF)) {
                if (n != arrayList.get(n2).getData().indexOf(ENDIF)) {
                    this.addToMap(3, arrayList.get(n2).getLineNumber());
                }
            } else if (this.isValidLine(arrayList.get(n2).getData())) {
                if (n + this.indentSpaces + 2 > this.findColumn(arrayList.get(n2).getData())) {
                    this.addToMap(3, arrayList.get(n2).getLineNumber());
                } else if (arrayList.get(n2).getData().contains(IF)) {
                    this.checkIndentSpacesforIF(arrayList.get(n2));
                }
            }
            this.findIndentationIssues(arrayList.get(n2));
            ++n2;
        }
    }

    private void checkIndentSpacesforIF(COBOLStatements cOBOLStatements) {
        String[] stringArray = cOBOLStatements.getData().split(SPACES);
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            if (stringArray[n].equalsIgnoreCase("IF") && (n2 = cOBOLStatements.getData().indexOf(stringArray[n + 1]) - cOBOLStatements.getData().indexOf(IF)) - 2 != this.indentSpaces) {
                this.addToMap(3, cOBOLStatements.getLineNumber());
                break;
            }
            ++n;
        }
    }

    private int findColumn(String string) {
        boolean bl = this.isValidLine(string);
        if (!bl) {
            return 0;
        }
        if (string.contains(IF)) {
            return string.indexOf(IF);
        }
        int n = 7;
        while (n < string.length()) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) break;
            ++n;
        }
        return n;
    }

    private boolean isValidLine(String string) {
        if (string.length() <= 6) {
            return false;
        }
        if (string.charAt(6) == '*') {
            return false;
        }
        return string.charAt(6) == 'D' || string.charAt(6) == '/' || string.charAt(6) == ' ' || string.charAt(6) == '-';
    }

    public void applyDuplicateNamesRule() {
        if (this.procedureElement != null) {
            HashSet<String> hashSet = new HashSet<String>();
            this.processElement(this.procedureElement, hashSet);
        }
    }

    private void processElement(Element element, Set<String> set) {
        ArrayList arrayList = element.getChildElements();
        int n = 0;
        while (n < arrayList.size()) {
            Element element2 = (Element)arrayList.get(n);
            String string = element2.getData();
            if (!set.add(string)) {
                this.addToMap(0, element2.getLineNumber());
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            this.processElement((Element)arrayList.get(n), set);
            ++n;
        }
    }

    private void addToMap(int n, int n2) {
        try {
            if (this.errorData != null) {
                List<Integer> list = this.errorData.get(n);
                if (list == null) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    arrayList.add(n2);
                    this.errorData.put(n, arrayList);
                } else {
                    list.add(n2);
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public COBOLErrorsObject getCOBOLErrorsObject() {
        return this.errorsObject;
    }

    public void dispose() {
        if (this.cobolParser != null) {
            this.cobolParser.dispose();
            this.cobolParser = null;
        }
    }
}

