/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.preferences;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.OS2200UIStartup;
import com.unisys.tde.ui.utils.ScheduleTask;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class OS2200BasePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Label lblFrequency = null;
    private Combo weekDays = null;
    private Combo hostcheckFrequency = null;
    private final int DEFAULT_VALUE = 0;
    private final String[] DAYS_OF_MONTH = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28"};
    private ScheduleTask task = new ScheduleTask();
    private static Thread thread;

    public OS2200BasePreferencePage() {
        OS2200CorePlugin.logger.debug((Object)"");
    }

    public OS2200BasePreferencePage(int n) {
        super(n);
        OS2200CorePlugin.logger.debug((Object)"");
    }

    public OS2200BasePreferencePage(String string, int n) {
        super(string, n);
        OS2200CorePlugin.logger.debug((Object)"");
    }

    public OS2200BasePreferencePage(String string, ImageDescriptor imageDescriptor, int n) {
        super(string, imageDescriptor, n);
        OS2200CorePlugin.logger.debug((Object)"");
    }

    public void init(IWorkbench iWorkbench) {
        OS2200CorePlugin.logger.debug((Object)"");
    }

    protected void createFieldEditors() {
        OS2200CorePlugin.logger.debug((Object)"");
    }

    protected Control createContents(Composite composite) {
        String string;
        String string2;
        OS2200CorePlugin.logger.debug((Object)"");
        this.setTitle(" OS 2200 ");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.");
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.widthHint = 125;
        gridData.heightHint = 17;
        gridData.horizontalSpan = 1;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 15;
        gridData2.heightHint = 17;
        gridData2.horizontalSpan = 1;
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        Group group = new Group(composite, 4);
        group.setText("Clear Cache");
        group.setLayoutData((Object)gridData3);
        group.setLayout((Layout)gridLayout);
        this.lblFrequency = new Label((Composite)group, 0);
        this.lblFrequency.setText("Clear residual files on ");
        this.lblFrequency.setLayoutData((Object)gridData);
        this.weekDays = new Combo((Composite)group, 8);
        this.weekDays.setItems(this.DAYS_OF_MONTH);
        try {
            string2 = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(this.task.SCHEDULED_TASK_DATE);
            if (string2 != null) {
                this.weekDays.select(this.weekDays.indexOf(string2));
            } else {
                this.weekDays.select(0);
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        this.weekDays.setLayoutData((Object)gridData2);
        string2 = new Label((Composite)group, 0);
        string2.setText(" of every month.");
        string2.setLayoutData((Object)gridData);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 3;
        Group group2 = new Group(composite, 4);
        group2.setText("Host Manager View ");
        group2.setLayoutData((Object)gridData4);
        group2.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group2, 0);
        label.setText(" Run Host status checker every ");
        label.setLayoutData((Object)gridData);
        this.hostcheckFrequency = new Combo((Composite)group2, 8);
        String[] stringArray = new String[]{"10", "15", "30", "60"};
        this.hostcheckFrequency.setItems(stringArray);
        this.hostcheckFrequency.setLayoutData((Object)gridData2);
        try {
            string = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(OS2200ProjectUpdate.SCHEDULED_HMV_STS_CHECK);
            if (string != null && string.trim().length() > 0) {
                this.hostcheckFrequency.select(this.hostcheckFrequency.indexOf(string));
            } else {
                this.hostcheckFrequency.select(0);
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        string = new Label((Composite)group2, 0);
        string.setText(" minutes.");
        string.setLayoutData((Object)gridData);
        return super.createContents(composite);
    }

    protected void performApply() {
        OS2200CorePlugin.logger.debug((Object)"");
        super.performApply();
    }

    protected void performDefaults() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.weekDays.select(0);
        this.hostcheckFrequency.select(0);
        super.performDefaults();
    }

    public boolean performOk() {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(this.task.SCHEDULED_TASK_DATE, this.weekDays.getItem(this.weekDays.getSelectionIndex()));
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(OS2200ProjectUpdate.SCHEDULED_HMV_STS_CHECK, this.hostcheckFrequency.getItem(this.hostcheckFrequency.getSelectionIndex()));
            if (OS2200UIStartup.t1 != null && OS2200UIStartup.t1.isAlive()) {
                OS2200UIStartup.t1.interrupt();
                OS2200CorePlugin.logger.debug((Object)(String.valueOf(OS2200UIStartup.t1.getName()) + " thread interrputed."));
                OS2200UIStartup.t1 = null;
            }
            if (thread != null && thread.isAlive()) {
                thread.interrupt();
                OS2200CorePlugin.logger.debug((Object)(String.valueOf(thread.getName()) + " thread interrputed."));
                thread = null;
            }
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OS2200UIStartup.startHMVStatusThread();
                }
            }, "HMVStatusCheckBasePreferencePage");
            thread.setPriority(1);
            thread.start();
            OS2200CorePlugin.logger.debug((Object)(String.valueOf(thread.getName()) + " thread started."));
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        OS2200CorePlugin.logger.debug((Object)(" Selected date : " + this.weekDays.getItem(this.weekDays.getSelectionIndex())));
        OS2200CorePlugin.logger.debug((Object)(" Scheduled Frequency : " + this.hostcheckFrequency.getItem(this.hostcheckFrequency.getSelectionIndex())));
        this.task.schedule();
        return super.performOk();
    }
}

