/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.listeners;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.UIUtil;
import com.unisys.tde.ui.actions.PasteAction;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.tde.ui.views.OS2200WorkFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class OS2200ExplorerDropListener
implements DropTargetListener {
    private OS2200View viewer;
    private List<IFile> dragList = new ArrayList<IFile>(10);
    private String[] sourceData = null;
    private IProject sourceProject = null;
    IProject targetProject = null;

    public OS2200ExplorerDropListener() {
    }

    public OS2200ExplorerDropListener(OS2200View oS2200View) {
        this.viewer = oS2200View;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.feedback = 8;
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        if (dropTargetEvent != null) {
            this.targetProject = this.getProject((TreeItem)dropTargetEvent.item);
            if (this.targetProject != null && this.targetProject.isOpen()) {
                IStructuredSelection iStructuredSelection = this.viewer.getCurrentSel();
                if (iStructuredSelection instanceof TreeSelection) {
                    TreePath[] treePathArray;
                    TreePath[] treePathArray2 = treePathArray = ((TreeSelection)iStructuredSelection).getPaths();
                    int n = treePathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath treePath = treePathArray2[n2];
                        this.sourceProject = (IProject)treePath.getSegment(0);
                        if (this.viewer.isDragged() && this.sourceProject.getName().equalsIgnoreCase(this.targetProject.getName())) {
                            dropTargetEvent.detail = 0;
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.targetProject != null) {
                    OS2200CorePlugin.logger.info((Object)(" targetProject := " + this.targetProject.getName()));
                }
            } else {
                dropTargetEvent.detail = 0;
                return;
            }
        }
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        TreeItem treeItem = (TreeItem)dropTargetEvent.item;
        this.sourceData = (String[])dropTargetEvent.data;
        this.dragList = this.getSelectedFiles();
        try {
            final IProject iProject = this.getProject(treeItem);
            if (iProject != null) {
                if (this.sourceData != null) {
                    try {
                        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                        progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                iProgressMonitor.beginTask(Messages.getString((String)"OS2200ExplorerDropListener_0"), OS2200ExplorerDropListener.this.dragList.size());
                                PasteAction.localToOS2200Paste(OS2200ExplorerDropListener.this.sourceData, (IResource)iProject, iProgressMonitor);
                                OS2200ExplorerDropListener.this.viewer.getViewer().refresh();
                            }
                        });
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)("User Cancelled Drop Operation" + exception));
                    }
                } else if (this.dragList != null && this.dragList.size() > 0) {
                    IProject iProject2;
                    IProject iProject3 = null;
                    for (IResource iResource : this.dragList) {
                        if (iResource instanceof IFile) {
                            iProject2 = ((IFile)iResource).getProject();
                            if (iProject3 != null && iProject3 == iProject2) continue;
                            iProject3 = iProject2;
                            if (UIUtil.openDlgForFileDnD()) break;
                            return;
                        }
                        if (!(iResource instanceof IFolder)) continue;
                        if (UIUtil.openDlgForFolderDnD()) break;
                        return;
                    }
                    ArrayList<IResource> arrayList = new ArrayList<IResource>();
                    for (IResource iResource : this.dragList) {
                        try {
                            if (iResource instanceof IFile) {
                                arrayList.add(iResource);
                                continue;
                            }
                            if (!(iResource instanceof IFolder)) continue;
                            IResource[] iResourceArray = ((IFolder)iResource).members();
                            ArrayList<IResource> arrayList2 = new ArrayList<IResource>(Arrays.asList(iResourceArray));
                            arrayList.addAll(arrayList2);
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)("An error occured while copying the files !!! " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    final IResource[] iResourceArray = arrayList.toArray(new IResource[arrayList.size()]);
                    iProject2 = new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                    iProject2.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            iProgressMonitor.beginTask(Messages.getString((String)"OS2200ExplorerDropListener_0"), iResourceArray.length + 1);
                            PasteAction.os2200ToOS2200Paste(iResourceArray, (IResource)iProject, iProgressMonitor);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public List<IFile> getSelectedFiles() {
        if (this.viewer != null) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getViewer().getSelection();
            return iStructuredSelection.toList();
        }
        return null;
    }

    private Shell getShell() {
        return this.viewer.getViewer().getTree().getShell();
    }

    private IProject getProject(TreeItem treeItem) {
        if (treeItem != null) {
            Object object = treeItem.getData();
            if (object instanceof IProject) {
                return (IProject)object;
            }
            if (object instanceof OS2200WorkFile) {
                return ((OS2200WorkFile)object).getProject();
            }
            if (object instanceof IFile) {
                return ((IFile)object).getProject();
            }
            return null;
        }
        return null;
    }
}

