/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.listeners;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.ui.views.HostManagerViewModel;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import java.util.HashSet;

public class ConnectionStatusChecker {
    private static ConnectionStatusChecker conStatusCheck = null;

    private ConnectionStatusChecker() {
    }

    public static ConnectionStatusChecker getInstance() {
        if (conStatusCheck == null) {
            conStatusCheck = new ConnectionStatusChecker();
        }
        return conStatusCheck;
    }

    public HashSet<HostManagerViewModel> getHostStatus() {
        OS2200CorePlugin.logger.debug((Object)"");
        HashSet<HostManagerViewModel> hashSet = null;
        try {
            HostAccount[] hostAccountArray = HostAccount.getHostAccounts();
            if (hostAccountArray.length > 0) {
                hashSet = new HashSet<HostManagerViewModel>();
                HostManagerViewModel hostManagerViewModel = null;
                int n = 0;
                while (n < hostAccountArray.length) {
                    hostManagerViewModel = new HostManagerViewModel(hostAccountArray[n]);
                    if (OS2200FileInterface.isCifsConnected((HostAccount)hostAccountArray[n])) {
                        hostManagerViewModel.setConnected(this.executePingCommand(hostAccountArray[n].getCifsHostId()));
                    } else {
                        hostManagerViewModel.setConnected(false);
                    }
                    hashSet.add(hostManagerViewModel);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return hashSet;
    }

    private boolean executePingCommand(String string) {
        OS2200CorePlugin.logger.debug((Object)"");
        Process process = null;
        try {
            boolean bl;
            String string2 = "ping -n 3 " + string;
            process = Runtime.getRuntime().exec(string2);
            int n = process.waitFor();
            boolean bl2 = bl = n == 0;
            return bl2;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (process != null) {
                process.destroy();
                process = null;
            }
        }
        return false;
    }
}

