/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.logging.core.PluginLogManager;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.osgi.framework.Bundle;

public class SetLogLevelDialog
extends SelectionStatusDialog {
    private Composite composite;
    public static final String PLUGIN_ID = "com.unisys.tde.core";
    private String recentLogLevel;

    public SetLogLevelDialog(Shell shell) {
        super(shell);
        OS2200CorePlugin.logger.info((Object)"");
    }

    protected Control createDialogArea(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.context_set_log_level1");
        composite.getShell().setText(Messages.getString((String)"SetLogLevel.1"));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 20;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        this.composite = new Composite(composite, 0);
        this.composite.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(1, false);
        this.composite.setLayout((Layout)gridLayout2);
        String[] stringArray = new String[]{"Fatal", "Error", "Warn", "Info", "Debug"};
        Button button = null;
        int n = 0;
        while (n < 5) {
            button = new Button(this.composite, 16);
            button.setText(stringArray[n]);
            button.setData((Object)stringArray[n].toUpperCase());
            button.setSelection(this.recentLogLevel.equals(stringArray[n].toUpperCase()));
            ++n;
        }
        return composite;
    }

    protected void okPressed() {
        String string = this.getRadioSelection();
        this.setLogLevel(string);
        OS2200CorePlugin.logger.log((Priority)Level.toLevel((String)string), (Object)("Log Level Changed to: " + string));
        super.okPressed();
    }

    public String getPluginDirectoryPath() {
        OS2200CorePlugin.logger.info((Object)"");
        Path path = null;
        try {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            URL uRL = Platform.resolve((URL)bundle.getEntry("/"));
            path = new Path(uRL.getFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return path.toOSString();
    }

    public String getRadioSelection() {
        OS2200CorePlugin.logger.info((Object)"");
        Control[] controlArray = this.composite.getChildren();
        Button button = null;
        int n = 0;
        while (n < controlArray.length) {
            if (((Button)controlArray[n]).getSelection()) {
                button = (Button)controlArray[n];
                break;
            }
            ++n;
        }
        return (String)button.getData();
    }

    private void setLogLevel(String string) {
        OS2200CorePlugin.logger.info((Object)"");
        OS2200CorePlugin oS2200CorePlugin = OS2200CorePlugin.getPlugin();
        PluginLogManager pluginLogManager = oS2200CorePlugin.getPluginLogManager();
        Logger logger = pluginLogManager.getLogger("com.unisys.os2200");
        AppenderSkeleton appenderSkeleton = (AppenderSkeleton)logger.getAppender("A1");
        appenderSkeleton.setThreshold((Priority)Level.toLevel((String)string));
        this.persistLogLevelSetting(string);
    }

    private void persistLogLevelSetting(String string) {
        block45: {
            Object object;
            StringBuffer stringBuffer;
            File file;
            block43: {
                OS2200CorePlugin.logger.debug((Object)"Inside persistLogLevel setting");
                String string2 = this.getPluginDirectoryPath();
                String string3 = String.valueOf(string2.substring(0, string2.length())) + "logger.properties";
                file = null;
                FileInputStream fileInputStream = null;
                InputStreamReader inputStreamReader = null;
                BufferedReader bufferedReader = null;
                stringBuffer = null;
                String string4 = "log4j.appender.A1.threshold=";
                try {
                    file = new File(string3);
                    fileInputStream = new FileInputStream(file);
                    inputStreamReader = new InputStreamReader(fileInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    stringBuffer = new StringBuffer();
                    while ((object = bufferedReader.readLine()) != null) {
                        if (((String)object).startsWith(string4)) {
                            stringBuffer.append("log4j.appender.A1.threshold=" + string);
                        } else {
                            stringBuffer.append((String)object);
                        }
                        stringBuffer.append("\n");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                            inputStreamReader = null;
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                        break block43;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block43;
                }
                catch (IOException iOException) {
                    try {
                        iOException.printStackTrace();
                        break block43;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                                fileInputStream = null;
                            }
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                                inputStreamReader = null;
                            }
                            if (bufferedReader != null) {
                                bufferedReader.close();
                                bufferedReader = null;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                        inputStreamReader = null;
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    object = new FileWriter(file);
                    bufferedWriter = new BufferedWriter((Writer)object);
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    try {
                        if (object != null) {
                            ((OutputStreamWriter)object).close();
                            object = null;
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                            bufferedWriter = null;
                        }
                        file = null;
                    }
                    catch (Exception exception) {}
                    break block45;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        ((OutputStreamWriter)object).close();
                        object = null;
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                        bufferedWriter = null;
                    }
                    file = null;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (object != null) {
                    ((OutputStreamWriter)object).close();
                    object = null;
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
                file = null;
            }
            catch (Exception exception) {}
        }
    }

    public String getRecentLogLevel() {
        return this.recentLogLevel;
    }

    public void setRecentLogLevel(String string) {
        this.recentLogLevel = string;
    }

    protected void computeResult() {
    }
}

