/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.handler.SendMailBase;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SendOutlookMail
extends SendMailBase {
    private static SendOutlookMail outlookMail;
    private OleAutomation mail;
    private Job mailJob;
    private ArrayList<File> attachableFiles;
    private ArrayList<String> errFiles;
    private HashMap<String, Integer> map = null;
    private HashMap<String, HashMap<String, Object>> fileMap = null;
    private static final String OUTLOOK_ID = "Outlook.Application";
    private static final String OUTLOOK_CREATE_ITEM = "CreateItem";
    private static final String OUTLOOK_DISPLAY = "Display";
    private static final String OUTLOOK_SUBJECT = "Subject";
    private static final String OUTLOOK_ATTACHMENT = "Attachments";
    private static final String OUTLOOK_BODY = "HtmlBody";
    private static final String OUTLOOK_ADD = "Add";
    private static final String HTML_OPENING_TAG = "<html><PRE>";
    private static final String HTML_CLOSEING_TAG = "</PRE></html>";
    private static final String HTML_NEWLINE = "<br/>";
    private static final String HTML_SPACE = "%-40s %s";
    private static final String DOUBLE_SLASH = "\\";
    private static final String OPENING_BRACE = "(";
    private static final String CLOSING_BRACE = ")";
    private static final String TEMP_DIR_PATH = "java.io.tmpdir";
    private static final String DELIMITER = " , ";
    private boolean isActualFile = false;

    public static SendOutlookMail getInstance() {
        if (outlookMail == null) {
            outlookMail = new SendOutlookMail();
        }
        return outlookMail;
    }

    @Override
    public void SendMail(final ArrayList<?> arrayList, boolean bl) {
        this.attachableFiles = null;
        this.errFiles = new ArrayList();
        this.map = new HashMap();
        this.fileMap = new HashMap();
        this.isActualFile = bl;
        if (!arrayList.isEmpty()) {
            OS2200CorePlugin.logger.debug((Object)("Send Via Email -- Total files to be attached : " + arrayList.size()));
            this.mailJob = new Job(Messages.getString((String)"SendEmail.1")){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    SendOutlookMail.this.attachableFiles = SendOutlookMail.this.getListofAttachableFiles(arrayList, iProgressMonitor);
                    if (SendOutlookMail.this.attachableFiles != null && !SendOutlookMail.this.attachableFiles.isEmpty()) {
                        OS2200CorePlugin.logger.debug((Object)("Send Via Email -- Attachable file count : " + SendOutlookMail.this.attachableFiles.size()));
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Display display = Display.getDefault();
                                Shell shell = new Shell(display);
                                OleFrame oleFrame = new OleFrame((Composite)shell, 0);
                                OleClientSite oleClientSite = new OleClientSite((Composite)oleFrame, 0, SendOutlookMail.OUTLOOK_ID);
                                OleAutomation oleAutomation = new OleAutomation(oleClientSite);
                                SendOutlookMail.this.mail = SendOutlookMail.invoke(oleAutomation, SendOutlookMail.OUTLOOK_CREATE_ITEM, 0).getAutomation();
                                if (SendOutlookMail.this.attachFiles(SendOutlookMail.this.attachableFiles)) {
                                    SendOutlookMail.invoke(SendOutlookMail.this.mail, SendOutlookMail.OUTLOOK_DISPLAY);
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            this.mailJob.setUser(true);
            this.mailJob.schedule();
        }
    }

    private String getIFilePath(IFile iFile, String string, IProgressMonitor iProgressMonitor) {
        String string2 = "";
        if (TDECoreUtilities.isUnInitializedFile((IFile)iFile)) {
            iProgressMonitor.setTaskName(String.valueOf(Messages.getString((String)"SendEmail.13")) + " " + iFile.getName());
            if (!OS2200ArchitectureUtils.initiateDownlodingElement(iFile)) {
                this.errFiles.add(iFile.getName());
                OS2200CorePlugin.logger.debug((Object)("Send Via Email -- " + iFile.getName() + " could not be downloaded from host"));
                return null;
            }
            string2 = iFile.getRawLocation().toOSString();
        } else {
            string2 = iFile.getRawLocation().toOSString();
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (SendOutlookMail.copyToLocal(file2, file, null)) {
            return string;
        }
        this.errFiles.add(iFile.getName());
        return null;
    }

    private String getFilePath(File file, String string, IProgressMonitor iProgressMonitor) {
        File file2 = new File(string);
        iProgressMonitor.setTaskName(String.valueOf(Messages.getString((String)"SendEmail.17")) + " " + file.getName());
        if (SendOutlookMail.copyToLocal(file, file2, null)) {
            return string;
        }
        this.errFiles.add(file.getName());
        return null;
    }

    private String getOrginalFileName(Object object) {
        String string = "";
        if (object instanceof IFile) {
            string = ((IFile)object).getLocation().toFile().getName();
        }
        if (object instanceof File) {
            string = ((File)object).getName();
        }
        if (object instanceof String) {
            File file = new File((String)object);
            string = file.getName();
        }
        return string;
    }

    private String getDestFilePath(Object object) {
        String string = this.getOrginalFileName(object);
        if (this.map.containsKey(string)) {
            Integer n = this.map.get(string);
            n = n + 1;
            this.map.put(string, n);
        } else {
            this.map.put(string, 0);
        }
        int n = this.map.get(string);
        if (n > 0) {
            if (string.contains(".")) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.insert(string.lastIndexOf("."), OPENING_BRACE + n + CLOSING_BRACE);
                string = stringBuilder.toString();
            } else {
                string = String.valueOf(string) + OPENING_BRACE + n + CLOSING_BRACE;
            }
        }
        return String.valueOf(System.getProperty(TEMP_DIR_PATH)) + DOUBLE_SLASH + string;
    }

    private ArrayList<File> getListofAttachableFiles(ArrayList<?> arrayList, IProgressMonitor iProgressMonitor) {
        String string;
        ArrayList<File> arrayList2 = new ArrayList<File>();
        iProgressMonitor.beginTask(String.valueOf(Messages.getString((String)"SendEmail.15")) + " ", arrayList.size());
        try {
            try {
                for (Object object : arrayList) {
                    string = null;
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (object instanceof IFile) {
                        string = this.getIFilePath((IFile)object, this.getDestFilePath(object), iProgressMonitor);
                    }
                    if (object instanceof File) {
                        string = this.getFilePath((File)object, this.getDestFilePath(object), iProgressMonitor);
                    }
                    if (object instanceof String) {
                        string = (String)object;
                    }
                    if (string != null) {
                        File file = new File(string);
                        if (file.exists()) {
                            arrayList2.add(file);
                            String string2 = this.getOrginalFileName(object);
                            if (this.fileMap.containsKey(string2)) {
                                this.fileMap.get(string2).put(file.getName(), object);
                            } else {
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                hashMap.put(file.getName(), object);
                                this.fileMap.put(string2, hashMap);
                            }
                        } else {
                            this.errFiles.add(file.getName());
                        }
                    }
                    iProgressMonitor.worked(1);
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.debug((Object)("Send Via Email -- " + exception.getMessage()));
                ArrayList<File> arrayList3 = arrayList2;
                iProgressMonitor.done();
                return arrayList3;
            }
        }
        finally {
            iProgressMonitor.done();
        }
        if (!this.errFiles.isEmpty()) {
            Object object;
            object = new StringBuilder();
            int n = 0;
            while (n < this.errFiles.size()) {
                string = this.errFiles.get(n);
                ((StringBuilder)object).append(string);
                if (n < this.errFiles.size() - 1) {
                    ((StringBuilder)object).append(DELIMITER);
                }
                ++n;
            }
            OS2200CorePlugin.logger.debug((Object)("Send Via Email -- Files which are not attachable : " + object));
            Display.getDefault().syncExec(new Runnable((StringBuilder)object){
                private final /* synthetic */ StringBuilder val$errFileName;
                {
                    this.val$errFileName = stringBuilder;
                }

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"SendEmail.1"), (String)Messages.getString((String)"SendEmail.14", (String)this.val$errFileName.toString()));
                }
            });
        }
        return arrayList2;
    }

    private String getEmailBody() {
        OS2200CorePlugin.logger.debug((Object)"Send Via Email -- Constructing Email Body.");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, HashMap<String, Object>> entry : this.fileMap.entrySet()) {
            HashMap<String, Object> hashMap = this.fileMap.get(entry.getKey());
            for (Map.Entry<String, Object> entry2 : hashMap.entrySet()) {
                String string = SendOutlookMail.getOrginalFileLocation(entry2.getValue());
                String string2 = String.format(HTML_SPACE, entry2.getKey(), string);
                stringBuilder.append(String.valueOf(string2) + HTML_NEWLINE);
                stringBuilder.append(HTML_NEWLINE);
            }
        }
        if (stringBuilder.length() > 0 && !this.isActualFile) {
            stringBuilder.append(Messages.getString((String)"SendEmail.25"));
        }
        return stringBuilder.toString();
    }

    private boolean attachFiles(ArrayList<File> arrayList) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(Messages.getString((String)"SendEmail.16")) + " ");
            int n = 0;
            while (n < arrayList.size()) {
                File file = arrayList.get(n);
                OleAutomation oleAutomation = SendOutlookMail.getProperty(this.mail, OUTLOOK_ATTACHMENT);
                SendOutlookMail.invoke(oleAutomation, OUTLOOK_ADD, file.getPath());
                OS2200CorePlugin.logger.debug((Object)("Send Via Email -- File attached : " + file.getPath()));
                stringBuffer.append(file.getName());
                if (n < arrayList.size() - 1) {
                    stringBuffer.append(DELIMITER);
                }
                ++n;
            }
            this.mail.setProperty(SendOutlookMail.property(this.mail, OUTLOOK_SUBJECT), new Variant(stringBuffer.toString()));
            String string = this.getEmailBody();
            if (string.length() > 0) {
                this.mail.setProperty(SendOutlookMail.property(this.mail, OUTLOOK_BODY), new Variant(HTML_OPENING_TAG + string + HTML_CLOSEING_TAG));
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)("Send Using Email - " + exception.getMessage()));
            return false;
        }
        return true;
    }

    private static OleAutomation getProperty(OleAutomation oleAutomation, String string) {
        OS2200CorePlugin.logger.debug((Object)"Inside get property method");
        Variant variant = oleAutomation.getProperty(SendOutlookMail.property(oleAutomation, string));
        if (variant != null && variant.getType() != 0) {
            OleAutomation oleAutomation2 = variant.getAutomation();
            variant.dispose();
            return oleAutomation2;
        }
        return null;
    }

    private static Variant invoke(OleAutomation oleAutomation, String string, String string2) {
        OS2200CorePlugin.logger.debug((Object)"Inside invoke method");
        return oleAutomation.invoke(SendOutlookMail.property(oleAutomation, string), new Variant[]{new Variant(string2)});
    }

    private static Variant invoke(OleAutomation oleAutomation, String string) {
        OS2200CorePlugin.logger.debug((Object)"Inside invoke method");
        return oleAutomation.invoke(SendOutlookMail.property(oleAutomation, string));
    }

    private static Variant invoke(OleAutomation oleAutomation, String string, int n) {
        OS2200CorePlugin.logger.debug((Object)"Inside invoke method");
        return oleAutomation.invoke(SendOutlookMail.property(oleAutomation, string), new Variant[]{new Variant(n)});
    }

    private static int property(OleAutomation oleAutomation, String string) {
        OS2200CorePlugin.logger.debug((Object)"Inside invoke method");
        return oleAutomation.getIDsOfNames(new String[]{string})[0];
    }
}

