/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.editor.editors.UDTEditor;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SaveToLocalDiskHandler
extends AbstractHandler {
    private Shell shell;
    private File dFile = null;
    private final String FILE_FILTER = "*.*";
    private final String BK_SLASH = "\\";
    private final String CR = "\r";
    private final String NEW_LINE = "\n";
    private final String CR_NL = "\r\n";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchPage iWorkbenchPage;
        OS2200CorePlugin.logger.debug((Object)"Inside execute of save as to local");
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart != null) {
                if (this.performSaveAs(iEditorPart) && iWorkbenchPage.closeEditor(iEditorPart, false)) {
                    this.OpenAction(this.dFile);
                }
            } else {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"SaveLocal.Err"), (String)Messages.getString((String)"SaveLocal.NoEditor"));
            }
        }
        return null;
    }

    private boolean performSaveAs(IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Display display = Display.getDefault();
        IDocument iDocument = ((ITextEditor)iEditorPart).getDocumentProvider().getDocument((Object)iEditorInput);
        this.shell = display.getActiveShell();
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        String[] stringArray = new String[]{"*.*"};
        String string = "";
        if (iEditorInput instanceof OS2200FileEditorInput) {
            string = ((OS2200FileEditorInput)iEditorInput).getFileName().toUpperCase();
        } else if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
            string = iEditorInput.getName().toUpperCase();
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            string = ((FileStoreEditorInput)iEditorInput).getName().toUpperCase();
        } else if (iEditorInput instanceof NonExistingFileEditorInput) {
            string = ((NonExistingFileEditorInput)iEditorInput).getName().toUpperCase();
        }
        fileDialog.setFileName(string);
        fileDialog.setFilterExtensions(stringArray);
        String string2 = fileDialog.open();
        if (string2 != null) {
            String string3 = String.valueOf(fileDialog.getFilterPath()) + "\\" + fileDialog.getFileName();
            this.dFile = new File(string3);
            if (this.dFile.exists()) {
                if (!this.dFile.canWrite()) {
                    try {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"SaveLocal.Err"), (String)(this.dFile + " " + Messages.getString((String)"SaveLocal.Modified")));
                        throw new IOException("File: " + this.dFile + " " + Messages.getString((String)"SaveLocal.Modified"));
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException);
                        return false;
                    }
                }
                if (!MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"SaveLocal.FileExists"), (String)(String.valueOf(Messages.getString((String)"SaveLocal.Overwrite")) + " " + this.dFile))) {
                    return false;
                }
            }
            Writer writer = null;
            try {
                try {
                    OS2200CorePlugin.logger.debug((Object)"Writing editor content");
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.dFile), ResourcesPlugin.getEncoding()));
                    String string4 = iDocument.get();
                    if (iEditorPart instanceof UDTEditor || iEditorPart instanceof TextEditor) {
                        if (!string4.contains("\r\n")) {
                            writer.write(string4.replaceAll("\n", "\r\n"));
                        } else {
                            writer.write(string4);
                        }
                    } else {
                        writer.write(string4);
                    }
                    string4 = null;
                    writer.flush();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException);
                    if (writer != null) {
                        try {
                            writer.close();
                            writer = null;
                        }
                        catch (IOException iOException2) {
                            OS2200CorePlugin.logger.error((Object)iOException2);
                        }
                    }
                    return false;
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                        writer = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException);
                    }
                }
            }
            OS2200CorePlugin.logger.debug((Object)"Save as successful");
            return true;
        }
        return false;
    }

    OS2200FileEditorInput getFileEditorInput(File file) {
        IFileStore iFileStore = null;
        try {
            iFileStore = EFS.getStore((URI)file.toURI());
        }
        catch (Exception exception) {}
        OS2200FileEditorInput oS2200FileEditorInput = new OS2200FileEditorInput(iFileStore);
        return oS2200FileEditorInput;
    }

    boolean OpenAction(File file) {
        OS2200FileEditorInput oS2200FileEditorInput = this.getFileEditorInput(file);
        if (oS2200FileEditorInput != null) {
            IEditorPart iEditorPart = null;
            oS2200FileEditorInput.setDataFile(false);
            iEditorPart = OS2200FileInterface.OpenAction((File)file, (OS2200FileEditorInput)oS2200FileEditorInput);
            return iEditorPart != null;
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"SaveLocal.Err"), (String)(String.valueOf(Messages.getString((String)"SaveLocal.ErrOpening")) + " " + file.getName()));
        return false;
    }
}

