/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.internal.handlers.SaveAsHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SaveInWorkSpaceHandler
extends SaveAsHandler {
    private static final String SLASH = "/";
    private IWorkbenchPage page;

    public Object execute(ExecutionEvent executionEvent) {
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = this.page.getActiveEditor();
        IProgressMonitor iProgressMonitor = null;
        IStatusLineManager iStatusLineManager = iEditorPart.getEditorSite().getActionBars().getStatusLineManager();
        if (iStatusLineManager != null) {
            iProgressMonitor = iStatusLineManager.getProgressMonitor();
        }
        if (iEditorPart != null && iEditorPart.getEditorInput() instanceof NonExistingFileEditorInput) {
            this.performSaveAs(iProgressMonitor, iEditorPart);
            return null;
        }
        if (iEditorPart != null && iEditorPart instanceof AbstractTextEditor) {
            this.performSaveAs(iProgressMonitor, iEditorPart);
        } else {
            super.execute(executionEvent);
        }
        return null;
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor, IEditorPart iEditorPart) {
        String string;
        Object object;
        boolean bl;
        Serializable serializable;
        IFile iFile;
        String string2;
        block34: {
            String string3;
            IProject iProject;
            Object object2;
            IFileEditorInput iFileEditorInput;
            string2 = null;
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof OS2200FileEditorInput) {
                saveAsDialog.setOriginalName(((OS2200FileEditorInput)iEditorInput).getName().toUpperCase());
                string2 = ((OS2200FileEditorInput)iEditorInput).getEncoding();
            } else if (iEditorInput instanceof FileStoreEditorInput) {
                saveAsDialog.setOriginalName(((FileStoreEditorInput)iEditorInput).getName().toUpperCase());
            } else if (iEditorInput instanceof NonExistingFileEditorInput) {
                saveAsDialog.setOriginalName(((NonExistingFileEditorInput)iEditorInput).getName().toUpperCase());
            } else if (iEditorInput instanceof IFileEditorInput) {
                iFileEditorInput = (IFileEditorInput)iEditorInput;
                object2 = iFileEditorInput.getFile();
                try {
                    string2 = object2.getCharset(true);
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                }
                saveAsDialog.setOriginalName(((IFileEditorInput)iEditorInput).getName().toUpperCase());
            }
            saveAsDialog.open();
            iFileEditorInput = saveAsDialog.getResult();
            if (iFileEditorInput == null) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            object2 = null;
            if (iFileEditorInput.segmentCount() >= 3) {
                object2 = iFileEditorInput.uptoSegment(1).toString();
                iFileEditorInput = Path.fromOSString((String)(String.valueOf(object2) + SLASH + iFileEditorInput.lastSegment()));
            }
            IDocumentProvider iDocumentProvider = null;
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iFile = iWorkspace.getRoot().getFile((IPath)iFileEditorInput);
            try {
                iProject = iFile.getProject();
                long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)true);
                if (l != 0L) {
                    MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"SaveInWorkSpaceHandler_0"), (String)Messages.getString((String)"SaveInWorkSpaceHandler_1"));
                    return;
                }
            }
            catch (CoreException coreException) {
                OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
            }
            if (iEditorPart instanceof AbstractTextEditor) {
                iDocumentProvider = ((AbstractTextEditor)iEditorPart).getDocumentProvider();
            }
            iProject = new FileEditorInput(iFile);
            if (iDocumentProvider == null) {
                return;
            }
            if (iEditorInput != null && iEditorInput instanceof NonExistingFileEditorInput && (string3 = OS2200FileInterface.getCIFSDir((IProject)iFile.getProject())) != null) {
                serializable = new File(string3);
                if (!((File)serializable).exists()) {
                    OS2200FileInterface.validatedWorkFileMsg((IProject)iFile.getProject(), (String)"DIRNOTREACHABLE");
                    iProgressMonitor.setCanceled(true);
                    return;
                }
                if (!((File)serializable).isDirectory()) {
                    OS2200FileInterface.validatedWorkFileMsg((IProject)iFile.getProject(), (String)"ISNOTDIR");
                    return;
                }
                if (!((File)serializable).canWrite()) {
                    OS2200FileInterface.validatedWorkFileMsg((IProject)iFile.getProject(), (String)"READONLYDIR");
                    return;
                }
            }
            bl = false;
            try {
                try {
                    iDocumentProvider.aboutToChange((Object)iProject);
                    iDocumentProvider.saveDocument(iProgressMonitor, (Object)iProject, iDocumentProvider.getDocument((Object)iEditorInput), true);
                    bl = true;
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                    object = coreException.getStatus();
                    if (object == null || object.getSeverity() != 8) {
                        string = Messages.getString((String)"SaveInWorkSpaceHandler_2");
                        String string4 = NLSUtility.format((String)"Save could not be completed. {0}", (Object)coreException.getMessage());
                        MessageDialog.openError((Shell)shell, (String)string, (String)string4);
                    }
                    iDocumentProvider.changed((Object)iProject);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                iDocumentProvider.changed((Object)iProject);
                throw throwable;
            }
            iDocumentProvider.changed((Object)iProject);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
        serializable = new ArrayList();
        object = "<default>";
        if (iFile.getFileExtension() != null) {
            object = iFile.getFileExtension();
        }
        string = null;
        if (string2 == null) {
            string2 = ResourcesPlugin.getEncoding();
        }
        string2 = string2.equalsIgnoreCase("LETSJ") ? "LETSJ" : "<NONE>";
        string = new ElementSelectionObject(iFile.getName(), iFile.getName(), iFile.getName(), (String)object, string2);
        ((ArrayList)serializable).add(string);
        try {
            OS2200ProjectUpdate.addLinks((IProject)iFile.getProject(), (List)((Object)serializable), (IProgressMonitor)iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            OS2200CorePlugin.logger.info((Object)operationCanceledException.getLocalizedMessage(), (Throwable)operationCanceledException);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        if (this.page != null && bl) {
            this.page.closeEditor(iEditorPart, false);
        }
    }
}

