/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.serviceprovider.ConnectionStatusUtility;
import com.unisys.tde.ui.views.HostManagerView;
import com.unisys.tde.ui.views.HostManagerViewModel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.handlers.HandlerUtil;

public class DisconnectHostHandler
extends AbstractHandler {
    private HostManagerView hostMgrView = null;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        OS2200CorePlugin.logger.debug((Object)"Inside com.unisys.tde.ui.handler.DisconnectHostHandler.execute(ExecutionEvent) method");
        this.hostMgrView = (HostManagerView)HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        if (this.hostMgrView == null) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        TableItem[] tableItemArray = this.hostMgrView.getTableViewer().getTable().getSelection();
        HostManagerViewModel hostManagerViewModel = (HostManagerViewModel)iStructuredSelection.getFirstElement();
        if (hostManagerViewModel == null) {
            OS2200CorePlugin.logger.error((Object)"The selected element returned NULL value while disconnecting a host");
            return null;
        }
        this.disconnect(hostManagerViewModel);
        this.hostMgrView.getTableViewer().getTable().setSelection(tableItemArray);
        this.hostMgrView.getTableViewer().refresh();
        return null;
    }

    private void disconnect(HostManagerViewModel hostManagerViewModel) {
        OS2200CorePlugin.logger.debug((Object)"Inside com.unisys.tde.ui.handler.DisconnectHostHandler.disconnect(HostManagerViewModel) method");
        if (hostManagerViewModel.getConnectionStatus().equalsIgnoreCase(Messages.getString((String)"HManager.1"))) {
            this.hostMgrView.createWaitingCursor();
            this.hostMgrView.saveBeforeOperation(hostManagerViewModel.getHostAccount().getCifsHostId());
            long l = hostManagerViewModel.doDisconnect();
            if (l != 0L) {
                this.hostMgrView.disposeWaitingCursor();
                return;
            }
        } else {
            return;
        }
        ConnectionStatusUtility.changeStatus(this.hostMgrView, hostManagerViewModel);
        this.hostMgrView.disposeWaitingCursor();
    }
}

