/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.actions.DeleteOS2200Connection;
import com.unisys.tde.ui.views.HostManagerView;
import com.unisys.tde.ui.views.HostManagerViewModel;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHostHandler
extends AbstractHandler {
    private HostManagerView hostMgrView = null;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        OS2200CorePlugin.logger.debug((Object)"Inside DeleteHostHandler method");
        this.hostMgrView = (HostManagerView)HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        if (this.hostMgrView == null) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        HostManagerViewModel hostManagerViewModel = (HostManagerViewModel)iStructuredSelection.getFirstElement();
        if (hostManagerViewModel == null) {
            OS2200CorePlugin.logger.error((Object)"The selected element returned NULL value while deleting a host");
            return null;
        }
        this.deleteHost(hostManagerViewModel);
        this.hostMgrView.getTableViewer().refresh();
        return null;
    }

    public void deleteHost(HostManagerViewModel hostManagerViewModel) {
        this.hostMgrView.saveBeforeOperation(hostManagerViewModel.getHostAccount().getCifsHostId());
        this.hostMgrView.createWaitingCursor();
        DeleteOS2200Connection deleteOS2200Connection = new DeleteOS2200Connection();
        if (!deleteOS2200Connection.deleteConnection(hostManagerViewModel.getHostAccount())) {
            this.hostMgrView.disposeWaitingCursor();
            return;
        }
        this.hostMgrView.deleteFromHostManagerView(hostManagerViewModel.getConnName());
        this.hostMgrView.disposeWaitingCursor();
    }

    private void deleteFromXML(HostAccount hostAccount) {
        HostAccount.Remove((String)hostAccount.getCifsHostId(), (String)hostAccount.getCifsUserId(), (String)hostAccount.getConnectionName());
    }
}

