/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import com.unisys.tde.ui.views.OFCSView;
import com.unisys.tde.ui.views.OS2200View;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class CopyOS2200PathHandler
extends AbstractHandler {
    private static CopyOS2200PathHandler handler = null;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.copyOS2200Path();
        return null;
    }

    public static void copyPath() {
        try {
            if (handler == null) {
                handler = new CopyOS2200PathHandler();
            }
            handler.copyOS2200Path();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void copyOS2200Path() {
        OS2200CorePlugin.logger.info((Object)"");
        try {
            IEditorPart iEditorPart = null;
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            IWorkbenchPart iWorkbenchPart = null;
            if (iWorkbenchWindow != null) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                iEditorPart = iWorkbenchPage.getActiveEditor();
                iWorkbenchPart = iWorkbenchPage.getActivePart();
                String string = null;
                if (iWorkbenchPart instanceof OS2200View) {
                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                        OS2200CorePlugin.logger.info((Object)"Copy OS2200 path initiated from OS 2200 Explorer.");
                    }
                    string = this.handleOS2200Explorer((OS2200View)iWorkbenchPart);
                } else if (iWorkbenchPart instanceof OFCSView) {
                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                        OS2200CorePlugin.logger.info((Object)"Copy OS2200 path initiated from OS 2200 File Explorer.");
                    }
                    string = this.handleOS2200FileExplorer();
                } else if (iEditorPart != null) {
                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                        OS2200CorePlugin.logger.info((Object)"Copy OS2200 path initiated from Editor tab.");
                    }
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    string = this.handleEditorTabs(iEditorInput);
                }
                if (string != null) {
                    if (string.toUpperCase().contains("STD#")) {
                        string = string.replace("STD#", "").trim();
                    } else if (string.toUpperCase().contains("SHARED#")) {
                        string = string.replace("SHARED#", "").trim();
                    }
                    this.copyStringToSystemClipBoard(string.toUpperCase());
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private String handleEditorTabs(IEditorInput iEditorInput) {
        String string = null;
        try {
            if (iEditorInput instanceof IFileEditorInput) {
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFile iFile = iFileEditorInput.getFile();
                string = OS2200ArchitectureUtils.getOS2200PathFromIFile(iFile);
            } else if (iEditorInput instanceof OS2200FileEditorInput) {
                OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
                string = OS2200FileInterface.getPath((String)oS2200FileEditorInput.getFile().getAbsolutePath(), (int)oS2200FileEditorInput.getFileShare().value());
            } else if (iEditorInput instanceof FileStoreEditorInput) {
                FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
                string = fileStoreEditorInput.getURI().getPath().trim();
                string = string.substring(1, string.length());
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return string;
    }

    private String handleOS2200Explorer(OS2200View oS2200View) {
        String string = null;
        try {
            TreeSelection treeSelection;
            Object object;
            TreeViewer treeViewer = oS2200View.getViewer();
            ISelection iSelection = treeViewer.getSelection();
            if (iSelection instanceof TreeSelection && (object = (treeSelection = (TreeSelection)iSelection).getFirstElement()) instanceof IFile) {
                IFile iFile = (IFile)object;
                string = OS2200ArchitectureUtils.getOS2200PathFromIFile(iFile);
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleOS2200FileExplorer() {
        String string = null;
        try {
            OFCSView oFCSView = CopyOS2200PathHandler.getOFEViewObject();
            String string2 = null;
            if (oFCSView != null) {
                string2 = oFCSView.getSelectedFilePath(true);
            }
            if (string2 == null) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"CopyOS2200PathHandler_2"), (String)Messages.getString((String)"CopyOS2200PathHandler_3"));
                return null;
            }
            String[] stringArray = string2.split(",");
            File file = new File(stringArray[0]);
            if (!file.isDirectory()) return OS2200FileInterface.getPath((String)stringArray[0], (int)oFCSView.getShareState());
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"CopyOS2200PathHandler_0"), (String)(String.valueOf(file.getName().toUpperCase()) + Messages.getString((String)"CopyOS2200PathHandler_1")));
            return null;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return string;
    }

    private void copyStringToSystemClipBoard(String string) {
        try {
            if (string != null) {
                if (OS2200CorePlugin.logger.isDebugEnabled()) {
                    OS2200CorePlugin.logger.debug((Object)("Path of the OS2200 string to be Copied to Clipboard, " + string));
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string.toUpperCase());
                clipboard.setContents(stringSelection, null);
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private static OFCSView getOFEViewObject() {
        IViewReference iViewReference;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null && (iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OFCSView")) != null) {
            OFCSView oFCSView = null;
            oFCSView = (OFCSView)iViewReference.getView(true);
            return oFCSView;
        }
        return null;
    }
}

