/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.RuntimeExec;
import com.unisys.tde.ui.serviceprovider.ConnectionStatusUtility;
import com.unisys.tde.ui.views.HostManagerView;
import com.unisys.tde.ui.views.HostManagerViewModel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConnectHostHandler
extends AbstractHandler {
    private HostManagerView hostMgrView = null;
    private IStructuredSelection selection = null;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        OS2200CorePlugin.logger.debug((Object)"Inside com.unisys.tde.ui.handler.ConnectHostHandler.execute(ExecutionEvent) method");
        this.hostMgrView = (HostManagerView)HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        if (this.hostMgrView == null) {
            return null;
        }
        this.selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        TableItem[] tableItemArray = this.hostMgrView.getTableViewer().getTable().getSelection();
        HostManagerViewModel hostManagerViewModel = (HostManagerViewModel)this.selection.getFirstElement();
        if (hostManagerViewModel == null) {
            OS2200CorePlugin.logger.error((Object)"The selected element returned NULL value while connecting to a host");
            return null;
        }
        this.connect(hostManagerViewModel);
        this.hostMgrView.getTableViewer().getTable().setSelection(tableItemArray);
        this.hostMgrView.getTableViewer().refresh();
        return null;
    }

    private void connect(HostManagerViewModel hostManagerViewModel) {
        OS2200CorePlugin.logger.debug((Object)"Inside com.unisys.tde.ui.handler.ConnectHostHandler.connect(HostManagerViewModel) method");
        if (!hostManagerViewModel.getConnectionStatus().equalsIgnoreCase("Connected")) {
            this.hostMgrView.createWaitingCursor();
            long l = hostManagerViewModel.doConnect();
            if (l != 0L && l != -1111L) {
                String string = RuntimeExec.getRuntimeExecInst().getconnectCifsMsg(l);
                if (OS2200FileInterface.error1219 != 1) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)(String.valueOf(Messages.getString((String)"Connection.2")) + " - " + l), (String)Messages.getString((String)"Connection.3", (String)(String.valueOf(hostManagerViewModel.getHostName()) + "\n\n" + string)));
                } else {
                    OS2200FileInterface.error1219 = -3;
                }
                this.hostMgrView.disposeWaitingCursor();
                return;
            }
            ConnectionStatusUtility.changeStatus(this.hostMgrView, hostManagerViewModel);
            this.hostMgrView.disposeWaitingCursor();
        }
    }
}

