/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.handler;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.OS2200CorePlugin;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ConfigureEditorScalabilityDialog
extends SelectionStatusDialog {
    private Text memFactorText;
    private Text fileSizeFactorText;

    protected ConfigureEditorScalabilityDialog(Shell shell) {
        super(shell);
        MemChecker.getInstance();
    }

    protected Control createDialogArea(Composite composite) {
        OS2200CorePlugin.logger.debug((Object)"");
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.context_set_editor_scalability");
        composite.getShell().setText(Messages.getString((String)"ConfigureEditorScalabilityDialog.title"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"ConfigureEditorScalabilityDialog.freeMemFactor"));
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        this.memFactorText = new Text(composite, 2048);
        this.memFactorText.setTextLimit(2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.memFactorText.setLayoutData((Object)gridData);
        this.memFactorText.setText(iPreferenceStore.getString("FREE_MEM_FACTOR"));
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString((String)"ConfigureEditorScalabilityDialog.fileSizeFactor"));
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        label2.setLayoutData((Object)gridData);
        this.fileSizeFactorText = new Text(composite, 2048);
        this.fileSizeFactorText.setTextLimit(2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fileSizeFactorText.setLayoutData((Object)gridData);
        this.fileSizeFactorText.setText(iPreferenceStore.getString("FILE_SIZE_FACTOR"));
        return composite;
    }

    protected void okPressed() {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        if (!this.validateData()) {
            return;
        }
        if (!this.memFactorText.getText().isEmpty()) {
            iPreferenceStore.putValue("FREE_MEM_FACTOR", this.memFactorText.getText().trim());
        }
        if (!this.fileSizeFactorText.getText().isEmpty()) {
            iPreferenceStore.putValue("FILE_SIZE_FACTOR", this.fileSizeFactorText.getText().trim());
        }
        super.okPressed();
    }

    private boolean validateData() {
        boolean bl = true;
        boolean bl2 = true;
        String string = this.memFactorText.getText();
        try {
            int n = Integer.parseInt(string);
            if (n < 10 || n > 30) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        String string2 = this.fileSizeFactorText.getText();
        try {
            int n = Integer.parseInt(string2);
            if (n < 6 || n > 20) {
                bl2 = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        if (!bl && !bl2) {
            String string3 = Messages.getString((String)"ConfigureEditorScalabilityDialog.invalidNumberInputInAll");
            string3 = MessageFormat.format(string3, Messages.getString((String)"ConfigureEditorScalabilityDialog.freeMemFactor"), 10, 30, Messages.getString((String)"ConfigureEditorScalabilityDialog.fileSizeFactor"), 6, 20);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OpenFileAction.6"), (String)string3);
        } else if (!bl) {
            String string4 = Messages.getString((String)"ConfigureEditorScalabilityDialog.invalidNumberInput");
            string4 = MessageFormat.format(string4, Messages.getString((String)"ConfigureEditorScalabilityDialog.freeMemFactor"), 10, 30);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OpenFileAction.6"), (String)string4);
        } else if (!bl2) {
            String string5 = Messages.getString((String)"ConfigureEditorScalabilityDialog.invalidNumberInput");
            string5 = MessageFormat.format(string5, Messages.getString((String)"ConfigureEditorScalabilityDialog.fileSizeFactor"), 6, 20);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OpenFileAction.6"), (String)string5);
        }
        return bl2 & bl;
    }

    protected void computeResult() {
    }
}

