/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.ui.utils.OS2200CompareUtils;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SaveConflictDialog
extends TrayDialog {
    private Label lbl = null;
    private Label lb2 = null;
    private IFile file = null;
    private String operationType;

    public SaveConflictDialog(Shell shell, IFile iFile, String string) {
        super(shell);
        this.file = iFile;
        this.operationType = string;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.getShell().setText(Messages.getString((String)"SaveConflictDialog.title"));
        this.setHelpAvailable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "");
        try {
            GridLayout gridLayout = new GridLayout(1, false);
            composite2.setLayout((Layout)gridLayout);
            this.createComponents(composite2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return composite2;
    }

    private void createComponents(Composite composite) {
        this.lbl = new Label(composite, 0);
        this.lbl.setText(Messages.getString((String)"SaveConflictDialog.1", (String)this.file.getFullPath().toOSString()));
        if (this.operationType == "Sync with Local") {
            this.lb2 = new Label(composite, 0);
            this.lb2.setText(Messages.getString((String)"SaveConflictDialog.2"));
        } else if (this.operationType == "Sync with Host") {
            this.lb2 = new Label(composite, 0);
            this.lb2.setText(Messages.getString((String)"SaveConflictDialog.3"));
        }
    }

    public int open() {
        return super.open();
    }

    protected void buttonPressed(int n) {
        if (n == 10) {
            File file = new File(this.file.getRawLocation().toOSString());
            OS2200CompareUtils.compareCacheFileWithHost(file);
            super.cancelPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 10, Messages.getString((String)"SaveConflictDialog_0"), true);
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        if (this.operationType == "Sync with Local") {
            this.getButton(0).setText(Messages.getString((String)"save"));
        } else if (this.operationType == "Sync with Host") {
            this.getButton(0).setText(Messages.getString((String)"download"));
        }
        this.getButton(1).setText(Messages.getString((String)"cancel"));
        return control;
    }
}

