/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.dialogs.OS2200CompareEditorInput;
import com.unisys.tde.ui.utils.OS2200CompareUtils;
import java.io.File;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OS2200Compare {
    private String strFile1;
    private String strFile2;
    private IWorkbenchPart targetPart;
    private Shell shell;
    private IWorkbenchWindow window;
    private Map<String, String> filesMap;

    public OS2200Compare(String string, String string2, Map<String, String> map) {
        this.strFile1 = string;
        this.strFile2 = string2;
        this.filesMap = map;
    }

    public void compare() {
        OS2200CorePlugin.logger.debug((Object)"");
        String string = new String(this.strFile1);
        String string2 = new String(this.strFile2);
        if (this.filesMap != null && this.filesMap.containsKey(this.strFile1)) {
            this.strFile1 = this.filesMap.get(this.strFile1);
        }
        if (this.filesMap != null && this.filesMap.containsKey(this.strFile2)) {
            this.strFile2 = this.filesMap.get(this.strFile2);
        }
        if (this.strFile1.startsWith("//")) {
            this.strFile1 = this.strFile1.replaceAll("/", "\\");
        }
        if (this.strFile2.startsWith("//")) {
            this.strFile2 = this.strFile2.replaceAll("/", "\\");
        }
        if (OS2200CompareUtils.checkDirectory(this.strFile1)) {
            return;
        }
        if (OS2200CompareUtils.checkDirectory(this.strFile2)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!OS2200CompareUtils.checkFileAccess(this.strFile1, stringBuffer)) {
            OS2200CorePlugin.logger.info((Object)(String.valueOf(this.strFile1) + Messages.getString((String)"OS2200Compare.2")));
            return;
        }
        String string3 = "";
        if (stringBuffer.toString().trim().length() > 0) {
            string3 = stringBuffer.toString();
        }
        stringBuffer.delete(0, stringBuffer.length());
        if (!OS2200CompareUtils.checkFileAccess(this.strFile2, stringBuffer)) {
            OS2200CorePlugin.logger.info((Object)(String.valueOf(this.strFile2) + Messages.getString((String)"OS2200Compare.2")));
            return;
        }
        String string4 = "";
        if (stringBuffer.toString().trim().length() > 0) {
            string4 = stringBuffer.toString();
        }
        stringBuffer = null;
        if (!this.checkFileIntegrity(this.strFile1)) {
            OS2200CorePlugin.logger.info((Object)(String.valueOf(this.strFile1) + Messages.getString((String)"OS2200Compare.3")));
            return;
        }
        if (!this.checkFileIntegrity(this.strFile2)) {
            OS2200CorePlugin.logger.info((Object)(String.valueOf(this.strFile2) + Messages.getString((String)"OS2200Compare.3")));
            return;
        }
        if (string3.length() > 0) {
            this.strFile1 = string3;
        }
        if (string4.length() > 0) {
            this.strFile2 = string4;
        }
        ITypedElement iTypedElement = this.getElementFor(new File(this.strFile1));
        ITypedElement iTypedElement2 = this.getElementFor(new File(this.strFile2));
        this.openInCompare(null, iTypedElement, iTypedElement2, string, string2);
    }

    private ITypedElement getElementFor(File file) {
        OS2200CorePlugin.logger.debug((Object)"");
        String string = file.getAbsolutePath();
        String string2 = null;
        Path path = new Path(string);
        if (path.segmentCount() == 1) {
            string2 = String.valueOf(System.getProperty("java.io.tmpdir")) + path.segment(0);
            TDECoreUtilities.getInstance().copyToLocal(new File(string), new File(string2));
            file = new File(string2);
        }
        LocalNonWorkspaceTypedElement localNonWorkspaceTypedElement = new LocalNonWorkspaceTypedElement((IPath)new Path(file.getAbsolutePath()));
        return localNonWorkspaceTypedElement;
    }

    private void openInCompare(ITypedElement iTypedElement, ITypedElement iTypedElement2, ITypedElement iTypedElement3, String string, String string2) {
        OS2200CorePlugin.logger.debug((Object)"");
        final IWorkbenchPage iWorkbenchPage = this.getTargetPage();
        final OS2200CompareEditorInput oS2200CompareEditorInput = new OS2200CompareEditorInput(iTypedElement, iTypedElement2, iTypedElement3, iWorkbenchPage, string, string2);
        final IEditorPart iEditorPart = Utils.findReusableCompareEditor((CompareEditorInput)oS2200CompareEditorInput, (IWorkbenchPage)iWorkbenchPage, (Class[])new Class[]{CompareFileRevisionEditorInput.class});
        OS2200CorePlugin.logger.info((Object)(" Comparing " + this.strFile1 + " and " + this.strFile2));
        Job job = new Job(String.valueOf(Messages.getString((String)"OS2200Compare_0")) + this.strFile1 + Messages.getString((String)"OS2200Compare_1") + this.strFile2){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (iEditorPart != null) {
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput.equals((Object)oS2200CompareEditorInput)) {
                        iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
                    } else {
                        CompareUI.reuseCompareEditor((CompareEditorInput)oS2200CompareEditorInput, (IReusableEditor)((IReusableEditor)iEditorPart));
                        iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
                    }
                } else {
                    CompareUI.openCompareEditor((CompareEditorInput)oS2200CompareEditorInput);
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
            }
        };
        job.schedule();
    }

    protected IWorkbenchPage getTargetPage() {
        OS2200CorePlugin.logger.debug((Object)"");
        if (this.getTargetPart() == null) {
            return TeamUIPlugin.getActivePage();
        }
        return this.getTargetPart().getSite().getPage();
    }

    protected IWorkbenchPart getTargetPart() {
        OS2200CorePlugin.logger.debug((Object)"");
        if (this.targetPart == null) {
            IWorkbenchPage iWorkbenchPage = TeamUIPlugin.getActivePage();
            if (iWorkbenchPage != null) {
                this.targetPart = iWorkbenchPage.getActivePart();
            } else {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                this.targetPart = iWorkbench.getWorkbenchWindows()[0].getActivePage().getActivePart();
            }
        }
        return this.targetPart;
    }

    protected Shell getShell() {
        OS2200CorePlugin.logger.debug((Object)"");
        if (this.shell != null) {
            return this.shell;
        }
        if (this.targetPart != null) {
            return this.targetPart.getSite().getShell();
        }
        if (this.window != null) {
            return this.window.getShell();
        }
        IWorkbench iWorkbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getShell();
    }

    private boolean checkFileIntegrity(String string) {
        block3: {
            block4: {
                OS2200CorePlugin.logger.debug((Object)"");
                try {
                    if (!TDECoreUtilities.isUnInitializedFile((String)string)) break block3;
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(string) + " is not yet downloaded and downloading it now"));
                    final String string2 = TDECoreUtilities.getCIFSPathFromFilePath((String)string);
                    final String string3 = TDECoreUtilities.getInstance().copyToLocal(new File(string2), new File(string));
                    if (string3.trim().length() <= 0) break block4;
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200Compare.1"), (String)(String.valueOf(string2) + "\n" + string3));
                        }
                    });
                    return false;
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    return false;
                }
            }
            OS2200CorePlugin.logger.info((Object)"Download successful.");
        }
        return true;
    }
}

