/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OFCSCreateDialog
extends TrayDialog {
    private String eltName;
    private Text eltNameTxt;
    private Label errorLb;
    private static final String PERIOD = ".";
    private static final String SLASH = "/";
    private List<String> fileList = null;
    private String actionLabel = "";
    private boolean isFolderValidation = false;
    ModifyListener txtChange = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            OFCSCreateDialog.this.getButton(0).setEnabled(OFCSCreateDialog.this.isOKEnable());
        }
    };

    public OFCSCreateDialog(Shell shell, String[] stringArray, String string, boolean bl) {
        super(shell);
        this.fileList = Arrays.asList(stringArray);
        this.actionLabel = string;
        this.isFolderValidation = bl;
    }

    protected Control createDialogArea(Composite composite) {
        composite.getShell().setText(String.valueOf(Messages.getString((String)"OS2200FileExplorer.create")) + " " + this.actionLabel);
        OS2200CorePlugin.logger.debug((Object)("Inside the Create " + this.actionLabel + " dialog."));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.Creating_and_Deleting");
        this.setHelpAvailable(true);
        this.actionLabel = this.actionLabel.toLowerCase();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 20;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString((String)"OFCSCreateDialog.label", (String)this.actionLabel));
        label.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 250;
        this.eltNameTxt = new Text(composite2, 2048);
        this.eltNameTxt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                verifyEvent.text = verifyEvent.text.toUpperCase();
            }
        });
        this.eltNameTxt.addModifyListener(this.txtChange);
        this.eltNameTxt.setLayoutData((Object)gridData2);
        GridData gridData3 = new GridData(768);
        gridData3.heightHint = 20;
        gridData3.horizontalSpan = 2;
        this.errorLb = new Label(composite2, 0);
        this.errorLb.setForeground(new Color(null, 255, 0, 0));
        this.errorLb.setText("");
        this.errorLb.setLayoutData((Object)gridData3);
        int n = 0;
        while (n < this.fileList.size()) {
            this.fileList.set(n, this.fileList.get(n).toUpperCase());
            ++n;
        }
        return composite;
    }

    private boolean isOKEnable() {
        this.eltName = this.eltNameTxt.getText().toUpperCase().toString();
        String string = "";
        String string2 = "";
        if (this.isFolderValidation) {
            string = this.eltName;
            string2 = this.eltName;
        } else {
            string = this.eltName.replace(PERIOD, SLASH);
            string2 = this.eltName.replaceFirst(SLASH, PERIOD);
        }
        if (this.isFolderValidation && (string.contains(SLASH) || string.contains(PERIOD))) {
            this.errorLb.setText(Messages.getString((String)"OFCSCreateDialog.errMsg1", (String)this.actionLabel));
            return false;
        }
        if (OS2200FileInterface.verifyEltName((String)string)) {
            if (this.fileList.contains(string2)) {
                this.errorLb.setText(Messages.getString((String)"OFCSCreateDialog.errMsg2", (String)this.eltName));
                return false;
            }
            this.getButton(0).setEnabled(true);
            this.errorLb.setText("");
            return true;
        }
        this.errorLb.setText(Messages.getString((String)"OFCSCreateDialog.errMsg1", (String)this.actionLabel));
        return false;
    }

    protected void okPressed() {
        this.eltName = this.eltNameTxt.getText().toString();
        super.okPressed();
    }

    public String getEltName() {
        return this.eltName;
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.getButton(0).setText(Messages.getString((String)"OS2200FileNameConflictDialog.6"));
        this.getButton(0).setEnabled(false);
        this.getButton(1).setText(Messages.getString((String)"OS2200FileNameConflictDialog.7"));
        return control;
    }
}

