/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.utils.OS2200CompareUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CompareWindowDialog
extends TrayDialog {
    private Composite composite;
    private String strFirstFilePath;
    private String[] editorPaths;
    private Combo combo = null;
    private Text firstText = null;
    private Text secondText = null;
    private List elementList = null;
    private final String[] FILTEREXT = new String[]{"*.*", "*.JCL", "*.COB", "*.ELT", "*.C", "*.H", "*.FOR", "*.MSM", "*.PLS", "*.JAVA", "*.TXT"};
    private Map<String, String> filesMap = null;
    private Button swapBtn = null;
    private Button file1browse = null;
    private Composite left = null;
    private Button file2browse = null;
    private Composite bottom = null;
    private String firstFilePath = null;
    private String secondFilePath = null;
    private String diffTool = null;
    private Map<String, String> comboDataMap = null;

    public CompareWindowDialog(Shell shell, String string, String[] stringArray, Map<String, String> map) {
        super(shell);
        this.strFirstFilePath = string;
        this.editorPaths = stringArray;
        this.filesMap = map;
        this.setShellStyle(67680);
        this.setBlockOnOpen(true);
        this.comboDataMap = new HashMap<String, String>();
    }

    protected Control createDialogArea(Composite composite) {
        this.composite = composite;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 15;
        this.composite.setLayout((Layout)gridLayout);
        this.createContent();
        this.setHelpAvailable(true);
        String string = TDECoreUtilities.getPluginDirectoryPath((String)"com.unisys.tde.ui").append("icons\\compare-16.png").toOSString();
        composite.getShell().setImage(new Image((Device)composite.getDisplay(), string));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.context_os2200_compare");
        return this.composite;
    }

    private void createContent() {
        this.createTopContent();
        this.createMiddleContent();
        this.createBottomContent();
        this.initListeners();
        this.setFocus();
        if (this.elementList.getItemCount() > 0) {
            this.elementList.setSelection(0);
            this.elementList.notifyListeners(13, new Event());
        }
        this.setComboData();
        int n = this.getIndexForDefault();
        if (n == -1) {
            n = this.combo.indexOf("ECLIPSE DEFAULT COMPARE TOOL");
        }
        this.combo.select(n);
        this.combo.setToolTipText((String)this.combo.getData(this.combo.getText()));
    }

    private void initListeners() {
        this.firstText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                CompareWindowDialog.this.firstText.setToolTipText(CompareWindowDialog.this.firstText.getText().trim());
            }
        });
        this.secondText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                CompareWindowDialog.this.secondText.setToolTipText(CompareWindowDialog.this.secondText.getText().trim());
            }
        });
        this.firstText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                boolean bl = CompareWindowDialog.this.firstText.getText().trim().length() > 0 && CompareWindowDialog.this.secondText.getText().trim().length() > 0;
                CompareWindowDialog.this.setOKBtnStatus(bl);
            }

            public void focusGained(FocusEvent focusEvent) {
                boolean bl = CompareWindowDialog.this.firstText.getText().trim().length() > 0 && CompareWindowDialog.this.secondText.getText().trim().length() > 0;
                CompareWindowDialog.this.setOKBtnStatus(bl);
            }
        });
        this.secondText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                CompareWindowDialog.this.setOKBtnStatus(CompareWindowDialog.this.secondText.getText().trim().length() > 0);
            }

            public void focusGained(FocusEvent focusEvent) {
                CompareWindowDialog.this.setOKBtnStatus(CompareWindowDialog.this.secondText.getText().trim().length() > 0);
            }
        });
        this.file1browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String string;
                String string2 = CompareWindowDialog.this.firstText.getText().trim();
                string2 = (String)CompareWindowDialog.this.filesMap.get(string2);
                if (string2 == null) {
                    string2 = CompareWindowDialog.this.firstText.getText().trim();
                }
                if ((string = CompareWindowDialog.this.browseFile(CompareWindowDialog.this.left, Messages.getString((String)"CompareWindowDialog_0"), string2)) != null) {
                    CompareWindowDialog.this.firstText.setText(string.toUpperCase());
                }
                if (CompareWindowDialog.this.firstText.getText().trim().length() > 0 && CompareWindowDialog.this.secondText.getText().trim().length() > 0) {
                    CompareWindowDialog.this.setOKBtnStatus(true);
                } else {
                    CompareWindowDialog.this.setOKBtnStatus(false);
                }
            }
        });
        this.file2browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String string;
                String string2 = CompareWindowDialog.this.secondText.getText().trim();
                string2 = (String)CompareWindowDialog.this.filesMap.get(string2);
                if (string2 == null) {
                    string2 = CompareWindowDialog.this.secondText.getText().trim();
                }
                if ((string = CompareWindowDialog.this.browseFile(CompareWindowDialog.this.left, Messages.getString((String)"CompareWindowDialog_1"), string2)) != null) {
                    CompareWindowDialog.this.secondText.setText(string.toUpperCase());
                }
                if (CompareWindowDialog.this.firstText.getText().trim().length() > 0 && CompareWindowDialog.this.secondText.getText().trim().length() > 0) {
                    CompareWindowDialog.this.setOKBtnStatus(true);
                } else {
                    CompareWindowDialog.this.setOKBtnStatus(false);
                }
            }
        });
        this.swapBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompareWindowDialog.this.handleSwap();
            }
        });
        this.elementList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = selectionEvent.getSource();
                if (object instanceof List) {
                    List list = (List)object;
                    String string = list.getSelection()[0].toUpperCase().trim();
                    if (string.equalsIgnoreCase(CompareWindowDialog.this.firstText.getText().trim())) {
                        if (list.getItemCount() > 1) {
                            CompareWindowDialog.this.secondText.setText(list.getItem(1).toUpperCase());
                        } else {
                            CompareWindowDialog.this.secondText.setText("");
                        }
                    } else {
                        CompareWindowDialog.this.secondText.setText(string);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = CompareWindowDialog.this.combo.getSelectionIndex();
                if (n == -1) {
                    n = 0;
                }
                String string = CompareWindowDialog.this.combo.getItem(n);
                CompareWindowDialog.this.combo.setToolTipText((String)CompareWindowDialog.this.combo.getData(string));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private void setFocus() {
        String string = this.firstText.getText().trim();
        String string2 = this.secondText.getText().trim();
        if (string.length() == 0) {
            this.firstText.setFocus();
        } else if (string2.length() == 0) {
            this.secondText.setFocus();
        }
    }

    protected Control createButtonBar(Composite composite) {
        return super.createButtonBar(composite);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"CompareAction.6"));
        shell.setSize(700, 500);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        Button button = this.getButton(0);
        button.setText(Messages.getString((String)"CompareAction.7"));
        this.setButtonLayoutData(button);
        Button button2 = this.getButton(1);
        button2.setText(Messages.getString((String)"CompareAction.8"));
        this.setButtonLayoutData(button2);
    }

    private void setOKBtnStatus(boolean bl) {
        this.getButton(0).setEnabled(bl);
        this.swapBtn.setEnabled(bl);
    }

    private void createTopContent() {
        Composite composite = new Composite(this.composite, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.left = new Composite(composite, 0);
        this.left.setLayout((Layout)new GridLayout(3, false));
        this.left.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(this.left, 0);
        label.setText(Messages.getString((String)"CompareAction.1"));
        this.firstText = new Text(this.left, 0);
        if (this.strFirstFilePath != null && this.strFirstFilePath.trim().length() > 0) {
            this.firstText.setText(this.strFirstFilePath.toUpperCase());
        } else {
            this.firstText.setText("");
        }
        this.firstText.setEditable(false);
        this.firstText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.file1browse = new Button(this.left, 16448);
        this.file1browse.setText(" ... ");
        Label label2 = new Label(this.left, 0);
        label2.setText(Messages.getString((String)"CompareAction.2"));
        this.secondText = new Text(this.left, 0);
        this.secondText.setText("");
        this.secondText.setEditable(false);
        this.secondText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.file2browse = new Button(this.left, 16448);
        this.file2browse.setText(" ... ");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.swapBtn = new Button(composite2, 16448);
        this.swapBtn.setText(" Swap ");
    }

    private String browseFile(Composite composite, String string, String string2) {
        String[] stringArray;
        String string3 = this.popUpFileDialog(composite, String.valueOf(string) + ". . .", string2);
        if (string3 == null) {
            return null;
        }
        File file = new File(string3);
        if (!file.exists()) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Invalid File", (String)(String.valueOf(string3) + " does not exists."));
            return null;
        }
        String[] stringArray2 = this.elementList.getItems();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
        if (!string.contains("Base(First) File") && !arrayList.contains(stringArray = file.getAbsolutePath().toUpperCase())) {
            arrayList.add((String)stringArray);
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.elementList.setItems(stringArray);
        return file.getAbsolutePath();
    }

    private void handleSwap() {
        try {
            String[] stringArray = this.elementList.getItems();
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            String string = this.firstText.getText();
            String string2 = this.secondText.getText();
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                arrayList.remove(string2);
            }
            if (string != null && string2 != null) {
                this.firstText.setText(string2);
                this.secondText.setText(string);
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            this.elementList.setItems(stringArray2);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
    }

    private void createMiddleContent() {
        Composite composite = new Composite(this.composite, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.elementList = new List(composite, 2816);
        this.elementList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.elementList.setSize(30, 30);
        if (this.editorPaths != null && this.editorPaths.length > 0) {
            this.elementList.setItems(this.editorPaths);
        }
    }

    private void createBottomContent() {
        this.bottom = new Composite(this.composite, 0);
        this.bottom.setLayout((Layout)new GridLayout(3, false));
        this.bottom.setLayoutData((Object)new GridData(4, 131072, true, false));
        Label label = new Label(this.bottom, 0);
        label.setText("\t\t");
        Label label2 = new Label(this.bottom, 0);
        label2.setText(Messages.getString((String)"CompareAction.3"));
        this.combo = new Combo(this.bottom, 8);
        this.combo.setLayoutData((Object)new GridData(4, 131072, true, true));
    }

    public void setStrFirstFilePath(String string) {
        this.strFirstFilePath = string;
    }

    public void setStrEditorPaths(String[] stringArray) {
        this.editorPaths = stringArray;
    }

    public void setfilesMap(Map<String, String> map) {
        this.filesMap = map;
    }

    public Map<String, String> getFilesMap() {
        return this.filesMap;
    }

    public void okPressed() {
        String string = this.combo.getText();
        if (string == null) {
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)"Choose Diff Tool", (String)"Please choose the Compare application to be used.");
            return;
        }
        this.firstFilePath = this.firstText.getText().trim();
        this.secondFilePath = this.secondText.getText().trim();
        this.diffTool = (String)this.combo.getData(string);
        super.close();
    }

    public boolean close() {
        return super.close();
    }

    protected void cancelPressed() {
        this.firstFilePath = null;
        this.secondFilePath = null;
        this.diffTool = null;
        super.cancelPressed();
    }

    public String getFirstFilePath() {
        return this.firstFilePath;
    }

    public String getSecondFilePath() {
        return this.secondFilePath;
    }

    public String getDiffTool() {
        return this.diffTool;
    }

    private String popUpFileDialog(Composite composite, String string, String string2) {
        try {
            FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
            fileDialog.setText("Open " + string);
            if (string2 != null && string2.trim().length() > 0) {
                fileDialog.setFileName(string2);
                string2 = string2.substring(0, string2.lastIndexOf(File.separator));
                fileDialog.setFilterPath(string2);
            } else {
                fileDialog.setFilterPath(System.getProperty("user.home"));
            }
            fileDialog.setFilterExtensions(this.FILTEREXT);
            return fileDialog.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private int getIndexForDefault() {
        try {
            if (this.combo != null) {
                String[] stringArray = this.combo.getItems();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].endsWith("<DEFAULT>")) {
                        return n;
                    }
                    ++n;
                }
                stringArray = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    private void setComboData() {
        try {
            new OS2200CompareUtils().checkForMissingCompProps();
            Map<String, String> map = OS2200CompareUtils.getCompareToolsForCombo();
            if (map != null) {
                String string = "";
                String string2 = "";
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    string = entry.getKey();
                    string2 = entry.getValue();
                    this.combo.add(string);
                    this.combo.setData(string, (Object)string2);
                }
                string = null;
                string2 = null;
                map = null;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public String[] getComboItems() {
        return this.combo.getItems();
    }
}

