/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.utils.OS2200CompareUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CompareConfigureDialog
extends TrayDialog {
    private TableViewer tableViewer;
    private Button editBtn;
    private Button removeBtn;
    private Button makeDefaultBtn;
    private static final String SPACE = "  ";
    private Properties confConToolProperties;
    private final String[] FILTEREXE = new String[]{"*.EXE"};
    private static Map<String, String> configuredCompareTools = null;
    private Image image = null;
    SelectionListener addSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: Add Compare Tool");
            String string = CompareConfigureDialog.this.fileBrowse(System.getenv("programfiles"));
            if (string != null) {
                String string2 = string.substring(string.lastIndexOf(File.separator) + 1, string.length());
                if (configuredCompareTools.containsKey(string2.toUpperCase()) || configuredCompareTools.containsKey((String.valueOf(string2) + "<DEFAULT>").toUpperCase())) {
                    String string3 = (String)configuredCompareTools.get(string2.toUpperCase());
                    if (string3 == null) {
                        string3 = (String)configuredCompareTools.get((String.valueOf(string2) + "<DEFAULT>").toUpperCase());
                        configuredCompareTools.put((String.valueOf(string2) + "<DEFAULT>").toUpperCase(), string.toUpperCase());
                    } else {
                        configuredCompareTools.put(string2.toUpperCase(), string.toUpperCase());
                    }
                } else {
                    configuredCompareTools.put(string2.toUpperCase(), string.toUpperCase());
                }
                CompareConfigureDialog.this.updateCompToolsTable();
                OS2200CorePlugin.logger.debug((Object)(String.valueOf(string) + " is added."));
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener editSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: Edit Compare Tool Path");
            IStructuredSelection iStructuredSelection = (IStructuredSelection)CompareConfigureDialog.this.tableViewer.getSelection();
            if (iStructuredSelection != null && iStructuredSelection.size() > 0 && iStructuredSelection.getFirstElement() instanceof String) {
                String string = (String)iStructuredSelection.getFirstElement();
                String string2 = (String)configuredCompareTools.get(string);
                String string3 = CompareConfigureDialog.this.fileBrowse(string2.substring(0, string2.lastIndexOf(File.separator) + 1));
                if (string3 != null) {
                    configuredCompareTools.put(string.toUpperCase(), string3.toUpperCase());
                    CompareConfigureDialog.this.updateCompToolsTable();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener removeSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: Remove Compare Tool Path");
            IStructuredSelection iStructuredSelection = (IStructuredSelection)CompareConfigureDialog.this.tableViewer.getSelection();
            if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
                for (String string : iStructuredSelection) {
                    if (!configuredCompareTools.containsKey(string) || string.contains("ECLIPSE DEFAULT COMPARE TOOL") || string.contains("ECLIPSE DEFAULT COMPARE TOOL<DEFAULT>")) continue;
                    configuredCompareTools.remove(string);
                }
                if (!CompareConfigureDialog.this.checkDefault()) {
                    configuredCompareTools.remove("ECLIPSE DEFAULT COMPARE TOOL");
                    configuredCompareTools.put("ECLIPSE DEFAULT COMPARE TOOL<DEFAULT>", "ECLIPSE DEFAULT COMPARE TOOL");
                }
                CompareConfigureDialog.this.updateCompToolsTable();
                OS2200CorePlugin.logger.debug((Object)" has been deleted from the configured path ");
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener makeDefaultSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: Make Default ");
            IStructuredSelection iStructuredSelection = (IStructuredSelection)CompareConfigureDialog.this.tableViewer.getSelection();
            String string = null;
            String string2 = null;
            if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
                Object object = iStructuredSelection.getFirstElement();
                if (object instanceof String) {
                    string2 = (String)object;
                }
                Iterator iterator = configuredCompareTools.keySet().iterator();
                String string3 = null;
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string.contains("<DEFAULT>")) continue;
                    string3 = (String)configuredCompareTools.get(string);
                    iterator.remove();
                    string = string.replace("<DEFAULT>", "");
                    configuredCompareTools.put(string, string3);
                    break;
                }
                string3 = (String)configuredCompareTools.get(string2);
                configuredCompareTools.remove(string2);
                configuredCompareTools.put(String.valueOf(string2) + "<DEFAULT>", string3);
                CompareConfigureDialog.this.updateCompToolsTable();
                string3 = null;
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    public CompareConfigureDialog(Shell shell) {
        super(shell);
        this.setShellStyle(67696);
        this.setBlockOnOpen(true);
        configuredCompareTools = new HashMap<String, String>();
        this.loadConfConToolProperties();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        String string = TDECoreUtilities.getPluginDirectoryPath((String)"com.unisys.tde.ui").append("icons\\Configure-Compare-Tool.png").toOSString();
        this.image = new Image((Device)composite.getShell().getDisplay(), string);
        composite.getShell().setImage(this.image);
        return control;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, true);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(configuredCompareTools.size() > 0);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.Compare_Configure");
        composite.getShell().setText(Messages.getString((String)"CompareConfigureDialog.1"));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 190;
        gridData.widthHint = 400;
        composite3.setLayoutData((Object)gridData);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite3.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(composite3, 68354);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        tableColumn.setText(Messages.getString((String)"CompareConfigureDialog.2"));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn2 = tableViewerColumn2.getColumn();
        tableColumnLayout.setColumnData((Widget)tableColumn2, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
        tableColumn2.setText(Messages.getString((String)"CompareConfigureDialog.3"));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                return null;
            }

            public String getColumnText(Object object, int n) {
                String string = "";
                switch (n) {
                    case 0: {
                        if (!(object instanceof String)) break;
                        string = (String)object;
                        break;
                    }
                    case 1: {
                        if (!(object instanceof String) || !(string = (String)configuredCompareTools.get((String)object)).contains(".")) break;
                        string = string.substring(0, string.indexOf("."));
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                return string;
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof HashMap) {
                    return ((HashMap)object).keySet().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.updateCompToolsTable();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)CompareConfigureDialog.this.tableViewer.getSelection();
                if (iStructuredSelection != null && iStructuredSelection.size() == 1) {
                    CompareConfigureDialog.this.editBtn.setEnabled(true);
                    if (((String)iStructuredSelection.getFirstElement()).contains("<DEFAULT>")) {
                        CompareConfigureDialog.this.makeDefaultBtn.setEnabled(false);
                    } else {
                        CompareConfigureDialog.this.makeDefaultBtn.setEnabled(true);
                    }
                    if (((String)iStructuredSelection.getFirstElement()).equalsIgnoreCase("ECLIPSE DEFAULT COMPARE TOOL") || ((String)iStructuredSelection.getFirstElement()).equalsIgnoreCase("ECLIPSE DEFAULT COMPARE TOOL<DEFAULT>")) {
                        CompareConfigureDialog.this.removeBtn.setEnabled(false);
                        CompareConfigureDialog.this.editBtn.setEnabled(false);
                    } else {
                        CompareConfigureDialog.this.removeBtn.setEnabled(true);
                        CompareConfigureDialog.this.editBtn.setEnabled(true);
                    }
                } else if (iStructuredSelection != null && iStructuredSelection.size() > 1) {
                    CompareConfigureDialog.this.editBtn.setEnabled(false);
                    CompareConfigureDialog.this.removeBtn.setEnabled(true);
                    CompareConfigureDialog.this.makeDefaultBtn.setEnabled(false);
                } else {
                    CompareConfigureDialog.this.editBtn.setEnabled(false);
                    CompareConfigureDialog.this.removeBtn.setEnabled(false);
                    CompareConfigureDialog.this.makeDefaultBtn.setEnabled(false);
                }
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 10;
        gridLayout2.marginHeight = 10;
        gridLayout2.verticalSpacing = 20;
        composite4.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData(768);
        Button button = new Button(composite4, 0);
        button.setText(SPACE + Messages.getString((String)"CompareConfigureDialog.4") + SPACE);
        button.setLayoutData((Object)gridData2);
        button.addSelectionListener(this.addSelectionListener);
        this.editBtn = new Button(composite4, 0);
        this.editBtn.setText(SPACE + Messages.getString((String)"CompareConfigureDialog.5") + SPACE);
        this.editBtn.setLayoutData((Object)gridData2);
        this.editBtn.setEnabled(false);
        this.editBtn.addSelectionListener(this.editSelectionListener);
        this.removeBtn = new Button(composite4, 0);
        this.removeBtn.setText(SPACE + Messages.getString((String)"CompareConfigureDialog.6") + SPACE);
        this.removeBtn.setLayoutData((Object)gridData2);
        this.removeBtn.addSelectionListener(this.removeSelectionListener);
        this.removeBtn.setEnabled(false);
        this.makeDefaultBtn = new Button(composite4, 0);
        this.makeDefaultBtn.setText(SPACE + Messages.getString((String)"CompareConfigureDialog.7") + SPACE);
        this.makeDefaultBtn.setLayoutData((Object)gridData2);
        this.makeDefaultBtn.addSelectionListener(this.makeDefaultSelectionListener);
        this.makeDefaultBtn.setEnabled(false);
        return composite;
    }

    private String fileBrowse(String string) {
        String string2 = "";
        try {
            OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: File Browser.");
            FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
            fileDialog.setText(Messages.getString((String)"CompareConfigureDialog_0"));
            fileDialog.setFilterPath(string);
            fileDialog.setFilterExtensions(this.FILTEREXE);
            string2 = fileDialog.open();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return string2;
    }

    private void updateCompToolsTable() {
        this.tableViewer.setInput(configuredCompareTools);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(configuredCompareTools.size() > 0);
        }
    }

    private <K extends Comparable, V extends Comparable> HashMap<K, V> sortByValues(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> linkedList = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                return ((Comparable)entry.getValue()).compareTo(entry2.getValue());
            }
        });
        HashMap<Comparable, Comparable> hashMap = new HashMap<Comparable, Comparable>();
        for (Map.Entry entry : linkedList) {
            hashMap.put((Comparable)entry.getKey(), (Comparable)entry.getValue());
        }
        return hashMap;
    }

    protected void okPressed() {
        if (this.checkDefault()) {
            this.saveConfCompToolProperties();
            this.close();
        }
    }

    private boolean checkDefault() {
        boolean bl = false;
        try {
            Iterator<String> iterator = configuredCompareTools.keySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().contains("<DEFAULT>")) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return bl;
    }

    public boolean close() {
        boolean bl = super.close();
        this.destroy();
        return bl;
    }

    private Map<String, String> loadConfConToolProperties() {
        try {
            OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: Load configure properties");
            File file = new File(String.valueOf(OS2200CompareUtils.USER_HOME) + "\\Local Settings\\Application Data\\Unisys\\os2200\\ide\\" + "ConfigureCompareTool.properties");
            if (!file.exists()) {
                this.saveConfCompToolProperties();
            }
            this.confConToolProperties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            this.confConToolProperties.load(fileInputStream);
            if (this.confConToolProperties != null) {
                OS2200CorePlugin.logger.debug((Object)"Loading Configure Compare Tool Properties");
                for (Map.Entry<Object, Object> entry : this.confConToolProperties.entrySet()) {
                    configuredCompareTools.put((String)entry.getKey(), (String)entry.getValue());
                }
                OS2200CorePlugin.logger.debug((Object)(String.valueOf(this.confConToolProperties.size()) + " records in Configure Compare Tool."));
            } else {
                OS2200CorePlugin.logger.debug((Object)"Loading Configure Compare Tool Properties failed.");
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return configuredCompareTools;
    }

    private void saveConfCompToolProperties() {
        Map.Entry<String, String> entry2;
        OS2200CorePlugin.logger.debug((Object)"Configure Compare Tool: Save configure properties");
        if (this.confConToolProperties == null) {
            OS2200CorePlugin.logger.debug((Object)"Creating Configure Compare Tool Properties");
            this.confConToolProperties = new Properties();
        }
        this.confConToolProperties.clear();
        if (!(configuredCompareTools.containsKey("ECLIPSE DEFAULT COMPARE TOOL") || configuredCompareTools.containsKey("ECLIPSE DEFAULT COMPARE TOOL<DEFAULT>") && configuredCompareTools.containsValue("ECLIPSE DEFAULT COMPARE TOOL"))) {
            configuredCompareTools.put("ECLIPSE DEFAULT COMPARE TOOL<DEFAULT>", "ECLIPSE DEFAULT COMPARE TOOL");
        }
        for (Map.Entry<String, String> entry2 : configuredCompareTools.entrySet()) {
            if (entry2.getValue() == null) continue;
            this.confConToolProperties.put(entry2.getKey(), entry2.getValue());
        }
        OS2200CorePlugin.logger.debug((Object)("Configure Compare Tool Properties :" + configuredCompareTools.size() + " keys in the properties"));
        entry2 = new File(String.valueOf(OS2200CompareUtils.USER_HOME) + "\\Local Settings\\Application Data\\Unisys\\os2200\\ide\\");
        if (!((File)((Object)entry2)).exists()) {
            ((File)((Object)entry2)).mkdirs();
        }
        File file = new File(String.valueOf(OS2200CompareUtils.USER_HOME) + "\\Local Settings\\Application Data\\Unisys\\os2200\\ide\\" + "ConfigureCompareTool.properties");
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                this.confConToolProperties.store(fileOutputStream, "");
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
            }
        }
    }

    private void destroy() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.tableViewer = null;
        this.editBtn = null;
        this.removeBtn = null;
        this.makeDefaultBtn = null;
        this.confConToolProperties = null;
        configuredCompareTools = null;
    }
}

