/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.os2200.util.UtilLogger;
import com.unisys.tde.core.OS2200NonExistingFileEditorInput;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class UntitledTextFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String EDITORID = "com.unisys.os2200.editor.UDTEditor";
    private IWorkbenchWindow fWindow;

    public void run(IAction iAction) {
        String string = new SimpleDateFormat("yyyyMMdd_hhmmssSSS").format(new Date());
        String string2 = String.valueOf(Messages.getString((String)"UntitledTextFileAction_0")) + string;
        try {
            File.createTempFile(string2, "");
            if (MemChecker.getInstance().isLargeFile(new File(string2), true)) {
                UtilLogger.getLogger().info((Object)"Not enough memory to create new Editor.");
                return;
            }
        }
        catch (IOException iOException) {
            UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        IFileStore iFileStore = this.queryFileStore();
        IEditorInput iEditorInput = this.createEditorInput(iFileStore);
        IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
        if (iWorkbenchPage != null && iEditorInput != null) {
            try {
                iWorkbenchPage.openEditor(iEditorInput, EDITORID);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private IEditorInput createEditorInput(IFileStore iFileStore) {
        return new OS2200NonExistingFileEditorInput(iFileStore, Messages.getString((String)"UntitledTextFileAction_1"));
    }

    private String getEditorId(IFileStore iFileStore) {
        IWorkbench iWorkbench = this.fWindow.getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(iFileStore.getName());
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    private IFileStore queryFileStore() {
        IPath iPath = EditorsPlugin.getDefault().getStateLocation();
        IPath iPath2 = iPath.append("/_" + new Object().hashCode());
        return EFS.getLocalFileSystem().getStore(iPath2);
    }
}

