/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.FileInfo;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OFCSFileValidations;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.SFCSFileValidations;
import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.tde.ui.UiPlugin;
import com.unisys.tde.ui.actions.OFCSListContentProvider;
import com.unisys.tde.ui.actions.OS2200CreateFileDialog;
import com.unisys.tde.ui.views.HostManagerView;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SaveAsToConfigServerDialog
extends TrayDialog {
    private Combo hostSelect;
    private Text shareNameTxt;
    private Button stdBtn;
    private Button sharedBtn;
    private Button os2200ShareBtn;
    private Button wrkFileShareBtn;
    private Combo fileNameTxt;
    private TableViewer list;
    private CLabel statusLabel;
    private Button refreshBtn;
    private static ToolTip errToolTip;
    private ImageDescriptor fileIcon;
    private ImageDescriptor qualIcon;
    private ImageDescriptor eltIcon;
    private ImageDescriptor upIcon;
    private ImageDescriptor refreshIcon;
    private ImageDescriptor clearCacheIcon;
    private String[] emptyList = new String[0];
    public int shareState = 1;
    private String mfd = "";
    private static final byte[] buffer;
    private Button clearCache;
    private Button createNewWrkFileBtn;
    private static Image fileImage;
    private static Image qualImage;
    private static Image eltImage;
    private static Image upImage;
    private static Image refreshImage;
    private static Image clearCacheImage;
    private static Shell parentShell;
    private static final String STORE_FILE_SAVED = "Files Saved";
    private static final String HASH = "#";
    private static final String STD_SHARE = "STD#";
    private static final String SHARED_SHARE = "SHARED#";
    public static final String SPACE = " ";
    private static final String SLASH = "\\\\";
    private final String FULLPATH = "File Path";
    public static final int FILE_CREATION_OK = 0;
    public static final int FILE_EXIST = -1;
    public static final int CONNECTION_ERROR = -2;
    public static final String OFCSViewID = "com.unisys.tde.ui.views.OFCSView";
    public static final String HMViewID = "com.unisys.tde.core.views.HostManagerView";
    static SFCSFileValidations fileValidation;
    private String previousConn = "";
    private static final String fileIconPath = "/icons/file_icon.gif";
    private static final String qualIconPath = "/icons/qual_icon.gif";
    private static final String elementIconPath = "/icons/element_icon.gif";
    private static final String upIconPath = "/icons/Move-up-folder.png";
    private static final String refreshIconPath = "/icons/Refresh.png";
    private static final String clearCacheIconPath = "/icons/clear-cache-1.png";
    private static final String OS2200 = "OS2200";
    private static final String REG_DOT = "\\.";
    public static final String FRW_SLASH = "/";
    private static final String STAR = "*";
    public static final String DOT = ".";
    private static final String BACK_SLASH = "\\";
    private static final String ELT = "ELT";
    private static final String HYPEN = "-";
    private static final String OFCSVIEW = "OFCSView";
    private String fileEncoding = null;
    MouseListener listMouseListener = new MouseListener(){

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            SaveAsToConfigServerDialog.this.openListItem();
        }
    };
    SelectionListener createNewWrkListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display.getActiveShell(), 65600);
            final OS2200CreateFileDialog oS2200CreateFileDialog = new OS2200CreateFileDialog(shell, SaveAsToConfigServerDialog.this.hostSelect.getText(), !SaveAsToConfigServerDialog.this.mfd.isEmpty());
            String string = null;
            if (oS2200CreateFileDialog.open() != 0) {
                return;
            }
            string = oS2200CreateFileDialog.getWorkFileContents();
            if (string == null) {
                return;
            }
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    int n = oS2200CreateFileDialog.getWorkFileStatus();
                    String string = "";
                    switch (n) {
                        case 0: {
                            string = OS2200CreateFileDialog.workFileName;
                            if (string.startsWith(SaveAsToConfigServerDialog.STD_SHARE)) {
                                string = string.substring(string.indexOf(SaveAsToConfigServerDialog.HASH) + 1);
                                if (SaveAsToConfigServerDialog.this.stdBtn.isEnabled()) {
                                    SaveAsToConfigServerDialog.this.stdBtn.setSelection(true);
                                }
                                if (SaveAsToConfigServerDialog.this.stdBtn.isEnabled()) {
                                    SaveAsToConfigServerDialog.this.sharedBtn.setSelection(false);
                                }
                            } else if (string.startsWith(SaveAsToConfigServerDialog.SHARED_SHARE)) {
                                string = string.substring(string.indexOf(SaveAsToConfigServerDialog.HASH) + 1);
                                if (SaveAsToConfigServerDialog.this.stdBtn.isEnabled()) {
                                    SaveAsToConfigServerDialog.this.stdBtn.setSelection(false);
                                }
                                if (SaveAsToConfigServerDialog.this.stdBtn.isEnabled()) {
                                    SaveAsToConfigServerDialog.this.sharedBtn.setSelection(true);
                                }
                            }
                            if (string.contains("(+") && string.contains(")")) {
                                string = String.valueOf(string.substring(0, string.indexOf("("))) + SaveAsToConfigServerDialog.DOT;
                            }
                            SaveAsToConfigServerDialog.this.fileNameTxt.setText(string);
                            break;
                        }
                    }
                }
            };
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(new Shell(Display.getCurrent().getActiveShell(), 0));
                progressMonitorDialog.run(false, false, iRunnableWithProgress);
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)exception);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    static Listener shellListener;
    MouseListener hostMouseListener = new MouseListener(){

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            LoginAccount[] loginAccountArray;
            String string = SaveAsToConfigServerDialog.this.hostSelect.getText();
            if (SaveAsToConfigServerDialog.this.hostSelect.getItemCount() > 0) {
                SaveAsToConfigServerDialog.this.hostSelect.remove(0, SaveAsToConfigServerDialog.this.hostSelect.getItemCount() - 1);
            }
            if ((loginAccountArray = LoginAccount.getLoginAccounts()) != null && loginAccountArray.length > 0) {
                LoginAccount[] loginAccountArray2 = loginAccountArray;
                int n = loginAccountArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LoginAccount loginAccount = loginAccountArray2[n2];
                    SaveAsToConfigServerDialog.this.hostSelect.add(loginAccount.getName());
                    SaveAsToConfigServerDialog.this.hostSelect.setData(loginAccount.getName(), (Object)loginAccount);
                    ++n2;
                }
                if (!string.isEmpty() && SaveAsToConfigServerDialog.this.hostSelect.indexOf(string) >= 0) {
                    SaveAsToConfigServerDialog.this.hostSelect.select(SaveAsToConfigServerDialog.this.hostSelect.indexOf(string));
                }
            } else {
                SaveAsToConfigServerDialog.this.clearCache.setEnabled(false);
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }
    };
    ColumnLabelProvider labelprovider = new ColumnLabelProvider(){

        public Image getImage(Object object) {
            switch (fileValidation.getStructStatus()) {
                case QUAL_LIST: 
                case QUAL_FILTER: {
                    return qualImage;
                }
                case FILE_LIST: 
                case FILE_FILTER: {
                    String string = (String)object;
                    fileValidation.getClass();
                    if (string.equals(" ..")) {
                        return upImage;
                    }
                    return fileImage;
                }
            }
            String string = (String)object;
            fileValidation.getClass();
            if (string.equals(" ..")) {
                return upImage;
            }
            return eltImage;
        }

        public String getText(Object object) {
            String string = (String)object;
            fileValidation.getClass();
            if (string.equals(" ..")) {
                return string;
            }
            OFCSFileValidations.Status status = fileValidation.getStructStatus();
            String string2 = fileValidation.getParentStr().toUpperCase();
            switch (status) {
                case ELT_LIST: 
                case ELT_FILTER: {
                    if (SaveAsToConfigServerDialog.this.shareState != 2 || fileValidation.getIdx() != 0) break;
                    string = string.replaceAll(SaveAsToConfigServerDialog.REG_DOT, SaveAsToConfigServerDialog.FRW_SLASH);
                    return string.toUpperCase();
                }
            }
            if (!string2.isEmpty()) {
                if (string2.contains(SaveAsToConfigServerDialog.STAR)) {
                    string = string.replaceAll(SaveAsToConfigServerDialog.REG_DOT, SaveAsToConfigServerDialog.FRW_SLASH);
                    return string.toUpperCase();
                }
                return string.toUpperCase();
            }
            string = string.replaceAll(SaveAsToConfigServerDialog.REG_DOT, SaveAsToConfigServerDialog.FRW_SLASH);
            return string.toUpperCase();
        }
    };
    VerifyListener shareNameVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent verifyEvent) {
            verifyEvent.text = verifyEvent.text.toUpperCase();
        }
    };
    VerifyListener fileNameVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent verifyEvent) {
            verifyEvent.text = verifyEvent.text.toUpperCase();
        }
    };
    SelectionListener clearCacheListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (SaveAsToConfigServerDialog.this.hostSelect.getText() != null && !SaveAsToConfigServerDialog.this.hostSelect.getText().isEmpty()) {
                LoginAccount loginAccount = (LoginAccount)SaveAsToConfigServerDialog.this.hostSelect.getData(SaveAsToConfigServerDialog.this.hostSelect.getText());
                String string = fileValidation.clearLocalCache(loginAccount.getHostAccount().getCifsHostId());
                if (!string.isEmpty()) {
                    SaveAsToConfigServerDialog.this.setBallonTooltip(string, OFCSFileValidations.Position.HOST);
                }
            } else {
                SaveAsToConfigServerDialog.this.setBallonTooltip(Messages.getString((String)"OFCSView.validHost"), OFCSFileValidations.Position.HOST);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener hostSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SaveAsToConfigServerDialog.this.setHostSelection();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener os2200ShareSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (SaveAsToConfigServerDialog.this.os2200ShareBtn.getSelection() && SaveAsToConfigServerDialog.this.shareState != 1) {
                SaveAsToConfigServerDialog.this.setos2200Share();
                SaveAsToConfigServerDialog.this.shareNameTxt.setText(SaveAsToConfigServerDialog.OS2200);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener wrkFileShareSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (SaveAsToConfigServerDialog.this.wrkFileShareBtn.getSelection() && SaveAsToConfigServerDialog.this.shareState != 2) {
                SaveAsToConfigServerDialog.this.setwrkFileShare();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener stdBtnSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            fileValidation.getClass();
            SaveAsToConfigServerDialog.this.mfd = "std#";
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener shareBtnSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            fileValidation.getClass();
            SaveAsToConfigServerDialog.this.mfd = "shared#";
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    KeyListener enterKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 13) {
                SaveAsToConfigServerDialog.this.saveSingleFile(SaveAsToConfigServerDialog.this.fileNameTxt.getText().trim(), false);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    };
    KeyListener hostKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 13) {
                SaveAsToConfigServerDialog.this.saveSingleFile(SaveAsToConfigServerDialog.this.fileNameTxt.getText().trim(), false);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    };
    KeyListener listKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent keyEvent) {
            IStructuredSelection iStructuredSelection;
            if (keyEvent.keyCode == 13 && (iStructuredSelection = (IStructuredSelection)SaveAsToConfigServerDialog.this.list.getSelection()).size() == 1) {
                SaveAsToConfigServerDialog.this.openListItem();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    };
    SelectionListener goSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SaveAsToConfigServerDialog.this.saveSingleFile(SaveAsToConfigServerDialog.this.fileNameTxt.getText().trim(), false);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    static {
        buffer = new byte[65536];
        fileImage = null;
        qualImage = null;
        eltImage = null;
        upImage = null;
        refreshImage = null;
        clearCacheImage = null;
        fileValidation = null;
        shellListener = new Listener(){

            public void handleEvent(Event event) {
                if (errToolTip != null) {
                    errToolTip.setVisible(false);
                }
                parentShell.getDisplay().removeFilter(3, shellListener);
                parentShell.getDisplay().removeFilter(1, shellListener);
            }
        };
    }

    public SaveAsToConfigServerDialog(Shell shell) {
        super(shell);
        this.setShellStyle(67696);
        this.fileIcon = ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry(fileIconPath));
        this.qualIcon = ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry(qualIconPath));
        this.eltIcon = ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry(elementIconPath));
        this.upIcon = ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry(upIconPath));
        this.refreshIcon = ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry(refreshIconPath));
        this.clearCacheIcon = ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry(clearCacheIconPath));
        fileImage = this.fileIcon.createImage();
        qualImage = this.qualIcon.createImage();
        eltImage = this.eltIcon.createImage();
        upImage = this.upIcon.createImage();
        refreshImage = this.refreshIcon.createImage();
        clearCacheImage = this.clearCacheIcon.createImage();
        this.setShellStyle(67696);
        fileValidation = SFCSFileValidations.getSFCSFileValidationsInstance();
    }

    public void finalize() {
        try {
            if (fileImage != null) {
                fileImage.dispose();
                fileImage = null;
            }
            if (qualImage != null) {
                qualImage.dispose();
                qualImage = null;
            }
            if (eltImage != null) {
                eltImage.dispose();
                eltImage = null;
            }
            if (upImage != null) {
                upImage.dispose();
                upImage = null;
            }
            if (refreshImage != null) {
                refreshImage.dispose();
                refreshImage = null;
            }
            if (clearCacheImage != null) {
                clearCacheImage.dispose();
                clearCacheImage = null;
            }
            if (this.fileIcon != null) {
                this.fileIcon = null;
            }
            if (this.qualIcon != null) {
                this.qualIcon = null;
            }
            if (this.eltIcon != null) {
                this.eltIcon = null;
            }
            if (this.upIcon != null) {
                this.upIcon = null;
            }
            if (this.refreshIcon != null) {
                this.refreshIcon = null;
            }
            if (this.clearCacheIcon != null) {
                this.clearCacheIcon = null;
            }
            super.finalize();
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.warn((Object)throwable.getMessage(), throwable);
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.getButton(0).setText(SPACE + Messages.getString((String)"OFCSView.go") + SPACE);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        LoginAccount loginAccount;
        Composite composite2;
        parentShell = composite.getShell();
        parentShell.setText(Messages.getString((String)"SFCSDialog.1"));
        parentShell.getDisplay().addFilter(3, shellListener);
        parentShell.getDisplay().addFilter(1, shellListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.Save_As_To_Configured_Server");
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        composite3.setLayout((Layout)gridLayout);
        Composite composite4 = new Composite(composite3, 0);
        GridLayout gridLayout2 = new GridLayout(3, false);
        composite4.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        Label label = new Label(composite4, 0);
        label.setText(Messages.getString((String)"OFCSView.connection"));
        GridData gridData2 = new GridData();
        gridData2.horizontalIndent = 5;
        label.setLayoutData((Object)gridData2);
        this.hostSelect = new Combo(composite4, 2056);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 195;
        this.hostSelect.setLayoutData((Object)gridData3);
        Composite composite5 = LoginAccount.getLoginAccounts();
        if (composite5 != null) {
            composite2 = composite5;
            int n = ((LoginAccount[])composite2).length;
            int n2 = 0;
            while (n2 < n) {
                loginAccount = composite2[n2];
                this.hostSelect.add(loginAccount.getName());
                this.hostSelect.setData(loginAccount.getName(), (Object)loginAccount);
                ++n2;
            }
        }
        this.hostSelect.addKeyListener(this.hostKeyListener);
        this.hostSelect.addMouseListener(this.hostMouseListener);
        this.hostSelect.addSelectionListener(this.hostSelectionListener);
        this.clearCache = new Button(composite4, 0);
        this.clearCache.setImage(clearCacheImage);
        this.clearCache.setEnabled(false);
        this.clearCache.addSelectionListener(this.clearCacheListener);
        this.clearCache.addKeyListener(this.enterKeyListener);
        this.clearCache.setToolTipText(Messages.getString((String)"OFCSView.clearCache"));
        loginAccount = new GridData(256);
        loginAccount.horizontalSpan = 2;
        Group group = new Group(composite3, 4);
        group.setText(Messages.getString((String)"OFCSView.share"));
        group.setLayoutData((Object)loginAccount);
        GridLayout gridLayout3 = new GridLayout(3, false);
        gridLayout3.horizontalSpacing = 10;
        gridLayout3.verticalSpacing = 10;
        gridLayout3.marginWidth = 10;
        gridLayout3.marginHeight = 5;
        group.setLayout((Layout)gridLayout3);
        composite2 = new Composite((Composite)group, 0);
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData4);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.os2200ShareBtn = new Button(composite2, 16);
        this.os2200ShareBtn.setText(Messages.getString((String)"OFCSView.os2200"));
        this.os2200ShareBtn.addSelectionListener(this.os2200ShareSelListener);
        this.os2200ShareBtn.addKeyListener(this.enterKeyListener);
        this.os2200ShareBtn.setSelection(true);
        this.wrkFileShareBtn = new Button(composite2, 16);
        this.wrkFileShareBtn.setText(Messages.getString((String)"OFCSView.wrkFileShr"));
        this.wrkFileShareBtn.addSelectionListener(this.wrkFileShareSelListener);
        this.wrkFileShareBtn.addKeyListener(this.enterKeyListener);
        this.wrkFileShareBtn.setSelection(false);
        this.shareNameTxt = new Text((Composite)group, 2048);
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 3;
        gridData5.widthHint = 258;
        this.shareNameTxt.setLayoutData((Object)gridData5);
        this.shareNameTxt.setText(OS2200);
        this.shareNameTxt.addVerifyListener(this.shareNameVerifyListener);
        this.shareNameTxt.addKeyListener(this.enterKeyListener);
        GridData gridData6 = new GridData(768);
        gridData6.horizontalSpan = 2;
        Group group2 = new Group(composite3, 0);
        group2.setText(Messages.getString((String)"OFCSView.file"));
        group2.setLayoutData((Object)gridData6);
        GridLayout gridLayout4 = new GridLayout(2, false);
        gridLayout4.horizontalSpacing = 10;
        gridLayout4.verticalSpacing = 10;
        gridLayout4.marginWidth = 10;
        gridLayout4.marginHeight = 5;
        group2.setLayout((Layout)gridLayout4);
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 2;
        this.createNewWrkFileBtn = new Button((Composite)group2, 0);
        this.createNewWrkFileBtn.setText(Messages.getString((String)"SaveAsToConfigServerDialog_0"));
        this.createNewWrkFileBtn.addSelectionListener(this.createNewWrkListener);
        this.createNewWrkFileBtn.setLayoutData((Object)gridData7);
        this.createNewWrkFileBtn.setToolTipText(Messages.getString((String)"SaveAsToConfigServerDialog_1"));
        Composite composite6 = new Composite((Composite)group2, 0);
        composite6.setLayoutData((Object)gridData7);
        composite6.setLayout((Layout)new RowLayout());
        this.stdBtn = new Button(composite6, 16);
        this.stdBtn.setText(Messages.getString((String)"OFCSView.std"));
        this.stdBtn.setEnabled(false);
        this.stdBtn.addSelectionListener(this.stdBtnSelListener);
        this.stdBtn.addKeyListener(this.enterKeyListener);
        this.sharedBtn = new Button(composite6, 16);
        this.sharedBtn.setText(Messages.getString((String)"OFCSView.shared"));
        this.sharedBtn.setEnabled(false);
        this.sharedBtn.addSelectionListener(this.shareBtnSelListener);
        this.sharedBtn.addKeyListener(this.enterKeyListener);
        this.fileNameTxt = new Combo((Composite)group2, 2048);
        IDialogSettings iDialogSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = null;
        iDialogSettings2 = iDialogSettings.getSection(OFCSVIEW);
        if (iDialogSettings2 != null && iDialogSettings2.getArray(STORE_FILE_SAVED) != null) {
            this.fileNameTxt.setItems(iDialogSettings2.getArray(STORE_FILE_SAVED));
        }
        GridData gridData8 = new GridData();
        gridData8.widthHint = 250;
        this.fileNameTxt.setLayoutData((Object)gridData8);
        this.fileNameTxt.addVerifyListener(this.fileNameVerifyListener);
        this.fileNameTxt.addKeyListener(this.enterKeyListener);
        GridData gridData9 = new GridData(768);
        gridData9.horizontalSpan = 2;
        gridData9.horizontalAlignment = 1;
        this.refreshBtn = new Button((Composite)group2, 32);
        this.refreshBtn.setToolTipText(Messages.getString((String)"OFCSView.refresh"));
        this.refreshBtn.setImage(refreshImage);
        Label label2 = new Label((Composite)group2, 0);
        label2.setText(Messages.getString((String)"SFCSDialog.2"));
        label2.setLayoutData((Object)gridData9);
        this.statusLabel = new CLabel(composite3, 0);
        GridData gridData10 = new GridData();
        gridData10.horizontalSpan = 2;
        gridData10.widthHint = 280;
        gridData10.horizontalAlignment = 1;
        this.statusLabel.setLayoutData((Object)gridData10);
        this.statusLabel.setText("");
        Composite composite7 = new Composite(composite3, 0);
        GridData gridData11 = new GridData(4, 4, true, true);
        gridData11.horizontalSpan = 2;
        gridData11.verticalAlignment = 4;
        gridData11.grabExcessVerticalSpace = true;
        gridData11.minimumHeight = 320;
        composite7.setLayoutData((Object)gridData11);
        this.list = new TableViewer(composite7, 66064);
        this.list.setContentProvider((IContentProvider)new OFCSListContentProvider());
        this.list.getTable().setLinesVisible(false);
        this.list.getTable().addMouseListener(this.listMouseListener);
        this.list.getTable().addKeyListener(this.listKeyListener);
        TableColumn tableColumn = new TableColumn(this.list.getTable(), 0);
        tableColumn.setResizable(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.list, tableColumn);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100));
        composite7.setLayout((Layout)tableColumnLayout);
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.labelprovider);
        errToolTip = new ToolTip(composite.getShell(), 4098);
        errToolTip.setText("");
        errToolTip.setAutoHide(false);
        this.setInitialValuesForSave();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.saveSingleFile(this.fileNameTxt.getText().trim(), false);
    }

    private void setInitialValuesForSave() {
        IDialogSettings iDialogSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = null;
        iDialogSettings2 = iDialogSettings.getSection("SaveAsConfigureServerFileDialog");
        if (iDialogSettings2 != null && iDialogSettings2.getArray("File Path") != null) {
            this.fileNameTxt.setItems(iDialogSettings2.getArray("File Path"));
        }
        String string = null;
        String string2 = "";
        OS2200ProjectUpdate.Share share = null;
        String string3 = "";
        String string4 = null;
        IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (iEditorPart != null) {
            if (iEditorPart.getEditorInput() instanceof OS2200FileEditorInput) {
                if (((OS2200FileEditorInput)iEditorPart.getEditorInput()).isOS2200File()) {
                    string = ((OS2200FileEditorInput)iEditorPart.getEditorInput()).getHostAcc().getHostAccount().getConnectionName();
                    share = ((OS2200FileEditorInput)iEditorPart.getEditorInput()).getFileShare();
                    string3 = ((OS2200FileEditorInput)iEditorPart.getEditorInput()).getShareName();
                    string2 = ((OS2200FileEditorInput)iEditorPart.getEditorInput()).getPath().toOSString();
                    string4 = SaveAsToConfigServerDialog.getMFD(string2);
                    this.fileEncoding = ((OS2200FileEditorInput)iEditorPart.getEditorInput()).getEncoding();
                } else {
                    string2 = iEditorPart.getEditorInput().getName();
                }
            } else if (iEditorPart.getEditorInput() instanceof IFileEditorInput) {
                try {
                    IFile iFile = ((IFileEditorInput)iEditorPart.getEditorInput()).getFile();
                    Properties properties = OS2200ProjectUpdate.getProperties((IProject)iFile.getProject());
                    String string5 = properties.getProperty("hostID");
                    LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string5);
                    HostAccount hostAccount = loginAccount.getHostAccount();
                    string = hostAccount.getConnectionName();
                    FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(iFile.getLocation().toOSString());
                    if (fileInfo != null) {
                        string2 = fileInfo.getRemoteFile();
                    }
                    string4 = SaveAsToConfigServerDialog.getMFD(string2);
                    this.fileEncoding = iFile.getCharset(true);
                    share = OS2200ProjectUpdate.getShareState((Properties)properties);
                    switch (share) {
                        case stdShare: 
                        case cstShare: {
                            string3 = properties.getProperty("OS2200Share");
                            break;
                        }
                        case nShare: {
                            string3 = properties.getProperty("ProjectShare");
                        }
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception);
                }
            } else {
                string2 = iEditorPart.getEditorInput().getName();
            }
            this.initializeComponents(string, share, string3, string4, string2);
        }
    }

    private static String getMFD(String string) {
        Path path;
        String string2 = "";
        if (string != null && string.startsWith(SLASH) && (path = new Path(string)).segmentCount() == 5) {
            String string3 = path.segment(2);
            if (string3.contains(HASH)) {
                string2 = string3.substring(0, string3.indexOf(HASH) + 1);
            }
            return string2;
        }
        return null;
    }

    private void initializeComponents(String string, OS2200ProjectUpdate.Share share, String string2, String string3, String string4) {
        if (string != null && this.hostSelect.indexOf(string) >= 0) {
            LoginAccount loginAccount;
            this.hostSelect.select(this.hostSelect.indexOf(string));
            this.previousConn = this.hostSelect.getText();
            this.clearCache.setEnabled(true);
            String string5 = "";
            switch (share) {
                case stdShare: 
                case cstShare: {
                    this.os2200ShareBtn.setSelection(true);
                    string5 = OS2200FileInterface.getPathForsaveAs((String)string4, (int)0);
                    this.setos2200Share();
                    this.shareNameTxt.setText(OS2200);
                    break;
                }
                case nShare: {
                    this.wrkFileShareBtn.setSelection(true);
                    string5 = OS2200FileInterface.getPathForsaveAs((String)string4, (int)0);
                    this.setwrkFileShare();
                    break;
                }
                default: {
                    this.os2200ShareBtn.setSelection(true);
                    this.setos2200Share();
                }
            }
            if (string2 != null) {
                this.shareNameTxt.setText(string2.toUpperCase());
            }
            if ((loginAccount = LoginAccount.getLoginAccount((String)string)).getProtocols()[0].getProperty("Property.MHFS").equals("true") && string3 != null && !string3.isEmpty()) {
                this.stdBtn.setEnabled(true);
                this.sharedBtn.setEnabled(true);
                fileValidation.getClass();
                if (string3.equalsIgnoreCase("std#")) {
                    this.stdBtn.setSelection(true);
                    this.sharedBtn.setSelection(false);
                    fileValidation.getClass();
                    this.mfd = "std#";
                } else {
                    fileValidation.getClass();
                    if (string3.equalsIgnoreCase("shared#")) {
                        this.sharedBtn.setSelection(true);
                        this.stdBtn.setSelection(false);
                        fileValidation.getClass();
                        this.mfd = "shared#";
                    }
                }
            }
            if (string4 != null) {
                this.fileNameTxt.setText(string5);
            }
        } else {
            if (!string4.isEmpty()) {
                this.fileNameTxt.setText(string4);
            }
            this.clearCache.setEnabled(false);
        }
    }

    private void setos2200Share() {
        this.shareNameTxt.setText("");
        if (this.shareState != 1) {
            this.clearList();
            this.fileNameTxt.setText("");
        }
        this.shareState = 1;
        this.wrkFileShareBtn.setSelection(false);
        if (!this.hostSelect.getText().isEmpty()) {
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)this.hostSelect.getText());
            if (loginAccount.getProtocols()[0].getProperty("Property.MHFS").equals("true")) {
                this.stdBtn.setEnabled(true);
                this.sharedBtn.setEnabled(true);
                this.stdBtn.setSelection(true);
            }
            this.createNewWrkFileBtn.setEnabled(true);
        }
    }

    private void setwrkFileShare() {
        this.shareNameTxt.setText("");
        if (this.shareState != 2) {
            this.fileNameTxt.setText("");
            this.clearList();
        }
        this.shareState = 2;
        this.os2200ShareBtn.setSelection(false);
        this.stdBtn.setEnabled(false);
        this.sharedBtn.setEnabled(false);
        this.stdBtn.setSelection(false);
        this.sharedBtn.setSelection(false);
        this.createNewWrkFileBtn.setEnabled(false);
    }

    private void clearList() {
        this.statusLabel.setText("");
        this.list.setInput((Object)this.emptyList);
    }

    private void openListItem() {
        OFCSListContentProvider oFCSListContentProvider = (OFCSListContentProvider)this.list.getContentProvider();
        if (oFCSListContentProvider != null) {
            OFCSFileValidations.Status status = oFCSListContentProvider.getCurrentState();
            String string = oFCSListContentProvider.getParent();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.list.getSelection();
            if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
                String string2 = (String)iStructuredSelection.getFirstElement();
                String string3 = "";
                fileValidation.getClass();
                if (string2.equals(" ..")) {
                    this.saveSingleFile(string, true);
                    return;
                }
                switch (status) {
                    case QUAL_LIST: 
                    case QUAL_FILTER: {
                        string3 = string2;
                        this.fileNameTxt.setText(String.valueOf(string3) + STAR);
                        break;
                    }
                    case FILE_LIST: 
                    case FILE_FILTER: {
                        string3 = String.valueOf(string) + string2;
                        if (string3.contains(STAR)) {
                            this.fileNameTxt.setText(String.valueOf(string3) + DOT);
                            break;
                        }
                        this.fileNameTxt.setText(String.valueOf(string3) + BACK_SLASH);
                        break;
                    }
                    case ELT_LIST: 
                    case ELT_FILTER: {
                        string3 = this.shareState == 2 && fileValidation.getIdx() == 0 ? string2.replaceAll(REG_DOT, FRW_SLASH) : (fileValidation.getIdx() > 0 ? String.valueOf(string) + string2 : String.valueOf(string) + string2.replaceAll(REG_DOT, FRW_SLASH));
                        this.fileNameTxt.setText(string3);
                    }
                }
                this.saveSingleFile(string3, false);
            }
        }
    }

    private void setHostSelection() {
        if (!this.hostSelect.getText().isEmpty()) {
            this.clearCache.setEnabled(true);
        } else {
            this.clearCache.setEnabled(false);
        }
        if (!this.previousConn.equals(this.hostSelect.getText())) {
            this.os2200ShareBtn.setSelection(true);
            this.setos2200Share();
            this.shareNameTxt.setText(OS2200);
            LoginAccount loginAccount = (LoginAccount)this.hostSelect.getData(this.hostSelect.getText());
            this.mfd = "";
            if (loginAccount.getProtocols()[0].getProperty("Property.MHFS").equals("true")) {
                this.stdBtn.setEnabled(true);
                this.sharedBtn.setEnabled(true);
                this.sharedBtn.setSelection(false);
                this.stdBtn.setSelection(true);
                fileValidation.getClass();
                this.mfd = "std#";
            } else {
                this.stdBtn.setEnabled(false);
                this.sharedBtn.setEnabled(false);
                this.stdBtn.setSelection(false);
                this.sharedBtn.setSelection(false);
            }
            this.statusLabel.setText("");
            this.list.setInput((Object)this.emptyList);
        }
        this.previousConn = this.hostSelect.getText();
        this.fileNameTxt.setFocus();
    }

    private void setBallonTooltip(String string, OFCSFileValidations.Position position) {
        errToolTip.setMessage(string);
        OS2200CorePlugin.logger.info((Object)string);
        switch (position) {
            case HOST: {
                errToolTip.setLocation(this.hostSelect.toDisplay(this.hostSelect.getLocation()));
                break;
            }
            case SHARE: {
                errToolTip.setLocation(this.shareNameTxt.toDisplay(this.shareNameTxt.getCaretLocation().x + 50, this.shareNameTxt.getCaretLocation().y + 10));
                break;
            }
            case FILE: {
                errToolTip.setLocation(this.fileNameTxt.toDisplay(this.fileNameTxt.getSelection().x + 75, this.fileNameTxt.getSelection().y + 10));
            }
        }
        errToolTip.setVisible(true);
        parentShell.getDisplay().addFilter(3, shellListener);
        parentShell.getDisplay().addFilter(1, shellListener);
    }

    public String getSelectedFilePath(boolean bl) {
        if (this.hostSelect.getText() != null && this.hostSelect.getText().length() > 0) {
            LoginAccount loginAccount = (LoginAccount)this.hostSelect.getData(this.hostSelect.getText());
            if (loginAccount == null || loginAccount.getHostAccount() == null) {
                return null;
            }
            OFCSListContentProvider oFCSListContentProvider = (OFCSListContentProvider)this.list.getContentProvider();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.list.getSelection();
            List list = iStructuredSelection.toList();
            String string = oFCSListContentProvider.getParent();
            String string2 = fileValidation.validateMultipleOpen(loginAccount.getHostAccount().getCifsHostId(), this.shareState, this.shareNameTxt.getText().trim(), string, list.toArray(new String[0]), bl);
            if (string2 != null && string2.length() == 0) {
                return fileValidation.getReturnPaths();
            }
            return null;
        }
        return null;
    }

    private void fileSaveAction(String string, boolean bl) {
        LoginAccount loginAccount = (LoginAccount)this.hostSelect.getData(this.hostSelect.getText());
        this.statusLabel.setText(Messages.getString((String)"OFCSView.fetchContent"));
        this.statusLabel.update();
        long l = System.currentTimeMillis();
        String string2 = null;
        string2 = bl ? fileValidation.performUpOperation(loginAccount.getHostAccount().getCifsHostId(), this.shareState, this.shareNameTxt.getText().trim(), this.mfd, string, this.refreshBtn.getSelection()) : fileValidation.validateInput(loginAccount.getHostAccount().getCifsHostId(), this.shareState, this.shareNameTxt.getText().trim(), this.mfd, string, this.refreshBtn.getSelection());
        long l2 = System.currentTimeMillis();
        OS2200CorePlugin.logger.debug((Object)(" *** OFE time consumed backend " + (l2 - l) + " milliseconds *** "));
        long l3 = System.currentTimeMillis();
        if (SaveAsToConfigServerDialog.fileValidation.canBeSaved && !SaveAsToConfigServerDialog.fileValidation.savePath.isEmpty()) {
            String string3 = SaveAsToConfigServerDialog.fileValidation.savePath;
            Path path = new Path(SaveAsToConfigServerDialog.fileValidation.savePath);
            String string4 = path.removeLastSegments(1).toOSString();
            File file = new File(string4);
            file.mkdirs();
            File file2 = new File(string3);
            if (SaveAsToConfigServerDialog.fileValidation.wouldBeReplaced) {
                if (file2.isDirectory()) {
                    this.setBallonTooltip(Messages.getString((String)"SFCSDialog.3"), OFCSFileValidations.Position.FILE);
                    this.updateStatusLabel();
                    return;
                }
                if (!file2.canWrite()) {
                    this.setBallonTooltip(String.valueOf(file2.getName()) + SPACE + Messages.getString((String)"SFCSDialog.4"), OFCSFileValidations.Position.FILE);
                    this.updateStatusLabel();
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)parentShell, (String)Messages.getString((String)"SFCSDialog.5"), (String)(String.valueOf(Messages.getString((String)"SFCSDialog.6")) + file2.getName()))) {
                    this.updateStatusLabel();
                    return;
                }
            }
            this.statusLabel.setText(Messages.getString((String)"SFCSDialog.saveContent"));
            boolean bl2 = this.performSave(SaveAsToConfigServerDialog.fileValidation.savePath);
            this.updateStatusLabel();
            if (bl2) {
                this.saveToFileList(string);
                this.close();
            }
            return;
        }
        this.updateList(bl);
        if (string2 != null && !string2.isEmpty()) {
            this.setBallonTooltip(string2, fileValidation.getErrPosition());
        }
        long l4 = System.currentTimeMillis();
        OS2200CorePlugin.logger.debug((Object)(" *** Total time OFE consumed to fetch and display" + (l4 - l3) + " milliseconds *** "));
    }

    private void saveToFileList(String string) {
        Object object;
        String[] stringArray = this.fileNameTxt.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            if (((String)object).equalsIgnoreCase(string)) {
                return;
            }
            ++n2;
        }
        object = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings = object.getSection(OFCSVIEW);
        if (iDialogSettings == null) {
            iDialogSettings = object.addNewSection(OFCSVIEW);
        }
        if (this.fileNameTxt.getItemCount() >= 10) {
            this.fileNameTxt.remove(0);
        }
        this.fileNameTxt.add(string.toUpperCase());
        iDialogSettings.put(STORE_FILE_SAVED, this.fileNameTxt.getItems());
    }

    void updateList(boolean bl) {
        String[] stringArray = null;
        switch (fileValidation.getStructStatus()) {
            case QUAL_LIST: {
                stringArray = fileValidation.getQualList();
                break;
            }
            case QUAL_FILTER: {
                stringArray = fileValidation.getQualFilter();
                break;
            }
            case FILE_LIST: {
                stringArray = fileValidation.getFileList();
                break;
            }
            case FILE_FILTER: {
                stringArray = fileValidation.getFileFilter();
                break;
            }
            case ELT_LIST: {
                if (fileValidation.getIdx() > -1) {
                    stringArray = fileValidation.getEltList()[fileValidation.getIdx()];
                }
                this.saveToFileList(fileValidation.getParentStr());
                break;
            }
            case ELT_FILTER: {
                stringArray = fileValidation.getEltFilter();
                break;
            }
            case EMPTY: {
                stringArray = this.emptyList;
                this.statusLabel.setText("");
                break;
            }
            case NONE: {
                break;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        }
        if (fileValidation.getStructStatus() != OFCSFileValidations.Status.NONE) {
            this.list.setInput((Object)stringArray);
        }
        if (fileValidation.getStructStatus() != OFCSFileValidations.Status.NONE) {
            if (this.list.getTable().getItemCount() > 0) {
                this.list.getTable().setFocus();
                this.list.getTable().setSelection(0);
            }
            ((OFCSListContentProvider)this.list.getContentProvider()).setParent(fileValidation.getParentStr().toUpperCase());
            ((OFCSListContentProvider)this.list.getContentProvider()).setCurrentState(fileValidation.getStructStatus());
            if (!fileValidation.getParentStr().isEmpty()) {
                this.updateStatusLabel();
                if (bl) {
                    if (fileValidation.getStructStatus() == OFCSFileValidations.Status.QUAL_LIST || fileValidation.getStructStatus() == OFCSFileValidations.Status.QUAL_FILTER) {
                        this.fileNameTxt.setText("");
                    } else if (fileValidation.getStructStatus() == OFCSFileValidations.Status.ELT_LIST || fileValidation.getStructStatus() == OFCSFileValidations.Status.ELT_FILTER) {
                        if (this.shareState == 2 && fileValidation.getIdx() == 0) {
                            this.fileNameTxt.setText("");
                        } else {
                            this.fileNameTxt.setText(fileValidation.getParentStr());
                        }
                    } else {
                        this.fileNameTxt.setText(fileValidation.getParentStr());
                    }
                }
            } else {
                this.statusLabel.setText("");
            }
        } else {
            this.updateStatusLabel();
        }
    }

    void updateStatusLabel() {
        if (this.list.getTable().getItemCount() > 0) {
            this.statusLabel.setText(String.valueOf(Messages.getString((String)"OFCSView.display")) + fileValidation.getParentStr().toUpperCase());
        } else {
            this.statusLabel.setText("");
        }
    }

    private void saveSingleFile(final String string, final boolean bl) {
        BusyIndicator.showWhile((Display)parentShell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SaveAsToConfigServerDialog.this.hostSelect.getText() != null && SaveAsToConfigServerDialog.this.hostSelect.getText().length() > 0) {
                    LoginAccount loginAccount = (LoginAccount)SaveAsToConfigServerDialog.this.hostSelect.getData(SaveAsToConfigServerDialog.this.hostSelect.getText());
                    if (loginAccount == null || loginAccount.getHostAccount() == null) {
                        return;
                    }
                    String string2 = SaveAsToConfigServerDialog.this.statusLabel.getText();
                    if (string2 == null) {
                        string2 = "";
                    }
                    SaveAsToConfigServerDialog.this.statusLabel.setText(String.valueOf(Messages.getString((String)"OFCSView.Conn")) + loginAccount.getHostAccount().getCifsHostId());
                    SaveAsToConfigServerDialog.this.statusLabel.update();
                    if (SaveAsToConfigServerDialog.this.isConnected(true)) {
                        SaveAsToConfigServerDialog.this.fileSaveAction(string, bl);
                    } else {
                        SaveAsToConfigServerDialog.this.statusLabel.setText(string2);
                        SaveAsToConfigServerDialog.this.statusLabel.update();
                    }
                } else {
                    SaveAsToConfigServerDialog.this.setBallonTooltip(Messages.getString((String)"OFCSView.validHost"), OFCSFileValidations.Position.HOST);
                }
            }
        });
    }

    public OS2200FileEditorInput getFileEditorInput(String string) {
        File file = new File(string);
        OS2200ProjectUpdate.Share share = null;
        switch (this.shareState) {
            case 1: {
                if (this.shareNameTxt.getText().equalsIgnoreCase(OS2200)) {
                    share = OS2200ProjectUpdate.Share.stdShare;
                    break;
                }
                share = OS2200ProjectUpdate.Share.cstShare;
                break;
            }
            case 2: {
                share = OS2200ProjectUpdate.Share.nShare;
                break;
            }
        }
        OS2200FileEditorInput oS2200FileEditorInput = null;
        IFileStore iFileStore = null;
        try {
            String string2 = null;
            iFileStore = EFS.getStore((URI)file.toURI());
            if (this.fileEncoding == null || this.fileEncoding.equalsIgnoreCase(ResourcesPlugin.getEncoding())) {
                string2 = "<NONE>";
            }
            if (this.fileEncoding != null && this.fileEncoding.equalsIgnoreCase("LETSJ")) {
                string2 = OS2200CharSetPlugin.JAPANESE;
            }
            oS2200FileEditorInput = new OS2200FileEditorInput(iFileStore, (LoginAccount)this.hostSelect.getData(this.hostSelect.getText()), share, this.shareNameTxt.getText(), string2, null, null);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)("Exception while creating the input : " + exception.getMessage()));
            return oS2200FileEditorInput;
        }
        return oS2200FileEditorInput;
    }

    private boolean openFile(String string) {
        File file = new File(string);
        String string2 = OS2200FileInterface.isFileReadable((File)file, (int)this.shareState);
        if (string2 != null) {
            this.setBallonTooltip(string2, OFCSFileValidations.Position.FILE);
            return false;
        }
        OS2200FileEditorInput oS2200FileEditorInput = this.getFileEditorInput(string);
        if (oS2200FileEditorInput != null) {
            IEditorPart iEditorPart = null;
            if (OS2200FileInterface.determineType((String)string, (int)this.shareState) == OS2200FileInterface.Type.DATA) {
                String string3 = file.getName();
                OS2200CorePlugin.logger.debug((Object)("Opening the saved data file :  " + string3));
                if (string3.contains(DOT)) {
                    string3 = string3.replace(DOT, HYPEN);
                }
                oS2200FileEditorInput.setEditorid("com.unisys.os2200.editor.UDTEditor");
                oS2200FileEditorInput.setFileName(String.valueOf(string3) + DOT + ELT);
                oS2200FileEditorInput.setDataFile(true);
                iEditorPart = OS2200FileInterface.openFileInEditor((File)file, (OS2200FileEditorInput)oS2200FileEditorInput);
            } else {
                OS2200CorePlugin.logger.debug((Object)("Opening the saved data file :  " + file.getName()));
                oS2200FileEditorInput.setDataFile(false);
                iEditorPart = OS2200FileInterface.OpenAction((File)file, (OS2200FileEditorInput)oS2200FileEditorInput);
            }
            if (iEditorPart == null) {
                OS2200CorePlugin.logger.debug((Object)"Opening the saved file failed.");
                return false;
            }
            OS2200CorePlugin.logger.debug((Object)"Opening the saved file succesfull.");
            return true;
        }
        String string4 = String.valueOf(Messages.getString((String)"OFCSView.errOpen")) + this.fileNameTxt.getText().trim();
        this.setBallonTooltip(string4, OFCSFileValidations.Position.FILE);
        return false;
    }

    private boolean isConnected(boolean bl) {
        long l = 0L;
        LoginAccount loginAccount = (LoginAccount)this.hostSelect.getData(this.hostSelect.getText());
        if (loginAccount == null) {
            return false;
        }
        HostAccount hostAccount = loginAccount.getHostAccount();
        String string = this.shareNameTxt.getText();
        if (string == null || string.isEmpty()) {
            string = "os2200";
        }
        if ((l = OS2200FileInterface.connectCifs((HostAccount)hostAccount, (String)string, (boolean)false)) == 0L) {
            String string2 = hostAccount.getCifsHostId();
            File file = new File(String.valueOf(File.separator) + File.separator + string2 + File.separator + string);
            l = !file.exists() ? -1L : 0L;
        }
        if (l == 0L) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    LoginAccount loginAccount = (LoginAccount)SaveAsToConfigServerDialog.this.hostSelect.getData(SaveAsToConfigServerDialog.this.hostSelect.getText());
                    HostManagerView hostManagerView = SaveAsToConfigServerDialog.getViewObject();
                    if (hostManagerView != null) {
                        hostManagerView.updateHstMgrView(loginAccount.getHostAccount(), true);
                    }
                }
            });
            return true;
        }
        if (l == 53L) {
            if (bl) {
                this.setBallonTooltip(Messages.getString((String)"OFCSView.53Err", (String)string), OFCSFileValidations.Position.HOST);
            } else {
                OS2200CorePlugin.logger.info((Object)("Host could not be reached. Please verify if \n1. the share is reachable: " + string + ", and\n2. the ip-address for the configured connection is correct."));
            }
            return false;
        }
        if (bl) {
            this.setBallonTooltip(Messages.getString((String)"OFCSView.HostNotReachable"), OFCSFileValidations.Position.HOST);
        } else {
            OS2200CorePlugin.logger.info((Object)"Host is not reachable. Select a different host.");
        }
        return false;
    }

    private static HostManagerView getViewObject() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        IViewReference iViewReference = iWorkbenchPage.findViewReference(HMViewID);
        HostManagerView hostManagerView = null;
        if (iViewReference != null && (hostManagerView = (HostManagerView)iViewReference.getView(true)) == null) {
            try {
                hostManagerView = (HostManagerView)iWorkbenchPage.showView(HMViewID);
            }
            catch (PartInitException partInitException) {
                OS2200CorePlugin.logger.error((Object)partInitException.getMessage());
            }
        }
        return hostManagerView;
    }

    protected boolean performSave(String string) {
        IWorkbenchPage iWorkbenchPage;
        OS2200CorePlugin.logger.debug((Object)("Inside performSave method.Destination location : " + string));
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            Object object;
            Object object2;
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart == null) {
                return false;
            }
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            IDocument iDocument = ((ITextEditor)iEditorPart).getDocumentProvider().getDocument((Object)iEditorInput);
            File file = new File(string);
            String string2 = null;
            string2 = this.fileEncoding;
            if (string2 == null || string2.isEmpty()) {
                string2 = ResourcesPlugin.getEncoding();
            }
            OS2200CorePlugin.logger.info((Object)("File encoding : " + string2));
            Charset charset = null;
            try {
                charset = Charset.forName(string2);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                OS2200CorePlugin.logger.error((Object)("Character encoding is not supported by this platform" + unsupportedCharsetException));
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                OS2200CorePlugin.logger.debug((Object)("Character encoding is not a legal character encoding." + illegalCharsetNameException));
            }
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            try {
                object2 = charsetEncoder.encode(CharBuffer.wrap(iDocument.get()));
                if (((ByteBuffer)object2).hasArray()) {
                    object = ((ByteBuffer)object2).array();
                } else {
                    object = new byte[((Buffer)object2).limit()];
                    ((ByteBuffer)object2).get((byte[])object);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object, 0, ((Buffer)object2).limit());
                int n = 0;
                IFileStore iFileStore = EFS.getStore((URI)file.toURI());
                OutputStream outputStream = iFileStore.openOutputStream(n, (IProgressMonitor)new NullProgressMonitor());
                SaveAsToConfigServerDialog.transferStreams(byteArrayInputStream, outputStream, iFileStore.toString(), (IProgressMonitor)new NullProgressMonitor());
                OS2200CorePlugin.logger.info((Object)"Save as succesful");
                OS2200FileInterface.grantFullAccessToAllUsers((File)file);
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getException().getLocalizedMessage().contains("A device attached to the system is not functioning")) {
                    String string3 = OS2200FileInterface.getOS2200Path((String)string, (int)this.shareState);
                    if (string3.isEmpty()) {
                        this.setBallonTooltip(Messages.getString((String)"NewOS2200ProjectPageOne.37"), OFCSFileValidations.Position.FILE);
                    } else {
                        this.setBallonTooltip(Messages.getString((String)"NewOS2200ProjectPageOne.36", (String)string3), OFCSFileValidations.Position.FILE);
                    }
                } else if (coreException.getStatus().getException().getLocalizedMessage().startsWith(SLASH)) {
                    String string4 = coreException.getStatus().getException().getLocalizedMessage().trim();
                    if (string4.contains(SPACE)) {
                        string4 = string4.substring(string4.indexOf(SPACE) + 1);
                    }
                    if (string4.contains("(") && string4.contains(")")) {
                        string4 = string4.substring(string4.indexOf("(") + 1, string4.indexOf(")"));
                    }
                    this.setBallonTooltip(string4, OFCSFileValidations.Position.FILE);
                } else {
                    this.setBallonTooltip(coreException.getStatus().getException().getLocalizedMessage(), OFCSFileValidations.Position.FILE);
                }
                return false;
            }
            catch (CharacterCodingException characterCodingException) {
                OS2200CorePlugin.logger.error((Object)("Some characters cannot be mapped using " + string2 + SPACE + characterCodingException));
            }
            iWorkbenchPage.closeEditor(iEditorPart, false);
            object = file.getName();
            if (object != null && ((String)object).contains("(") && (((String)(object2 = ((String)object).substring(((String)object).lastIndexOf("("), file.getName().length()))).equals("(+1)") || ((String)object2).equals("(+0)") || ((String)object2).equals("(-0)"))) {
                file = new File(string.substring(0, string.lastIndexOf("(")));
            }
            return this.openFile(file.getPath());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transferStreams(InputStream inputStream, OutputStream outputStream, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            byte[] byArray = buffer;
            synchronized (buffer) {
                while (true) {
                    int n = -1;
                    try {
                        n = inputStream.read(buffer);
                    }
                    catch (IOException iOException) {
                        String string2 = Messages.getString((String)"SFCSDialog.9", (String)string);
                        throw new ResourceException(271, (IPath)new Path(string), string2, (Throwable)iOException);
                    }
                    try {
                        if (n == -1) {
                            outputStream.close();
                            break;
                        }
                        outputStream.write(buffer, 0, n);
                    }
                    catch (IOException iOException) {
                        String string3 = Messages.getString((String)"SFCSDialog.10", (String)string);
                        throw new ResourceException(272, (IPath)new Path(string), string3, (Throwable)iOException);
                    }
                    iProgressMonitor.worked(1);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            SaveAsToConfigServerDialog.safeClose(inputStream);
            SaveAsToConfigServerDialog.safeClose(outputStream);
        }
        {
            return;
        }
    }

    public static void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected Point getInitialLocation(Point point) {
        return super.getInitialLocation(point);
    }

    public boolean close() {
        parentShell.getDisplay().removeFilter(3, shellListener);
        parentShell.getDisplay().removeFilter(1, shellListener);
        return super.close();
    }
}

