/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.actions.BaseActionGroup;
import com.unisys.tde.ui.views.OS2200WorkFile;
import com.unisys.tde.ui.wizards.RenameOS2200FileWizard;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RenameAction
extends RenameResourceAction {
    private TreeViewer viewer;
    private Shell shell;
    IStructuredSelection selection;

    public RenameAction(Shell shell, TreeViewer treeViewer) {
        super(shell, treeViewer.getTree());
        this.shell = shell;
        this.viewer = treeViewer;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected void runWithNewPath(IPath iPath, IResource iResource) {
        IResource iResource2;
        IWorkspaceRoot iWorkspaceRoot = iResource.getProject().getWorkspace().getRoot();
        super.runWithNewPath(iPath, iResource);
        if (this.viewer != null && (iResource2 = iWorkspaceRoot.findMember(iPath)) != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)iResource2), true);
        }
    }

    public void run() {
        List list = this.getSelectedResources();
        IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
        if (iResourceArray.length != 1) {
            return;
        }
        if (!(iResourceArray[0] instanceof IProject) && BaseActionGroup.is2200Project((IResource)iResourceArray[0].getProject())) {
            String string = iResourceArray[0].getName();
            if (!OS2200FileInterface.isEditOpen((IProject)iResourceArray[0].getProject(), (String)string)) {
                RenameOS2200FileWizard renameOS2200FileWizard = new RenameOS2200FileWizard();
                renameOS2200FileWizard.init(PlatformUI.getWorkbench(), this.selection);
                WizardDialog wizardDialog = new WizardDialog(this.shell, (IWizard)renameOS2200FileWizard);
                wizardDialog.create();
                wizardDialog.open();
                if (wizardDialog.getReturnCode() != 1) {
                    StructuredSelection structuredSelection = new StructuredSelection(renameOS2200FileWizard.getNewResources());
                    this.viewer.setSelection((ISelection)structuredSelection, true);
                }
            } else {
                MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString((String)"RenameOS2200FileWizard.0"), (String)Messages.getString((String)"RenameAction.1"));
            }
        } else {
            IWorkbench iWorkbench;
            if (iResourceArray[0] instanceof IProject && !((IProject)iResourceArray[0]).isOpen()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"RenameAction_0"), (String)Messages.getString((String)"RenameAction_2"));
                return;
            }
            IEditorPart[] iEditorPartArray = null;
            if (iResourceArray[0] instanceof IProject) {
                iWorkbench = (IProject)iResourceArray[0];
                try {
                    iWorkbench.refreshLocal(1, null);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                iEditorPartArray = OS2200ProjectUpdate.getDirtyEditorsAssociatedToProj((IProject)iWorkbench);
            }
            iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchPage iWorkbenchPage = iWorkbench.getActiveWorkbenchWindow().getActivePage();
            int n = 0;
            while (n < iEditorPartArray.length) {
                boolean bl = iWorkbenchPage.saveEditor(iEditorPartArray[n], true);
                if (!bl) {
                    return;
                }
                ++n;
            }
            List<IEditorPart> list2 = this.getAssociatedEditors((IProject)iResourceArray[0]);
            if (list2.size() > 0) {
                Iterator<IEditorPart> iterator = list2.iterator();
                IWorkbenchPage iWorkbenchPage2 = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0];
                while (iterator.hasNext()) {
                    iWorkbenchPage2.closeEditor(iterator.next(), false);
                }
            }
            super.run();
        }
    }

    private List<IEditorPart> getAssociatedEditors(IProject iProject) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IFileEditorInput iFileEditorInput = null;
            try {
                IEditorInput iEditorInput = iEditorReferenceArray[n].getEditorInput();
                if (iEditorInput instanceof IFileEditorInput) {
                    iFileEditorInput = (IFileEditorInput)iEditorInput;
                }
                if (iFileEditorInput != null) {
                    IFile iFile = iFileEditorInput.getFile();
                    IProject iProject2 = iFile.getProject();
                    if (iProject.getName().equalsIgnoreCase(iProject2.getName())) {
                        IEditorPart iEditorPart = iEditorReferenceArray[n].getEditor(true);
                        arrayList.add(iEditorPart);
                    }
                }
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
            ++n;
        }
        return arrayList;
    }

    private IPath getNewNameFor(IPath iPath, final IWorkspace iWorkspace) {
        final IResource iResource = iWorkspace.getRoot().findMember(iPath);
        final IPath iPath2 = iResource.getFullPath().removeLastSegments(1);
        final String[] stringArray = new String[]{""};
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IInputValidator iInputValidator = new IInputValidator(){

                    public String isValid(String string) {
                        if (iResource.getName().equals(string)) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                        }
                        IStatus iStatus = iWorkspace.validateName(string, iResource.getType());
                        if (!iStatus.isOK()) {
                            return iStatus.getMessage();
                        }
                        if (iWorkspace.getRoot().exists(iPath2.append(string))) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                        }
                        return null;
                    }
                };
                InputDialog inputDialog = new InputDialog(RenameAction.this.shell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object)iResource.getName()), "Z", iInputValidator);
                inputDialog.setBlockOnOpen(true);
                inputDialog.open();
                stringArray[0] = inputDialog.getReturnCode() == 1 ? null : inputDialog.getValue();
            }
        });
        if (stringArray[0] == null) {
            throw new OperationCanceledException();
        }
        return iPath2.append(stringArray[0]);
    }

    public void handleKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x100000B && keyEvent.stateMask == 0 && this.isEnabled()) {
            this.run();
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        this.selection = iStructuredSelection;
        IResource iResource = (IResource)iStructuredSelection.getFirstElement();
        if (iResource == null) {
            return false;
        }
        if (iResource instanceof OS2200WorkFile) {
            return false;
        }
        return !(iResource instanceof IFile) || !BaseActionGroup.is2200Project(iResource);
    }
}

