/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.tde.ui.actions.BaseActionGroup;
import com.unisys.tde.ui.actions.CopyAction;
import com.unisys.tde.ui.actions.DeleteResourceAction;
import com.unisys.tde.ui.actions.MoveAction;
import com.unisys.tde.ui.actions.PasteAction;
import com.unisys.tde.ui.actions.RenameAction;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.tde.ui.views.OS2200WorkFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;

public class RefactorActionGroup
extends BaseActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private RenameAction renameAction;
    private MoveAction moveAction;
    private TextActionHandler textActionHandler;

    public RefactorActionGroup(OS2200View oS2200View) {
        super(oS2200View);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    @Override
    public void fillContextMenu(IMenuManager iMenuManager) {
        boolean bl;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (!iStructuredSelection.isEmpty() && ((bl = RefactorActionGroup.allResourcesAreOfType(iStructuredSelection, 7)) || iStructuredSelection.getFirstElement() instanceof OS2200WorkFile)) {
            iMenuManager.add((IAction)this.copyAction);
            iMenuManager.add((IAction)this.pasteAction);
            iMenuManager.add((IAction)this.deleteAction);
            iMenuManager.add((IAction)this.moveAction);
            if (!(iStructuredSelection.getFirstElement() instanceof IFile)) {
                iMenuManager.add((IAction)this.renameAction);
            }
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.textActionHandler = new TextActionHandler(iActionBars);
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        iActionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        iActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    @Override
    protected void makeActions(IWorkbenchSite iWorkbenchSite) {
        TreeViewer treeViewer = BaseActionGroup.getOS2200View().getViewer();
        Shell shell = iWorkbenchSite.getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.pasteAction = new PasteAction(shell, this.clipboard);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.copyAction = new CopyAction(shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.moveAction = new MoveAction(shell, (StructuredViewer)treeViewer);
        this.renameAction = new RenameAction(shell, treeViewer);
        this.deleteAction = new DeleteResourceAction(shell, (StructuredViewer)treeViewer);
        this.deleteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.selectionChanged(iStructuredSelection);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.copyAction.selectionChanged(iStructuredSelection);
        this.pasteAction.selectionChanged(iStructuredSelection);
        this.deleteAction.selectionChanged(iStructuredSelection);
        this.moveAction.selectionChanged(iStructuredSelection);
        this.renameAction.selectionChanged(iStructuredSelection);
    }
}

