/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.Session;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.patch.ErrorMessages;

public class ProjectLocationSelectionDialog
extends org.eclipse.ui.dialogs.patch.ProjectLocationSelectionDialog {
    public ErrorMessages errorMessages;
    private int WORKFILEDIAGNOSTIC;
    private Text workFileNameField;
    private String destinationWorkfile = "";
    private String destinationShare = "";
    private String workfileName;
    private IProject myProject;
    private Button elementCopyButton;
    private Button fileCopyButton;
    private boolean fileCopy;
    private ISession session;
    int wflen;
    OS2200ProjectUpdate.Share state;
    private final String COMMA = ",";

    public ProjectLocationSelectionDialog(Shell shell, IProject iProject) {
        super(shell, iProject);
        this.myProject = iProject;
        this.state = OS2200ProjectUpdate.getShareState((IProject)this.myProject);
        this.errorMessages = ((org.eclipse.ui.dialogs.patch.ProjectLocationSelectionDialog)this).errorMessages;
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        if (this.state == OS2200ProjectUpdate.Share.nShare) {
            label.setText(Messages.getString((String)"ProjectLocationSelectionDialog_0"));
        } else {
            label.setText(Messages.getString((String)"ProjectLocationSelectionDialog_1"));
        }
        this.WORKFILEDIAGNOSTIC = this.errorMessages.addMsgIndex();
        this.workFileNameField = new Text(composite3, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.workFileNameField.setLayoutData((Object)gridData);
        this.fileCopyButton = new Button(composite2, 16);
        this.fileCopyButton.setText(Messages.getString((String)"ProjectLocationSelectionDialog_2"));
        this.fileCopyButton.setSelection(true);
        this.elementCopyButton = new Button(composite2, 16);
        this.elementCopyButton.setText(Messages.getString((String)"ProjectLocationSelectionDialog_3"));
        this.elementCopyButton.setSelection(false);
        new Label(composite2, 0);
        this.workfileNameListener();
        this.workFileNameField.setText("");
        ProjectLocationSelectionDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void workfileNameListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                String string = "";
                String string2 = ProjectLocationSelectionDialog.this.workFileNameField.getText();
                if (ProjectLocationSelectionDialog.this.state == OS2200ProjectUpdate.Share.nShare) {
                    if (string2.length() == 0) {
                        string = Messages.getString((String)"ProjectLocationSelectionDialog_4");
                    }
                } else if (string2.contains("+") || !OS2200FileInterface.legalOS2200FileName((String)string2)) {
                    if (string2.length() == 0) {
                        string = Messages.getString((String)"ProjectLocationSelectionDialog_5");
                    }
                } else if (string2.indexOf(".") != -1 && string2.indexOf(".") < string2.length() - 1 || string2.indexOf("*") < 0 || string2.indexOf("*") >= string2.length() - 1) {
                    string = Messages.getString((String)"ProjectLocationSelectionDialog_6");
                }
                ProjectLocationSelectionDialog.this.errorMessages.issueMessage(ProjectLocationSelectionDialog.this.WORKFILEDIAGNOSTIC, string);
            }
        };
        this.workFileNameField.addListener(24, listener);
    }

    @Override
    public void computeResult() {
        this.workfileName = new String(this.workFileNameField.getText());
        this.fileCopy = this.fileCopyButton.getSelection();
        super.computeResult();
    }

    protected void okPressed() {
        boolean bl = true;
        String string = "";
        String string2 = "";
        try {
            Properties properties = OS2200ProjectUpdate.getProperties((IProject)this.myProject);
            String string3 = properties.getProperty("hostID");
            String string4 = properties.getProperty("workFile");
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string3);
            this.session = Session.New((LoginAccount)loginAccount);
            String string5 = this.session.Login();
            if (string5 == "") {
                int n;
                int n2;
                int n3;
                if (this.state == OS2200ProjectUpdate.Share.nShare) {
                    this.destinationShare = this.workFileNameField.getText();
                    this.session.SendCommand("@CIFSUT \n");
                    this.destinationWorkfile = OS2200FileInterface.getQSFfromCIFS((ISession)this.session, (String)this.destinationShare);
                    int n4 = this.destinationWorkfile.indexOf(" ");
                    n3 = this.destinationWorkfile.indexOf("*");
                    if (n4 > 0 || n3 < 0) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)(String.valueOf(Messages.getString((String)"ProjectLocationSelectionDialog_8")) + this.destinationShare + Messages.getString((String)"ProjectLocationSelectionDialog_9")));
                        return;
                    }
                } else {
                    this.destinationWorkfile = this.workFileNameField.getText();
                    this.wflen = this.destinationWorkfile.length() - 1;
                    if (this.destinationWorkfile.charAt(this.wflen) != '.') {
                        this.destinationWorkfile = this.destinationWorkfile.concat(".");
                    }
                    this.destinationShare = "";
                }
                string2 = this.destinationWorkfile;
                if (string4.contains("#")) {
                    string = string4.substring(0, string4.indexOf("#") + 1);
                    string4 = string4.substring(string4.indexOf("#") + 1);
                    this.session.SendCommand_ProtocolSpecific("@qual,d " + string + "\n", false);
                }
                this.session.SendCommand("@PRT,T " + string4 + "dummy" + "\n");
                string5 = this.session.getOutput();
                if (string5.contains("4000012")) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)(String.valueOf(Messages.getString((String)"ProjectLocationSelectionDialog_10")) + string4 + Messages.getString((String)"ProjectLocationSelectionDialog_11")));
                    return;
                }
                if (string5.contains("400001")) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)(String.valueOf(Messages.getString((String)"ProjectLocationSelectionDialog_10")) + string4 + Messages.getString((String)"ProjectLocationSelectionDialog_12")));
                    return;
                }
                this.session.SendCommand("@PRT,F " + string4 + "\n");
                string5 = this.session.getOutput();
                String string6 = string4.replace(".", "").toUpperCase();
                n3 = string5.indexOf("FURPUR");
                n3 = string5.indexOf(string6, n3);
                int n5 = string5.indexOf(",", n3);
                int n6 = string5.indexOf("\r", n5);
                String string7 = string5.substring(n5, n6);
                if (string2.contains("#")) {
                    string = string2.substring(0, string2.indexOf("#") + 1);
                    string2 = string2.substring(string2.indexOf("#") + 1);
                    this.session.SendCommand_ProtocolSpecific("@qual,d " + string + "\n", false);
                } else {
                    this.session.SendCommand_ProtocolSpecific("@qual,r \n", false);
                }
                this.session.SendCommand("@PRT,T " + string2 + "dummy" + "\n");
                string5 = this.session.getOutput();
                if (string5.contains("400010000000")) {
                    this.session.SendCommand("@CAT " + string2 + string7 + "\n");
                    string5 = this.session.getOutput();
                    if (string5.contains("40001")) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)(String.valueOf(Messages.getString((String)"ProjectLocationSelectionDialog_13")) + this.destinationWorkfile + Messages.getString((String)"ProjectLocationSelectionDialog_14")));
                        bl = false;
                    }
                } else if (string5.contains("400001200000")) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)Messages.getString((String)"ProjectLocationSelectionDialog_15"));
                    bl = false;
                } else if (string5.contains("40000")) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)Messages.getString((String)"ProjectLocationSelectionDialog_16"));
                    bl = false;
                } else if (!string5.contains("IS EMPTY")) {
                    String string8 = "";
                    string8 = this.fileCopyButton.getSelection() ? String.valueOf(this.destinationWorkfile) + Messages.getString((String)"ProjectLocationSelectionDialog_17") + this.destinationWorkfile : String.valueOf(this.destinationWorkfile) + Messages.getString((String)"ProjectLocationSelectionDialog_18") + this.destinationWorkfile;
                    n2 = MessageDialog.openConfirm(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_19"), (String)string8) ? 1 : 0;
                    if (n2 == 0) {
                        bl = false;
                    }
                }
                this.session.SendCommand_ProtocolSpecific("@qual,r \n", false);
                if (this.fileCopyButton.getSelection() && (n = this.getFileTrackCount(this.session, string4)) > (n2 = this.getFileTrackCount(this.session, string2))) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)(String.valueOf(Messages.getString((String)"ProjectLocationSelectionDialog_20")) + n + "\n" + Messages.getString((String)"ProjectLocationSelectionDialog_21") + n2 + "\n" + Messages.getString((String)"ProjectLocationSelectionDialog_22") + this.destinationWorkfile + Messages.getString((String)"ProjectLocationSelectionDialog_23")));
                    bl = false;
                    return;
                }
                if (bl) {
                    super.okPressed();
                }
            } else {
                MessageDialog.openError(null, (String)Messages.getString((String)"ProjectLocationSelectionDialog_7"), (String)(String.valueOf(Messages.getString((String)"ProjectLocationSelectionDialog_24")) + string3 + "\n" + string5));
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"", (Throwable)coreException);
        }
    }

    private int getFileTrackCount(ISession iSession, String string) {
        iSession.SendCommand("@PRT,F " + string + "\n");
        String string2 = iSession.getOutput();
        return this.parseTrackCount(string2, string);
    }

    private int parseTrackCount(String string, String string2) {
        String[] stringArray;
        String string3 = string2.replace(".", "");
        int n = 0;
        String[] stringArray2 = stringArray = string.split("\n");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray2[n3];
            if (string4.startsWith(string3.trim().toUpperCase())) {
                String[] stringArray3 = string4.split("/");
                String string5 = stringArray3[stringArray3.length - 1].trim();
                if (string5.contains(",")) {
                    string5 = string5.substring(0, string5.indexOf(",")).trim();
                }
                if (string5.length() <= 0 || !StringUtils.isNumeric((String)string5)) {
                    n = 0;
                    OS2200CorePlugin.logger.debug((Object)("Invalid Track count. @prt,f output: " + string));
                    break;
                }
                n = Integer.parseInt(string5);
                break;
            }
            ++n3;
        }
        return n;
    }

    public String getName() {
        String string = null;
        Object[] objectArray = super.getResult();
        if (objectArray.length > 0) {
            string = (String)objectArray[0];
        }
        return string;
    }

    public String getPath() {
        String string = null;
        Object[] objectArray = super.getResult();
        if (objectArray.length > 1) {
            string = (String)objectArray[1];
        }
        return string;
    }

    public String getWorkfileName() {
        return this.destinationWorkfile;
    }

    public String getWorkfileShare() {
        return this.destinationShare;
    }

    public boolean getFullFileCopy() {
        return this.fileCopy;
    }

    public ISession getSession() {
        return this.session;
    }
}

