/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.ExclusiveFileLockChecker;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.views.ModalTextDialog;
import com.unisys.tde.ui.UIUtil;
import com.unisys.tde.ui.actions.BaseActionGroup;
import com.unisys.tde.ui.actions.Copy2200ProjectOperation;
import com.unisys.tde.ui.dialogs.OS2200FileNameConflictDialog;
import com.unisys.tde.ui.dialogs.ReplacePasteDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionListenerAction {
    private Shell shell;
    private Clipboard clipboard;
    private static IProject destPrj;
    private static boolean isPasteCancel;
    private static boolean isApplyAllButtonEnabled;
    private static boolean isApplyAllChecked;
    public static final String ID = "org.eclipse.ui.PasteAction";
    private static final String SUPPORTED_EDITORS = "C,H,COB,FOR,ELT,TXT,PLS,JAVA,ASM,MSM";
    private static final String PERIOD = ".";
    private static final String HYPHEN = "-";
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private static String nativeName;
    private static String destinationPath;
    static int diag;
    static String sEltname;
    static String sLinkName;

    static {
        isPasteCancel = false;
        isApplyAllButtonEnabled = false;
        isApplyAllChecked = false;
        nativeName = "";
        destinationPath = "";
    }

    public PasteAction(Shell shell, Clipboard clipboard) {
        super("Paste");
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(Messages.getString((String)"PasteAction.13"));
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    private Object getTarget() {
        List list = this.getSelectedResources();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof IResource) {
                IResource iResource = (IResource)list.get(n);
                if (iResource instanceof IProject && !((IProject)iResource).isOpen()) {
                    return null;
                }
                if (iResource.getType() == 1) {
                    iResource = iResource.getParent();
                }
                if (iResource != null) {
                    return iResource;
                }
            }
            ++n;
        }
        return null;
    }

    public void run() {
        IContainer iContainer = BaseActionGroup.sanitizeDestination(this.getContainer());
        boolean bl = BaseActionGroup.is2200Project((IResource)iContainer);
        ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
        IResource[] iResourceArray = (IResource[])this.clipboard.getContents((Transfer)resourceTransfer);
        boolean bl2 = false;
        if (iResourceArray != null && iResourceArray.length > 0) {
            boolean bl3 = BaseActionGroup.is2200Project(iResourceArray[0]);
            if (iResourceArray.length > 1) {
                bl2 = true;
            }
            if (iResourceArray[0].getType() == 4) {
                int n = 0;
                while (n < iResourceArray.length) {
                    Copy2200ProjectOperation copy2200ProjectOperation;
                    if (bl3) {
                        OS2200CorePlugin.logger.debug((Object)"Paste Resources:OS 2200 Type Project");
                        copy2200ProjectOperation = new Copy2200ProjectOperation(this.shell);
                        copy2200ProjectOperation.copyProject((IProject)iResourceArray[n]);
                    } else {
                        OS2200CorePlugin.logger.debug((Object)"Paste Resources:not a OS 2200 Type Project");
                        copy2200ProjectOperation = new CopyProjectOperation(this.shell);
                        copy2200ProjectOperation.copyProject((IProject)iResourceArray[n]);
                    }
                    ++n;
                }
            } else if (bl && bl3) {
                OS2200CorePlugin.logger.debug((Object)"Paste Resources: source=OS2200 destination=OS2200");
                if (!UIUtil.openDlgForFileDnD()) {
                    return;
                }
                final IResource[] iResourceArray2 = iResourceArray;
                final IContainer iContainer2 = iContainer;
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor iProgressMonitor) {
                        PasteAction.os2200ToOS2200Paste(iResourceArray2, (IResource)iContainer2, iProgressMonitor);
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, bl2, (IRunnableWithProgress)workspaceModifyOperation);
                    OS2200ProjectUpdate.displayLinkNotes();
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                    PasteAction.errormsg(interruptedException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    PasteAction.errormsg(exception.getLocalizedMessage());
                }
            } else if (bl) {
                OS2200CorePlugin.logger.debug((Object)"Paste Resources: source=other destination=OS2200");
                IContainer iContainer3 = iContainer;
                final String[] stringArray = new String[iResourceArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = iResourceArray[n].getLocation().toString();
                    ++n;
                }
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((IResource)iContainer3){
                    private final /* synthetic */ IResource val$dest;
                    {
                        this.val$dest = iResource;
                    }

                    public void execute(IProgressMonitor iProgressMonitor) {
                        PasteAction.localToOS2200Paste(stringArray, this.val$dest, iProgressMonitor);
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, bl2, (IRunnableWithProgress)workspaceModifyOperation);
                    OS2200ProjectUpdate.displayLinkNotes();
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                    PasteAction.errormsg(interruptedException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    PasteAction.errormsg(exception.getLocalizedMessage());
                }
            } else if (bl3) {
                OS2200CorePlugin.logger.debug((Object)"Paste Resources: source=OS2200 destination=other");
                final IResource[] iResourceArray3 = iResourceArray;
                final IContainer iContainer4 = iContainer;
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor iProgressMonitor) {
                        PasteAction.os2200ToLocalPaste(iResourceArray3, (IResource)iContainer4, iProgressMonitor);
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, bl2, (IRunnableWithProgress)workspaceModifyOperation);
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.error((Object)interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
                    PasteAction.errormsg(interruptedException.getMessage());
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    PasteAction.errormsg(exception.getMessage());
                }
            } else {
                OS2200CorePlugin.logger.debug((Object)"source=other destination=other");
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.shell);
                copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
            }
        } else {
            FileTransfer fileTransfer = FileTransfer.getInstance();
            String[] stringArray = (String[])this.clipboard.getContents((Transfer)fileTransfer);
            if (stringArray != null && stringArray.length > 0) {
                if (stringArray.length > 1) {
                    bl2 = true;
                }
                if (bl) {
                    OS2200CorePlugin.logger.debug((Object)"source=file destination=2200");
                    final String[] stringArray2 = stringArray;
                    IContainer iContainer5 = iContainer;
                    WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((IResource)iContainer5){
                        private final /* synthetic */ IResource val$dest;
                        {
                            this.val$dest = iResource;
                        }

                        public void execute(IProgressMonitor iProgressMonitor) {
                            PasteAction.localToOS2200Paste(stringArray2, this.val$dest, iProgressMonitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, bl2, (IRunnableWithProgress)workspaceModifyOperation);
                        OS2200ProjectUpdate.displayLinkNotes();
                    }
                    catch (InterruptedException interruptedException) {
                        OS2200CorePlugin.logger.error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                    }
                    catch (Exception exception) {
                        PasteAction.errormsg(exception.getLocalizedMessage());
                        OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                } else {
                    OS2200CorePlugin.logger.debug((Object)"source=file destination=other");
                    CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.shell);
                    copyFilesAndFoldersOperation.copyFiles(stringArray, iContainer);
                }
            }
        }
    }

    private static void resetGlobalVars() {
        nativeName = "";
        destinationPath = "";
        destPrj = null;
        isApplyAllButtonEnabled = false;
        isApplyAllChecked = false;
    }

    public static boolean[] localToOS2200Paste(String[] stringArray, IResource iResource, IProgressMonitor iProgressMonitor) {
        PasteAction.resetGlobalVars();
        boolean[] blArray = new boolean[stringArray.length];
        ArrayList<ElementSelectionObject> arrayList = new ArrayList<ElementSelectionObject>();
        destPrj = iResource.getProject();
        if (stringArray.length > 1) {
            isApplyAllButtonEnabled = true;
        }
        try {
            long l = OS2200ProjectUpdate.connectOS2200((IProject)destPrj, (boolean)false);
            if (l != 0L) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OS2200CorePlugin.logger.error((Object)"Destination host is down or you are working offline. Please connect the network and try again.");
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"PasteAction.3"), (String)Messages.getString((String)"PasteAction.4"));
                    }
                });
                return blArray;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        iProgressMonitor.beginTask("", stringArray.length);
        final StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (iProgressMonitor.isCanceled()) break;
            iProgressMonitor.setTaskName(String.valueOf(Messages.getString((String)"PasteAction_0")) + (n2 + 1) + SLASH + stringArray.length + ")");
            isPasteCancel = false;
            File file = new File(stringArray[n2].toString());
            if (!file.exists() && !file.isFile()) {
                if (n == 1) {
                    stringBuffer.append(Messages.getString((String)"PasteAction_14"));
                }
                if (n < 5) {
                    stringBuffer.append("\t" + file.toString() + "\n");
                }
                if (n == 5) {
                    stringBuffer.append(Messages.getString((String)"PasteAction_15"));
                }
                ++n;
                blArray[n2] = false;
                OS2200CorePlugin.logger.info((Object)(String.valueOf(file.isFile()) + " its a directory or not exist."));
            } else {
                blArray[n2] = PasteAction.startFileCopy(file, "", "", arrayList, iProgressMonitor);
                if (iProgressMonitor.isCanceled()) break;
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    OS2200CorePlugin.logger.debug((Object)stringBuffer.toString());
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"PasteAction_16"), (String)stringBuffer.toString());
                }
            });
        }
        PasteAction.addAndUpdateProjectTree(arrayList);
        iProgressMonitor.done();
        PasteAction.resetGlobalVars();
        return blArray;
    }

    public static boolean[] os2200ToLocalPaste(IResource[] iResourceArray, IResource iResource, IProgressMonitor iProgressMonitor) {
        PasteAction.resetGlobalVars();
        IProject iProject = iResource.getProject();
        boolean[] blArray = new boolean[iResourceArray.length];
        iProgressMonitor.beginTask(Messages.getString((String)"PasteAction_1"), iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            File file = new File(iResourceArray[n].getLocation().toString());
            String string = file.getAbsolutePath();
            String string2 = String.valueOf(iResource.getLocation().toString()) + SLASH + iResourceArray[n].getName();
            iProgressMonitor.setTaskName(String.valueOf(Messages.getString((String)"PasteAction_2")) + file.getName());
            try {
                int n2 = PasteAction.fileCopy(string, string2, iProgressMonitor);
                if (n2 != 1) {
                    blArray[n] = false;
                    iProgressMonitor.done();
                    return blArray;
                }
                blArray[n] = true;
                iProject.refreshLocal(0, iProgressMonitor);
            }
            catch (Exception exception) {
                blArray[n] = false;
                OS2200CorePlugin.logger.info((Object)("An Error Occured while Copying. " + exception.getMessage()), (Throwable)exception);
                PasteAction.errormsg(exception.getMessage());
            }
            iProgressMonitor.worked(1);
            ++n;
        }
        iProgressMonitor.done();
        PasteAction.resetGlobalVars();
        return blArray;
    }

    public static boolean[] os2200ToOS2200Paste(IResource[] iResourceArray, IResource iResource, IProgressMonitor iProgressMonitor) {
        boolean[] blArray = new boolean[iResourceArray.length];
        PasteAction.resetGlobalVars();
        ArrayList<ElementSelectionObject> arrayList = new ArrayList<ElementSelectionObject>();
        destPrj = iResource.getProject();
        if (iResourceArray.length > 1) {
            isApplyAllButtonEnabled = true;
        }
        try {
            long l = OS2200ProjectUpdate.connectOS2200((IProject)destPrj, (boolean)false);
            if (l != 0L) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OS2200CorePlugin.logger.error((Object)"Destination host is down or you are working offline. Please connect the network and try again.");
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"PasteAction.3"), (String)Messages.getString((String)"PasteAction.4"));
                    }
                });
                return blArray;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        iProgressMonitor.beginTask("", iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            if (iProgressMonitor.isCanceled()) break;
            iProgressMonitor.setTaskName(String.valueOf(Messages.getString((String)"PasteAction_0")) + (n + 1) + SLASH + iResourceArray.length + ")");
            isPasteCancel = false;
            if (!(iResourceArray[n] instanceof IFile)) {
                blArray[n] = false;
            } else {
                final IFile iFile = (IFile)iResourceArray[n];
                iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"PasteAction_3")) + iFile.getName() + "'");
                final File file = new File(iFile.getRawLocation().toOSString());
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TDECoreUtilities.isUnInitializedFile((IFile)iFile) || file.lastModified() == 1L) {
                            try {
                                IProject iProject = iFile.getProject();
                                long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
                                if (l == 0L) {
                                    String string = TDECoreUtilities.getInstance().downloadingUnInitializedElement(iFile, false);
                                    if (string.length() != 0) {
                                        MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"PasteAction.3"), (String)string);
                                        isPasteCancel = true;
                                    }
                                } else {
                                    MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"PasteAction.3"), (String)Messages.getString((String)"PasteAction.6"));
                                    OS2200CorePlugin.logger.error((Object)("Network not available: Unable to copy the element " + file.getName() + " as it is not downloaded yet."));
                                    isPasteCancel = true;
                                }
                            }
                            catch (CoreException coreException) {
                                OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
                                isPasteCancel = true;
                            }
                        }
                    }
                });
                if (isPasteCancel) {
                    blArray[n] = false;
                } else {
                    String string = iFile.getFileExtension();
                    String string2 = OS2200ProjectUpdate.getCharConversion((IFile)iFile);
                    if (string == null) {
                        string = "";
                    }
                    blArray[n] = PasteAction.startFileCopy(file, string, string2, arrayList, iProgressMonitor);
                    if (iProgressMonitor.isCanceled()) break;
                }
            }
            ++n;
        }
        PasteAction.addAndUpdateProjectTree(arrayList);
        iProgressMonitor.done();
        PasteAction.resetGlobalVars();
        return blArray;
    }

    private static boolean startFileCopy(File file, String string, String string2, ArrayList<ElementSelectionObject> arrayList, IProgressMonitor iProgressMonitor) {
        Object object;
        String string3;
        block14: {
            Object object2;
            if (iProgressMonitor.isCanceled()) {
                return false;
            }
            nativeName = file.getName();
            if (nativeName.contains(PERIOD)) {
                nativeName = nativeName.replace(PERIOD, SLASH);
            }
            destinationPath = OS2200FileInterface.getCIFSDir((IProject)destPrj);
            if (!OS2200FileInterface.verifyEltName((String)nativeName)) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OS2200FileNameConflictDialog oS2200FileNameConflictDialog = new OS2200FileNameConflictDialog(new Shell(), nativeName, destinationPath);
                        if (oS2200FileNameConflictDialog.open() == 0) {
                            nativeName = oS2200FileNameConflictDialog.geteltName();
                        } else {
                            isPasteCancel = true;
                        }
                    }
                });
            } else {
                object2 = new File(String.valueOf(destinationPath) + File.separator + nativeName.replace(SLASH, PERIOD));
                if (((File)object2).exists() && !isApplyAllChecked) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReplacePasteDialog replacePasteDialog = new ReplacePasteDialog(new Shell(), nativeName, destinationPath, isApplyAllButtonEnabled);
                            if (replacePasteDialog.open() == 0) {
                                nativeName = replacePasteDialog.geteltName();
                                isApplyAllChecked = replacePasteDialog.getApplyAllSelection();
                            } else {
                                isPasteCancel = true;
                            }
                        }
                    });
                }
            }
            if (isPasteCancel || iProgressMonitor.isCanceled()) {
                return false;
            }
            try {
                object2 = file.getPath();
                string3 = String.valueOf(destinationPath) + File.separator + nativeName.replace(SLASH, PERIOD);
                int n = PasteAction.fileCopy((String)object2, string3, iProgressMonitor);
                if (n == 1) break block14;
                return false;
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)("error while Pasting files to destination. " + exception.getMessage()), (Throwable)exception);
                return false;
            }
        }
        ElementSelectionObject elementSelectionObject = null;
        String string4 = nativeName.replace(SLASH, PERIOD);
        String string5 = nativeName.replace(SLASH, HYPHEN);
        if (PasteAction.hasSupportedEditorType(string4)) {
            object = string5.substring(string5.lastIndexOf(HYPHEN) + 1);
            string5 = string.length() > 0 && !((String)object).equalsIgnoreCase(string) ? String.valueOf(string5) + PERIOD + string : string4;
        } else if (string.length() > 0) {
            string5 = String.valueOf(string5) + PERIOD + string;
        }
        if (string2.length() > 0) {
            string2 = "<NONE>";
        }
        elementSelectionObject = new ElementSelectionObject(string4, string5, string, "", string2);
        arrayList.add(elementSelectionObject);
        object = new File(string3);
        Path path = TDECoreUtilities.getFullProjectpath((Path)new Path(string3));
        if (path != null) {
            File file2 = new File(path.toOSString());
            TDECoreUtilities.getInstance().copyToLocal((File)object, file2);
        }
        iProgressMonitor.worked(1);
        return true;
    }

    private static void addAndUpdateProjectTree(ArrayList<ElementSelectionObject> arrayList) {
        try {
            ArrayList<ElementSelectionObject> arrayList2 = new ArrayList<ElementSelectionObject>();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            IResource[] iResourceArray = destPrj.members();
            int n = 0;
            while (n < iResourceArray.length) {
                hashMap.put(iResourceArray[n].getRawLocation().lastSegment().toUpperCase(), n);
                ++n;
            }
            n = -1;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Integer n3 = (Integer)hashMap.get(arrayList.get((int)n2).elementName.toUpperCase());
                if (n3 != null) {
                    n = n3;
                    OS2200CorePlugin.logger.info((Object)("The link for the added element " + arrayList.get((int)n2).elementName + " already exists in the project " + destPrj.getName() + " as " + destPrj.members()[n].getName()));
                } else {
                    arrayList2.add(arrayList.get(n2));
                }
                if (arrayList2 != null && arrayList2.size() > 0) {
                    OS2200ProjectUpdate.addLinks((IProject)destPrj, arrayList2, (IProgressMonitor)new NullProgressMonitor());
                }
                ++n2;
            }
            destPrj.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.warn((Object)("Exception adding links and refreshing." + coreException.getMessage()), (Throwable)coreException);
        }
    }

    private static boolean hasSupportedEditorType(String string) {
        string = string.substring(string.indexOf(PERIOD) + 1);
        String[] stringArray = SUPPORTED_EDITORS.split(COMMA);
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static ElementSelectionObject convertPcNameTo2200Name(String string) {
        Object object;
        Display display;
        String string2;
        File file = new File(string);
        String string3 = file.getName();
        String string4 = PasteAction.getName(string3);
        String string5 = PasteAction.getExtension(string3);
        String string6 = PasteAction.sanitizeFor2200(string4);
        String string7 = PasteAction.sanitizeFor2200(string5);
        String string8 = string6;
        String string9 = string6;
        String string10 = "";
        if (string7 != "") {
            string9 = String.valueOf(string9) + PERIOD + string7.toUpperCase();
        }
        if ((string2 = OS2200FileInterface.checkForTypeMatch((String)string9)).equalsIgnoreCase(string7)) {
            string10 = string9;
            string9 = string6;
        } else if (string7.length() == 0) {
            string10 = String.valueOf(string6) + PERIOD + string2;
            string9 = string6;
        } else {
            string10 = String.valueOf(string6) + HYPHEN + string7 + PERIOD + string2;
            string8 = String.valueOf(string6) + SLASH + string7;
        }
        diag = 0;
        if (!string6.equals(string4) || !string7.equals(string5)) {
            display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            object = display;
            sEltname = string8;
            sLinkName = string10;
            display.syncExec(new Runnable((Display)object){
                private final /* synthetic */ Display val$ddf;
                {
                    this.val$ddf = display;
                }

                @Override
                public void run() {
                    Shell shell = this.val$ddf.getActiveShell();
                    ModalTextDialog modalTextDialog = new ModalTextDialog(shell, Messages.getString((String)"PasteAction.7"), String.valueOf(Messages.getString((String)"PasteAction.8")) + " ", sEltname, sLinkName, 3);
                    diag = modalTextDialog.open();
                    if (diag == 0) {
                        sEltname = modalTextDialog.getText1().trim();
                        sLinkName = modalTextDialog.getLink();
                    }
                }
            });
            string9 = PasteAction.makeCifsName(sEltname);
            string10 = sLinkName;
            string2 = OS2200FileInterface.checkForTypeMatch((String)sLinkName);
        }
        if (diag == 0) {
            display = new ElementSelectionObject(string9, string10, string2);
            display.ConvName = null;
            return display;
        }
        display = ResourcesPlugin.getWorkspace();
        if (display != null && (object = display.getRoot().getLocation().toFile()) != null && file.getAbsolutePath().contains(((File)object).toString())) {
            String string11 = System.getProperty("java.io.tmpdir");
            try {
                int n = PasteAction.fileCopy(string, String.valueOf(string11) + string3, (IProgressMonitor)new NullProgressMonitor());
                File file2 = new File(String.valueOf(string11) + string3);
                if (n == 1) {
                    PasteAction.openTempFile(file2, string);
                    File file3 = new File(string);
                    if (!file3.delete()) {
                        OS2200CorePlugin.logger.info((Object)(String.valueOf(file2.getName()) + " Delete operation is failed."));
                    }
                } else {
                    MessageDialog.openInformation((Shell)PasteAction.getShell(), (String)Messages.getString((String)"PasteAction.9"), (String)("'" + file2.getName() + "'" + " " + Messages.getString((String)"PasteAction.10")));
                }
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.info((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
            }
        }
        return null;
    }

    private static boolean openTempFile(final File file, String string) {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart iEditorPart;
                IWorkbenchPage iWorkbenchPage;
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null) {
                    boolean bl = iWorkbenchPage.closeEditor(iEditorPart, false);
                    if (bl) {
                        String string = OS2200FileInterface.getEditorId((File)file);
                        if (string != null) {
                            PasteAction.OpenAction(file, string);
                        } else {
                            PasteAction.OpenAction(file, iEditorPart.getSite().getId());
                        }
                    } else {
                        MessageDialog.openInformation((Shell)PasteAction.getShell(), (String)Messages.getString((String)"PasteAction.9"), (String)("'" + file.getName() + "'" + " " + Messages.getString((String)"PasteAction.10")));
                    }
                }
            }
        });
        return true;
    }

    static boolean OpenAction(File file, String string) {
        OS2200CorePlugin.logger.debug((Object)("Opening element : " + file.getPath()));
        IEditorPart iEditorPart = PasteAction.openEditor(file, string);
        if (iEditorPart == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"PasteAction.3"), (String)Messages.getString((String)"PasteAction.11"));
            return false;
        }
        return true;
    }

    private static IEditorPart openEditor(File file, String string) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            IFileStore iFileStore = EFS.getStore((URI)file.toURI());
            IEditorInput iEditorInput = PasteAction.createEditorInput(iFileStore);
            iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, true);
            return iEditorPart;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
            return iEditorPart;
        }
    }

    private static IEditorInput createEditorInput(IFileStore iFileStore) {
        return new OS2200FileEditorInput(iFileStore);
    }

    public static String getName(String string) {
        String string2 = "";
        int n = string.lastIndexOf(PERIOD);
        string2 = n > -1 ? string.substring(0, n) : string;
        return string2;
    }

    public static String getEltName(String string) {
        String string2 = "";
        int n = string.lastIndexOf(SLASH);
        string2 = n > -1 ? string.substring(0, n) : string;
        return string2;
    }

    public static String getExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(PERIOD);
        string2 = n > -1 ? string.substring(n + 1, string.length()) : "";
        return string2;
    }

    public static String getVersion(String string) {
        String string2 = "";
        int n = string.lastIndexOf(SLASH);
        string2 = n > -1 ? string.substring(n + 1, string.length()) : "";
        return string2;
    }

    static String makeCifsName(String string) {
        String string2 = PasteAction.getEltName(string);
        String string3 = PasteAction.getVersion(string);
        if (string3.equals("")) {
            return string2;
        }
        return String.valueOf(string2) + PERIOD + string3;
    }

    private static String sanitizeFor2200(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        String string3 = string.toUpperCase();
        int n = 0;
        while (n < string3.length()) {
            Character c = Character.valueOf(string3.charAt(n));
            String string4 = string.substring(n, n + 1);
            if ((Character.isLetterOrDigit(c.charValue()) || c.equals(new Character('$'))) && (string2 = String.valueOf(string2) + string4).length() == 12) break;
            ++n;
        }
        return string2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int fileCopy(String string, String string2, IProgressMonitor iProgressMonitor) throws IOException {
        File file;
        File file2;
        OS2200CorePlugin.logger.debug((Object)("Copying files from: " + string + "  to: " + string2));
        int n = 65536;
        try {
            file2 = new File(string);
            file = new File(string2);
            iProgressMonitor.subTask(Messages.getString((String)"PasteAction_4"));
            if (!file2.exists()) {
                throw new IOException("No such source file exist ::: " + string);
            }
            if (!file2.isFile()) {
                throw new IOException("Cannot copy directory ::: " + string);
            }
            if (!file2.canRead()) {
                throw new IOException("Source file is unreadable. Please check if " + string + " is readable.");
            }
            if (file.isDirectory()) {
                file = new File(file, file2.getName());
            }
            FileInputStream fileInputStream = null;
            OutputStream outputStream = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            FileChannel fileChannel = null;
            String string3 = Messages.getString((String)"PasteAction_5");
            try {
                try {
                    if (!string.equals(string2)) {
                        fileInputStream = new FileInputStream(string);
                        string3 = Messages.getString((String)"PasteAction_6");
                        outputStream = new FileOutputStream(file);
                        abstractInterruptibleChannel = fileInputStream.getChannel();
                        fileChannel = ((FileOutputStream)outputStream).getChannel();
                        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                        int n2 = (int)((FileChannel)abstractInterruptibleChannel).size();
                        OS2200CorePlugin.logger.info((Object)(" FileInputStream created ::: From file " + file2 + " to file  " + file));
                        if (n2 != 0) {
                            int n3 = 0;
                            if (n2 < byteBuffer.capacity()) {
                                byteBuffer = ByteBuffer.allocate(n2);
                                n = n2;
                            }
                            while (((FileChannel)abstractInterruptibleChannel).read(byteBuffer) != -1) {
                                if (n2 < (n3 += n)) {
                                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"PasteAction_7")) + file.getName() + Messages.getString((String)"PasteAction_8") + n2 + Messages.getString((String)"PasteAction_9") + n2 + Messages.getString((String)"PasteAction_10"));
                                } else if (n2 >= n3) {
                                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"PasteAction_7")) + file.getName() + Messages.getString((String)"PasteAction_8") + n3 + Messages.getString((String)"PasteAction_9") + n2 + Messages.getString((String)"PasteAction_10"));
                                }
                                byteBuffer.flip();
                                IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                                if (iPreferenceStore.getBoolean("EnableControlChar")) {
                                    String string4 = new String(byteBuffer.array(), 0, byteBuffer.array().length, "UTF-8");
                                    Pattern pattern = Pattern.compile("[\\x00]");
                                    Matcher matcher = pattern.matcher("");
                                    matcher.reset(string4);
                                    String string5 = iPreferenceStore.getString("ControlChar");
                                    string4 = matcher.replaceAll(string5);
                                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(string4.getBytes());
                                    fileChannel.write(byteBuffer2);
                                    byteBuffer2.clear();
                                    continue;
                                }
                                fileChannel.write(byteBuffer);
                                byteBuffer.clear();
                            }
                        }
                    }
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    file.setReadable(true, false);
                    file.setExecutable(true, false);
                    file.setWritable(true, false);
                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"PasteAction_7")) + file.getName() + "'");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (fileNotFoundException.getMessage().contains("Access is denied")) {
                        PasteAction.errormsg(String.valueOf(Messages.getString((String)"PasteAction_11")) + file.getName() + Messages.getString((String)"PasteAction_12"));
                    } else {
                        String string6 = Messages.getString((String)"NewOS2200ProjectPageOne.36", (String)string3);
                        ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)fileNotFoundException.getMessage(), (String)string2, (String)string6);
                    }
                    OS2200CorePlugin.logger.error((Object)fileNotFoundException.getLocalizedMessage(), (Throwable)fileNotFoundException);
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            file2 = null;
                            fileInputStream = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (abstractInterruptibleChannel != null) {
                        try {
                            abstractInterruptibleChannel.close();
                            abstractInterruptibleChannel = null;
                            abstractInterruptibleChannel = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            file2 = null;
                            fileInputStream = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (outputStream != null) {
                        try {
                            ((FileOutputStream)outputStream).close();
                            file = null;
                            outputStream = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    return -1;
                }
                catch (Exception exception) {
                    block84: {
                        String string7;
                        block82: {
                            block83: {
                                string7 = null;
                                if (!exception.getMessage().contains("being used by another process")) break block82;
                                PasteAction.errormsg(exception.getMessage());
                                OS2200CorePlugin.logger.error((Object)exception);
                                if (fileInputStream == null) break block83;
                                try {
                                    fileInputStream.close();
                                    file2 = null;
                                    fileInputStream = null;
                                }
                                catch (IOException iOException) {
                                    OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                                }
                            }
                            if (abstractInterruptibleChannel != null) {
                                try {
                                    abstractInterruptibleChannel.close();
                                    abstractInterruptibleChannel = null;
                                    abstractInterruptibleChannel = null;
                                }
                                catch (IOException iOException) {
                                    OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                                }
                            }
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                    file2 = null;
                                    fileInputStream = null;
                                }
                                catch (IOException iOException) {
                                    OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                                }
                            }
                            if (outputStream != null) {
                                try {
                                    ((FileOutputStream)outputStream).close();
                                    file = null;
                                    outputStream = null;
                                }
                                catch (IOException iOException) {
                                    OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                                }
                            }
                            return -1;
                        }
                        if (file.exists()) {
                            file.delete();
                        }
                        string7 = exception.getMessage() != null && exception.getMessage().length() > 0 ? exception.getMessage() : Messages.getString((String)"PasteAction_13");
                        ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)exception.getLocalizedMessage(), (String)string2, (String)string7);
                        OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                        if (fileInputStream == null) break block84;
                        try {
                            fileInputStream.close();
                            file2 = null;
                            fileInputStream = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (abstractInterruptibleChannel != null) {
                        try {
                            abstractInterruptibleChannel.close();
                            abstractInterruptibleChannel = null;
                            abstractInterruptibleChannel = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            file2 = null;
                            fileInputStream = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (outputStream != null) {
                        try {
                            ((FileOutputStream)outputStream).close();
                            file = null;
                            outputStream = null;
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    return -1;
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        file2 = null;
                        fileInputStream = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                }
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                        abstractInterruptibleChannel = null;
                        abstractInterruptibleChannel = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        file2 = null;
                        fileInputStream = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                }
                if (outputStream != null) {
                    try {
                        ((FileOutputStream)outputStream).close();
                        file = null;
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return -1;
        }
        file2 = new File(string2);
        file = new File(string);
        if (file2.exists() && file.exists()) {
            file2.setLastModified(file.lastModified());
        }
        return 1;
    }

    private static void errormsg(String string) {
        if (string != null && string.length() > 0) {
            MessageDialog.openError((Shell)PasteAction.getShell(), (String)Messages.getString((String)"PasteAction.12"), (String)string);
        }
    }

    private static Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        Shell shell = new Shell(display.getActiveShell(), 0);
        return shell;
    }

    private IContainer getContainer() {
        List list = this.getSelectedResources();
        if (list.get(0) instanceof IFile) {
            return ((IFile)list.get(0)).getParent();
        }
        return (IContainer)list.get(0);
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl;
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        final IResource[][] iResourceArrayArray = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
                iResourceArrayArray[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resourceTransfer);
            }
        });
        IResource[] iResourceArray = iResourceArrayArray[0];
        boolean bl2 = bl = iResourceArray != null && iResourceArray.length > 0 && iResourceArray[0].getType() == 4;
        if (bl) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getType() != 4 || !((IProject)iResourceArray[n]).isOpen()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        List list = this.getSelectedNonResources();
        if (list.size() == 1) {
            return false;
        }
        Object object = this.getTarget();
        if (object == null) {
            return false;
        }
        if (BaseActionGroup.is2200Project((IResource)object) && iResourceArray != null && !(iResourceArray[0] instanceof IFile)) {
            return false;
        }
        if (iResourceArray != null) {
            if (object instanceof IFolder) {
                int n = 0;
                while (n < iResourceArray.length) {
                    if (object.equals(iResourceArray[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        TransferData[] transferDataArray = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int n = 0;
        while (n < transferDataArray.length) {
            if (fileTransfer.isSupportedType(transferDataArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static IProject getProj() {
        return destPrj;
    }
}

