/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.OS2200UIStartup;
import com.unisys.tde.ui.views.HostManagerView;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class OpenProjectAction
extends SelectionListenerAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenProjectAction";
    OpenResourceAction openProjAction = null;
    boolean openProject = false;
    private final String HASH = "#";

    public OpenProjectAction(IWorkbenchSite iWorkbenchSite) {
        super(Messages.getString((String)"OpenProjectAction_0"));
        this.openProjAction = new OpenResourceAction((IShellProvider)iWorkbenchSite);
    }

    public void run() {
        List list = this.getSelectedResources();
        try {
            for (Object e : list) {
                if (!(e instanceof IProject)) continue;
                IProject iProject = (IProject)e;
                iProject.open(null);
                iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                String string = properties.getProperty("hostID");
                if (LoginAccount.getLoginAccount((String)string) == null && iProject.isOpen() && iProject.hasNature("com.unisys.tde.core.OS2200")) {
                    IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                    String[] stringArray = iPreferenceStore.getString(iProject.getName()).split("#");
                    StringBuffer stringBuffer = new StringBuffer(Messages.getString((String)"OpenProjectAction.header", (String)iProject.getName()));
                    if (stringArray.length == 3) {
                        stringBuffer.append(Messages.getString((String)"OpenProjectAction.errormsg"));
                        stringBuffer.append(Messages.getString((String)"OpenProjectAction.errormsg.connectionName", (String)stringArray[2]));
                        stringBuffer.append(Messages.getString((String)"OpenProjectAction.errormsg.hostName", (String)stringArray[0]));
                        stringBuffer.append(Messages.getString((String)"OpenProjectAction.errormsg.userID", (String)stringArray[1]));
                    }
                    iProject.close(null);
                    MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"OpenProjectAction.title"), (String)stringBuffer.toString());
                    OS2200CorePlugin.logger.info((Object)stringBuffer.toString());
                    list.remove(e);
                    if (list == null || list.isEmpty()) {
                        return;
                    }
                }
                iProject.close(null);
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        this.openProjAction.selectionChanged((IStructuredSelection)new StructuredSelection(list));
        this.openProjAction.run();
        this.openProject = true;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (this.openProject) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    HostManagerView hostManagerView = OpenProjectAction.this.getHostManagerViewObject();
                    hostManagerView.updateHostManagerView();
                }
            });
            Thread thread = new Thread(Messages.getString((String)"OpenProjectAction_2")){

                @Override
                public void run() {
                    OS2200UIStartup.downloadUnInitializedFile();
                }
            };
            thread.setPriority(1);
            thread.start();
            this.openProject = false;
        }
    }

    private HostManagerView getHostManagerViewObject() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        IViewReference iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.core.views.HostManagerView");
        HostManagerView hostManagerView = null;
        if (iViewReference != null) {
            hostManagerView = (HostManagerView)iViewReference.getView(true);
        }
        if (hostManagerView == null) {
            try {
                hostManagerView = (HostManagerView)iWorkbenchPage.showView("com.unisys.tde.core.views.HostManagerView");
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
        return hostManagerView;
    }

    private OS2200View getOS2200ViewObject() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        IViewReference iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OS2200View");
        OS2200View oS2200View = null;
        if (iViewReference != null) {
            oS2200View = (OS2200View)iViewReference.getView(true);
        }
        if (oS2200View == null) {
            try {
                oS2200View = (OS2200View)iWorkbenchPage.showView("com.unisys.tde.ui.views.OS2200View");
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
        return oS2200View;
    }
}

