/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.actions.BaseActionGroup;
import com.unisys.tde.ui.actions.OpenFileAction;
import com.unisys.tde.ui.views.OS2200View;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenFileActionGroup
extends BaseActionGroup {
    private OpenFileAction openFileAction;

    public OpenFileActionGroup(OS2200View oS2200View) {
        super(oS2200View);
        OS2200CorePlugin.logger.debug((Object)"OpenFileActionGroup enter");
    }

    @Override
    protected void makeActions(IWorkbenchSite iWorkbenchSite) {
        this.openFileAction = new OpenFileAction(this.fSite.getPage());
    }

    @Override
    public void fillContextMenu(IMenuManager iMenuManager) {
        boolean bl;
        OS2200CorePlugin.logger.debug((Object)"OpenFileActionGroup fillContextMenu");
        super.fillContextMenu(iMenuManager);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl2 = !iStructuredSelection.isEmpty() && OpenFileActionGroup.allResourcesAreOfType(iStructuredSelection, 7);
        boolean bl3 = bl = !iStructuredSelection.isEmpty() && OpenFileActionGroup.allResourcesAreOfType(iStructuredSelection, 1);
        if (bl) {
            this.openFileAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.openFileAction);
            this.fillOpenWithMenu(iMenuManager, iStructuredSelection);
        }
        if (bl2) {
            this.addNewWindowAction(iMenuManager, iStructuredSelection);
        }
    }

    private void fillOpenWithMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        OS2200CorePlugin.logger.debug((Object)"OpenFileActionGroup fillOpenWithMenu");
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IFile)) {
            return;
        }
        MenuManager menuManager = new MenuManager(Messages.getString((String)"OpenFileActionGroup_0"));
        menuManager.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)((IFile)object)));
        iMenuManager.add((IContributionItem)menuManager);
    }

    private void addNewWindowAction(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        OS2200CorePlugin.logger.debug((Object)"OpenFileActionGroup addNewWindowAction");
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IContainer)) {
            return;
        }
        if (object instanceof IProject && !((IProject)object).isOpen()) {
            return;
        }
        iMenuManager.add((IAction)new OpenInNewWindowAction(myView.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
        IResource iResource;
        OS2200CorePlugin.logger.debug((Object)"OpenFileActionGroup runDefaultAction");
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAdaptable && (iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) instanceof IFile) {
            this.openFileAction.selectionChanged(iStructuredSelection);
            this.openFileAction.run();
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.openFileAction.selectionChanged(iStructuredSelection);
    }
}

