/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import java.io.File;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenExternalFileWithAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private final String extType = "xmi,xml,html,xhtml,htm,ant,C,cpp,cc,c++,for,fix,h,css,java,f77,f90,f95,f03";
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            String string = ((IEditorDescriptor)object).getLabel();
            String string2 = ((IEditorDescriptor)object2).getLabel();
            return this.collator.compare(string, string2);
        }
    };
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private IWorkbenchWindow fWindow;
    private File file;

    public OpenExternalFileWithAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private File queryFile() {
        FileDialog fileDialog = new FileDialog(this.fWindow.getShell(), 4096);
        fileDialog.setText(Messages.getString((String)"OpenExternalFileWithAction.0"));
        String string = fileDialog.open();
        if (string != null && string.length() > 0) {
            return new File(string);
        }
        return null;
    }

    public void run() {
        OS2200CorePlugin.logger.debug((Object)"Entering OEFWA run");
        this.file = this.queryFile();
        if (this.file != null && this.file.exists()) {
            if (MemChecker.getInstance().isLargeFile(this.file, true)) {
                return;
            }
            this.findEditors(this.file);
        } else if (this.file != null) {
            String string = Messages.getString((String)"OpenExternalFileWithAction.2", (String)this.file.getName());
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Messages.getString((String)"OpenExternalFileWithAction.0"), (String)string);
        }
    }

    private IEditorInput createEditorInput(IFileStore iFileStore) {
        return new OS2200FileEditorInput(iFileStore);
    }

    private boolean isTextType(IContentType iContentType) {
        if (iContentType == null) {
            return false;
        }
        IContentType iContentType2 = iContentType;
        while (iContentType2.getBaseType() != null) {
            iContentType2 = iContentType2.getBaseType();
        }
        return iContentType2.getId().equals("org.eclipse.core.runtime.text");
    }

    private ArrayList findEditTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IContentTypeManager iContentTypeManager = Platform.getContentTypeManager();
        IContentType[] iContentTypeArray = iContentTypeManager.getAllContentTypes();
        int n = 0;
        while (n < iContentTypeArray.length) {
            IContentType iContentType = iContentTypeArray[n];
            IContentType iContentType2 = iContentType.getBaseType();
            if (iContentType2 != null && this.isTextType(iContentType2)) {
                String[] stringArray = iContentType.getFileSpecs(8);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if ("xmi,xml,html,xhtml,htm,ant,C,cpp,cc,c++,for,fix,h,css,java,f77,f90,f95,f03".contains(stringArray[n2])) {
                        arrayList.add(stringArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    private void findEditors(File file) {
        IEditorDescriptor iEditorDescriptor;
        Object object;
        ArrayList arrayList = null;
        Menu menu = new Menu((Control)this.fWindow.getShell());
        IEditorDescriptor iEditorDescriptor2 = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor iEditorDescriptor3 = this.registry.getDefaultEditor(file.getName());
        IFileEditorMapping[] iFileEditorMappingArray = this.registry.getFileEditorMappings();
        boolean bl = false;
        ArrayList<IEditorDescriptor> arrayList2 = new ArrayList<IEditorDescriptor>();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            object = iFileEditorMappingArray[n];
            iEditorDescriptor = object.getEditors();
            Collections.sort(Arrays.asList(iEditorDescriptor), comparer);
            int n2 = 0;
            while (n2 < ((IEditorDescriptor[])iEditorDescriptor).length) {
                IEditorDescriptor iEditorDescriptor4 = iEditorDescriptor[n2];
                if (!arrayList2.contains(iEditorDescriptor4)) {
                    this.createMenuItem(menu, iEditorDescriptor4, iEditorDescriptor3);
                    if (iEditorDescriptor2 != null && iEditorDescriptor4.getId().equals(iEditorDescriptor2.getId())) {
                        bl = true;
                    }
                    arrayList2.add(iEditorDescriptor4);
                }
                ++n2;
            }
            ++n;
        }
        arrayList = this.findEditTypes();
        n = 0;
        while (n < arrayList.size()) {
            object = (String)arrayList.get(n);
            iEditorDescriptor = this.registry.getDefaultEditor("foo." + (String)object);
            if (iEditorDescriptor != null && !arrayList2.contains(iEditorDescriptor)) {
                this.createMenuItem(menu, iEditorDescriptor, iEditorDescriptor3);
                if (iEditorDescriptor2 != null && iEditorDescriptor.getId().equals(iEditorDescriptor2.getId())) {
                    bl = true;
                }
                arrayList2.add(iEditorDescriptor);
            }
            ++n;
        }
        if (arrayList2.size() > 0) {
            new MenuItem(menu, 2);
        }
        if (!bl && iEditorDescriptor2 != null) {
            this.createMenuItem(menu, iEditorDescriptor2, iEditorDescriptor3);
        }
        IEditorDescriptor iEditorDescriptor5 = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, iEditorDescriptor5, iEditorDescriptor3);
        iEditorDescriptor5 = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        if (iEditorDescriptor5 != null) {
            this.createMenuItem(menu, iEditorDescriptor5, iEditorDescriptor3);
        }
        menu.setVisible(true);
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor iEditorDescriptor, IEditorDescriptor iEditorDescriptor2) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            if (menuItemArray[n].getText().compareTo(iEditorDescriptor.getLabel()) == 0) {
                return;
            }
            ++n;
        }
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean bl = iEditorDescriptor2 != null && iEditorDescriptor.getId().equals(iEditorDescriptor2.getId());
        menuItem.setSelection(bl);
        menuItem.setText(iEditorDescriptor.getLabel());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenExternalFileWithAction.this.openEditor(iEditorDescriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void openEditor(IEditorDescriptor iEditorDescriptor) {
        IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
        try {
            String string = iEditorDescriptor == null ? "org.eclipse.ui.systemExternalEditor" : iEditorDescriptor.getId();
            IFileStore iFileStore = EFS.getStore((URI)this.file.toURI());
            IEditorInput iEditorInput = this.createEditorInput(iFileStore);
            if (iEditorInput instanceof OS2200FileEditorInput) {
                ((OS2200FileEditorInput)iEditorInput).setEditorid(string);
            }
            iWorkbenchPage.openEditor(iEditorInput, string, true);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

