/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200NonExistingFileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.tde.ui.UiPlugin;
import com.unisys.tde.ui.actions.OS2200SearchAction;
import com.unisys.tde.ui.actions.OS2200SearchObject;
import com.unisys.tde.ui.actions.OS2200SearchView;
import com.unisys.tde.ui.views.OFCSView;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.tde.ui.views.OS2200WorkFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OS2200SearchUI
extends DialogPage
implements ISearchPage {
    private String selected;
    private static Combo inputCombo;
    private Combo noOfLineCombo;
    private Label tmpLb;
    private List<String> list = new ArrayList<String>();
    private List<List> listDetail = new ArrayList<List>();
    private String eltName;
    private Button caseSensitiveBtn;
    private Button openEditorBtn;
    OS2200SearchView eView = null;
    private Button wholeWordBtn;
    private Button noOfLineBtn;
    private Button selectResourceBtn;
    private Group scopeGroup;
    private String searchedString;
    private String searchedStringInput;
    private Button regExpBtn;
    private Boolean isCaseSensitive = false;
    private Boolean isregExp = false;
    private Boolean isMatchWholeWord = false;
    private Boolean isExpand = false;
    private Boolean isSelectedResource = false;
    private String charConv = "";
    int numberOfLine;
    private IWorkbenchPage pg = null;
    private int loop = 0;
    private String[] wholecontent = null;
    private int noOfSearch;
    private String filePath = null;
    private static List<Object> listOfElement;
    private HashSet<IFile> listOfIFile;
    private String selectedPath = null;
    private static String scope;
    private final String SEARCHLIST = "Search List";
    private final String ISEXPANDCHECK = "Expand Check";
    private final String EXPANDLEVEL = "Expand Level";
    private IDialogSettings workbenchSettings = null;
    private IDialogSettings configServerSection = null;
    private static int session;
    private int checkSession = 0;
    private final String OS2200_View_ID = "com.unisys.tde.ui.views.OS2200View";
    private final String CancelOprration = "operation canceled";
    private boolean isSelectedAllOpenEditor;
    public static HashMap<String, Object> searchDetailMap;
    private Thread OS2200Search = null;
    private Job searchjob = null;
    private OS2200FileEditorInput OS2200EdiInput = null;
    private final int MAXSEARCH = 500;
    private static ToolTip infoToolTip;
    private static Shell parentShell;
    private List<String> bigFileList = new ArrayList<String>();
    private List<String> accessDeniedFileList = new ArrayList<String>();
    private List<String> errorFileList = new ArrayList<String>();
    private int shareState = 0;
    Listener sellListener = new Listener(){

        public void handleEvent(Event event) {
            infoToolTip.setVisible(false);
        }
    };
    SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (OS2200SearchUI.this.noOfLineBtn.getSelection()) {
                OS2200SearchUI.this.noOfLineCombo.setEnabled(true);
            } else {
                OS2200SearchUI.this.noOfLineCombo.setEnabled(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener wholeWordselectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (OS2200SearchUI.this.wholeWordBtn.getSelection()) {
                OS2200SearchUI.this.regExpBtn.setSelection(false);
                OS2200SearchUI.this.regExpBtn.setEnabled(false);
            } else {
                OS2200SearchUI.this.regExpBtn.setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    static {
        session = 0;
        searchDetailMap = new HashMap();
    }

    public OS2200SearchUI() {
    }

    public OS2200SearchUI(String string) {
        super(string);
    }

    public boolean performAction() {
        if (inputCombo.getText().length() == 0) {
            OS2200SearchUI.setBallonTooltip(Messages.getString((String)"OS2200SearchUI.15"));
            return false;
        }
        if (!this.openEditorBtn.getEnabled() && !this.selectResourceBtn.getEnabled()) {
            infoToolTip.setMessage(Messages.getString((String)"OS2200SearchUI.2"));
            infoToolTip.setLocation(this.scopeGroup.toDisplay(this.scopeGroup.getSize()));
            infoToolTip.setVisible(true);
            return false;
        }
        if (listOfElement != null) {
            listOfElement.clear();
        }
        this.setUserSelection();
        this.setSearchString(inputCombo.getText());
        this.searchedStringInput = inputCombo.getText();
        this.OS2200Search = new Thread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (OS2200SearchUI.this.enableOS2200SearchView() && OS2200SearchUI.this.searchedString != null && OS2200SearchUI.this.searchedString.length() > 0) {
                            session = session + 1;
                            OS2200SearchUI.this.checkSession = session;
                            if (OS2200SearchUI.this.isSelectedResource.booleanValue()) {
                                if (OS2200SearchAction.selectedResource.name().equals("SelectedFromProject")) {
                                    scope = Messages.getString((String)"OS2200SearchUI_3");
                                    OS2200SearchUI.this.searchWhichLinkedWithProject(OS2200SearchUI.this.searchedString);
                                } else if (OS2200SearchAction.selectedResource.name().equals("SelectedFromOFCS")) {
                                    scope = Messages.getString((String)"OS2200SearchUI_4");
                                    OS2200SearchUI.this.searchWhichLinkedWithOFCS(OS2200SearchUI.this.searchedString);
                                } else if (OS2200SearchAction.selectedResource.name().equals("CurrentEditor")) {
                                    OS2200SearchUI.this.currentEditorSearch(OS2200SearchUI.this.pg, OS2200SearchUI.this.searchedString);
                                }
                            } else if (OS2200SearchUI.this.isSelectedAllOpenEditor) {
                                scope = Messages.getString((String)"OS2200SearchUI_5");
                                OS2200SearchUI.this.searchFromAllOpenEditors(OS2200SearchUI.this.pg, OS2200SearchUI.this.searchedString);
                            } else {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OS2200SearchUI.1"), (String)Messages.getString((String)"OS2200SearchUI.2"));
                            }
                        }
                    }
                });
            }
        });
        this.OS2200Search.start();
        this.storeValues();
        return true;
    }

    private void infoAftersearchFinish() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Object object;
                if (OS2200SearchView.nodes.isEmpty()) {
                    object = new OS2200SearchView();
                    ((OS2200SearchView)((Object)object)).setNoFoundHeader(OS2200SearchUI.this.searchedStringInput, scope);
                }
                if (!(OS2200SearchUI.this.bigFileList.isEmpty() && OS2200SearchUI.this.accessDeniedFileList.isEmpty() && OS2200SearchUI.this.errorFileList.isEmpty())) {
                    int n;
                    object = new StringBuffer();
                    ((StringBuffer)object).append(Messages.getString((String)"OS2200SearchUI_0"));
                    if (!OS2200SearchUI.this.bigFileList.isEmpty()) {
                        ((StringBuffer)object).append(Messages.getString((String)"OS2200SearchUI_1"));
                        n = 0;
                        while (n < OS2200SearchUI.this.bigFileList.size() && n < 3) {
                            ((StringBuffer)object).append("\t" + (String)OS2200SearchUI.this.bigFileList.get(n) + "\n");
                            ++n;
                        }
                        if (OS2200SearchUI.this.bigFileList.size() > 3) {
                            ((StringBuffer)object).append("\t" + Messages.getString((String)"OS2200SearchUI_2") + "\n");
                        }
                    }
                    if (!OS2200SearchUI.this.accessDeniedFileList.isEmpty()) {
                        ((StringBuffer)object).append(Messages.getString((String)"OS2200SearchUI_6"));
                        n = 0;
                        while (n < OS2200SearchUI.this.accessDeniedFileList.size() && n < 3) {
                            ((StringBuffer)object).append("\t" + (String)OS2200SearchUI.this.accessDeniedFileList.get(n) + "\n");
                            ++n;
                        }
                        if (OS2200SearchUI.this.accessDeniedFileList.size() > 3) {
                            ((StringBuffer)object).append("\t" + Messages.getString((String)"OS2200SearchUI_2") + "\n");
                        }
                    }
                    if (!OS2200SearchUI.this.errorFileList.isEmpty()) {
                        ((StringBuffer)object).append(Messages.getString((String)"OS2200SearchUI_7"));
                        n = 0;
                        while (n < OS2200SearchUI.this.errorFileList.size() && n < 3) {
                            ((StringBuffer)object).append("\t" + (String)OS2200SearchUI.this.errorFileList.get(n) + "\n");
                            ++n;
                        }
                        if (OS2200SearchUI.this.errorFileList.size() > 3) {
                            ((StringBuffer)object).append("\t" + Messages.getString((String)"OS2200SearchUI_2") + "\n");
                        }
                    }
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OS2200SearchUI.1"), (String)((StringBuffer)object).toString());
                }
            }
        });
    }

    protected void currentEditorSearch(final IWorkbenchPage iWorkbenchPage, final String string) {
        if (iWorkbenchPage != null) {
            this.searchjob = new Job(Messages.getString((String)"OS2200SearchUI.3")){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_8")) + OS2200SearchUI.this.searchedStringInput + "..", -1);
                    final IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
                    OS2200SearchObject oS2200SearchObject = null;
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof FileEditorInput) {
                        OS2200SearchUI.this.filePath = ((FileEditorInput)iEditorInput).getFile().toString();
                        OS2200SearchUI.this.eltName = ((FileEditorInput)iEditorInput).getName();
                        if (MemChecker.getInstance().isLargeFile(new File(((FileEditorInput)iEditorInput).getFile().getRawLocation().toOSString()), false)) {
                            OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                            OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                            OS2200SearchUI.this.infoAftersearchFinish();
                            return Status.CANCEL_STATUS;
                        }
                        oS2200SearchObject = new OS2200SearchObject(iEditorPart, iEditorInput, ((FileEditorInput)iEditorInput).getFile(), OpenEditorType.LinkedToProject);
                    } else if (iEditorInput instanceof OS2200FileEditorInput) {
                        OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
                        OS2200SearchUI.this.filePath = oS2200FileEditorInput.getPath().toOSString();
                        OS2200SearchUI.this.eltName = oS2200FileEditorInput.getName();
                        if (MemChecker.getInstance().isLargeFile(new File(oS2200FileEditorInput.getPath().toOSString()), false)) {
                            OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                            OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                            OS2200SearchUI.this.infoAftersearchFinish();
                            return Status.CANCEL_STATUS;
                        }
                        oS2200SearchObject = new OS2200SearchObject(iEditorPart, oS2200FileEditorInput, oS2200FileEditorInput.getFile(), OpenEditorType.LinkedToOFCS);
                    } else if (iEditorInput instanceof FileStoreEditorInput) {
                        URI uRI = ((FileStoreEditorInput)iEditorInput).getURI();
                        File file = new File(uRI.getPath());
                        OS2200SearchUI.this.filePath = file.getPath();
                        OS2200SearchUI.this.eltName = file.getName();
                        if (MemChecker.getInstance().isLargeFile(file, false)) {
                            OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                            OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                            OS2200SearchUI.this.infoAftersearchFinish();
                            return Status.CANCEL_STATUS;
                        }
                        oS2200SearchObject = new OS2200SearchObject(iEditorPart, iEditorInput, file, OpenEditorType.LocalFile);
                    } else if (iEditorInput instanceof ExternalEditorInput) {
                        URI uRI = ((ExternalEditorInput)iEditorInput).getURI();
                        File file = new File(uRI.getPath());
                        OS2200SearchUI.this.filePath = file.getPath();
                        OS2200SearchUI.this.eltName = file.getName();
                        if (MemChecker.getInstance().isLargeFile(file, false)) {
                            OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                            OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                            OS2200SearchUI.this.infoAftersearchFinish();
                            return Status.CANCEL_STATUS;
                        }
                        oS2200SearchObject = new OS2200SearchObject(iEditorPart, iEditorInput, file, OpenEditorType.LocalFile);
                    } else {
                        if (iEditorInput instanceof OS2200NonExistingFileEditorInput) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OS2200SearchUI.1"), (String)Messages.getString((String)"OS2200SearchUI.4"));
                                }
                            });
                            OS2200SearchUI.this.infoAftersearchFinish();
                            return Status.CANCEL_STATUS;
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OS2200SearchUI.1"), (String)Messages.getString((String)"OS2200SearchUI.5"));
                            }
                        });
                        OS2200SearchUI.this.infoAftersearchFinish();
                        return Status.CANCEL_STATUS;
                    }
                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_9")) + OS2200SearchUI.this.eltName);
                    scope = "'" + OS2200SearchUI.this.eltName.toUpperCase() + "'";
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (iEditorPart instanceof ITextEditor) {
                                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                                IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                                IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
                                OS2200SearchUI.this.wholecontent = iDocument.get().replace("\r", "").split("\n");
                            }
                        }
                    });
                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_9")) + OS2200SearchUI.this.eltName);
                    OS2200SearchUI.this.startSearchOperation(string, oS2200SearchObject, iProgressMonitor);
                    OS2200SearchUI.this.infoAftersearchFinish();
                    return Status.OK_STATUS;
                }
            };
            this.searchjob.setUser(true);
            this.searchjob.schedule();
        }
    }

    protected void searchWhichLinkedWithOFCS(final String string) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                OFCSView oFCSView = OS2200SearchUI.this.getOFEViewObject();
                if (oFCSView != null) {
                    OS2200SearchUI.this.selectedPath = oFCSView.getSelectedFilePath(true);
                    OS2200SearchUI.this.charConv = oFCSView.getCurrentCharConvSelection();
                    OS2200SearchUI.this.shareState = oFCSView.getShareState();
                }
            }
        });
        this.searchjob = new Job(Messages.getString((String)"OS2200SearchUI.3")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Object object;
                iProgressMonitor.beginTask(Messages.getString((String)"OS2200SearchUI_10"), -1);
                if (OS2200SearchUI.this.selectedPath != null && OS2200SearchUI.this.selectedPath.length() > 0) {
                    File file = null;
                    listOfElement = new ArrayList();
                    object = OS2200SearchUI.this.selectedPath.split(",");
                    int n = 0;
                    while (n < ((String[])object).length) {
                        block18: {
                            file = new File(object[n]);
                            if (!file.isDirectory()) {
                                listOfElement.add(file);
                            } else {
                                try {
                                    OS2200SearchUI.this.getListofElementFromDir(file, iProgressMonitor);
                                }
                                catch (Exception exception) {
                                    if (!exception.getMessage().equals("operation canceled")) break block18;
                                    return Status.CANCEL_STATUS;
                                }
                            }
                        }
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++n;
                    }
                }
                iProgressMonitor.beginTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_8")) + OS2200SearchUI.this.searchedStringInput + "..", listOfElement.size());
                int n = 0;
                while (n < listOfElement.size()) {
                    object = new File(listOfElement.get(n).toString());
                    OS2200SearchUI.this.filePath = ((File)object).getAbsolutePath();
                    OS2200SearchUI.this.eltName = ((File)object).getName();
                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_12")) + (n + 1) + " of " + listOfElement.size() + ": " + OS2200SearchUI.this.eltName);
                    if (MemChecker.getInstance().isLargeFile((File)object, false)) {
                        OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                        OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                    } else {
                        try {
                            if (OS2200SearchUI.this.charConv.equals(OS2200CharSetPlugin.JAPANESE)) {
                                String string2 = OS2200FileInterface.readFile((String)OS2200SearchUI.this.filePath);
                                OS2200SearchUI.this.wholecontent = new String(string2.getBytes(), "LETSJ").split("\n");
                            } else if (OS2200SearchUI.this.isMatchWholeWord.booleanValue()) {
                                OS2200SearchUI.this.wholecontent = OS2200FileInterface.readFile((String)OS2200SearchUI.this.filePath).replace("\r", "").split("\n");
                            } else {
                                OS2200SearchUI.this.wholecontent = OS2200FileInterface.readFile((String)OS2200SearchUI.this.filePath).split("\n");
                            }
                            Display.getDefault().syncExec(new Runnable((File)object){
                                private final /* synthetic */ File val$file;
                                {
                                    this.val$file = file;
                                }

                                @Override
                                public void run() {
                                    OFCSView oFCSView = OS2200SearchUI.this.getOFEViewObject();
                                    if (oFCSView != null) {
                                        OS2200SearchUI.this.OS2200EdiInput = oFCSView.getFileEditorInput(this.val$file.toString());
                                    }
                                }
                            });
                            OS2200SearchObject oS2200SearchObject = new OS2200SearchObject(null, OS2200SearchUI.this.OS2200EdiInput, (File)object, OpenEditorType.LinkedToOFCS);
                            OS2200SearchUI.this.startSearchOperation(string, oS2200SearchObject, iProgressMonitor);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            OS2200SearchUI.this.accessDeniedFileList.add(OS2200FileInterface.getPath((String)OS2200SearchUI.this.filePath, (int)OS2200SearchUI.this.shareState));
                            OS2200CorePlugin.logger.info((Object)("OS 2200 Search :" + fileNotFoundException.getMessage()), (Throwable)fileNotFoundException);
                        }
                        catch (IOException iOException) {
                            OS2200SearchUI.this.errorFileList.add(OS2200FileInterface.getPath((String)OS2200SearchUI.this.filePath, (int)OS2200SearchUI.this.shareState));
                            OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                        }
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        iProgressMonitor.worked(1);
                    }
                    ++n;
                }
                OS2200SearchUI.this.infoAftersearchFinish();
                return Status.OK_STATUS;
            }
        };
        this.searchjob.setUser(true);
        this.searchjob.schedule();
    }

    private void getListofElementFromDir(File file, IProgressMonitor iProgressMonitor) throws Exception {
        if (file.listFiles() != null) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (!file2.isDirectory()) {
                    listOfElement.add(file2);
                    if (iProgressMonitor.isCanceled()) {
                        throw new Exception("operation canceled");
                    }
                } else {
                    this.getListofElementFromDir(file2, iProgressMonitor);
                }
                ++n2;
            }
        } else {
            this.accessDeniedFileList.add(OS2200FileInterface.getPath((String)file.getAbsolutePath(), (int)this.shareState));
            OS2200CorePlugin.logger.info((Object)("OS 2200 Search :" + file.getAbsolutePath()));
        }
    }

    protected void cleanData() {
        this.list.clear();
        this.listDetail.clear();
    }

    protected void searchWhichLinkedWithProject(final String string) {
        this.searchjob = new Job(Messages.getString((String)"OS2200SearchUI_11")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(Messages.getString((String)"OS2200SearchUI_10"), -1);
                OS2200SearchUI.this.listOfIFile = this.getListOfSelection();
                if (OS2200SearchUI.this.listOfIFile.size() > 0) {
                    listOfElement = new ArrayList(OS2200SearchUI.this.listOfIFile);
                    iProgressMonitor.beginTask("Searching for pattern: " + OS2200SearchUI.this.searchedStringInput + "..", OS2200SearchUI.this.listOfIFile.size());
                    int n = 0;
                    while (n < OS2200SearchUI.this.listOfIFile.size()) {
                        if (listOfElement.get(n) instanceof IFile) {
                            IFile iFile = (IFile)listOfElement.get(n);
                            OS2200SearchUI.this.filePath = iFile.getFullPath().toOSString();
                            OS2200SearchUI.this.eltName = iFile.getName();
                            iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_12")) + (n + 1) + Messages.getString((String)"OS2200SearchUI_13") + OS2200SearchUI.this.listOfIFile.size() + ": " + OS2200SearchUI.this.eltName);
                            if (MemChecker.getInstance().isLargeFile(new File(iFile.getRawLocation().toOSString()), false)) {
                                OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                                OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                            } else {
                                try {
                                    Object object;
                                    if (iFile.getName().startsWith(" ") || OS2200ProjectUpdate.hasCharConversion((IFile)iFile)) {
                                        object = OS2200FileInterface.readFile((String)iFile.getLocation().toOSString());
                                        OS2200SearchUI.this.wholecontent = new String(((String)object).getBytes(), "LETSJ").split("\n");
                                    } else if (OS2200SearchUI.this.isMatchWholeWord.booleanValue()) {
                                        OS2200SearchUI.this.wholecontent = OS2200FileInterface.readFile((String)iFile.getLocation().toOSString()).replace("\r", "").split("\n");
                                    } else {
                                        OS2200SearchUI.this.wholecontent = OS2200FileInterface.readFile((String)iFile.getLocation().toOSString()).split("\n");
                                    }
                                    object = new OS2200SearchObject(null, null, iFile, OpenEditorType.LinkedToProject);
                                    OS2200SearchUI.this.startSearchOperation(string, (OS2200SearchObject)object, iProgressMonitor);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    OS2200SearchUI.this.accessDeniedFileList.add(OS2200SearchUI.this.filePath);
                                    OS2200CorePlugin.logger.info((Object)("OS 2200 Search :" + fileNotFoundException.getMessage()));
                                }
                                catch (IOException iOException) {
                                    OS2200SearchUI.this.errorFileList.add(OS2200SearchUI.this.filePath);
                                    OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                                }
                                if (iProgressMonitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                iProgressMonitor.worked(1);
                            }
                        }
                        ++n;
                    }
                }
                OS2200SearchUI.this.infoAftersearchFinish();
                return Status.OK_STATUS;
            }

            protected HashSet<IFile> getListOfSelection() {
                IViewReference iViewReference;
                if (OS2200SearchUI.this.pg != null && (iViewReference = OS2200SearchUI.this.pg.findViewReference("com.unisys.tde.ui.views.OS2200View")) != null) {
                    OS2200View oS2200View = (OS2200View)iViewReference.getView(true);
                    if (oS2200View != null) {
                        IStructuredSelection iStructuredSelection = oS2200View.getCurrentSel();
                        if (iStructuredSelection instanceof TreeSelection) {
                            List list = ((TreeSelection)iStructuredSelection).toList();
                            if (list != null && list.size() > 0) {
                                OS2200SearchUI.this.listOfIFile = new HashSet();
                                int n = 0;
                                while (n < list.size()) {
                                    if (list.get(n) instanceof IFile) {
                                        OS2200SearchUI.this.listOfIFile.add((IFile)list.get(n));
                                    } else {
                                        this.getListOfIFile(list.get(n));
                                    }
                                    ++n;
                                }
                                return OS2200SearchUI.this.listOfIFile;
                            }
                        } else {
                            OS2200CorePlugin.logger.debug((Object)Messages.getString((String)"OpenExtFileSearchPageAction.logMsg4"));
                        }
                    }
                    OS2200CorePlugin.logger.debug((Object)Messages.getString((String)"OpenExtFileSearchPageAction.logMsg5"));
                }
                return null;
            }

            private void getListOfIFile(Object object) {
                try {
                    IResource[] iResourceArray = null;
                    if (object instanceof IProject) {
                        iResourceArray = ((IProject)object).members();
                    } else if (object instanceof OS2200WorkFile) {
                        iResourceArray = ((OS2200WorkFile)object).members();
                    }
                    if (iResourceArray != null && iResourceArray.length > 0) {
                        int n = 0;
                        while (n < iResourceArray.length) {
                            if (iResourceArray[n] instanceof IFile && !iResourceArray[n].toString().toLowerCase().endsWith(".project") && !iResourceArray[n].toString().toLowerCase().endsWith(".settings")) {
                                OS2200SearchUI.this.listOfIFile.add((IFile)iResourceArray[n]);
                            }
                            ++n;
                        }
                    }
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.debug((Object)coreException.getMessage(), (Throwable)coreException);
                }
            }
        };
        this.searchjob.setUser(true);
        this.searchjob.schedule();
    }

    private void setUserSelection() {
        this.isCaseSensitive = this.caseSensitiveBtn.getSelection();
        this.isregExp = this.regExpBtn.getSelection();
        this.isMatchWholeWord = this.wholeWordBtn.getSelection();
        this.isExpand = this.noOfLineBtn.getSelection();
        this.isSelectedResource = this.selectResourceBtn.getSelection();
        this.isSelectedAllOpenEditor = this.openEditorBtn.getSelection();
        this.numberOfLine = Integer.parseInt(this.noOfLineCombo.getText());
    }

    public void setSearchString(String string) {
        if (!this.isCaseSensitive.booleanValue()) {
            string = string.toUpperCase();
        }
        if (this.isregExp.booleanValue()) {
            if (string.contains(".")) {
                string = string.replace(".", "\\.");
            }
            if (string.contains("~")) {
                string = string.replaceAll("(^[\\~]|[~])", ".*");
            }
            if (string.contains("?")) {
                string = string.replaceAll("(^[\\?]|[?])", ".");
            }
        }
        this.searchedString = string;
    }

    private void searchFromAllOpenEditors(final IWorkbenchPage iWorkbenchPage, final String string) {
        if (iWorkbenchPage != null) {
            this.searchjob = new Job(Messages.getString((String)"OS2200SearchUI_14")){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    final IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                    iProgressMonitor.beginTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_15")) + OS2200SearchUI.this.searchedStringInput + "..", iEditorReferenceArray.length);
                    OS2200SearchUI.this.loop = 0;
                    while (OS2200SearchUI.this.loop < iEditorReferenceArray.length) {
                        block14: {
                            IEditorInput iEditorInput = null;
                            OS2200SearchObject oS2200SearchObject = null;
                            try {
                                File file;
                                Object object;
                                iEditorInput = iEditorReferenceArray[OS2200SearchUI.this.loop].getEditorInput();
                                if (iEditorInput instanceof FileEditorInput) {
                                    OS2200SearchUI.this.filePath = ((FileEditorInput)iEditorInput).getFile().toString();
                                    OS2200SearchUI.this.eltName = ((FileEditorInput)iEditorInput).getName();
                                    if (MemChecker.getInstance().isLargeFile(new File(((FileEditorInput)iEditorInput).getFile().getRawLocation().toOSString()), false)) {
                                        OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                                        OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                                        return Status.CANCEL_STATUS;
                                    }
                                    oS2200SearchObject = new OS2200SearchObject(null, iEditorInput, ((FileEditorInput)iEditorInput).getFile(), OpenEditorType.LinkedToProject);
                                } else if (iEditorInput instanceof OS2200FileEditorInput) {
                                    object = (OS2200FileEditorInput)iEditorInput;
                                    OS2200SearchUI.this.filePath = object.getPath().toOSString();
                                    OS2200SearchUI.this.eltName = object.getName();
                                    if (MemChecker.getInstance().isLargeFile(new File(object.getPath().toOSString()), false)) {
                                        OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                                        OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                                        return Status.CANCEL_STATUS;
                                    }
                                    oS2200SearchObject = new OS2200SearchObject(iEditorReferenceArray[OS2200SearchUI.this.loop].getEditor(true), (OS2200FileEditorInput)object, object.getFile(), OpenEditorType.LinkedToOFCS);
                                } else if (iEditorInput instanceof FileStoreEditorInput) {
                                    object = ((FileStoreEditorInput)iEditorInput).getURI();
                                    file = new File(((URI)object).getPath());
                                    OS2200SearchUI.this.filePath = file.getPath();
                                    OS2200SearchUI.this.eltName = file.getName();
                                    if (MemChecker.getInstance().isLargeFile(file, false)) {
                                        OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                                        OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                                        return Status.CANCEL_STATUS;
                                    }
                                    oS2200SearchObject = new OS2200SearchObject(null, iEditorInput, file, OpenEditorType.LocalFile);
                                } else {
                                    if (!(iEditorInput instanceof ExternalEditorInput)) break block14;
                                    object = ((ExternalEditorInput)iEditorInput).getURI();
                                    file = new File(((URI)object).getPath());
                                    OS2200SearchUI.this.filePath = file.getPath();
                                    OS2200SearchUI.this.eltName = file.getName();
                                    if (MemChecker.getInstance().isLargeFile(file, false)) {
                                        OS2200SearchUI.this.bigFileList.add(OS2200SearchUI.this.filePath);
                                        OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + OS2200SearchUI.this.filePath));
                                        return Status.CANCEL_STATUS;
                                    }
                                    oS2200SearchObject = new OS2200SearchObject(null, iEditorInput, file, OpenEditorType.LocalFile);
                                }
                                iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200SearchUI_12")) + (OS2200SearchUI.this.loop + 1) + Messages.getString((String)"OS2200SearchUI_13") + iEditorReferenceArray.length + ": " + OS2200SearchUI.this.eltName);
                            }
                            catch (PartInitException partInitException) {
                                OS2200CorePlugin.logger.debug((Object)partInitException.getMessage(), (Throwable)partInitException);
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IEditorPart iEditorPart = iEditorReferenceArray[OS2200SearchUI.this.loop].getEditor(true);
                                    if (iEditorPart instanceof ITextEditor) {
                                        ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                                        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                                        IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
                                        if (OS2200SearchUI.this.isMatchWholeWord.booleanValue()) {
                                            OS2200SearchUI.this.wholecontent = iDocument.get().replace("\r", "").split("\n");
                                        } else {
                                            OS2200SearchUI.this.wholecontent = iDocument.get().split("\n");
                                        }
                                    }
                                }
                            });
                            OS2200SearchUI.this.startSearchOperation(string, oS2200SearchObject, iProgressMonitor);
                            if (iProgressMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            iProgressMonitor.worked(1);
                        }
                        OS2200SearchUI oS2200SearchUI = OS2200SearchUI.this;
                        oS2200SearchUI.loop = oS2200SearchUI.loop + 1;
                    }
                    OS2200SearchUI.this.infoAftersearchFinish();
                    return Status.OK_STATUS;
                }
            };
            this.searchjob.setUser(true);
            this.searchjob.schedule();
        }
    }

    private void startSearchOperation(String string, OS2200SearchObject oS2200SearchObject, IProgressMonitor iProgressMonitor) {
        int n = 0;
        this.noOfSearch = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.isregExp.booleanValue()) {
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = null;
            if (this.isCaseSensitive.booleanValue()) {
                int n3 = 0;
                while (n3 < this.wholecontent.length) {
                    matcher = pattern.matcher(this.wholecontent[n3]);
                    if (matcher != null && matcher.find()) {
                        this.addInSearchList(this.wholecontent, n, this.numberOfLine);
                        ++this.noOfSearch;
                        if (this.list.size() >= 500) {
                            bl = true;
                            this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
                            n2 = n;
                            this.noOfSearch = 0;
                            if (!this.isMemoryAvailable(n2)) {
                                return;
                            }
                        }
                    }
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    ++n;
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < this.wholecontent.length) {
                    matcher = pattern.matcher(this.wholecontent[n4].toUpperCase());
                    if (matcher != null && matcher.find()) {
                        this.addInSearchList(this.wholecontent, n, this.numberOfLine);
                        ++this.noOfSearch;
                        if (this.list.size() >= 500) {
                            bl = true;
                            this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
                            n2 = n;
                            this.noOfSearch = 0;
                            if (!this.isMemoryAvailable(n2)) {
                                return;
                            }
                        }
                    }
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    ++n;
                    ++n4;
                }
            }
        } else if (this.isMatchWholeWord.booleanValue()) {
            if (this.isCaseSensitive.booleanValue()) {
                int n5 = 0;
                while (n5 < this.wholecontent.length) {
                    if (this.wholecontent[n5].contains(string) && (this.wholecontent[n5].contains(" " + string + " ") || this.wholecontent[n5].endsWith(" " + string) || this.wholecontent[n5].startsWith(String.valueOf(string) + " ") || this.wholecontent[n5].equals(string))) {
                        this.addInSearchList(this.wholecontent, n, this.numberOfLine);
                        ++this.noOfSearch;
                        if (this.list.size() >= 500) {
                            bl = true;
                            this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
                            n2 = n;
                            this.noOfSearch = 0;
                            if (!this.isMemoryAvailable(n2)) {
                                return;
                            }
                        }
                    }
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    ++n;
                    ++n5;
                }
            } else {
                int n6 = 0;
                while (n6 < this.wholecontent.length) {
                    if (this.wholecontent[n6].toString().toUpperCase().contains(string) && (this.wholecontent[n6].toString().toUpperCase().contains(" " + string + " ") || this.wholecontent[n6].toString().toUpperCase().endsWith(" " + string) || this.wholecontent[n6].toString().toUpperCase().startsWith(String.valueOf(string) + " ") || this.wholecontent[n6].toString().toUpperCase().equals(string))) {
                        this.addInSearchList(this.wholecontent, n, this.numberOfLine);
                        ++this.noOfSearch;
                        if (this.list.size() >= 500) {
                            bl = true;
                            this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
                            n2 = n;
                            this.noOfSearch = 0;
                            if (!this.isMemoryAvailable(n2)) {
                                return;
                            }
                        }
                    }
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    ++n;
                    ++n6;
                }
            }
        } else if (this.isCaseSensitive.booleanValue()) {
            int n7 = 0;
            while (n7 < this.wholecontent.length) {
                if (this.wholecontent[n7].contains(string)) {
                    this.addInSearchList(this.wholecontent, n, this.numberOfLine);
                    ++this.noOfSearch;
                    if (this.list.size() >= 500) {
                        bl = true;
                        this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
                        n2 = n;
                        this.noOfSearch = 0;
                        if (!this.isMemoryAvailable(n2)) {
                            return;
                        }
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                ++n;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < this.wholecontent.length) {
                if (this.wholecontent[n8].toString().toUpperCase().contains(string)) {
                    this.addInSearchList(this.wholecontent, n, this.numberOfLine);
                    ++this.noOfSearch;
                    if (this.list.size() >= 500) {
                        bl = true;
                        this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
                        n2 = n;
                        this.noOfSearch = 0;
                        if (!this.isMemoryAvailable(n2)) {
                            return;
                        }
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                ++n;
                ++n8;
            }
        }
        if (this.list.size() > 0) {
            this.addNodeForSearch(n2, n, oS2200SearchObject, bl);
        }
    }

    private boolean isMemoryAvailable(int n) {
        if (!MemChecker.getInstance().hasAtleast20MBFreeMemory()) {
            this.bigFileList.add(String.valueOf(this.filePath) + Messages.getString((String)"OS2200SearchUI_16") + n + Messages.getString((String)"OS2200SearchUI_17"));
            OS2200CorePlugin.logger.info((Object)("OS 2200 Search-Low memory :" + this.filePath + " from line number: " + n + " onwords."));
            return false;
        }
        return true;
    }

    private void addNodeForSearch(final int n, final int n2, OS2200SearchObject oS2200SearchObject, boolean bl) {
        if (bl) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OS2200SearchUI.this.eView.showSearchResult(String.valueOf(OS2200SearchUI.this.eltName) + Messages.getString((String)"OS2200SearchUI_18") + n + Messages.getString((String)"OS2200SearchUI_19") + n2 + ")[" + OS2200SearchUI.this.filePath + "]" + OS2200SearchUI.this.list.size(), OS2200SearchUI.this.list, OS2200SearchUI.this.listDetail, OS2200SearchUI.this.searchedString, OS2200SearchUI.this.searchedStringInput, OS2200SearchUI.this.noOfSearch, scope, OS2200SearchUI.this.isregExp, OS2200SearchUI.this.isCaseSensitive, OS2200SearchUI.this.isMatchWholeWord, OS2200SearchUI.this.checkSession);
                }
            });
            searchDetailMap.put(String.valueOf(this.eltName) + Messages.getString((String)"OS2200SearchUI_20") + n + Messages.getString((String)"OS2200SearchUI_19") + n2 + ")[" + this.filePath + "]" + this.list.size(), oS2200SearchObject);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OS2200SearchUI.this.eView.showSearchResult(String.valueOf(OS2200SearchUI.this.eltName) + "[" + OS2200SearchUI.this.filePath + "]" + OS2200SearchUI.this.list.size(), OS2200SearchUI.this.list, OS2200SearchUI.this.listDetail, OS2200SearchUI.this.searchedString, OS2200SearchUI.this.searchedStringInput, OS2200SearchUI.this.noOfSearch, scope, OS2200SearchUI.this.isregExp, OS2200SearchUI.this.isCaseSensitive, OS2200SearchUI.this.isMatchWholeWord, OS2200SearchUI.this.checkSession);
                }
            });
            searchDetailMap.put(String.valueOf(this.eltName) + "[" + this.filePath + "]" + this.list.size(), oS2200SearchObject);
        }
        this.cleanData();
    }

    public void quickSearch(String string) {
        if (this.enableOS2200SearchView()) {
            this.workbenchSettings = UiPlugin.getDefault().getDialogSettings();
            this.configServerSection = this.workbenchSettings.getSection("OS2200SearchDialog");
            this.checkSession = ++session;
            if (this.configServerSection != null) {
                this.isExpand = this.configServerSection.getBoolean("Expand Check");
                this.numberOfLine = this.configServerSection.getInt("Expand Level") + 1;
            } else {
                this.isExpand = true;
                this.numberOfLine = 2;
            }
            this.searchedStringInput = string;
            OS2200SearchAction.isSelectedResourceEnable = false;
            OS2200SearchAction.selectedResource = OS2200SearchAction.Resource.None;
            this.searchedString = string.toUpperCase();
            this.currentEditorSearch(this.pg, this.searchedString);
        }
    }

    private boolean enableOS2200SearchView() {
        block5: {
            try {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
                this.pg = iWorkbenchWindowArray[0].getActivePage();
                IViewReference iViewReference = this.pg.findViewReference("com.unisys.tde.ui.actions.ExtSearchView");
                if (iViewReference != null) {
                    this.eView = (OS2200SearchView)iViewReference.getView(true);
                }
                if (this.eView == null) {
                    this.eView = (OS2200SearchView)this.pg.showView("com.unisys.tde.ui.actions.ExtSearchView");
                }
                if (this.eView == null) break block5;
                this.pg.showView("com.unisys.tde.ui.actions.ExtSearchView");
                this.eView.cleanview();
                this.list.clear();
                this.bigFileList.clear();
                this.accessDeniedFileList.clear();
                return true;
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.debug((Object)exception.getMessage(), (Throwable)exception);
                return false;
            }
        }
        OS2200CorePlugin.logger.error((Object)"Could not open the search View");
        return false;
    }

    public void dispose() {
        super.dispose();
        parentShell.getDisplay().removeFilter(3, this.sellListener);
        parentShell.getDisplay().removeFilter(1, this.sellListener);
        OS2200SearchAction.isOS2200SearchEnable = false;
    }

    private void addInSearchList(String[] stringArray, int n, int n2) {
        if (this.isExpand.booleanValue()) {
            int n3;
            ArrayList<String> arrayList = new ArrayList<String>(n2 * 2 + 1);
            if (n >= n2) {
                n3 = n2;
                while (n3 > 0) {
                    arrayList.add(String.valueOf(n - (n3 - 1)) + ": " + stringArray[n - n3]);
                    --n3;
                }
            } else {
                n3 = n;
                while (n3 > 0) {
                    arrayList.add(String.valueOf(n - (n3 - 1)) + ": " + stringArray[n - n3]);
                    --n3;
                }
            }
            arrayList.add(String.valueOf(n + 1) + ": " + stringArray[n]);
            if (n < stringArray.length - n2) {
                n3 = 1;
                while (n3 <= n2) {
                    arrayList.add(String.valueOf(n + 1 + n3) + ": " + stringArray[n + n3]);
                    ++n3;
                }
            } else {
                n3 = n + 1;
                while (n3 < stringArray.length) {
                    arrayList.add(String.valueOf(n3 + 1) + ": " + stringArray[n3]);
                    ++n3;
                }
            }
            this.listDetail.add(arrayList);
        }
        this.list.add(String.valueOf(n + 1) + ": " + stringArray[n]);
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        if (iSearchPageContainer.getSelection() instanceof TextSelection) {
            this.selected = ((TextSelection)iSearchPageContainer.getSelection()).getText();
        }
    }

    public void createControl(Composite composite) {
        OS2200SearchAction oS2200SearchAction;
        Label label;
        IWorkbench iWorkbench;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 1;
        GridData gridData4 = new GridData();
        gridData4.widthHint = 125;
        gridData4.horizontalSpan = 1;
        parentShell = composite.getShell();
        this.workbenchSettings = UiPlugin.getDefault().getDialogSettings();
        this.configServerSection = this.workbenchSettings.getSection("OS2200SearchDialog");
        if (!OS2200SearchAction.isOS2200SearchEnable) {
            iWorkbench = PlatformUI.getWorkbench();
            label = iWorkbench.getActiveWorkbenchWindow();
            oS2200SearchAction = new OS2200SearchAction();
            oS2200SearchAction.initiateOS2200SearchDialog((IWorkbenchWindow)label, true);
        }
        infoToolTip = new ToolTip(composite.getShell(), 4098);
        infoToolTip.setText("");
        infoToolTip.setAutoHide(false);
        iWorkbench = new Label(composite, 0);
        iWorkbench.setText(Messages.getString((String)"OS2200SearchUI.6"));
        iWorkbench.setLayoutData((Object)gridData2);
        inputCombo = new Combo(composite, 2048);
        if (this.configServerSection != null && this.configServerSection.getArray("Search List") != null) {
            label = this.configServerSection.getArray("Search List");
            int n = 0;
            while (n < ((String[])label).length) {
                inputCombo.add(label[n]);
                ++n;
            }
        }
        inputCombo.setLayoutData((Object)new GridData(768));
        if (this.selected != null && this.selected.length() > 0) {
            inputCombo.setText(this.selected);
        } else {
            inputCombo.select(0);
        }
        this.caseSensitiveBtn = new Button(composite, 32);
        this.caseSensitiveBtn.setText(Messages.getString((String)"OS2200SearchUI_21"));
        label = new Label(composite, 0);
        label.setText(Messages.getString((String)"OS2200SearchUI.7"));
        this.regExpBtn = new Button(composite, 32);
        this.regExpBtn.setText(Messages.getString((String)"OS2200SearchUI.8"));
        this.tmpLb = new Label(composite, 0);
        this.tmpLb.setText("");
        this.tmpLb.setLayoutData((Object)gridData2);
        this.wholeWordBtn = new Button(composite, 32);
        this.wholeWordBtn.setText(Messages.getString((String)"OS2200SearchUI.9"));
        this.wholeWordBtn.setLayoutData((Object)gridData2);
        this.wholeWordBtn.addSelectionListener(this.wholeWordselectionListener);
        this.tmpLb = new Label(composite, 0);
        this.tmpLb.setText("");
        this.tmpLb.setLayoutData((Object)gridData2);
        oS2200SearchAction = new Group(composite, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.numColumns = 2;
        oS2200SearchAction.setLayout((Layout)gridLayout2);
        GridData gridData5 = new GridData(768);
        gridData5.horizontalSpan = 2;
        oS2200SearchAction.setText(Messages.getString((String)"OS2200SearchUI.10"));
        this.noOfLineBtn = new Button((Composite)oS2200SearchAction, 32);
        this.noOfLineBtn.setText(Messages.getString((String)"OS2200SearchUI.11"));
        this.noOfLineBtn.addSelectionListener(this.selectionListener);
        this.noOfLineCombo = new Combo((Composite)oS2200SearchAction, 2056);
        this.noOfLineCombo.add("1");
        this.noOfLineCombo.add("2");
        this.noOfLineCombo.add("3");
        if (this.configServerSection != null) {
            this.noOfLineBtn.setSelection(this.configServerSection.getBoolean("Expand Check"));
            this.noOfLineCombo.select(this.configServerSection.getInt("Expand Level"));
            this.noOfLineCombo.setEnabled(this.configServerSection.getBoolean("Expand Check"));
        } else {
            this.noOfLineBtn.setSelection(true);
            this.noOfLineCombo.select(1);
        }
        this.tmpLb = new Label(composite, 0);
        this.tmpLb.setText("");
        this.tmpLb.setLayoutData((Object)gridData2);
        this.scopeGroup = new Group(composite, 0);
        GridLayout gridLayout3 = new GridLayout(2, true);
        gridLayout3.numColumns = 2;
        this.scopeGroup.setLayout((Layout)gridLayout3);
        GridData gridData6 = new GridData(768);
        gridData6.horizontalSpan = 2;
        this.scopeGroup.setText(Messages.getString((String)"OS2200SearchUI.12"));
        this.selectResourceBtn = new Button((Composite)this.scopeGroup, 16);
        this.selectResourceBtn.setText(Messages.getString((String)"OS2200SearchUI.13"));
        this.selectResourceBtn.setLayoutData((Object)gridData3);
        if (OS2200SearchAction.isSelectedResourceEnable) {
            this.selectResourceBtn.setSelection(true);
            this.selectResourceBtn.setEnabled(true);
        } else {
            this.selectResourceBtn.setSelection(false);
            this.selectResourceBtn.setEnabled(false);
        }
        this.openEditorBtn = new Button((Composite)this.scopeGroup, 16);
        this.openEditorBtn.setText(Messages.getString((String)"OS2200SearchUI.14"));
        this.openEditorBtn.setLayoutData((Object)gridData3);
        if (OS2200SearchAction.isAllOpenEditorEnable) {
            if (OS2200SearchAction.isSelectedResourceEnable) {
                this.openEditorBtn.setSelection(false);
            } else {
                this.openEditorBtn.setSelection(true);
            }
            this.openEditorBtn.setEnabled(true);
        } else {
            this.openEditorBtn.setSelection(false);
            this.openEditorBtn.setEnabled(false);
        }
        parentShell.getDisplay().addFilter(3, this.sellListener);
        parentShell.getDisplay().addFilter(1, this.sellListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.context_os2200_search");
        this.setControl((Control)composite);
    }

    static void setBallonTooltip(String string) {
        infoToolTip.setMessage(string);
        infoToolTip.setLocation(inputCombo.toDisplay(OS2200SearchUI.inputCombo.getSelection().x + 75, OS2200SearchUI.inputCombo.getSelection().y + 20));
        infoToolTip.setVisible(true);
    }

    private void storeValues() {
        this.workbenchSettings = UiPlugin.getDefault().getDialogSettings();
        this.configServerSection = this.workbenchSettings.getSection("OS2200SearchDialog");
        if (this.configServerSection == null) {
            this.configServerSection = this.workbenchSettings.addNewSection("OS2200SearchDialog");
        }
        this.configServerSection.put("Expand Check", this.isExpand.booleanValue());
        this.configServerSection.put("Expand Level", this.noOfLineCombo.indexOf(this.noOfLineCombo.getText()));
        String string = inputCombo.getText();
        int n = 0;
        while (n < inputCombo.getItemCount()) {
            if (string.equals(inputCombo.getItem(n))) {
                inputCombo.remove(n);
                break;
            }
            ++n;
        }
        if (inputCombo.getItemCount() < 10) {
            inputCombo.add(string, 0);
        } else {
            inputCombo.remove(9);
            inputCombo.add(string, 0);
        }
        this.configServerSection.put("Search List", inputCombo.getItems());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        inputCombo.setFocus();
    }

    private OFCSView getOFEViewObject() {
        IViewReference iViewReference;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null && (iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OFCSView")) != null) {
            OFCSView oFCSView = null;
            oFCSView = (OFCSView)iViewReference.getView(true);
            return oFCSView;
        }
        return null;
    }

    public static enum OpenEditorType {
        LinkedToProject,
        LinkedToOFCS,
        LocalFile,
        None;

    }
}

