/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200NonExistingFileEditorInput;
import com.unisys.tde.ui.views.OFCSView;
import com.unisys.tde.ui.views.OS2200View;
import java.util.List;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OS2200SearchAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private final String OS2200_SEARCH_ID = "org.eclipse.search.ui.openExtSearchDialog";
    private final String OS2200ProjectExplorer = "OS 2200 Explorer";
    private final String OFCSExplorer = "OS 2200 File Explorer";
    private IWorkbenchWindow fWindow;
    public static boolean isOS2200SearchEnable = false;
    public static boolean isSelectedResourceEnable = false;
    public static boolean isAllOpenEditorEnable = false;
    public static Resource selectedResource;
    private final String OS2200_View_ID = "com.unisys.tde.ui.views.OS2200View";

    public OS2200SearchAction() {
        super("OS 2200 Search");
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.ui", (String)"icons/OS2200_Search.png");
        this.setImageDescriptor(imageDescriptor);
        this.setToolTipText(Messages.getString((String)"OpenExtFileSearchPageAction.1"));
    }

    public void run(IAction iAction) {
        this.initiateOS2200SearchDialog(this.fWindow, false);
    }

    public void runWithEvent(Event event) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        this.fWindow = iWorkbench.getActiveWorkbenchWindow();
        this.initiateOS2200SearchDialog(this.fWindow, false);
    }

    public void initiateOS2200SearchDialog(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        Object object;
        Object object2;
        String string = null;
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchWindow == null || iWorkbenchPage == null) {
            SearchPlugin.beep();
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OpenExtFileSearchPageAction.logMsg1"));
            return;
        }
        isSelectedResourceEnable = false;
        isAllOpenEditorEnable = false;
        selectedResource = Resource.None;
        isOS2200SearchEnable = true;
        if (iWorkbenchPage.getEditorReferences().length >= 1) {
            try {
                object2 = iWorkbenchPage.getEditorReferences();
                object = null;
                int n = 0;
                while (n < ((IEditorReference[])object2).length) {
                    object = object2[n].getEditorInput();
                    if (object instanceof FileEditorInput) {
                        isAllOpenEditorEnable = true;
                        break;
                    }
                    if (object instanceof OS2200FileEditorInput) {
                        isAllOpenEditorEnable = true;
                        break;
                    }
                    if (object instanceof FileStoreEditorInput) {
                        isAllOpenEditorEnable = true;
                        break;
                    }
                    if (object instanceof ExternalEditorInput) {
                        isAllOpenEditorEnable = true;
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.debug((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        if ((string = iWorkbenchPage.getActivePart().getTitle().trim()) != null && string.equalsIgnoreCase("OS 2200 Explorer")) {
            List list;
            IStructuredSelection iStructuredSelection;
            object2 = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OS2200View");
            if (object2 != null && (object = (OS2200View)object2.getView(true)) != null && (iStructuredSelection = ((OS2200View)((Object)object)).getCurrentSel()) instanceof TreeSelection && (list = ((TreeSelection)iStructuredSelection).toList()) != null && list.size() > 0) {
                selectedResource = Resource.SelectedFromProject;
                isSelectedResourceEnable = true;
            }
        } else if (string != null && string.equalsIgnoreCase("OS 2200 File Explorer")) {
            object2 = this.getOFEViewObject();
            object = object2.getSelectedFilePath(true);
            if (object != null && ((String)object).length() > 0) {
                selectedResource = Resource.SelectedFromOFCS;
                isSelectedResourceEnable = true;
            }
        } else if (iWorkbenchPage.getActiveEditor() != null && !((object2 = iWorkbenchPage.getActiveEditor().getEditorInput()) instanceof OS2200NonExistingFileEditorInput)) {
            selectedResource = Resource.CurrentEditor;
            isSelectedResourceEnable = true;
        }
        if (!bl) {
            NewSearchUI.openSearchDialog((IWorkbenchWindow)iWorkbenchWindow, (String)"org.eclipse.search.ui.openExtSearchDialog");
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    public static Resource getSelectedResource() {
        return selectedResource;
    }

    private OFCSView getOFEViewObject() {
        IViewReference iViewReference;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null && (iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OFCSView")) != null) {
            OFCSView oFCSView = null;
            oFCSView = (OFCSView)iViewReference.getView(true);
            return oFCSView;
        }
        return null;
    }

    public static enum Resource {
        SelectedFromProject,
        SelectedFromOFCS,
        CurrentEditor,
        None;

    }
}

