/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.ui.actions.PasteAction;
import com.unisys.tde.ui.dialogs.OS2200FileNameConflictDialog;
import com.unisys.tde.ui.dialogs.ReplacePasteDialog;
import com.unisys.tde.ui.utils.UtilsViews;
import com.unisys.tde.ui.views.OFCSView;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OFEPasteAction
extends Action {
    private static boolean isApplyAllChecked = false;
    private static boolean isApplyAllButtonEnabled = false;
    private static String eltName = "";
    private static final String PERIOD = ".";
    private static final String SLASH = "/";
    private static boolean isPasteCancel = false;

    private static void resetGlobalVars() {
        isPasteCancel = false;
        isApplyAllButtonEnabled = false;
        isApplyAllChecked = false;
    }

    public OFEPasteAction() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.ui", (String)"icons/PasteElement.gif");
        this.setImageDescriptor(imageDescriptor);
        this.setToolTipText(Messages.getString((String)"OFEPasteAction.Topic"));
    }

    public void run() {
        OS2200CorePlugin.logger.debug((Object)("Executing menu \"" + this.getText() + "\" in OFE."));
        this.pasteMenuAction();
    }

    private void pasteMenuAction() {
        OS2200CorePlugin.logger.debug((Object)"Inside the Paste menu action.");
        OFCSView oFCSView = UtilsViews.getOFEViewObject();
        if (oFCSView.isConnected(true)) {
            String string = oFCSView.getSelectedDir();
            if (string != null && string.length() > 0) {
                File file = new File(string);
                if (file.isDirectory()) {
                    this.pasteFileAction(file);
                } else {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OFEPasteAction.info"), (String)Messages.getString((String)"OFEPasteAction.isNotDir"));
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(file.getAbsolutePath()) + " is not a directory."));
                }
            } else {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OFEPasteAction.info"), (String)Messages.getString((String)"OFEPasteAction.isNotDir"));
                OS2200CorePlugin.logger.info((Object)"Selected directory might be null or length zero.");
            }
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OFEPasteAction.info"), (String)Messages.getString((String)"OFEPasteAction.hostNotConnected"));
            OS2200CorePlugin.logger.info((Object)"Error while connecting the Host.");
        }
    }

    private void pasteFileAction(final File file) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Clipboard clipboard = new Clipboard(display);
        FileTransfer fileTransfer = FileTransfer.getInstance();
        final String[] stringArray = (String[])clipboard.getContents((Transfer)fileTransfer);
        clipboard.dispose();
        if (stringArray != null) {
            OFEPasteAction.resetGlobalVars();
            if (!OFCSView.doesSelectionContainsDir(stringArray).booleanValue()) {
                Job job = new Job(Messages.getString((String)"OFEPasteAction.pasteJob")){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask(Messages.getString((String)"OFEPasteAction.pasteOperation"), stringArray.length);
                        OFEPasteAction.this.startFileCopy(file, stringArray, iProgressMonitor);
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                OFCSView oFCSView = UtilsViews.getOFEViewObject();
                                oFCSView.refreshList();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            } else {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OFEPasteAction.info"), (String)Messages.getString((String)"OFEPasteAction.copyPasteOperation"));
            }
        }
    }

    private IStatus startFileCopy(final File file, String[] stringArray, IProgressMonitor iProgressMonitor) {
        int n = 0;
        while (n < stringArray.length) {
            block13: {
                isPasteCancel = false;
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    File file2;
                    if (stringArray.length > 1) {
                        isApplyAllButtonEnabled = true;
                    }
                    if (!(file2 = new File(stringArray[n])).exists()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                OS2200CorePlugin.logger.error((Object)("'" + file2.getName() + "' does not exist"));
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OFEPasteAction.error"), (String)Messages.getString((String)"OFEPasteAction.errorMsg", (String)file2.getName()));
                                isPasteCancel = true;
                            }
                        });
                    }
                    if (isPasteCancel) break block13;
                    eltName = file2.getName();
                    File file3 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + eltName);
                    if (file2.getAbsolutePath().equals(file3.getAbsolutePath())) {
                        OS2200CorePlugin.logger.info((Object)"preventing creating stream if sorce and destination is same");
                        break block13;
                    }
                    if (eltName.contains(PERIOD)) {
                        eltName = eltName.replace(PERIOD, SLASH);
                    }
                    if (!OS2200FileInterface.verifyEltName((String)eltName)) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                OS2200FileNameConflictDialog oS2200FileNameConflictDialog = new OS2200FileNameConflictDialog(new Shell(), eltName, file.getAbsolutePath());
                                if (oS2200FileNameConflictDialog.open() == 0) {
                                    eltName = oS2200FileNameConflictDialog.geteltName();
                                } else {
                                    isPasteCancel = true;
                                }
                            }
                        });
                    } else if (file3.exists() && !isApplyAllChecked) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ReplacePasteDialog replacePasteDialog = new ReplacePasteDialog(new Shell(), eltName, file.getAbsolutePath(), isApplyAllButtonEnabled);
                                if (replacePasteDialog.open() == 0) {
                                    eltName = replacePasteDialog.geteltName();
                                    isApplyAllChecked = replacePasteDialog.getApplyAllSelection();
                                } else {
                                    isPasteCancel = true;
                                }
                            }
                        });
                    }
                    if (eltName.contains(SLASH)) {
                        eltName = eltName.replace(SLASH, PERIOD);
                    }
                    file3 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + eltName);
                    if (isPasteCancel) break block13;
                    if (PasteAction.fileCopy(file2.getAbsolutePath(), file3.getAbsolutePath(), iProgressMonitor) == -1) {
                        iProgressMonitor.setCanceled(true);
                    }
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                }
                iProgressMonitor.worked(1);
            }
            ++n;
        }
        return null;
    }
}

