/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.utils.UtilsViews;
import com.unisys.tde.ui.views.OFCSView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OFECopyAction
extends Action {
    private final String COMMA = ",";

    public OFECopyAction() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.ui", (String)"icons/CopyElement.gif");
        this.setImageDescriptor(imageDescriptor);
        this.setToolTipText(Messages.getString((String)"OFECopyAction.Topic"));
    }

    public void run() {
        OS2200CorePlugin.logger.debug((Object)("Executing menu \"" + this.getText() + "\" in OFE."));
        this.copyMenuAction();
    }

    public void copyMenuAction() {
        OS2200CorePlugin.logger.debug((Object)"Inside the copy menu action.");
        final OFCSView oFCSView = UtilsViews.getOFEViewObject();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (oFCSView.isConnected(true)) {
                    String string = oFCSView.getSelectedFilePath(true);
                    if (string != null && string.length() > 0) {
                        String[] stringArray = string.split(",");
                        if (!OFCSView.doesSelectionContainsDir(stringArray).booleanValue()) {
                            OFECopyAction.this.copytoClipboard(stringArray);
                            OS2200CorePlugin.logger.info((Object)"copy completed successfully.");
                        } else {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"info", (String)Messages.getString((String)"OFEPasteAction.copyPasteOperation"));
                            OS2200CorePlugin.logger.info((Object)"Selected element(s) contains directory.");
                        }
                    } else {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"info", (String)Messages.getString((String)"OFECopyAction.copyOperation"));
                        OS2200CorePlugin.logger.info((Object)"Selection of element(s) is not proper");
                    }
                }
            }
        });
    }

    private void copytoClipboard(String[] stringArray) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{stringArray}, new Transfer[]{FileTransfer.getInstance()});
        clipboard.dispose();
    }
}

