/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.ui.actions.BaseActionGroup;
import com.unisys.tde.ui.actions.DeleteResourceAction;
import com.unisys.tde.ui.actions.PasteAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class MoveResourceAction
extends CopyResourceAction {
    private Shell shell;
    public static final String ID = "org.eclipse.ui.MoveResourceAction";
    protected List destinations;

    public MoveResourceAction(Shell shell) {
        super(shell);
        super.setText(IDEWorkbenchMessages.MoveResourceAction_text);
        this.shell = shell;
        this.setToolTipText(IDEWorkbenchMessages.MoveResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_resource_action_context");
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new MoveFilesAndFoldersOperation(this.shell);
    }

    protected List getDestinations() {
        return this.destinations;
    }

    protected IResource[] getResources(List list) {
        ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.shell, IDEWorkbenchMessages.MoveResourceAction_title, IDEWorkbenchMessages.MoveResourceAction_checkMoveMessage);
        return readOnlyStateChecker.checkReadOnlyResources(super.getResources(list));
    }

    protected void runOperation(final IResource[] iResourceArray, IContainer iContainer) {
        this.destinations = new ArrayList();
        if (this.noOpenEdits(iResourceArray)) {
            final IContainer iContainer2 = BaseActionGroup.sanitizeDestination(iContainer);
            if (BaseActionGroup.is2200Project(iResourceArray[0])) {
                if (BaseActionGroup.is2200Project((IResource)iContainer2)) {
                    if (BaseActionGroup.differentWorkFiles(iResourceArray[0], (IResource)iContainer2)) {
                        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                            public void execute(IProgressMonitor iProgressMonitor) {
                                boolean[] blArray = PasteAction.os2200ToOS2200Paste(iResourceArray, (IResource)iContainer2, iProgressMonitor);
                                MoveResourceAction.this.recordAndRemove(iResourceArray, iContainer2, blArray);
                            }
                        };
                        try {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"Internal Unisys Error"), (Throwable)exception);
                        }
                    } else {
                        MessageDialog.openError((Shell)this.shell, (String)Messages.getString((String)"MoveResourceAction.2"), (String)Messages.getString((String)"MoveResourceAction.3"));
                    }
                } else {
                    WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                        public void execute(IProgressMonitor iProgressMonitor) {
                            boolean[] blArray = PasteAction.os2200ToLocalPaste(iResourceArray, (IResource)iContainer2, (IProgressMonitor)new NullProgressMonitor());
                            MoveResourceAction.this.recordAndRemove(iResourceArray, iContainer2, blArray);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)Messages.getString((String)"Internal Unisys Error"), (Throwable)exception);
                    }
                }
            } else if (BaseActionGroup.is2200Project((IResource)iContainer2)) {
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor iProgressMonitor) {
                        String[] stringArray = new String[iResourceArray.length];
                        int n = 0;
                        while (n < stringArray.length) {
                            stringArray[n] = iResourceArray[n].getLocation().toString();
                            ++n;
                        }
                        boolean[] blArray = PasteAction.localToOS2200Paste(stringArray, (IResource)iContainer2, iProgressMonitor);
                        MoveResourceAction.this.recordAndRemove(iResourceArray, iContainer2, blArray);
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)Messages.getString((String)"Internal Unisys Error"), (Throwable)exception);
                }
            } else {
                IResource[] iResourceArray2 = this.operation.copyResources(iResourceArray, iContainer2);
                if (iResourceArray2 != null) {
                    int n = 0;
                    while (n < iResourceArray2.length) {
                        this.destinations.add(iContainer2.getFullPath().append(iResourceArray2[n].getName()));
                        ++n;
                    }
                }
            }
        }
    }

    boolean noOpenEdits(IResource[] iResourceArray) {
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (OS2200FileInterface.isEditOpen((IProject)iResource.getProject(), (String)iResource.getName())) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.getString((String)"DeleteResourceAction.0"), (String)Messages.getString((String)"DeleteResourceAction.1"));
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void recordAndRemove(IResource[] iResourceArray, IContainer iContainer, boolean[] blArray) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = null;
        int n = 0;
        while (n < iResourceArray.length) {
            if (blArray[n]) {
                if (iResourceArray[n] instanceof IFile) {
                    IPath iPath = ((IFile)iResourceArray[n]).getProject().getFullPath();
                    IContainer iContainer2 = (IContainer)iWorkspaceRoot.findMember(iPath);
                    iResource = iWorkspaceRoot.findMember(iContainer2.getFullPath().append(((IFile)iResourceArray[n]).getName()));
                } else {
                    iResource = iWorkspaceRoot.findMember(iContainer.getFullPath().append(iResourceArray[n].getName()));
                }
                if (iResource != null) {
                    this.destinations.add(iContainer.getFullPath().append(iResourceArray[n].getName()));
                    if (BaseActionGroup.is2200Project(iResourceArray[n])) {
                        DeleteResourceAction.delete2200Elt(iResourceArray[n]);
                    } else {
                        try {
                            iResourceArray[n].delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
            }
            ++n;
        }
    }
}

