/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.CopyProcParser;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.UiPlugin;
import com.unisys.tde.ui.actions.CopyProcConnDetail;
import com.unisys.tde.ui.actions.CopyProcConnMap;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.dialogs.patch.ErrorMessages;
import org.eclipse.ui.dialogs.patch.IIssueMessage;

public class ListCopyProcProjectDialog
extends SelectionStatusDialog
implements IIssueMessage {
    private Text workFilePathField = null;
    private ErrorMessages errorMessages;
    private int DIAG = 0;
    private Combo hostSelect;
    private Text projectsText;
    private Properties copyProcProperties;
    private final String HOST = "Host Value";
    private Button nonStdShareBtn;
    private Button wrkFileShareBtn;
    private Text shareNameTxt;
    private int shareState = 0;
    private CopyProcConnMap procMap = null;
    private CopyProcConnDetail currentConnDetail = null;
    private JAXBContext context;
    private Label wrkFileLabel;
    private String wrkFileName = "";
    private String wrkFileShare = "";
    private ArrayList<String> validatedPath;
    private static final String copyProcDir = "\\Local Settings\\Application Data\\Unisys\\os2200\\dd\\";
    private static final String userHome = System.getProperty("user.home");
    private static final String OS2200 = "OS2200";
    private static final String COPYPROC_XML = String.valueOf(userHome) + "\\Local Settings\\Application Data\\Unisys\\os2200\\dd\\" + "CopyProc.xml";
    private static final String WRKFILE_MSG = "workfile";
    private static final String WRKSHARE_MSG = "workfile share";
    private static final String ASTERISK = "*";
    private static final String DOT = ".";
    private static final String COMMA_DELIMITER = ",";
    private static final String COPY_PROC_SECTION = "CopyProc";
    private static final String OLD_COPYPROC_FILE = "copyProc.properties";
    private static final String SLASH = "\\\\";
    private static final String FILE_SEPERATOR = "\\";
    private static final String IDE_WORKBENCH = "org.eclipse.ui.ide";
    private static final int CST_SHARE = 1;
    private static final int N_SHARE = 2;
    ModifyListener shareTxtModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ListCopyProcProjectDialog.this.errorMessages.issueMessage(ListCopyProcProjectDialog.this.DIAG, "");
            if (ListCopyProcProjectDialog.this.shareState != 2) {
                if (!ListCopyProcProjectDialog.this.hostSelect.getText().isEmpty() && ListCopyProcProjectDialog.this.workFilePathField.getText().trim().length() > 0) {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(true);
                } else {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(false);
                }
            } else if (ListCopyProcProjectDialog.this.shareNameTxt.getText().trim().length() > 0) {
                ListCopyProcProjectDialog.this.getButton(0).setEnabled(true);
            } else {
                ListCopyProcProjectDialog.this.getButton(0).setEnabled(false);
            }
        }
    };
    SelectionListener nonOs2200ShareSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (ListCopyProcProjectDialog.this.nonStdShareBtn.getSelection() && ListCopyProcProjectDialog.this.shareState != 1) {
                ListCopyProcProjectDialog.this.setOS2200StdShare();
                ListCopyProcProjectDialog.this.errorMessages.issueMessage(ListCopyProcProjectDialog.this.DIAG, "");
                if (!ListCopyProcProjectDialog.this.hostSelect.getText().isEmpty() && ListCopyProcProjectDialog.this.workFilePathField.getText().trim().length() > 0) {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(true);
                } else {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(false);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener wrkFileShareSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (ListCopyProcProjectDialog.this.wrkFileShareBtn.getSelection() && ListCopyProcProjectDialog.this.shareState != 2) {
                ListCopyProcProjectDialog.this.setwrkFileShare();
                ListCopyProcProjectDialog.this.errorMessages.issueMessage(ListCopyProcProjectDialog.this.DIAG, "");
                if (!ListCopyProcProjectDialog.this.hostSelect.getText().isEmpty() && ListCopyProcProjectDialog.this.shareNameTxt.getText().trim().length() > 0) {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(true);
                } else {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(false);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    VerifyListener shareNameVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent verifyEvent) {
            verifyEvent.text = verifyEvent.text.toUpperCase();
        }
    };

    public ListCopyProcProjectDialog(Shell shell) {
        super(shell);
        this.errorMessages = new ErrorMessages(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.unisys.tde.ui.configuring_the_cobol_copy-procs");
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{CopyProcConnMap.class});
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            this.procMap = (CopyProcConnMap)unmarshaller.unmarshal((Reader)new FileReader(COPYPROC_XML));
            if (this.procMap == null) {
                OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : copyproc map loaded");
                this.procMap = CopyProcConnMap.getInstance();
            }
        }
        catch (Exception exception) {
            this.procMap = CopyProcConnMap.getInstance();
            OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc :  new copyproc map created");
        }
    }

    @Override
    public void issueMessage(String string) {
        int n = 0;
        boolean bl = true;
        if (string.length() != 0) {
            n = 4;
            bl = false;
        }
        try {
            this.updateStatus((IStatus)new Status(n, IDE_WORKBENCH, n, string, null));
            OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : error msg - " + string));
            this.getOkButton().setEnabled(bl);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage());
        }
    }

    private void setInitialValues() {
        String string;
        IDialogSettings iDialogSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(COPY_PROC_SECTION);
        if (iDialogSettings2 != null && this.hostSelect.indexOf(string = iDialogSettings2.get("Host Value")) >= 0) {
            this.hostSelect.select(this.hostSelect.indexOf(string));
            if (this.hostSelect.getSelectionIndex() >= 0) {
                OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : Initial value set for host : " + string));
                this.setHostAction();
                return;
            }
        }
        this.setDefaultInitialValue();
        this.setHostAction();
    }

    private void setDefaultInitialValue() {
        OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : default values set");
        this.nonStdShareBtn.setSelection(true);
        this.setOS2200StdShare();
        this.workFilePathField.setEnabled(true);
        this.getButton(0).setEnabled(false);
        this.hostSelect.setFocus();
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        this.checkCopyPocPropertiesFile();
        this.setInitialValues();
    }

    private void checkCopyPocPropertiesFile() {
        this.copyProcProperties = this.loadCopyProcProperties();
        if (this.copyProcProperties != null && !this.copyProcProperties.isEmpty()) {
            OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : old copyproc.properties file exsists");
            Enumeration<?> enumeration = this.copyProcProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc :adding map for host : " + string));
                String string2 = this.copyProcProperties.getProperty(string);
                CopyProcConnDetail copyProcConnDetail = new CopyProcConnDetail();
                if (string2.contains(ASTERISK)) {
                    copyProcConnDetail.setShareState(1);
                    copyProcConnDetail.setShareName(OS2200);
                } else {
                    copyProcConnDetail.setShareState(2);
                    copyProcConnDetail.setShareName("");
                }
                copyProcConnDetail.setWrk(string2);
                this.procMap.addToCopyProcMap(string.toUpperCase(), copyProcConnDetail);
            }
            this.saveCopyProcProperties();
            this.deletePropertiesFile();
        }
    }

    private void deletePropertiesFile() {
        try {
            File file = new File(String.valueOf(userHome) + copyProcDir + OLD_COPYPROC_FILE);
            if (file.delete()) {
                OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc :deletion of old copyproc file succesfull");
            } else {
                OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc :deletion of old copyproc file falied");
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : deletion of old copyproc (error) - " + exception.getMessage()));
        }
    }

    protected Control createDialogArea(Composite composite) {
        LoginAccount loginAccount;
        Group group;
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString((String)"CopyProcUI.ConnName"));
        this.hostSelect = new Combo(composite2, 2056);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.hostSelect.setLayoutData((Object)gridData);
        Group group2 = LoginAccount.getLoginAccounts();
        if (group2 != null && ((LoginAccount[])group2).length > 0) {
            group = group2;
            int n = ((LoginAccount[])group).length;
            int n2 = 0;
            while (n2 < n) {
                loginAccount = group[n2];
                this.hostSelect.add(loginAccount.getName());
                this.hostSelect.setData(loginAccount.getName(), (Object)loginAccount);
                ++n2;
            }
            this.hostSelect.select(0);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ConfiguredServerFileDialog.error1"), (String)Messages.getString((String)"ConfiguredServerFileDialog.NoHosts"));
        }
        this.hostSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListCopyProcProjectDialog.this.setHostAction();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        loginAccount = new Label(composite2, 0);
        loginAccount.setText(Messages.getString((String)"CopyProcUI.AssoPro"));
        this.projectsText = new Text(composite2, 2048);
        this.projectsText.setEnabled(false);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 350;
        this.projectsText.setLayoutData((Object)gridData2);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 2;
        group = new Group(composite2, 4);
        group.setText(Messages.getString((String)"OFCSView.share"));
        group.setLayoutData((Object)gridData3);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.horizontalSpacing = 10;
        gridLayout2.verticalSpacing = 10;
        gridLayout2.marginWidth = 10;
        gridLayout2.marginHeight = 5;
        group.setLayout((Layout)gridLayout2);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 2;
        this.nonStdShareBtn = new Button((Composite)group, 16);
        this.nonStdShareBtn.setText(Messages.getString((String)"OFCSView.nonStdShr"));
        this.nonStdShareBtn.addSelectionListener(this.nonOs2200ShareSelListener);
        this.wrkFileShareBtn = new Button((Composite)group, 16);
        this.wrkFileShareBtn.setText(Messages.getString((String)"OFCSView.wrkFileShr"));
        this.wrkFileShareBtn.addSelectionListener(this.wrkFileShareSelListener);
        this.shareNameTxt = new Text((Composite)group, 2048);
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 2;
        gridData5.widthHint = 200;
        this.shareNameTxt.setLayoutData((Object)gridData4);
        this.shareNameTxt.addVerifyListener(this.shareNameVerifyListener);
        this.shareNameTxt.addModifyListener(this.shareTxtModifyListener);
        this.wrkFileLabel = new Label(composite2, 0);
        this.wrkFileLabel.setText(Messages.getString((String)"CopyProcUI.WrkName"));
        this.workFilePathField = new Text(composite2, 2048);
        this.workFilePathField.setLayoutData((Object)gridData2);
        this.workFilePathField.addVerifyListener(this.shareNameVerifyListener);
        this.workFilePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ListCopyProcProjectDialog.this.errorMessages.issueMessage(ListCopyProcProjectDialog.this.DIAG, "");
                if (!ListCopyProcProjectDialog.this.hostSelect.getText().isEmpty() && ListCopyProcProjectDialog.this.workFilePathField.getText().trim().length() > 0) {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(true);
                } else {
                    ListCopyProcProjectDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Label label2 = new Label((Composite)group, 0);
        label2.setText("");
        this.DIAG = this.errorMessages.addMsgIndex();
        return composite;
    }

    private void setOS2200StdShare() {
        if (this.shareState != 1) {
            this.wrkFileShare = this.shareNameTxt.getText();
        }
        this.shareNameTxt.setText(OS2200);
        this.shareState = 1;
        this.workFilePathField.setEnabled(true);
        this.workFilePathField.setText(this.wrkFileName.toUpperCase());
        this.wrkFileShareBtn.setSelection(false);
    }

    private void setwrkFileShare() {
        this.shareState = 2;
        this.nonStdShareBtn.setSelection(false);
        this.wrkFileName = this.workFilePathField.getText();
        this.workFilePathField.setEnabled(false);
        this.workFilePathField.setText("");
        this.shareNameTxt.setText(this.wrkFileShare);
    }

    private void setHostAction() {
        block11: {
            block10: {
                String string2;
                Serializable serializable;
                this.workFilePathField.setEnabled(true);
                LoginAccount loginAccount = (LoginAccount)this.hostSelect.getData(this.hostSelect.getText());
                List list = OS2200ProjectUpdate.getProjListFromAssociatedHost((HostAccount)loginAccount.getHostAccount());
                if (list != null && list.size() >= 0) {
                    serializable = new StringBuilder();
                    for (String string2 : list) {
                        ((StringBuilder)serializable).append(string2);
                        ((StringBuilder)serializable).append(COMMA_DELIMITER);
                    }
                    if (((StringBuilder)serializable).length() > 0 && ((StringBuilder)serializable).lastIndexOf(COMMA_DELIMITER) > 0) {
                        ((StringBuilder)serializable).deleteCharAt(((StringBuilder)serializable).lastIndexOf(COMMA_DELIMITER));
                    }
                    this.projectsText.setText(((StringBuilder)serializable).toString());
                }
                if (!((HashMap)(serializable = this.procMap.getCopyProcMap())).containsKey(this.hostSelect.getText())) break block10;
                this.currentConnDetail = (CopyProcConnDetail)((HashMap)serializable).get(this.hostSelect.getText());
                string2 = this.currentConnDetail.getShareName();
                switch (this.currentConnDetail.getShareState()) {
                    case 0: 
                    case 1: {
                        this.nonStdShareBtn.setSelection(true);
                        this.setOS2200StdShare();
                        if (string2 != null && !string2.isEmpty()) {
                            this.shareNameTxt.setText(string2.toUpperCase());
                        }
                        this.workFilePathField.setText(this.currentConnDetail.getWrk().toUpperCase());
                        break;
                    }
                    case 2: {
                        this.wrkFileShareBtn.setSelection(true);
                        this.setwrkFileShare();
                        if (string2 == null || string2.isEmpty()) break block11;
                        this.shareNameTxt.setText(string2.toUpperCase());
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block11;
            }
            this.currentConnDetail = null;
            this.nonStdShareBtn.setSelection(true);
            this.shareNameTxt.setText("");
            this.setOS2200StdShare();
            this.workFilePathField.setText("");
        }
    }

    private void storeValues() {
        OS2200CorePlugin.logger.debug((Object)"Storing the values");
        IDialogSettings iDialogSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(COPY_PROC_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(COPY_PROC_SECTION);
        }
        iDialogSettings2.put("Host Value", this.hostSelect.getText());
    }

    public String getShareName() {
        String string = this.shareNameTxt.getText();
        if (string == null || string.isEmpty()) {
            string = OS2200;
        }
        return string;
    }

    private boolean validatePath(String string) {
        OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc :Validating the user input");
        String string2 = "";
        String[] stringArray = string.split(COMMA_DELIMITER, -1);
        this.validatedPath = new ArrayList();
        String string3 = "";
        boolean bl = false;
        String string4 = WRKFILE_MSG;
        if (this.shareState == 2) {
            string4 = WRKSHARE_MSG;
        }
        if (stringArray.length == 0) {
            bl = true;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                String string5 = stringArray2[n2];
                String string6 = string5.trim();
                if (string6.isEmpty()) {
                    bl = true;
                } else {
                    if (this.shareState != 2) {
                        if (!string6.endsWith(DOT)) {
                            string6 = String.valueOf(string6) + DOT;
                        }
                    } else if (string6.endsWith(DOT)) {
                        string6 = string6.substring(0, string6.lastIndexOf(DOT));
                    }
                    for (String string7 : this.validatedPath) {
                        if (!string6.trim().equalsIgnoreCase(string7.trim())) continue;
                        string3 = String.valueOf(string2) + " " + Messages.getString((String)"CopyProcErr.Err4", (String)string4);
                        break block17;
                    }
                    if (this.shareState == 2) {
                        if (string6.contains(ASTERISK)) {
                            string2 = string2.isEmpty() ? string5 : String.valueOf(string2) + COMMA_DELIMITER + string5;
                        }
                    } else if (!OS2200FileInterface.isValidOS2200FileName((String)string6)) {
                        string2 = string2.isEmpty() ? string5 : String.valueOf(string2) + COMMA_DELIMITER + string5;
                    }
                    this.validatedPath.add(string6);
                }
            }
            ++n2;
        }
        if (!string2.isEmpty()) {
            string3 = string2.indexOf(COMMA_DELIMITER) > 0 ? String.valueOf(string2) + " " + Messages.getString((String)"CopyProcErr.Err1", (String)string4) : String.valueOf(string2) + " " + Messages.getString((String)"CopyProcErr.Err2", (String)string4);
        }
        if (this.validatedPath.size() == 0 && bl) {
            string3 = String.valueOf(string3) + Messages.getString((String)"CopyProcErr.Err3", (String)string4);
        }
        if (!string3.isEmpty()) {
            this.errorMessages.issueMessage(this.DIAG, string3);
            return false;
        }
        this.errorMessages.issueMessage(this.DIAG, "");
        return true;
    }

    protected void okPressed() {
        try {
            Object object;
            String string = "";
            string = this.wrkFileShareBtn.getSelection() ? this.shareNameTxt.getText().trim() : this.workFilePathField.getText().trim();
            if (!this.validatePath(string.toUpperCase())) {
                return;
            }
            String[] stringArray = this.validatedPath.toArray(new String[this.validatedPath.size()]);
            OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : Total no. of workfile : " + stringArray.length));
            if (this.validatedPath.size() > 5) {
                OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : Input count greater than 5");
                if (this.isSameInput(stringArray) && ((File)(object = new File(String.valueOf(userHome) + copyProcDir + this.hostSelect.getText()))).exists()) {
                    OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : Same input as previous");
                    if (!MessageDialog.openConfirm((Shell)this.getParentShell(), (String)Messages.getString((String)"CopyProcUI.title"), (String)Messages.getString((String)"CopyProcUI.warn"))) {
                        super.okPressed();
                        return;
                    }
                }
            }
            if (this.currentConnDetail == null) {
                object = new CopyProcConnDetail();
                ((CopyProcConnDetail)object).setShareState(this.shareState);
                ((CopyProcConnDetail)object).setShareName(this.shareNameTxt.getText());
                ((CopyProcConnDetail)object).setWrk(this.workFilePathField.getText());
                this.procMap.addToCopyProcMap(this.hostSelect.getText(), (CopyProcConnDetail)object);
            } else {
                this.currentConnDetail.setShareState(this.shareState);
                this.currentConnDetail.setShareName(this.shareNameTxt.getText());
                this.currentConnDetail.setWrk(this.workFilePathField.getText());
            }
            object = new CopyProcParser();
            LoginAccount loginAccount = (LoginAccount)this.hostSelect.getData(this.hostSelect.getText());
            String string2 = this.getHostPath(loginAccount);
            String string3 = "";
            string3 = this.wrkFileShareBtn.getSelection() ? object.procParser(loginAccount, stringArray, string2, this.hostSelect.getText(), "", this.shareState, this.getShell()) : object.procParser(loginAccount, stringArray, string2, this.hostSelect.getText(), this.getShareName(), this.shareState, this.getShell());
            if (object.isFileGenerated()) {
                this.saveCopyProcProperties();
                this.storeValues();
            }
            if (!string3.isEmpty()) {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)Messages.getString((String)"CopyProcUI.title"), (String)string3);
                this.getButton(0).setEnabled(false);
                return;
            }
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)Messages.getString((String)"CopyProcUI.title"), (String)(String.valueOf(Messages.getString((String)"CopyProcUI.success")) + " " + this.hostSelect.getText()));
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
        super.okPressed();
    }

    private ArrayList<String> removeDuplicate_Space(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String string = stringArray2[n2];
                String string2 = string.trim();
                if (!string2.isEmpty()) {
                    if (this.shareState != 2) {
                        if (!string2.endsWith(DOT)) {
                            string2 = String.valueOf(string2) + DOT;
                        }
                    } else if (string2.endsWith(DOT)) {
                        string2 = string2.substring(0, string2.lastIndexOf(DOT));
                    }
                    for (String string3 : arrayList) {
                        if (!string2.trim().equalsIgnoreCase(string3.trim())) {
                            continue;
                        }
                        break block8;
                    }
                    arrayList.add(string2);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean isSameInput(String[] stringArray) {
        String string;
        String string2;
        if (this.currentConnDetail == null) {
            return false;
        }
        if (this.currentConnDetail.getShareState() != this.shareState) {
            return false;
        }
        if (this.currentConnDetail.shareState == this.shareState) {
            string2 = "";
            string2 = this.currentConnDetail.shareState != 2 ? this.getShareName() : this.shareNameTxt.getText().trim();
            if (!this.currentConnDetail.getShareName().equalsIgnoreCase(string2)) {
                return false;
            }
        }
        string2 = "";
        string2 = this.currentConnDetail.getShareState() == 1 ? this.currentConnDetail.getWrk().toUpperCase() : this.currentConnDetail.getShareName().toUpperCase();
        String[] stringArray2 = string2.split(COMMA_DELIMITER, -1);
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = this.removeDuplicate_Space(stringArray2);
        int n = 0;
        while (n < list.size()) {
            string = list.get(n);
            if (!string.endsWith(DOT)) {
                string = String.valueOf(string) + DOT;
                list.set(n, string);
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            string = (String)arrayList.get(n);
            if (!string.endsWith(DOT)) {
                string = String.valueOf(string) + DOT;
                arrayList.set(n, string);
            }
            ++n;
        }
        return list.containsAll(arrayList);
    }

    private String getHostPath(LoginAccount loginAccount) {
        String string = SLASH + loginAccount.getHostAccount().getHostId() + FILE_SEPERATOR;
        if (this.shareState != 2) {
            string = String.valueOf(string) + this.getShareName() + FILE_SEPERATOR;
        }
        return string;
    }

    private void saveCopyProcProperties() {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File file = new File(String.valueOf(userHome) + copyProcDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(COPYPROC_XML);
            marshaller.marshal((Object)this.procMap, (OutputStream)fileOutputStream);
            OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : save the copyproxc mappings succesfull");
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)("Configure Copy-Proc : save the copyproxc mappings (error) - " + exception.getMessage()));
        }
    }

    protected Point getInitialSize() {
        return new Point(700, 290);
    }

    protected void computeResult() {
    }

    private Properties loadCopyProcProperties() {
        Properties properties = new Properties();
        File file = new File(String.valueOf(userHome) + copyProcDir + OLD_COPYPROC_FILE);
        FileInputStream fileInputStream = null;
        try {
            try {
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    OS2200CorePlugin.logger.debug((Object)"Configure Copy-Proc : succesfully loaded copyproc.properties file");
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : couldn't load copyproc.properties file (error) - " + exception.getMessage()));
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : couldn't close copyproc.properties file steam (error) - " + iOException.getMessage()));
                }
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)("Configure Copy-Proc : couldn't close copyproc.properties file steam (error) - " + iOException.getMessage()));
            }
        }
        return properties;
    }
}

