/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.actions.BaseActionGroup;
import com.unisys.tde.ui.actions.DeleteProjDialog;
import com.unisys.tde.ui.actions.DeleteRadioDialog;
import com.unisys.tde.ui.views.HostManagerView;
import com.unisys.tde.ui.views.OS2200WorkFile;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private Shell shell;
    boolean state = false;
    private boolean deleteContent = false;
    private static boolean deleteVersions = false;
    private boolean deleteCancelled = false;
    private boolean forceOutOfSyncDelete = false;
    protected boolean fTestingMode = false;
    private String[] modelProviderIds;
    private IEditorPart editor = null;
    private IWorkbenchPage page = null;
    private boolean delOS2200Element = false;
    private StringBuffer error = null;
    private StructuredViewer viewer;

    public DeleteResourceAction(Shell shell, StructuredViewer structuredViewer) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        this.viewer = structuredViewer;
        this.setToolTipText(IDEWorkbenchMessages.DeleteResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    private boolean canDelete(IResource[] iResourceArray) {
        if (!this.containsOnlyProjects(iResourceArray) && !this.containsOnlyNonProjects(iResourceArray)) {
            return false;
        }
        if (iResourceArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource instanceof OS2200WorkFile) {
                return false;
            }
            if (iResource.isPhantom()) {
                return false;
            }
            if (iResource instanceof IFile && OS2200FileInterface.isEditOpen((IProject)iResource.getProject(), (String)iResource.getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean containsLinkedResource(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.isLinked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean containsOnlyNonProjects(IResource[] iResourceArray) {
        int n = this.getSelectedResourceTypes(iResourceArray);
        if (n == 0) {
            return false;
        }
        return (n & 4) == 0;
    }

    private boolean containsOnlyProjects(IResource[] iResourceArray) {
        int n = this.getSelectedResourceTypes(iResourceArray);
        return n == 4;
    }

    private IStatus createResult(List list) {
        if (list.isEmpty()) {
            return Status.OK_STATUS;
        }
        int n = list.size();
        if (n == 1) {
            return ((CoreException)((Object)list.get(0))).getStatus();
        }
        CoreException[] coreExceptionArray = list.toArray(new CoreException[n]);
        boolean bl = false;
        int n2 = 0;
        while (n2 < coreExceptionArray.length) {
            if (coreExceptionArray[n2].getStatus().getCode() == 274) {
                bl = true;
                break;
            }
            ++n2;
        }
        String string = bl ? UndoMessages.AbstractResourcesOperation_outOfSyncError : UndoMessages.AbstractResourcesOperation_deletionExceptionMessage;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.ide", 0, string, null);
        int n3 = 0;
        while (n3 < n) {
            CoreException coreException = coreExceptionArray[n3];
            IStatus iStatus = coreException.getStatus();
            multiStatus.add((IStatus)new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), (Throwable)coreException));
            ++n3;
        }
        return multiStatus;
    }

    private boolean confirmDelete(IResource[] iResourceArray) {
        if (this.validateDelete(iResourceArray)) {
            if (this.containsOnlyProjects(iResourceArray)) {
                return this.confirmDeleteProjects(iResourceArray);
            }
            if (this.checkEditsNotOpen(iResourceArray)) {
                return this.confirmDeleteNonProjects(iResourceArray);
            }
            return false;
        }
        return false;
    }

    boolean checkEditsNotOpen(IResource[] iResourceArray) {
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (OS2200FileInterface.isEditOpen((IProject)iResource.getProject(), (String)iResource.getName())) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.getString((String)"DeleteResourceAction.0"), (String)Messages.getString((String)"DeleteResourceAction.1"));
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean confirmDeleteNonProjects(IResource[] iResourceArray) {
        String string;
        String string2;
        if (BaseActionGroup.is2200Project(iResourceArray)) {
            DeleteRadioDialog deleteRadioDialog = new DeleteRadioDialog(this.shell, iResourceArray, Messages.getString((String)"OS2200DeleteTitle.0"), DeleteRadioDialog.getMessage(iResourceArray));
            deleteRadioDialog.setTestingMode(this.fTestingMode);
            int n = deleteRadioDialog.open();
            this.deleteContent = deleteRadioDialog.getDeleteContent();
            deleteVersions = deleteRadioDialog.getDeleteVersions();
            return n == 0;
        }
        if (iResourceArray.length == 1) {
            string2 = IDEWorkbenchMessages.DeleteResourceAction_title1;
            IResource iResource = iResourceArray[0];
            string = iResource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResource1, (Object)iResource.getName()) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirm1, (Object)iResource.getName());
        } else {
            string2 = IDEWorkbenchMessages.DeleteResourceAction_titleN;
            string = this.containsLinkedResource(iResourceArray) ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResourceN, (Object)new Integer(iResourceArray.length)) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmN, (Object)new Integer(iResourceArray.length));
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)string2, (String)string);
    }

    private boolean confirmDeleteProjects(IResource[] iResourceArray) {
        DeleteProjDialog deleteProjDialog = new DeleteProjDialog(this.shell, iResourceArray);
        deleteProjDialog.setTestingMode(this.fTestingMode);
        int n = deleteProjDialog.open();
        this.deleteContent = deleteProjDialog.getDeleteContent();
        return n == 0;
    }

    private void delete(IResource[] iResourceArray, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList<CoreException> arrayList = new ArrayList<CoreException>();
        this.forceOutOfSyncDelete = false;
        iProgressMonitor.beginTask("", iResourceArray.length);
        try {
            IStatus iStatus;
            int n = iResourceArray.length;
            ArrayList<String> arrayList2 = new ArrayList<String>(25);
            int n2 = 0;
            while (n2 < n) {
                block21: {
                    String string;
                    block20: {
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        string = null;
                        if (iResourceArray[n2].getType() == 1) {
                            string = iResourceArray[n2].getRawLocation().toOSString();
                        }
                        if (!this.deleteCancelled) break block20;
                        return;
                    }
                    try {
                        this.delete(iResourceArray[n2], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 4));
                        if (iResourceArray[n2].getType() != 1) break block21;
                        if (string == null) {
                            this.delOS2200Element = false;
                            OS2200CorePlugin.logger.error((Object)(String.valueOf(iResourceArray[n2].getName()) + " is not linked with the project tree."));
                        }
                        if (!this.delOS2200Element) break block21;
                        try {
                            if (TDECoreUtilities.delete((File)new File(string))) {
                                OS2200CorePlugin.logger.debug((Object)("The local cache file " + string + " is deleted successfully."));
                            } else if (n >= 1) {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"DeleteResourceAction.4"), (String)(String.valueOf(Messages.getString((String)"DeleteResourceAction.2")) + string + Messages.getString((String)"DeleteResourceAction.5")));
                            } else {
                                arrayList2.add(string);
                                OS2200CorePlugin.logger.debug((Object)("The local cache file " + string + " could not be deleted."));
                            }
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.error((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                        string = null;
                    }
                    catch (CoreException coreException) {
                        arrayList.add(coreException);
                        OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                    }
                }
                ++n2;
            }
            if (arrayList2.size() > 0) {
                this.error = new StringBuffer();
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    this.error.append((String)arrayList2.get(n2));
                    this.error.append("\n");
                    ++n2;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OS2200CorePlugin.logger.debug((Object)("The following file from local cache is not deleted.\n" + DeleteResourceAction.this.error.toString()));
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"DeleteResourceAction.4"), (String)(String.valueOf(Messages.getString((String)"DeleteResourceAction.6")) + DeleteResourceAction.this.error.toString()));
                    }
                });
            }
            if (!(iStatus = this.createResult(arrayList)).isOK()) {
                throw new CoreException(iStatus);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void delete(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        block25: {
            boolean bl = false;
            try {
                if (iResource.getType() == 4) {
                    Object object;
                    ILaunchConfiguration[] iLaunchConfigurationArray;
                    IProject iProject = (IProject)iResource;
                    if (iProject.isOpen()) {
                        iLaunchConfigurationArray = this.getSelectedResources();
                        if (iLaunchConfigurationArray != null || iLaunchConfigurationArray.isEmpty()) {
                            List list = this.getDirtyEditors((List)iLaunchConfigurationArray);
                            for (IEditorPart this.editor : list) {
                                this.page = this.editor.getEditorSite().getPage();
                                this.state = false;
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        DeleteResourceAction.this.state = DeleteResourceAction.this.page.closeEditor(DeleteResourceAction.this.editor, true);
                                    }
                                });
                                if (this.state) continue;
                                OS2200CorePlugin.logger.debug((Object)"User cancelled the delete operation.");
                                this.deleteCancelled = true;
                                return;
                            }
                        }
                        iProject.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    iLaunchConfigurationArray = null;
                    try {
                        iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.unisys.udt.debug.ui.launcher.UDTLaunchConfigurationDelegate"));
                    }
                    catch (CoreException coreException) {
                        OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                    }
                    int n = 0;
                    while (n < iLaunchConfigurationArray.length) {
                        object = iLaunchConfigurationArray[n].getAttribute("ProjectName", "");
                        if (((String)object).equalsIgnoreCase(iProject.getName())) {
                            iLaunchConfigurationArray[n].delete();
                        }
                        ++n;
                    }
                    Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                    object = properties.getProperty("hostID");
                    IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                    try {
                        Object object2;
                        if (object != null && ((String)object).length() == 0) {
                            object2 = iPreferenceStore.getString(iProject.getName());
                            object = ((String)object2).substring(((String)object2).lastIndexOf("#") + 1).trim();
                        }
                        iPreferenceStore.setToDefault(iProject.getName());
                        object2 = LoginAccount.getLoginAccount((String)object);
                        if (object2 != null) {
                            OS2200ProjectUpdate.updateHostProjMap((String)object2.getName(), (String)iProject.getName());
                        }
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    iProject.delete(this.deleteContent, bl, iProgressMonitor);
                    break block25;
                }
                boolean bl2 = true;
                if (BaseActionGroup.is2200Project(iResource)) {
                    this.delOS2200Element = (this.deleteContent || deleteVersions) && iResource.isLinked() ? (bl2 = DeleteResourceAction.delete2200Elt(iResource)) : false;
                }
                if (bl2) {
                    iResource.delete(2, iProgressMonitor);
                }
            }
            catch (CoreException coreException) {
                if (iResource.getType() == 1) {
                    IStatus[] iStatusArray = coreException.getStatus().getChildren();
                    if (iStatusArray.length == 1 && iStatusArray[0].getCode() == 274) {
                        if (this.forceOutOfSyncDelete) {
                            iResource.delete(3, iProgressMonitor);
                        } else {
                            int n = this.queryDeleteOutOfSync(iResource);
                            if (n == 2) {
                                iResource.delete(3, iProgressMonitor);
                            } else if (n == 4) {
                                this.forceOutOfSyncDelete = true;
                                iResource.delete(3, iProgressMonitor);
                            } else if (n == 1) {
                                throw new OperationCanceledException();
                            }
                        }
                    }
                    throw coreException;
                }
                throw coreException;
            }
        }
    }

    public static boolean delete2200Elt(IResource iResource) {
        block4: {
            IWorkbenchWindow iWorkbenchWindow;
            LoginAccount loginAccount;
            Properties properties;
            IFile iFile;
            block5: {
                OS2200CorePlugin.logger.debug((Object)"Entering DeleteElement run");
                try {
                    iFile = (IFile)iResource;
                    if (iFile == null) break block4;
                    IProject iProject = iFile.getProject();
                    properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                    String string = properties.getProperty("hostID");
                    loginAccount = LoginAccount.getLoginAccount((String)string);
                    String string2 = "delete2200Elt1 " + Messages.getString((String)"DeleteElement.1");
                    iWorkbenchWindow = OS2200FileInterface.UIActiveWindow();
                    if (loginAccount != null) break block5;
                    String string3 = Messages.getString((String)"Connection.1", (String)string);
                    Display display = Display.getDefault();
                    final IWorkbenchWindow iWorkbenchWindow2 = iWorkbenchWindow;
                    final String string4 = string2;
                    final String string5 = string3;
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)iWorkbenchWindow2.getShell(), (String)string4, (String)string5);
                        }
                    });
                    return false;
                }
                catch (Throwable throwable) {
                    OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", throwable);
                    return false;
                }
            }
            String string = properties.getProperty("workFile");
            long l = OS2200ProjectUpdate.deleteFileFromOS2200Project((IFile)iFile, (boolean)deleteVersions);
            if (l != 0L) {
                Display display = Display.getDefault();
                final IFile iFile2 = iFile;
                final String string6 = string;
                final long l2 = l;
                final LoginAccount loginAccount2 = loginAccount;
                final IWorkbenchWindow iWorkbenchWindow3 = iWorkbenchWindow;
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)iWorkbenchWindow3.getShell(), (String)Messages.getString((String)"DeleteElement.7"), (String)(String.valueOf(Messages.getString((String)"DeleteElement.8", (String)iFile2.getName(), (String)string6.toUpperCase())) + "\n\n" + OS2200FileInterface.getConnectErrorMsg((long)l2, (LoginAccount)loginAccount2, (IFile)iFile2)));
                    }
                });
                return false;
            }
        }
        return true;
    }

    private IResource[] getSelectedResourcesArray() {
        Object object;
        ArrayList<Object> arrayList = null;
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof TreeSelection) {
            object = ((TreeSelection)iSelection).toArray();
            arrayList = new ArrayList<Object>(Arrays.asList(object));
            object = null;
            iSelection = null;
        }
        if (arrayList != null) {
            object = new ArrayList(arrayList.size());
            Iterator iterator = arrayList.iterator();
            Object e = null;
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof IFile)) continue;
                object.add(e);
            }
            arrayList.removeAll((Collection<?>)object);
            object.addAll(arrayList);
            IResource[] iResourceArray = new IResource[object.size()];
            object.toArray(iResourceArray);
            return iResourceArray;
        }
        object = new IResource[]{};
        return object;
    }

    private int getSelectedResourceTypes(IResource[] iResourceArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            n |= iResourceArray[n2].getType();
            ++n2;
        }
        return n;
    }

    public void run() {
        final IResource[] iResourceArray = this.getSelectedResourcesArray();
        this.deleteCancelled = false;
        if (!this.confirmDelete(iResourceArray)) {
            return;
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        progressMonitorDialog = PlatformUI.getWorkbench().getProgressService();
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IResource[] iResourceArray2 = DeleteResourceAction.this.getResourcesToDelete(iResourceArray);
                        if (iResourceArray2.length == 0) {
                            return;
                        }
                        DeleteResourceAction.this.scheduleDeleteJob(iResourceArray2, iProgressMonitor);
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void scheduleDeleteJob(IResource[] iResourceArray, IProgressMonitor iProgressMonitor) {
        try {
            this.delete(iResourceArray, iProgressMonitor);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
    }

    private ISchedulingRule getDeleteRule(IResource[] iResourceArray) {
        IResourceRuleFactory iResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule iSchedulingRule = null;
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            ISchedulingRule iSchedulingRule2 = iResourceRuleFactory.deleteRule(iResource);
            iSchedulingRule = iSchedulingRule == null ? iSchedulingRule2 : MultiRule.combine((ISchedulingRule)iSchedulingRule, (ISchedulingRule)iSchedulingRule2);
            ++n;
        }
        return iSchedulingRule;
    }

    private IResource[] getResourcesToDelete(IResource[] iResourceArray) {
        if (this.containsOnlyProjects(iResourceArray) && !this.deleteContent) {
            return iResourceArray;
        }
        ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.shell, IDEWorkbenchMessages.DeleteResourceAction_title1, IDEWorkbenchMessages.DeleteResourceAction_readOnlyQuestion);
        readOnlyStateChecker.setIgnoreLinkedResources(true);
        return readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl = super.updateSelection(iStructuredSelection);
        if (bl) {
            if (BaseActionGroup.allResourcesAreOfType(iStructuredSelection, 4)) {
                bl = true;
            } else if (BaseActionGroup.isOS2200WorkFile(iStructuredSelection)) {
                bl = false;
            } else if (BaseActionGroup.sameProject(iStructuredSelection) && BaseActionGroup.allResourcesAreOfType(iStructuredSelection, 3)) {
                bl = true;
            }
        }
        return bl;
    }

    private int queryDeleteOutOfSync(IResource iResource) {
        final MessageDialog messageDialog = new MessageDialog(this.shell, UndoMessages.AbstractResourcesOperation_deletionMessageTitle, null, "OoS " + NLS.bind((String)UndoMessages.AbstractResourcesOperation_outOfSyncQuestion, (Object)iResource.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                messageDialog.open();
            }
        });
        int n = messageDialog.getReturnCode();
        if (n == 0) {
            return 2;
        }
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 3;
        }
        return 1;
    }

    private boolean validateDelete(IResource[] iResourceArray) {
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        boolean bl = false;
        while (bl < iResourceArray.length) {
            IResource iResource = iResourceArray[bl];
            iResourceChangeDescriptionFactory.delete(iResource);
            bl += 1;
        }
        bl = IDE.promptToConfirm((Shell)this.shell, (String)IDEWorkbenchMessages.DeleteResourceAction_confirm, (String)IDEWorkbenchMessages.DeleteResourceAction_warning, (IResourceDelta)iResourceChangeDescriptionFactory.getDelta(), (String[])this.getModelProviderIds(), (boolean)false);
        return bl;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void xsetModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    private List getDirtyEditors(List list) {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                IEditorPart[] iEditorPartArray = iWorkbenchPage.getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IFile iFile;
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    if (!(iEditorPart.getEditorInput() instanceof OS2200FileEditorInput) && (iFile = ResourceUtil.getFile((IEditorInput)iEditorPart.getEditorInput())) != null && list.contains(iFile.getProject())) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private HostManagerView getViewObject() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        IViewReference iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.core.views.HostManagerView");
        HostManagerView hostManagerView = null;
        if (iViewReference != null) {
            hostManagerView = (HostManagerView)iViewReference.getView(true);
        }
        if (hostManagerView == null) {
            try {
                hostManagerView = (HostManagerView)iWorkbenchPage.showView("com.unisys.tde.core.views.HostManagerView");
            }
            catch (PartInitException partInitException) {
                OS2200CorePlugin.logger.error((Object)partInitException.getLocalizedMessage(), (Throwable)partInitException);
            }
        }
        return hostManagerView;
    }
}

