/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.ui.actions.PasteAction;
import com.unisys.tde.ui.views.OS2200WorkFile;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

class CopyAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CopyAction";
    private Shell shell;
    private Clipboard clipboard;
    private PasteAction pasteAction;

    public CopyAction(Shell shell, Clipboard clipboard) {
        super("Copy");
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(Messages.getString((String)"CopyAction_0"));
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "CopyHelpId");
    }

    public CopyAction(Shell shell, Clipboard clipboard, PasteAction pasteAction) {
        this(shell, clipboard);
        this.pasteAction = pasteAction;
    }

    public void run() {
        List list = this.getSelectedResources();
        IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
        int n = iResourceArray.length;
        int n2 = 0;
        String[] stringArray = new String[n];
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        int n3 = 0;
        while (n3 < n) {
            IPath iPath = iResourceArray[n3].getLocation();
            if (iPath != null && !bl && !bl2) {
                stringArray[n2++] = iPath.toOSString();
            }
            if (n3 > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(iResourceArray[n3].getName());
            ++n3;
        }
        if (n2 < n) {
            String[] stringArray2 = stringArray;
            stringArray = new String[n2];
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n4] = stringArray2[n4];
                ++n4;
            }
        }
        if (bl) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString((String)"CopyAction.error.title1"), (String)(String.valueOf(Messages.getString((String)"CopyAction.error.process1")) + string + " " + Messages.getString((String)"CopyAction.error.process2")));
        } else if (bl2) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString((String)"CopyAction.error.title2"), (String)Messages.getString((String)"CopyAction.error.usedByAnotherProcess", (String)string));
        }
        if (string.equals("")) {
            this.setClipboard(iResourceArray, stringArray, stringBuffer.toString());
        }
        if (this.pasteAction != null && this.pasteAction.getStructuredSelection() != null) {
            this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
        }
    }

    private void setClipboard(IResource[] iResourceArray, String[] stringArray, String string) {
        block5: {
            try {
                OS2200CorePlugin.logger.info((Object)"");
                if (stringArray.length > 0) {
                    this.clipboard.setContents(new Object[]{iResourceArray, stringArray, string}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.clipboard.setContents(new Object[]{iResourceArray, string}, new Transfer[]{ResourceTransfer.getInstance(), TextTransfer.getInstance()});
                }
            }
            catch (SWTError sWTError) {
                OS2200CorePlugin.logger.error((Object)sWTError.getMessage(), (Throwable)sWTError);
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.shell, (String)"Error", (String)"Unable to copy the contents to clipboard. Do you want to retry?")) break block5;
                this.setClipboard(iResourceArray, stringArray, string);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List list = this.getSelectedResources();
        if (list.size() == 0) {
            return false;
        }
        boolean bl = this.selectionIsOfType(4);
        boolean bl2 = this.selectionIsOfType(3);
        if (!bl && !bl2) {
            return false;
        }
        if (bl && bl2) {
            return false;
        }
        IContainer iContainer = ((IResource)list.get(0)).getParent();
        if (iContainer == null) {
            return false;
        }
        for (IResource iResource : list) {
            if (iResource instanceof OS2200WorkFile) {
                return false;
            }
            if (!iResource.getParent().equals((Object)iContainer)) {
                return false;
            }
            if (iResource.getLocation() != null) continue;
            return false;
        }
        return true;
    }
}

